/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.Assert;
import com.ibm.icu.impl.ICUData;
import com.ibm.icu.impl.ICULocaleService;
import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.ICUService;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.RuleBasedBreakIterator;
import com.ibm.icu.text.ThaiBreakIterator;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import java.io.IOException;
import java.io.InputStream;
import java.text.StringCharacterIterator;
import java.util.Locale;
import java.util.MissingResourceException;

final class BreakIteratorFactory
extends BreakIterator.BreakIteratorServiceShim {
    static final ICULocaleService service = new BFService();
    private static final String[] KIND_NAMES = new String[]{"grapheme", "word", "line", "sentence", "title"};
    private static final boolean[] DICTIONARY_POSSIBLE = new boolean[]{false, true, true, false, false};

    BreakIteratorFactory() {
    }

    public Object registerInstance(BreakIterator iter2, ULocale locale, int kind) {
        iter2.setText(new StringCharacterIterator(""));
        return service.registerObject((Object)iter2, locale, kind);
    }

    public boolean unregister(Object key) {
        if (service.isDefault()) {
            return false;
        }
        return service.unregisterFactory((ICUService.Factory)key);
    }

    public Locale[] getAvailableLocales() {
        if (service == null) {
            return ICUResourceBundle.getAvailableLocales();
        }
        return service.getAvailableLocales();
    }

    public ULocale[] getAvailableULocales() {
        if (service == null) {
            return ICUResourceBundle.getAvailableULocales();
        }
        return service.getAvailableULocales();
    }

    public BreakIterator createBreakIterator(ULocale locale, int kind) {
        if (service.isDefault()) {
            return BreakIteratorFactory.createBreakInstance(locale, kind);
        }
        ULocale[] actualLoc = new ULocale[1];
        BreakIterator iter2 = (BreakIterator)service.get(locale, kind, actualLoc);
        iter2.setLocale(actualLoc[0], actualLoc[0]);
        return iter2;
    }

    private static BreakIterator createBreakInstance(ULocale locale, int kind) {
        RuleBasedBreakIterator iter2 = null;
        ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt48b/brkitr", locale);
        InputStream ruleStream = null;
        try {
            String typeKey = KIND_NAMES[kind];
            String brkfname = rb.getStringWithFallback("boundaries/" + typeKey);
            String rulesFileName = "data/icudt48b/brkitr/" + brkfname;
            ruleStream = ICUData.getStream(rulesFileName);
        }
        catch (Exception e) {
            throw new MissingResourceException(e.toString(), "", "");
        }
        if (DICTIONARY_POSSIBLE[kind]) {
            try {
                if (locale.getLanguage().equals("th")) {
                    String dictType = "Thai";
                    String dictFileName = rb.getStringWithFallback("dictionaries/" + dictType);
                    dictFileName = "data/icudt48b/brkitr/" + dictFileName;
                    InputStream is = ICUData.getStream(dictFileName);
                    iter2 = new ThaiBreakIterator(ruleStream, is);
                }
            }
            catch (MissingResourceException e) {
            }
            catch (IOException e) {
                Assert.fail(e);
            }
        }
        if (iter2 == null) {
            try {
                iter2 = RuleBasedBreakIterator.getInstanceFromCompiledRules(ruleStream);
            }
            catch (IOException e) {
                Assert.fail(e);
            }
        }
        ULocale uloc = ULocale.forLocale(rb.getLocale());
        iter2.setLocale(uloc, uloc);
        return iter2;
    }

    private static class BFService
    extends ICULocaleService {
        BFService() {
            super("BreakIterator");
            class RBBreakIteratorFactory
            extends ICULocaleService.ICUResourceBundleFactory {
                RBBreakIteratorFactory() {
                }

                protected Object handleCreate(ULocale loc, int kind, ICUService srvc) {
                    return BreakIteratorFactory.createBreakInstance(loc, kind);
                }
            }
            this.registerFactory(new RBBreakIteratorFactory());
            this.markDefault();
        }
    }
}

