/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.wrappers.batch;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Features;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.GraphQuery;
import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.VertexQuery;
import com.tinkerpop.blueprints.util.ExceptionFactory;
import com.tinkerpop.blueprints.util.StringFactory;
import com.tinkerpop.blueprints.util.wrappers.WrapperGraph;
import com.tinkerpop.blueprints.util.wrappers.batch.VertexIDType;
import com.tinkerpop.blueprints.util.wrappers.batch.WritethroughGraph;
import com.tinkerpop.blueprints.util.wrappers.batch.cache.VertexCache;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class BatchGraph<T extends TransactionalGraph>
implements TransactionalGraph,
WrapperGraph<T> {
    public static final long DEFAULT_BUFFER_SIZE = 100000L;
    private final T baseGraph;
    private String vertexIdKey = null;
    private String edgeIdKey = null;
    private boolean loadingFromScratch = true;
    private final VertexCache cache;
    private long bufferSize = 100000L;
    private long remainingBufferSize;
    private BatchEdge currentEdge = null;
    private Edge currentEdgeCached = null;
    private Object previousOutVertexId = null;

    public BatchGraph(T graph, VertexIDType type, long bufferSize) {
        if (graph == null) {
            throw new IllegalArgumentException("Graph may not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Type may not be null");
        }
        if (bufferSize <= 0L) {
            throw new IllegalArgumentException("BufferSize must be positive");
        }
        this.baseGraph = graph;
        this.bufferSize = bufferSize;
        this.vertexIdKey = null;
        this.edgeIdKey = null;
        this.cache = type.getVertexCache();
        this.remainingBufferSize = this.bufferSize;
    }

    public BatchGraph(T graph, long bufferSize) {
        this(graph, VertexIDType.OBJECT, bufferSize);
    }

    public BatchGraph(T graph) {
        this(graph, VertexIDType.OBJECT, 100000L);
    }

    public static BatchGraph wrap(Graph graph) {
        if (graph instanceof BatchGraph) {
            return (BatchGraph)graph;
        }
        if (graph instanceof TransactionalGraph) {
            return new BatchGraph<TransactionalGraph>((TransactionalGraph)graph);
        }
        return new BatchGraph<WritethroughGraph<Graph>>(new WritethroughGraph<Graph>(graph));
    }

    public static BatchGraph wrap(Graph graph, long buffer) {
        if (graph instanceof BatchGraph) {
            return (BatchGraph)graph;
        }
        if (graph instanceof TransactionalGraph) {
            return new BatchGraph<TransactionalGraph>((TransactionalGraph)graph, VertexIDType.OBJECT, buffer);
        }
        return new BatchGraph<WritethroughGraph<Graph>>(new WritethroughGraph<Graph>(graph), VertexIDType.OBJECT, buffer);
    }

    public void setVertexIdKey(String key) {
        if (!this.loadingFromScratch && key == null && this.baseGraph.getFeatures().ignoresSuppliedIds.booleanValue()) {
            throw new IllegalStateException("Cannot set vertex id key to null when not loading from scratch while ids are ignored.");
        }
        this.vertexIdKey = key;
    }

    public String getVertexIdKey() {
        return this.vertexIdKey;
    }

    public void setEdgeIdKey(String key) {
        this.edgeIdKey = key;
    }

    public String getEdgeIdKey() {
        return this.edgeIdKey;
    }

    public void setLoadingFromScratch(boolean fromScratch) {
        if (!fromScratch && this.vertexIdKey == null && this.baseGraph.getFeatures().ignoresSuppliedIds.booleanValue()) {
            throw new IllegalStateException("Vertex id key is required to query existing vertices in wrapped graph.");
        }
        this.loadingFromScratch = fromScratch;
    }

    public boolean isLoadingFromScratch() {
        return this.loadingFromScratch;
    }

    private void nextElement() {
        this.currentEdge = null;
        this.currentEdgeCached = null;
        if (this.remainingBufferSize <= 0L) {
            this.baseGraph.commit();
            this.cache.newTransaction();
            this.remainingBufferSize = this.bufferSize;
        }
        --this.remainingBufferSize;
    }

    @Override
    public void stopTransaction(TransactionalGraph.Conclusion conclusion) {
        if (TransactionalGraph.Conclusion.SUCCESS == conclusion) {
            this.commit();
        } else {
            this.rollback();
        }
    }

    @Override
    public void commit() {
        this.currentEdge = null;
        this.currentEdgeCached = null;
        this.remainingBufferSize = 0L;
        this.baseGraph.commit();
    }

    @Override
    public void rollback() {
        throw new IllegalStateException("Can not rollback during batch loading");
    }

    @Override
    public void shutdown() {
        this.baseGraph.commit();
        this.baseGraph.shutdown();
        this.currentEdge = null;
        this.currentEdgeCached = null;
    }

    @Override
    public T getBaseGraph() {
        return this.baseGraph;
    }

    @Override
    public Features getFeatures() {
        Features features = this.baseGraph.getFeatures().copyFeatures();
        features.ignoresSuppliedIds = false;
        features.isWrapper = true;
        features.supportsEdgeIteration = false;
        features.supportsThreadedTransactions = false;
        features.supportsVertexIteration = false;
        return features;
    }

    private Vertex retrieveFromCache(Object externalID) {
        Object internal = this.cache.getEntry(externalID);
        if (internal instanceof Vertex) {
            return (Vertex)internal;
        }
        if (internal != null) {
            Vertex v = this.baseGraph.getVertex(internal);
            this.cache.set(v, externalID);
            return v;
        }
        return null;
    }

    private Vertex getCachedVertex(Object externalID) {
        Vertex v = this.retrieveFromCache(externalID);
        if (v == null) {
            throw new IllegalArgumentException("Vertex for given ID cannot be found: " + externalID);
        }
        return v;
    }

    @Override
    public Vertex getVertex(Object id) {
        if (this.previousOutVertexId != null && this.previousOutVertexId.equals(id)) {
            return new BatchVertex(this.previousOutVertexId);
        }
        Vertex v = this.retrieveFromCache(id);
        if (v == null) {
            if (this.loadingFromScratch) {
                return null;
            }
            if (this.baseGraph.getFeatures().ignoresSuppliedIds.booleanValue()) {
                assert (this.vertexIdKey != null);
                Iterator<Vertex> iter2 = this.baseGraph.getVertices(this.vertexIdKey, id).iterator();
                if (!iter2.hasNext()) {
                    return null;
                }
                v = iter2.next();
                if (iter2.hasNext()) {
                    throw new IllegalArgumentException("There are multiple vertices with the provided id in the database: " + id);
                }
            } else {
                v = this.baseGraph.getVertex(id);
                if (v == null) {
                    return null;
                }
            }
            this.cache.set(v, id);
        }
        return new BatchVertex(id);
    }

    @Override
    public Vertex addVertex(Object id) {
        return this.addVertex(id, null);
    }

    public Vertex addVertex(Object id, Object ... properties) {
        if (id == null) {
            throw ExceptionFactory.vertexIdCanNotBeNull();
        }
        if (this.retrieveFromCache(id) != null) {
            throw ExceptionFactory.vertexWithIdAlreadyExists(id);
        }
        this.nextElement();
        Vertex v = this.baseGraph.addVertex(id);
        if (this.vertexIdKey != null) {
            v.setProperty(this.vertexIdKey, id);
        }
        this.cache.set(v, id);
        BatchVertex newVertex = new BatchVertex(id);
        this.setProperties(newVertex, properties);
        return newVertex;
    }

    @Override
    public Edge addEdge(Object id, Vertex outVertex, Vertex inVertex, String label) {
        return this.addEdge(id, outVertex, inVertex, label, null);
    }

    public Edge addEdge(Object id, Vertex outVertex, Vertex inVertex, String label, Object ... properties) {
        if (!BatchVertex.class.isInstance(outVertex) || !BatchVertex.class.isInstance(inVertex)) {
            throw new IllegalArgumentException("Given element was not created in this baseGraph");
        }
        this.nextElement();
        Vertex ov = this.getCachedVertex(outVertex.getId());
        Vertex iv = this.getCachedVertex(inVertex.getId());
        this.previousOutVertexId = outVertex.getId();
        this.currentEdgeCached = this.baseGraph.addEdge(id, ov, iv, label);
        if (this.edgeIdKey != null && id != null) {
            this.currentEdgeCached.setProperty(this.edgeIdKey, id);
        }
        this.currentEdge = new BatchEdge();
        this.setProperties(this.currentEdge, properties);
        return this.currentEdge;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected <E extends Element> E setProperties(E element, Object ... properties) {
        if (properties == null || properties.length <= 0) return element;
        if (properties.length == 1) {
            Object f = properties[0];
            if (!(f instanceof Map)) throw new IllegalArgumentException("Invalid properties: expecting a pairs of fields as String,Object or a single Map<String,Object>, but found: " + f);
            for (Map.Entry entry : ((Map)f).entrySet()) {
                element.setProperty(entry.getKey().toString(), entry.getValue());
            }
            return element;
        } else {
            for (int i = 0; i < properties.length; i += 2) {
                element.setProperty(properties[i].toString(), properties[i + 1]);
            }
        }
        return element;
    }

    protected Edge addEdgeSupport(Vertex outVertex, Vertex inVertex, String label) {
        return this.addEdge(null, outVertex, inVertex, label);
    }

    public String toString() {
        return StringFactory.graphString(this, this.baseGraph.toString());
    }

    @Override
    public Edge getEdge(Object id) {
        throw BatchGraph.retrievalNotSupported();
    }

    @Override
    public void removeVertex(Vertex vertex) {
        throw BatchGraph.removalNotSupported();
    }

    @Override
    public Iterable<Vertex> getVertices() {
        throw BatchGraph.retrievalNotSupported();
    }

    @Override
    public Iterable<Vertex> getVertices(String key, Object value) {
        throw BatchGraph.retrievalNotSupported();
    }

    @Override
    public void removeEdge(Edge edge) {
        throw BatchGraph.removalNotSupported();
    }

    @Override
    public Iterable<Edge> getEdges() {
        throw BatchGraph.retrievalNotSupported();
    }

    @Override
    public Iterable<Edge> getEdges(String key, Object value) {
        throw BatchGraph.retrievalNotSupported();
    }

    @Override
    public GraphQuery query() {
        throw BatchGraph.retrievalNotSupported();
    }

    private static UnsupportedOperationException retrievalNotSupported() {
        return new UnsupportedOperationException("Retrieval operations are not supported during batch loading");
    }

    private static UnsupportedOperationException removalNotSupported() {
        return new UnsupportedOperationException("Removal operations are not supported during batch loading");
    }

    private class BatchEdge
    implements Edge {
        private BatchEdge() {
        }

        @Override
        public Vertex getVertex(Direction direction) throws IllegalArgumentException {
            return this.getWrappedEdge().getVertex(direction);
        }

        @Override
        public String getLabel() {
            return this.getWrappedEdge().getLabel();
        }

        @Override
        public void setProperty(String key, Object value) {
            this.getWrappedEdge().setProperty(key, value);
        }

        @Override
        public Object getId() {
            return this.getWrappedEdge().getId();
        }

        public Object getProperty(String key) {
            return this.getWrappedEdge().getProperty(key);
        }

        @Override
        public Set<String> getPropertyKeys() {
            return this.getWrappedEdge().getPropertyKeys();
        }

        public Object removeProperty(String key) {
            return this.getWrappedEdge().removeProperty(key);
        }

        private Edge getWrappedEdge() {
            if (this != BatchGraph.this.currentEdge) {
                throw new UnsupportedOperationException("This edge is no longer in scope");
            }
            return BatchGraph.this.currentEdgeCached;
        }

        public String toString() {
            return this.getWrappedEdge().toString();
        }

        @Override
        public void remove() {
            BatchGraph.this.removeEdge(this);
        }
    }

    private class BatchVertex
    implements Vertex {
        private final Object externalID;

        BatchVertex(Object id) {
            if (id == null) {
                throw new IllegalArgumentException("External id may not be null");
            }
            this.externalID = id;
        }

        @Override
        public Iterable<Edge> getEdges(Direction direction, String ... labels) {
            throw BatchGraph.retrievalNotSupported();
        }

        @Override
        public Iterable<Vertex> getVertices(Direction direction, String ... labels) {
            throw BatchGraph.retrievalNotSupported();
        }

        @Override
        public VertexQuery query() {
            throw BatchGraph.retrievalNotSupported();
        }

        @Override
        public Edge addEdge(String label, Vertex vertex) {
            return BatchGraph.this.addEdgeSupport(this, vertex, label);
        }

        @Override
        public void setProperty(String key, Object value) {
            BatchGraph.this.getCachedVertex(this.externalID).setProperty(key, value);
        }

        @Override
        public Object getId() {
            return this.externalID;
        }

        public Object getProperty(String key) {
            return BatchGraph.this.getCachedVertex(this.externalID).getProperty(key);
        }

        @Override
        public Set<String> getPropertyKeys() {
            return BatchGraph.this.getCachedVertex(this.externalID).getPropertyKeys();
        }

        public Object removeProperty(String key) {
            return BatchGraph.this.getCachedVertex(this.externalID).removeProperty(key);
        }

        @Override
        public void remove() {
            BatchGraph.this.removeVertex(this);
        }

        public String toString() {
            return "v[" + this.externalID + "]";
        }
    }
}

