/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.extension;

import com.tinkerpop.rexster.util.HierarchicalConfigurationComparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.log4j.Logger;

public class ExtensionConfiguration {
    private static final Logger logger = Logger.getLogger(ExtensionConfiguration.class);
    private final String namespace;
    private final String extensionName;
    private final HierarchicalConfiguration configuration;

    public ExtensionConfiguration(String namespace, String extensionName, HierarchicalConfiguration extensionConfiguration) {
        if (namespace == null || namespace.isEmpty()) {
            throw new IllegalArgumentException("Namespace cannot be null or empty.");
        }
        if (extensionName == null || extensionName.isEmpty()) {
            throw new IllegalArgumentException("Extension Name cannot be null or empty.");
        }
        if (extensionConfiguration == null) {
            throw new IllegalArgumentException("Extension Configuration cannot be null.");
        }
        this.namespace = namespace;
        this.extensionName = extensionName;
        this.configuration = extensionConfiguration;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getExtensionName() {
        return this.extensionName;
    }

    public HierarchicalConfiguration getConfiguration() {
        return this.configuration;
    }

    public Map<String, String> tryGetMapFromConfiguration() {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            Iterator<String> keys = this.configuration.getKeys();
            while (keys.hasNext()) {
                String key = keys.next().toString();
                map.put(key, this.configuration.getString(key));
            }
        }
        catch (Exception ex) {
            logger.error("There is an error in the configuration of this extension [" + this.namespace + ":" + this.extensionName + "].  All values must be of a String data type.");
            map = null;
        }
        return map;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtensionConfiguration that = (ExtensionConfiguration)o;
        if (!this.extensionName.equals(that.extensionName)) {
            return false;
        }
        if (!this.namespace.equals(that.namespace)) {
            return false;
        }
        return new HierarchicalConfigurationComparator().compare(this.getConfiguration(), that.getConfiguration());
    }

    public int hashCode() {
        int result = this.namespace.hashCode();
        result = 31 * result + this.extensionName.hashCode();
        result = 31 * result + this.configuration.hashCode();
        return result;
    }
}

