/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.extension;

import com.tinkerpop.rexster.extension.ExtensionApi;
import com.tinkerpop.rexster.extension.ExtensionApiBehavior;
import com.tinkerpop.rexster.extension.ExtensionDefinition;
import com.tinkerpop.rexster.extension.ExtensionDescriptor;
import com.tinkerpop.rexster.extension.ExtensionRequestParameter;
import com.tinkerpop.rexster.extension.RexsterExtension;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.codehaus.jettison.json.JSONObject;

public class ExtensionMethod {
    private final Method method;
    private final ExtensionDefinition extensionDefinition;
    private final ExtensionDescriptor extensionDescriptor;
    private final RexsterExtension rexsterExtension;

    public ExtensionMethod(Method method, ExtensionDefinition extensionDefinition, ExtensionDescriptor extensionDescriptor, RexsterExtension rexsterExtension) {
        this.method = method;
        this.extensionDefinition = extensionDefinition;
        this.extensionDescriptor = extensionDescriptor;
        this.rexsterExtension = rexsterExtension;
    }

    public Method getMethod() {
        return this.method;
    }

    public ExtensionDefinition getExtensionDefinition() {
        return this.extensionDefinition;
    }

    public RexsterExtension getRexsterExtension() {
        return this.rexsterExtension;
    }

    public JSONObject getExtensionApiAsJson() {
        JSONObject fullApi = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.extensionDescriptor != null) {
            map.put("description", this.extensionDescriptor.description());
            JSONObject api = null;
            HashMap<String, String> innerMap = new HashMap<String, String>();
            if ((this.extensionDescriptor.apiBehavior() == ExtensionApiBehavior.DEFAULT || this.extensionDescriptor.apiBehavior() == ExtensionApiBehavior.EXTENSION_DESCRIPTOR_ONLY) && this.extensionDescriptor.api().length > 0) {
                for (ExtensionApi apiItem : this.extensionDescriptor.api()) {
                    innerMap.put(apiItem.parameterName(), apiItem.description());
                }
            }
            if (this.extensionDescriptor.apiBehavior() == ExtensionApiBehavior.DEFAULT || this.extensionDescriptor.apiBehavior() == ExtensionApiBehavior.EXTENSION_PARAMETER_ONLY) {
                Annotation[][] parametersAnnotations = this.method.getParameterAnnotations();
                for (int ix = 0; ix < parametersAnnotations.length; ++ix) {
                    Annotation[] annotation = parametersAnnotations[ix];
                    if (annotation == null || annotation.length <= 0 || !(annotation[0] instanceof ExtensionRequestParameter)) continue;
                    ExtensionRequestParameter extensionRequestParameter = (ExtensionRequestParameter)annotation[0];
                    innerMap.put(extensionRequestParameter.name(), extensionRequestParameter.description());
                }
            }
            if (!innerMap.isEmpty()) {
                api = new JSONObject(innerMap);
                map.put("parameters", api);
            }
            fullApi = new JSONObject(map);
        }
        return fullApi;
    }
}

