/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.server;

import com.codahale.metrics.MetricRegistry;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.rexster.RexsterApplicationGraph;
import com.tinkerpop.rexster.server.RexsterApplication;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public abstract class AbstractMapRexsterApplication
implements RexsterApplication {
    private static final Logger logger = Logger.getLogger(AbstractMapRexsterApplication.class);
    protected static MetricRegistry metricRegistry;
    protected final long startTime = System.currentTimeMillis();
    protected final Map<String, RexsterApplicationGraph> graphs = new ConcurrentHashMap<String, RexsterApplicationGraph>();

    @Override
    public Graph getGraph(String graphName) {
        RexsterApplicationGraph g = this.getApplicationGraph(graphName);
        if (g != null) {
            return g.getGraph();
        }
        return null;
    }

    @Override
    public RexsterApplicationGraph getApplicationGraph(String graphName) {
        return this.graphs.get(graphName);
    }

    @Override
    public Set<String> getGraphNames() {
        return this.graphs.keySet();
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public void stop() {
        for (RexsterApplicationGraph rag : this.graphs.values()) {
            Graph graph = rag.getGraph();
            logger.info(String.format("Shutting down [%s] - [%s]", rag.getGraphName(), graph));
            if (graph == null) continue;
            Graph shutdownGraph = rag.getUnwrappedGraph();
            shutdownGraph.shutdown();
        }
    }

    @Override
    public MetricRegistry getMetricRegistry() {
        if (metricRegistry == null) {
            metricRegistry = new MetricRegistry();
        }
        return metricRegistry;
    }

    public String toString() {
        return String.format("RexsterServerContext {configured graphs=%s}", this.graphs.size());
    }
}

