/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;

public class ElementHelper {
    public static Object getTypedPropertyValue(Object propertyValue) {
        return ElementHelper.getTypedPropertyValue(propertyValue, true);
    }

    public static Object getTypedPropertyValue(Object propertyValue, boolean parseTypes) {
        Cloneable typedPropertyValue = propertyValue;
        if (typedPropertyValue == null) {
            typedPropertyValue = null;
        }
        if (propertyValue != null) {
            if (propertyValue instanceof String) {
                String stringPropertyValue = ((Object)propertyValue).toString();
                if (parseTypes && stringPropertyValue.startsWith("(") && stringPropertyValue.endsWith(")")) {
                    String dataType = ElementHelper.getDataTypeSegment(stringPropertyValue);
                    String theValue = ElementHelper.getValueSegment(stringPropertyValue);
                    if (dataType.equals("string")) {
                        typedPropertyValue = theValue;
                    } else if (dataType.equals("integer")) {
                        typedPropertyValue = ElementHelper.tryParseInteger(theValue);
                    } else if (dataType.equals("boolean")) {
                        typedPropertyValue = ElementHelper.tryParseBoolean(theValue);
                    } else if (dataType.equals("long")) {
                        typedPropertyValue = ElementHelper.tryParseLong(theValue);
                    } else if (dataType.equals("double")) {
                        typedPropertyValue = ElementHelper.tryParseDouble(theValue);
                    } else if (dataType.equals("float")) {
                        typedPropertyValue = ElementHelper.tryParseFloat(theValue);
                    } else if (dataType.equals("list")) {
                        ArrayList<String> items = ElementHelper.tryParseList(theValue);
                        ArrayList<Object> typedItems = new ArrayList<Object>();
                        for (String item : items) {
                            typedItems.add(ElementHelper.getTypedPropertyValue(item));
                        }
                        typedPropertyValue = typedItems;
                    } else if (dataType.equals("map")) {
                        HashMap<String, String> stringProperties = ElementHelper.tryParseMap(theValue);
                        HashMap<String, Object> properties = new HashMap<String, Object>();
                        for (Map.Entry<String, String> entry : stringProperties.entrySet()) {
                            properties.put(entry.getKey(), ElementHelper.getTypedPropertyValue(entry.getValue()));
                        }
                        typedPropertyValue = properties;
                    } else if (dataType.equals("null")) {
                        typedPropertyValue = null;
                    }
                }
            } else if (propertyValue == JSONObject.NULL) {
                typedPropertyValue = null;
            } else if (propertyValue instanceof JSONObject) {
                JSONObject innerJson = (JSONObject)((Object)propertyValue);
                HashMap<String, Object> properties = new HashMap<String, Object>();
                Iterator itty = innerJson.keys();
                while (itty.hasNext()) {
                    String key = (String)itty.next();
                    properties.put(key, ElementHelper.getTypedPropertyValue(innerJson.opt(key), parseTypes));
                }
                typedPropertyValue = properties;
            } else if (propertyValue instanceof JSONArray) {
                JSONArray innerJson = (JSONArray)((Object)propertyValue);
                ArrayList<Object> typedItems = new ArrayList<Object>();
                for (int ix = 0; ix < innerJson.length(); ++ix) {
                    typedItems.add(ElementHelper.getTypedPropertyValue(innerJson.opt(ix), parseTypes));
                }
                typedPropertyValue = typedItems;
            }
        }
        return typedPropertyValue;
    }

    private static HashMap<String, String> tryParseMap(String mapValue) {
        String stripped = mapValue.substring(1, mapValue.length() - 1);
        HashMap<String, String> pairs = new HashMap<String, String>();
        ArrayList<Integer> delimiterPlaces = new ArrayList<Integer>();
        int parensOpened = 0;
        for (int ix = 0; ix < stripped.length(); ++ix) {
            char c = stripped.charAt(ix);
            if (c == ',') {
                if (parensOpened != 0) continue;
                delimiterPlaces.add(ix);
                continue;
            }
            if (c == '(') {
                ++parensOpened;
                continue;
            }
            if (c != ')') continue;
            --parensOpened;
        }
        int lastPlace = 0;
        int equalPlace = 0;
        for (Integer place : delimiterPlaces) {
            String property = stripped.substring(lastPlace, place);
            equalPlace = property.indexOf("=");
            pairs.put(property.substring(0, equalPlace), property.substring(equalPlace + 1));
            lastPlace = place + 1;
        }
        String property = stripped.substring(lastPlace);
        equalPlace = property.indexOf("=");
        pairs.put(property.substring(0, equalPlace), property.substring(equalPlace + 1));
        return pairs;
    }

    private static ArrayList<String> tryParseList(String listValue) {
        String stripped = listValue.substring(1, listValue.length() - 1);
        ArrayList<String> items = new ArrayList<String>();
        int place = stripped.indexOf(44);
        if (place > -1) {
            boolean isEndItem = false;
            int parensOpened = 0;
            StringBuffer sb = new StringBuffer();
            for (int ix = 0; ix < stripped.length(); ++ix) {
                char c = stripped.charAt(ix);
                if (c == ',') {
                    if (parensOpened == 0) {
                        isEndItem = true;
                    }
                } else if (c == '(') {
                    ++parensOpened;
                } else if (c == ')') {
                    --parensOpened;
                }
                if (ix == stripped.length() - 1) {
                    isEndItem = true;
                    sb.append(c);
                }
                if (isEndItem) {
                    items.add(sb.toString());
                    sb = new StringBuffer();
                    isEndItem = false;
                    continue;
                }
                sb.append(c);
            }
        } else {
            items.add(stripped);
        }
        return items;
    }

    private static String getValueSegment(String propertyValue) {
        String value = "";
        String stripped = propertyValue.substring(1, propertyValue.length() - 1);
        int place = stripped.indexOf(44);
        value = place > -1 ? (place + 1 < stripped.length() ? stripped.substring(place + 1) : "") : stripped;
        return value;
    }

    private static String getDataTypeSegment(String propertyValue) {
        String dataType = "string";
        int place = propertyValue.indexOf(44);
        String inner = propertyValue.substring(1, place).trim();
        if (inner.equals("s") || inner.equals("string")) {
            dataType = "string";
        } else if (inner.equals("b") || inner.equals("boolean")) {
            dataType = "boolean";
        } else if (inner.equals("i") || inner.equals("integer")) {
            dataType = "integer";
        } else if (inner.equals("d") || inner.equals("double")) {
            dataType = "double";
        } else if (inner.equals("f") || inner.equals("float")) {
            dataType = "float";
        } else if (inner.equals("list")) {
            dataType = "list";
        } else if (inner.equals("l") || inner.equals("long")) {
            dataType = "long";
        } else if (inner.equals("map")) {
            dataType = "map";
        } else if (inner.equals("null")) {
            dataType = "null";
        }
        return dataType;
    }

    private static Object tryParseInteger(String intValue) {
        Object parsedValue;
        try {
            parsedValue = Integer.parseInt(intValue);
        }
        catch (NumberFormatException nfe) {
            parsedValue = intValue;
        }
        return parsedValue;
    }

    private static Object tryParseFloat(String floatValue) {
        Object parsedValue;
        try {
            parsedValue = Float.valueOf(Float.parseFloat(floatValue));
        }
        catch (NumberFormatException nfe) {
            parsedValue = floatValue;
        }
        return parsedValue;
    }

    private static Object tryParseBoolean(String booleanValue) {
        Object parsedValue;
        try {
            parsedValue = Boolean.parseBoolean(booleanValue);
        }
        catch (NumberFormatException nfe) {
            parsedValue = booleanValue;
        }
        return parsedValue;
    }

    private static Object tryParseLong(String longValue) {
        Object parsedValue;
        try {
            parsedValue = Long.parseLong(longValue);
        }
        catch (NumberFormatException nfe) {
            parsedValue = longValue;
        }
        return parsedValue;
    }

    private static Object tryParseDouble(String doubleValue) {
        Object parsedValue;
        try {
            parsedValue = Double.parseDouble(doubleValue);
        }
        catch (NumberFormatException nfe) {
            parsedValue = doubleValue;
        }
        return parsedValue;
    }
}

