/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.util;

import com.tinkerpop.blueprints.Compare;
import com.tinkerpop.blueprints.VertexQuery;
import com.tinkerpop.rexster.util.ElementHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class RequestObjectHelper {
    public static JSONObject getRexsterRequest(JSONObject requestObject) {
        return requestObject != null ? requestObject.optJSONObject("rexster") : null;
    }

    public static Set<String> getReturnKeys(JSONObject requestObject) {
        return RequestObjectHelper.getReturnKeys(requestObject, "*");
    }

    public static Set<String> getReturnKeys(JSONObject requestObject, String wildcard) {
        JSONObject rexsterRequestObject = RequestObjectHelper.getRexsterRequest(requestObject);
        if (rexsterRequestObject != null) {
            try {
                JSONArray jsonArrayOfReturnKeys = rexsterRequestObject.optJSONArray("returnKeys");
                return RequestObjectHelper.getReturnKeys(jsonArrayOfReturnKeys, wildcard);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static Set<String> getReturnKeys(JSONArray arrayOfKeys, String wildcard) {
        HashSet<String> returnKeys = null;
        if (arrayOfKeys != null) {
            returnKeys = new HashSet<String>();
            for (int ix = 0; ix < arrayOfKeys.length(); ++ix) {
                returnKeys.add(arrayOfKeys.optString(ix));
            }
            if (returnKeys.size() == 1 && returnKeys.contains(wildcard)) {
                returnKeys = null;
            }
        } else {
            returnKeys = null;
        }
        return returnKeys;
    }

    public static boolean getShowTypes(JSONObject requestObject) {
        JSONObject rexsterRequestObject = RequestObjectHelper.getRexsterRequest(requestObject);
        if (rexsterRequestObject != null) {
            try {
                return rexsterRequestObject.getBoolean("showTypes");
            }
            catch (JSONException e) {
                return false;
            }
        }
        return false;
    }

    public static Long getStartOffset(JSONObject requestObject) {
        Long offset = RequestObjectHelper.getOffset(requestObject, "start");
        if (null == offset) {
            return 0L;
        }
        return offset;
    }

    public static Long getEndOffset(JSONObject requestObject) {
        Long offset = RequestObjectHelper.getOffset(requestObject, "end");
        if (null == offset) {
            return Long.MAX_VALUE;
        }
        return offset;
    }

    public static boolean hasElementProperties(JSONObject requestObject) {
        if (requestObject == null) {
            return false;
        }
        Iterator keys = requestObject.keys();
        while (keys.hasNext()) {
            String key = keys.next().toString();
            if (key.startsWith("_")) continue;
            return true;
        }
        return false;
    }

    public static void buildQueryProperties(JSONObject requestObject, VertexQuery query) {
        JSONArray propertyArray = requestObject.optJSONArray("_properties");
        if (propertyArray != null) {
            try {
                StringBuffer sb = new StringBuffer();
                for (int ix = 0; ix < propertyArray.length(); ++ix) {
                    sb.append(propertyArray.optString(ix));
                    if (ix >= propertyArray.length() - 1) continue;
                    sb.append(",");
                }
                String propertyArgument = sb.toString();
                int startBracePlace = propertyArgument.indexOf(91);
                int endBracePlace = propertyArgument.indexOf(93);
                while (startBracePlace > -1 && endBracePlace > -1) {
                    Compare c;
                    String triple = propertyArgument.substring(startBracePlace + 1, endBracePlace);
                    String[] separated = triple.split(",");
                    String[] tripleSplit = new String[3];
                    tripleSplit[0] = separated[0].trim();
                    tripleSplit[1] = separated[1].trim();
                    Object[] tripleValue = Arrays.copyOfRange(separated, 2, separated.length);
                    tripleSplit[2] = StringUtils.join(tripleValue, ',');
                    String[] splitTripleValue = tripleSplit[2].split(" ");
                    String compareString = tripleSplit[1];
                    try {
                        c = Compare.fromString(compareString);
                    }
                    catch (IllegalArgumentException iae) {
                        throw new WebApplicationException(Response.Status.BAD_REQUEST);
                    }
                    if (splitTripleValue.length == 1) {
                        query.has(tripleSplit[0], c, (Comparable)ElementHelper.getTypedPropertyValue(splitTripleValue[0], true));
                    } else {
                        ArrayList<Object> l = new ArrayList<Object>(splitTripleValue.length);
                        for (String stv : splitTripleValue) {
                            l.add(ElementHelper.getTypedPropertyValue(stv, true));
                        }
                        if (c == Compare.EQUAL) {
                            query.has(tripleSplit[0], l.toArray(new Object[l.size()]));
                        } else {
                            query.hasNot(tripleSplit[0], l.toArray(new Object[l.size()]));
                        }
                    }
                    startBracePlace = propertyArgument.indexOf(91, endBracePlace);
                    endBracePlace = propertyArgument.indexOf(93, endBracePlace + 1);
                }
            }
            catch (WebApplicationException wae) {
                throw wae;
            }
            catch (Exception jse) {
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
        }
    }

    private static Long getOffset(JSONObject requestObject, String offsetToken) {
        JSONObject rexsterRequestObject = RequestObjectHelper.getRexsterRequest(requestObject);
        if (rexsterRequestObject != null) {
            if (rexsterRequestObject.has("offset")) {
                if (rexsterRequestObject.optJSONObject("offset").has(offsetToken)) {
                    return rexsterRequestObject.optJSONObject("offset").optLong(offsetToken);
                }
                return null;
            }
            return null;
        }
        return null;
    }
}

