/*
 * Decompiled with CFR 0.152.
 */
package cutthecrap.utils.striterators;

import cutthecrap.utils.striterators.Expander;
import cutthecrap.utils.striterators.IContextMgr;
import cutthecrap.utils.striterators.IStriterator;
import cutthecrap.utils.striterators.Prefetch;
import java.util.Iterator;

public class Expanderator
extends Prefetch
implements IStriterator.ITailOp {
    private final Iterator m_src;
    private Iterator m_child = null;
    protected final Object m_context;
    private final Expander m_expander;
    private final IContextMgr m_contextMgr;

    public Expanderator(Iterator src, Object context, Expander expander) {
        this.m_src = src;
        this.m_context = context;
        this.m_expander = expander;
        this.m_contextMgr = this.m_expander.getContextMgr();
    }

    @Override
    protected Object getNext() {
        while (true) {
            if (this.m_child != null && this.m_child.hasNext()) {
                Object ret = this.m_child.next();
                if (this.m_child instanceof IStriterator.ITailOp) {
                    this.m_child = ((IStriterator.ITailOp)((Object)this.m_child)).availableTailOp();
                }
                return ret;
            }
            if (this.m_child != null && this.m_contextMgr != null) {
                this.m_contextMgr.popContext();
            }
            if (!this.m_src.hasNext()) break;
            Object nxt = this.m_src.next();
            if (this.m_contextMgr != null) {
                this.m_contextMgr.pushContext(nxt);
            }
            this.m_child = this.m_expander.expand(nxt);
        }
        return null;
    }

    @Override
    public void remove() {
        this.m_child.remove();
    }

    @Override
    public Iterator availableTailOp() {
        if (this.m_contextMgr == null && !this.ready() && !this.m_src.hasNext()) {
            return this.m_child;
        }
        return this;
    }
}

