/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.iteration;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.Iteration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Iterations {
    public static <E, X extends Exception> List<E> asList(Iteration<? extends E, X> iter2) throws X {
        ArrayList result = new ArrayList();
        Iterations.addAll(iter2, result);
        return result;
    }

    public static <E, X extends Exception> Set<E> asSet(Iteration<? extends E, X> iter2) throws X {
        HashSet result = new HashSet();
        Iterations.addAll(iter2, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E, X extends Exception, C extends Collection<E>> C addAll(Iteration<? extends E, X> iter2, C collection) throws X {
        try {
            while (iter2.hasNext()) {
                collection.add(iter2.next());
            }
        }
        finally {
            Iterations.closeCloseable(iter2);
        }
        return collection;
    }

    public static <X extends Exception> void closeCloseable(Iteration<?, X> iter2) throws X {
        if (iter2 instanceof CloseableIteration) {
            ((CloseableIteration)iter2).close();
        }
    }

    public static <X extends Exception> String toString(Iteration<?, X> iter2, String separator) throws X {
        StringBuilder sb = new StringBuilder();
        Iterations.toString(iter2, separator, sb);
        return sb.toString();
    }

    public static <X extends Exception> void toString(Iteration<?, X> iter2, String separator, StringBuilder sb) throws X {
        while (iter2.hasNext()) {
            sb.append(iter2.next());
            if (!iter2.hasNext()) continue;
            sb.append(separator);
        }
    }
}

