/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.iteration;

import info.aduna.iteration.Iteration;
import info.aduna.iteration.IterationWrapper;
import java.util.NoSuchElementException;

public class LimitIteration<E, X extends Exception>
extends IterationWrapper<E, X> {
    private final long limit;
    private long returnCount;

    public LimitIteration(Iteration<? extends E, X> iter2, long limit) {
        super(iter2);
        assert (iter2 != null);
        assert (limit >= 0L);
        this.limit = limit;
        this.returnCount = 0L;
    }

    @Override
    public boolean hasNext() throws X {
        return this.returnCount < this.limit && super.hasNext();
    }

    @Override
    public E next() throws X {
        if (this.returnCount >= this.limit) {
            throw new NoSuchElementException("limit reached");
        }
        ++this.returnCount;
        return super.next();
    }
}

