/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.bits;

import it.unimi.dsi.bits.AbstractBitVector;
import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.BitVectors;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.util.LongBigList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class LongArrayBitVector
extends AbstractBitVector
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int LOG2_BITS_PER_WORD = 6;
    public static final int BITS_PER_WORD = 64;
    public static final int WORD_MASK = 63;
    public static final int LAST_BIT = 63;
    public static final long ALL_ONES = -1L;
    public static final long LAST_BIT_MASK = Long.MIN_VALUE;
    public static final boolean CHECKS = true;
    private static final boolean ASSERTS = false;
    protected long length;
    protected transient long[] bits;

    protected static final int numWords(long size) {
        return (int)(size + 63L >>> 6);
    }

    protected static final int word(long index) {
        return (int)(index >> 6);
    }

    protected static final int bit(long index) {
        return (int)(index & 0x3FL);
    }

    protected static final long mask(long index) {
        return 1L << (int)(index & 0x3FL);
    }

    protected LongArrayBitVector(long capacity) {
        this.bits = capacity > 0L ? new long[LongArrayBitVector.numWords(capacity)] : LongArrays.EMPTY_ARRAY;
    }

    public static LongArrayBitVector getInstance(long capacity) {
        return new LongArrayBitVector(capacity);
    }

    public static LongArrayBitVector getInstance() {
        return new LongArrayBitVector(0L);
    }

    public static LongArrayBitVector ofLength(long length) {
        return new LongArrayBitVector(length).length(length);
    }

    public static LongArrayBitVector of(int ... bit) {
        LongArrayBitVector bitVector = new LongArrayBitVector(bit.length);
        for (int b : bit) {
            bitVector.add(b);
        }
        return bitVector;
    }

    @Override
    public long[] bits() {
        return this.bits;
    }

    @Override
    public long length() {
        return this.length;
    }

    public LongArrayBitVector ensureCapacity(long numBits) {
        this.bits = LongArrays.grow(this.bits, LongArrayBitVector.numWords(numBits), LongArrayBitVector.numWords(this.length));
        return this;
    }

    @Override
    public LongArrayBitVector length(long newLength) {
        this.bits = LongArrays.ensureCapacity(this.bits, LongArrayBitVector.numWords(newLength), LongArrayBitVector.numWords(this.length));
        long oldLength = this.length;
        if (newLength < oldLength) {
            this.fill(newLength, oldLength, false);
        }
        this.length = newLength;
        return this;
    }

    @Override
    public void fill(boolean value) {
        int fullWords = (int)(this.length / 64L);
        LongArrays.fill(this.bits, 0, fullWords, value ? -1L : 0L);
        if (this.length % 64L != 0L) {
            this.bits[fullWords] = value ? (1L << (int)(this.length % 64L)) - 1L : 0L;
        }
    }

    @Override
    public void fill(long from, long to, boolean value) {
        if (to / 64L == from / 64L) {
            if (value) {
                int n = (int)(from / 64L);
                this.bits[n] = this.bits[n] | (1L << (int)(to - from)) - 1L << (int)from;
            } else {
                int n = (int)(from / 64L);
                this.bits[n] = this.bits[n] & ((1L << (int)(to - from)) - 1L << (int)from ^ 0xFFFFFFFFFFFFFFFFL);
            }
            return;
        }
        LongArrays.fill(this.bits, (int)((from + 64L - 1L) / 64L), (int)(to / 64L), value ? -1L : 0L);
        if (from % 64L != 0L) {
            if (value) {
                int n = (int)(from / 64L);
                this.bits[n] = this.bits[n] | -1L << (int)(from % 64L);
            } else {
                int n = (int)(from / 64L);
                this.bits[n] = this.bits[n] & (1L << (int)(from % 64L)) - 1L;
            }
        }
        if (to % 64L != 0L) {
            if (value) {
                int n = (int)(to / 64L);
                this.bits[n] = this.bits[n] | (1L << (int)(to % 64L)) - 1L;
            } else {
                int n = (int)(to / 64L);
                this.bits[n] = this.bits[n] & -1L << (int)(to % 64L);
            }
        }
    }

    @Override
    public void flip() {
        int fullWords;
        int i = fullWords = (int)(this.length / 64L);
        while (i-- != 0) {
            int n = i;
            this.bits[n] = this.bits[n] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (this.length % 64L != 0L) {
            int n = fullWords;
            this.bits[n] = this.bits[n] ^ (1L << (int)(this.length % 64L)) - 1L;
        }
    }

    public boolean trim() {
        if (this.bits.length == LongArrayBitVector.numWords(this.length)) {
            return false;
        }
        this.bits = LongArrays.setLength(this.bits, LongArrayBitVector.numWords(this.length));
        return true;
    }

    @Override
    public void clear() {
        LongArrays.fill(this.bits, 0, LongArrayBitVector.word(this.length - 1L) + 1, 0L);
        this.length = 0L;
    }

    @Override
    public LongArrayBitVector copy(long from, long to) {
        BitVectors.ensureFromTo(this.length, from, to);
        LongArrayBitVector copy = new LongArrayBitVector(to - from);
        copy.length = to - from;
        if (copy.length == 0L) {
            return copy;
        }
        int numWords = LongArrayBitVector.numWords(to - from);
        int startWord = LongArrayBitVector.word(from);
        int startBit = LongArrayBitVector.bit(from);
        if (startBit == 0) {
            System.arraycopy(this.bits, startWord, copy.bits, 0, numWords);
            int endBit = LongArrayBitVector.bit(to);
            if (endBit > 0) {
                int n = numWords - 1;
                copy.bits[n] = copy.bits[n] & (1L << endBit) - 1L;
            }
        } else if (startWord == LongArrayBitVector.word(to - 1L)) {
            copy.bits[0] = this.bits[startWord] >>> startBit & (1L << (int)(to - from)) - 1L;
        } else {
            int bitsPerWordMinusStartBit = 64 - startBit;
            long[] bits = this.bits;
            long[] copyBits = copy.bits;
            copyBits[0] = bits[startWord] >>> startBit;
            for (int word = 1; word < numWords; ++word) {
                int n = word - 1;
                copyBits[n] = copyBits[n] | bits[word + startWord] << bitsPerWordMinusStartBit;
                copyBits[word] = bits[word + startWord] >>> startBit;
            }
            int endBit = LongArrayBitVector.bit(to - from);
            if (endBit == 0) {
                int n = numWords - 1;
                copyBits[n] = copyBits[n] | bits[numWords + startWord] << bitsPerWordMinusStartBit;
            } else {
                if (endBit > bitsPerWordMinusStartBit) {
                    int n = numWords - 1;
                    copyBits[n] = copyBits[n] | bits[numWords + startWord] << bitsPerWordMinusStartBit;
                }
                int n = numWords - 1;
                copyBits[n] = copyBits[n] & (1L << endBit) - 1L;
            }
        }
        return copy;
    }

    @Override
    public LongArrayBitVector copy() {
        LongArrayBitVector copy = new LongArrayBitVector(this.length);
        copy.length = this.length;
        System.arraycopy(this.bits, 0, copy.bits, 0, LongArrayBitVector.numWords(this.length));
        return copy;
    }

    @Override
    public LongArrayBitVector fast() {
        return this;
    }

    public static LongArrayBitVector copy(BitVector bv) {
        long length = bv.length();
        LongArrayBitVector copy = new LongArrayBitVector(length);
        long fullBits = length - length % 64L;
        for (long i = 0L; i < fullBits; i += 64L) {
            copy.bits[(int)(i / 64L)] = bv.getLong(i, i + 64L);
        }
        if (length % 64L != 0L) {
            copy.bits[(int)(fullBits / 64L)] = bv.getLong(fullBits, length);
        }
        copy.length = length;
        return copy;
    }

    @Override
    public boolean getBoolean(long index) {
        this.ensureRestrictedIndex(index);
        return (this.bits[LongArrayBitVector.word(index)] & LongArrayBitVector.mask(index)) != 0L;
    }

    @Override
    public boolean set(long index, boolean value) {
        boolean oldValue;
        this.ensureRestrictedIndex(index);
        int word = LongArrayBitVector.word(index);
        long mask = LongArrayBitVector.mask(index);
        boolean bl = oldValue = (this.bits[word] & mask) != 0L;
        if (value) {
            int n = word;
            this.bits[n] = this.bits[n] | mask;
        } else {
            int n = word;
            this.bits[n] = this.bits[n] & (mask ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return oldValue != value;
    }

    @Override
    public void set(long index) {
        this.ensureRestrictedIndex(index);
        int n = LongArrayBitVector.word(index);
        this.bits[n] = this.bits[n] | LongArrayBitVector.mask(index);
    }

    @Override
    public void clear(long index) {
        this.ensureRestrictedIndex(index);
        int n = LongArrayBitVector.word(index);
        this.bits[n] = this.bits[n] & (LongArrayBitVector.mask(index) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public void add(long index, boolean value) {
        this.ensureIndex(index);
        if (this.length == (long)(this.bits.length << 6)) {
            this.bits = LongArrays.grow(this.bits, LongArrayBitVector.numWords(this.length + 1L));
        }
        ++this.length;
        if (index == this.length - 1L) {
            this.set(index, value);
        } else {
            int word = LongArrayBitVector.word(index);
            int bit = LongArrayBitVector.bit(index);
            boolean carry = (this.bits[word] & Long.MIN_VALUE) != 0L;
            long t = this.bits[word];
            t = bit == 63 ? (t &= Long.MAX_VALUE) : (t & -(1L << bit)) << 1 | t & (1L << bit) - 1L;
            if (value) {
                t |= 1L << bit;
            }
            this.bits[word] = t;
            int numWords = LongArrayBitVector.numWords(this.length);
            for (int i = word + 1; i < numWords; ++i) {
                boolean nextCarry = (this.bits[i] & Long.MIN_VALUE) != 0L;
                int n = i;
                this.bits[n] = this.bits[n] << 1;
                if (carry) {
                    int n2 = i;
                    this.bits[n2] = this.bits[n2] | 1L;
                }
                carry = nextCarry;
            }
        }
    }

    @Override
    public boolean removeBoolean(long index) {
        this.ensureRestrictedIndex(index);
        boolean oldValue = this.getBoolean(index);
        long[] bits = this.bits;
        int word = LongArrayBitVector.word(index);
        int bit = LongArrayBitVector.bit(index);
        bits[word] = (bits[word] & -(1L << bit) << 1) >>> 1 | bits[word] & (1L << bit) - 1L;
        int numWords = LongArrayBitVector.numWords(this.length--);
        int i = word + 1;
        while (i < numWords) {
            if ((bits[i] & 1L) != 0L) {
                int n = i - 1;
                bits[n] = bits[n] | Long.MIN_VALUE;
            }
            int n = i++;
            bits[n] = bits[n] >>> 1;
        }
        return oldValue;
    }

    @Override
    public LongArrayBitVector append(long value, int width) {
        if (width == 0) {
            return this;
        }
        if (width < 64 && (value & -1L << width) != 0L) {
            throw new IllegalArgumentException("The specified value (" + value + ") is larger than the maximum value for the given width (" + width + ")");
        }
        long length = this.length;
        int startWord = LongArrayBitVector.word(length);
        int startBit = LongArrayBitVector.bit(length);
        this.ensureCapacity(length + (long)width);
        if (startBit + width <= 64) {
            int n = startWord;
            this.bits[n] = this.bits[n] | value << startBit;
        } else {
            int n = startWord;
            this.bits[n] = this.bits[n] | value << startBit;
            this.bits[startWord + 1] = value >>> 64 - startBit;
        }
        this.length += (long)width;
        return this;
    }

    @Override
    public long getLong(long from, long to) {
        BitVectors.ensureFromTo(this.length, from, to);
        long l = 64L - (to - from);
        int startWord = LongArrayBitVector.word(from);
        int startBit = LongArrayBitVector.bit(from);
        if (l == 64L) {
            return 0L;
        }
        if ((long)startBit <= l) {
            return this.bits[startWord] << (int)(l - (long)startBit) >>> (int)l;
        }
        return this.bits[startWord] >>> startBit | this.bits[startWord + 1] << (int)(64L + l - (long)startBit) >>> (int)l;
    }

    @Override
    public long count() {
        long c = 0L;
        int i = LongArrayBitVector.numWords(this.length);
        while (i-- != 0) {
            c += (long)Fast.count(this.bits[i]);
        }
        return c;
    }

    @Override
    public long nextOne(long index) {
        if (index >= this.length) {
            return -1L;
        }
        long[] bits = this.bits;
        long words = LongArrayBitVector.numWords(this.length);
        int from = LongArrayBitVector.word(index);
        long maskedFirstWord = bits[from] & -(1L << LongArrayBitVector.bit(index));
        if (maskedFirstWord != 0L) {
            return from * 64 + Fast.leastSignificantBit(maskedFirstWord);
        }
        int i = from + 1;
        while ((long)i < words) {
            if (bits[i] != 0L) {
                return i * 64 + Fast.leastSignificantBit(bits[i]);
            }
            ++i;
        }
        return -1L;
    }

    @Override
    public long previousOne(long index) {
        long mask;
        if (index == 0L) {
            return -1L;
        }
        long[] bits = this.bits;
        int from = LongArrayBitVector.word(index - 1L);
        long maskedFirstWord = bits[from] & ((mask = 1L << LongArrayBitVector.bit(index - 1L)) | mask - 1L);
        if (maskedFirstWord != 0L) {
            return from * 64 + Fast.mostSignificantBit(maskedFirstWord);
        }
        int i = from;
        while (i-- != 0) {
            if (bits[i] == 0L) continue;
            return i * 64 + Fast.mostSignificantBit(bits[i]);
        }
        return -1L;
    }

    @Override
    public long nextZero(long index) {
        if (index >= this.length) {
            return -1L;
        }
        long[] bits = this.bits;
        long words = LongArrayBitVector.numWords(this.length);
        int from = LongArrayBitVector.word(index);
        long maskedFirstWord = bits[from] | (1L << LongArrayBitVector.bit(index)) - 1L;
        if (maskedFirstWord != -1L) {
            long result = from * 64 + Fast.leastSignificantBit(maskedFirstWord ^ 0xFFFFFFFFFFFFFFFFL);
            return result >= this.length ? -1L : result;
        }
        int i = from + 1;
        while ((long)i < words) {
            if (bits[i] != -1L) {
                long result = i * 64 + Fast.leastSignificantBit(bits[i] ^ 0xFFFFFFFFFFFFFFFFL);
                return result >= this.length ? -1L : result;
            }
            ++i;
        }
        return -1L;
    }

    @Override
    public long previousZero(long index) {
        if (index == 0L) {
            return -1L;
        }
        long[] bits = this.bits;
        int from = LongArrayBitVector.word(index - 1L);
        long maskedFirstWord = bits[from] | -1L << LongArrayBitVector.bit(index);
        if (from == LongArrayBitVector.word(this.length - 1L)) {
            maskedFirstWord |= -1L << (int)(this.length % 64L);
        }
        if (maskedFirstWord != -1L) {
            return from * 64 + Fast.mostSignificantBit(maskedFirstWord ^ 0xFFFFFFFFFFFFFFFFL);
        }
        int i = from;
        while (i-- != 0) {
            if (bits[i] == -1L) continue;
            return i * 64 + Fast.mostSignificantBit(bits[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return -1L;
    }

    @Override
    public long longestCommonPrefixLength(BitVector v) {
        if (v instanceof LongArrayBitVector) {
            return this.longestCommonPrefixLength((LongArrayBitVector)v);
        }
        return super.longestCommonPrefixLength(v);
    }

    public long longestCommonPrefixLength(LongArrayBitVector v) {
        long minLength = Math.min(v.length(), this.length());
        long words = minLength + 64L - 1L >> 6;
        long[] bits = this.bits;
        long[] vBits = v.bits;
        int i = 0;
        while ((long)i < words) {
            if (bits[i] != vBits[i]) {
                return Math.min(minLength, (long)(i * 64 + Fast.leastSignificantBit(bits[i] ^ vBits[i])));
            }
            ++i;
        }
        return minLength;
    }

    @Override
    public BitVector and(BitVector v) {
        if (v instanceof LongArrayBitVector) {
            LongArrayBitVector l = (LongArrayBitVector)v;
            int words = Math.min(LongArrayBitVector.numWords(this.length()), LongArrayBitVector.numWords(l.length()));
            while (words-- != 0) {
                int n = words;
                this.bits[n] = this.bits[n] & l.bits[words];
            }
        } else {
            super.and(v);
        }
        return this;
    }

    @Override
    public BitVector or(BitVector v) {
        if (v instanceof LongArrayBitVector) {
            LongArrayBitVector l = (LongArrayBitVector)v;
            int words = Math.min(LongArrayBitVector.numWords(this.length()), LongArrayBitVector.numWords(l.length()));
            while (words-- != 0) {
                int n = words;
                this.bits[n] = this.bits[n] | l.bits[words];
            }
        } else {
            super.or(v);
        }
        return this;
    }

    @Override
    public BitVector xor(BitVector v) {
        if (v instanceof LongArrayBitVector) {
            LongArrayBitVector l = (LongArrayBitVector)v;
            int words = Math.min(LongArrayBitVector.numWords(this.length()), LongArrayBitVector.numWords(l.length()));
            while (words-- != 0) {
                int n = words;
                this.bits[n] = this.bits[n] ^ l.bits[words];
            }
        } else {
            super.xor(v);
        }
        return this;
    }

    public static LongArrayBitVector wrap(long[] array, long size) {
        if (size > (long)(array.length << 6)) {
            throw new IllegalArgumentException("The provided array is too short (" + array.length + " elements) for the given size (" + size + ")");
        }
        LongArrayBitVector result = new LongArrayBitVector(0L);
        result.length = size;
        result.bits = array;
        int lastWord = (int)(size / 64L);
        int arrayLength = array.length;
        if (lastWord < arrayLength && (array[lastWord] & ((1L << (int)(size % 64L)) - 1L ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            throw new IllegalArgumentException("Garbage beyond size in bit array");
        }
        for (int i = lastWord + 1; i < arrayLength; ++i) {
            if (array[i] == 0L) continue;
            throw new IllegalArgumentException("Garbage beyond size in bit array");
        }
        return result;
    }

    public static LongArrayBitVector wrap(long[] array) {
        return LongArrayBitVector.wrap(array, array.length * 64);
    }

    public LongArrayBitVector clone() throws CloneNotSupportedException {
        LongArrayBitVector copy = (LongArrayBitVector)super.clone();
        copy.bits = (long[])this.bits.clone();
        return copy;
    }

    public LongArrayBitVector replace(LongArrayBitVector bv) {
        int bvFirstFreeWord;
        this.ensureCapacity(bv.length);
        long[] bits = this.bits;
        long[] bvBits = bv.bits;
        int i = bvFirstFreeWord = LongArrayBitVector.word(bv.length - 1L) + 1;
        while (i-- != 0) {
            bits[i] = bvBits[i];
        }
        int thisFirstFreeWord = LongArrayBitVector.word(this.length - 1L) + 1;
        if (bvFirstFreeWord < thisFirstFreeWord) {
            LongArrays.fill(this.bits, bvFirstFreeWord, thisFirstFreeWord, 0L);
        }
        this.length = bv.length;
        return this;
    }

    @Override
    public LongArrayBitVector replace(BitVector bv) {
        long bvLength = bv.length();
        this.ensureCapacity(bvLength);
        long[] bits = this.bits;
        long fullBits = bvLength - bvLength % 64L;
        for (long i = 0L; i < fullBits; i += 64L) {
            bits[(int)(i / 64L)] = bv.getLong(i, i + 64L);
        }
        int bvFirstFreeWord = LongArrayBitVector.word(bvLength - 1L) + 1;
        int thisFirstFreeWord = LongArrayBitVector.word(this.length - 1L) + 1;
        if (bvLength % 64L != 0L) {
            bits[(int)(fullBits / 64L)] = bv.getLong(fullBits, bvLength);
        }
        if (bvFirstFreeWord < thisFirstFreeWord) {
            LongArrays.fill(this.bits, bvFirstFreeWord, thisFirstFreeWord, 0L);
        }
        this.length = bvLength;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof LongArrayBitVector) {
            return this.equals((LongArrayBitVector)o);
        }
        return super.equals(o);
    }

    public boolean equals(LongArrayBitVector v) {
        if (this.length != v.length()) {
            return false;
        }
        int i = LongArrayBitVector.numWords(this.length);
        while (i-- != 0) {
            if (this.bits[i] == v.bits[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        long h = 0x9E3779B97F4A7C13L ^ this.length;
        int numWords = LongArrayBitVector.numWords(this.length);
        for (int i = 0; i < numWords; ++i) {
            h ^= (h << 5) + this.bits[i] + (h >>> 2);
        }
        return (int)(h >>> 32 ^ h);
    }

    @Override
    public LongBigList asLongBigList(int width) {
        return new LongBigListView(this, width);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        int numWords = LongArrayBitVector.numWords(this.length);
        for (int i = 0; i < numWords; ++i) {
            s.writeLong(this.bits[i]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int numWords = LongArrayBitVector.numWords(this.length);
        this.bits = new long[numWords];
        for (int i = 0; i < numWords; ++i) {
            this.bits[i] = s.readLong();
        }
    }

    protected static class LongBigListView
    extends AbstractBitVector.LongBigListView {
        private static final long serialVersionUID = 1L;
        private final LongArrayBitVector bitVector;

        public LongBigListView(LongArrayBitVector bitVector, int width) {
            super(bitVector, width);
            this.bitVector = bitVector;
        }

        @Override
        public boolean add(long value) {
            this.bitVector.append(value, this.width);
            return true;
        }

        @Override
        public long getLong(long index) {
            long start = index * (long)this.width;
            return this.bitVector.getLong(start, start + (long)this.width);
        }

        @Override
        public void clear() {
            this.bitVector.clear();
        }

        @Override
        public long set(long index, long value) {
            long oldValue;
            if (this.width == 0) {
                return 0L;
            }
            if (this.width != 64 && value > this.fullMask) {
                throw new IllegalArgumentException("Value too large: " + value);
            }
            long[] bits = this.bitVector.bits;
            long start = index * (long)this.width;
            int startWord = LongArrayBitVector.word(start);
            int endWord = LongArrayBitVector.word(start + (long)this.width - 1L);
            int startBit = LongArrayBitVector.bit(start);
            if (startWord == endWord) {
                oldValue = bits[startWord] >>> startBit & this.fullMask;
                int n = startWord;
                bits[n] = bits[n] & (this.fullMask << startBit ^ 0xFFFFFFFFFFFFFFFFL);
                int n2 = startWord;
                bits[n2] = bits[n2] | value << startBit;
            } else {
                oldValue = bits[startWord] >>> startBit | bits[endWord] << 64 - startBit & this.fullMask;
                int n = startWord;
                bits[n] = bits[n] & (1L << startBit) - 1L;
                int n3 = startWord;
                bits[n3] = bits[n3] | value << startBit;
                int n4 = endWord;
                bits[n4] = bits[n4] & -(1L << this.width - 64 + startBit);
                int n5 = endWord;
                bits[n5] = bits[n5] | value >>> 64 - startBit;
            }
            return oldValue;
        }
    }
}

