/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.bits;

import it.unimi.dsi.bits.AbstractBitVector;
import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.TransformationStrategy;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.lang.MutableString;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;

public class TransformationStrategies {
    private static final TransformationStrategy<BitVector> IDENTITY = new TransformationStrategy<BitVector>(){
        private static final long serialVersionUID = 1L;

        @Override
        public BitVector toBitVector(BitVector object) {
            return object;
        }

        @Override
        public long numBits() {
            return 0L;
        }

        @Override
        public TransformationStrategy<BitVector> copy() {
            return this;
        }

        public Object readResolve() {
            return IDENTITY;
        }
    };
    private static final TransformationStrategy<CharSequence> UTF16 = new Utf16TransformationStrategy(false);
    private static final TransformationStrategy<CharSequence> PREFIX_FREE_UTF16 = new Utf16TransformationStrategy(true);
    private static final TransformationStrategy<CharSequence> ISO = new ISOTransformationStrategy(false);
    private static final TransformationStrategy<CharSequence> PREFIX_FREE_ISO = new ISOTransformationStrategy(true);
    private static final TransformationStrategy<? extends BitVector> PREFIX_FREE = new PrefixFreeTransformationStrategy();

    public static <T extends BitVector> TransformationStrategy<T> identity() {
        return IDENTITY;
    }

    public static <T extends CharSequence> TransformationStrategy<T> utf16() {
        return UTF16;
    }

    public static <T extends CharSequence> TransformationStrategy<T> prefixFreeUtf16() {
        return PREFIX_FREE_UTF16;
    }

    public static <T extends CharSequence> TransformationStrategy<T> iso() {
        return ISO;
    }

    public static <T extends CharSequence> TransformationStrategy<T> prefixFreeIso() {
        return PREFIX_FREE_ISO;
    }

    public static <T> Iterator<BitVector> wrap(Iterator<T> iterator, TransformationStrategy<? super T> transformationStrategy) {
        return transformationStrategy == IDENTITY ? iterator : new IteratorWrapper<T>(iterator, transformationStrategy);
    }

    public static <T> Iterable<BitVector> wrap(Iterable<T> iterable, TransformationStrategy<? super T> transformationStrategy) {
        return transformationStrategy == IDENTITY ? iterable : new IterableWrapper<T>(iterable, transformationStrategy);
    }

    public static <T> List<BitVector> wrap(List<T> list, TransformationStrategy<? super T> transformationStrategy) {
        return transformationStrategy == IDENTITY ? list : new ListWrapper<T>(list, transformationStrategy);
    }

    public static <T extends BitVector> TransformationStrategy<T> prefixFree() {
        return PREFIX_FREE;
    }

    private static class PrefixFreeTransformationStrategy
    implements TransformationStrategy<BitVector>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private PrefixFreeTransformationStrategy() {
        }

        @Override
        public BitVector toBitVector(BitVector v) {
            return new PrefixFreeBitVector(v);
        }

        @Override
        public long numBits() {
            return 0L;
        }

        @Override
        public TransformationStrategy<BitVector> copy() {
            return this;
        }

        private Object readResolve() {
            return PREFIX_FREE;
        }

        private static class PrefixFreeBitVector
        extends AbstractBitVector
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private transient BitVector v;
            private transient long length;

            public PrefixFreeBitVector(BitVector v) {
                this.v = v;
                this.length = v.length() * 2L + 1L;
            }

            @Override
            public boolean getBoolean(long index) {
                if (index >= this.length) {
                    throw new IndexOutOfBoundsException();
                }
                if (index == this.length - 1L) {
                    return false;
                }
                if (index % 2L == 0L) {
                    return true;
                }
                return this.v.getBoolean(index / 2L);
            }

            @Override
            public long getLong(long from, long to) {
                int startBit = (int)(from % 64L);
                if (startBit == 0 && to - from == 64L) {
                    long word = this.v.getLong(from / 2L, Math.min(this.v.length(), from / 2L + 64L));
                    word = from % 2L != 0L ? (word >>>= 32) : (word &= 0xFFFFFFFFL);
                    word = (word | word << 16) & 0xFFFF0000FFFFL;
                    word = (word | word << 8) & 0xFF00FF00FF00FFL;
                    word = (word | word << 4) & 0xF0F0F0F0F0F0F0FL;
                    word = (word | word << 2) & 0x3333333333333333L;
                    word = word << 1 | word << 2 | 0x5555555555555555L;
                    return word;
                }
                return super.getLong(from, to);
            }

            @Override
            public long length() {
                return this.length;
            }
        }
    }

    private static final class ListWrapper<T>
    extends AbstractObjectList<BitVector> {
        private final TransformationStrategy<? super T> transformationStrategy;
        private final List<T> list;

        public ListWrapper(List<T> list, TransformationStrategy<? super T> transformationStrategy) {
            this.list = list;
            this.transformationStrategy = transformationStrategy;
        }

        @Override
        public BitVector get(int index) {
            return this.transformationStrategy.toBitVector(this.list.get(index));
        }

        @Override
        public int size() {
            return this.list.size();
        }
    }

    private static final class IterableWrapper<T>
    implements Iterable<BitVector> {
        private final TransformationStrategy<? super T> transformationStrategy;
        private final Iterable<T> collection;

        public IterableWrapper(Iterable<T> collection, TransformationStrategy<? super T> transformationStrategy) {
            this.collection = collection;
            this.transformationStrategy = transformationStrategy;
        }

        @Override
        public ObjectIterator<BitVector> iterator() {
            return new IteratorWrapper<T>(this.collection.iterator(), this.transformationStrategy.copy());
        }
    }

    private static final class IteratorWrapper<T>
    extends AbstractObjectIterator<BitVector> {
        final Iterator<T> iterator;
        final TransformationStrategy<? super T> transformationStrategy;

        public IteratorWrapper(Iterator<T> iterator, TransformationStrategy<? super T> transformationStrategy) {
            this.iterator = iterator;
            this.transformationStrategy = transformationStrategy;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public BitVector next() {
            return this.transformationStrategy.toBitVector(this.iterator.next());
        }
    }

    private static class ISOTransformationStrategy
    implements TransformationStrategy<CharSequence>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final boolean prefixFree;

        protected ISOTransformationStrategy(boolean prefixFree) {
            this.prefixFree = prefixFree;
        }

        @Override
        public BitVector toBitVector(CharSequence s) {
            return s instanceof MutableString ? new ISOMutableStringBitVector((MutableString)s, this.prefixFree) : new ISOCharSequenceBitVector(s, this.prefixFree);
        }

        @Override
        public long numBits() {
            return 0L;
        }

        @Override
        public TransformationStrategy<CharSequence> copy() {
            return this;
        }

        private Object readResolve() {
            return this.prefixFree ? PREFIX_FREE_ISO : ISO;
        }

        private static class ISOMutableStringBitVector
        extends AbstractBitVector
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private transient char[] a;
            private transient long length;
            private transient long actualEnd;

            public ISOMutableStringBitVector(MutableString s, boolean prefixFree) {
                this.a = s.array();
                this.actualEnd = s.length() * 8;
                this.length = this.actualEnd + (long)(prefixFree ? 8 : 0);
            }

            @Override
            public boolean getBoolean(long index) {
                if (index > this.length) {
                    throw new IndexOutOfBoundsException();
                }
                if (index >= this.actualEnd) {
                    return false;
                }
                int byteIndex = (int)(index / 8L);
                return (this.a[byteIndex] & 128 >>> (int)(index % 8L)) != 0;
            }

            @Override
            public long getLong(long from, long to) {
                int startBit = (int)(from % 64L);
                if (startBit == 0 && to % 8L == 0L) {
                    long l;
                    if (from == to) {
                        return 0L;
                    }
                    int pos = (int)(from / 8L);
                    if (to == from + 64L) {
                        l = (to > this.actualEnd ? 0L : (long)this.a[pos + 7] & 0xFFL) << 56 | ((long)this.a[pos + 6] & 0xFFL) << 48 | ((long)this.a[pos + 5] & 0xFFL) << 40 | ((long)this.a[pos + 4] & 0xFFL) << 32 | ((long)this.a[pos + 3] & 0xFFL) << 24 | (long)((this.a[pos + 2] & 0xFF) << 16) | (long)((this.a[pos + 1] & 0xFF) << 8) | (long)(this.a[pos] & 0xFF);
                    } else {
                        l = 0L;
                        int residual = (int)(Math.min(this.actualEnd, to) - from);
                        int i = residual / 8;
                        while (i-- != 0) {
                            l |= ((long)this.a[pos + i] & 0xFFL) << i * 8;
                        }
                    }
                    l = (l & 0x5555555555555555L) << 1 | l >>> 1 & 0x5555555555555555L;
                    l = (l & 0x3333333333333333L) << 2 | l >>> 2 & 0x3333333333333333L;
                    return (l & 0xF0F0F0F0F0F0F0FL) << 4 | l >>> 4 & 0xF0F0F0F0F0F0F0FL;
                }
                long l = 64L - (to - from);
                long startPos = from - (long)startBit;
                if (l == 64L) {
                    return 0L;
                }
                if ((long)startBit <= l) {
                    return this.getLong(startPos, Math.min(this.length, startPos + 64L)) << (int)(l - (long)startBit) >>> (int)l;
                }
                return this.getLong(startPos, startPos + 64L) >>> startBit | this.getLong(startPos + 64L, Math.min(this.length, startPos + 128L)) << (int)(64L + l - (long)startBit) >>> (int)l;
            }

            @Override
            public long length() {
                return this.length;
            }
        }

        private static class ISOCharSequenceBitVector
        extends AbstractBitVector
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private transient CharSequence s;
            private transient long length;
            private transient long actualEnd;

            public ISOCharSequenceBitVector(CharSequence s, boolean prefixFree) {
                this.s = s;
                this.actualEnd = s.length() * 8;
                this.length = this.actualEnd + (long)(prefixFree ? 8 : 0);
            }

            @Override
            public boolean getBoolean(long index) {
                if (index > this.length) {
                    throw new IndexOutOfBoundsException();
                }
                if (index >= this.actualEnd) {
                    return false;
                }
                int byteIndex = (int)(index / 8L);
                return (this.s.charAt(byteIndex) & 128 >>> (int)(index % 8L)) != 0;
            }

            @Override
            public long getLong(long from, long to) {
                int startBit = (int)(from % 64L);
                if (startBit == 0 && to % 8L == 0L) {
                    long l;
                    if (from == to) {
                        return 0L;
                    }
                    int pos = (int)(from / 8L);
                    if (to == from + 64L) {
                        l = (to > this.actualEnd ? 0L : (long)this.s.charAt(pos + 7) & 0xFFL) << 56 | ((long)this.s.charAt(pos + 6) & 0xFFL) << 48 | ((long)this.s.charAt(pos + 5) & 0xFFL) << 40 | ((long)this.s.charAt(pos + 4) & 0xFFL) << 32 | ((long)this.s.charAt(pos + 3) & 0xFFL) << 24 | (long)((this.s.charAt(pos + 2) & 0xFF) << 16) | (long)((this.s.charAt(pos + 1) & 0xFF) << 8) | (long)(this.s.charAt(pos) & 0xFF);
                    } else {
                        l = 0L;
                        int residual = (int)(Math.min(this.actualEnd, to) - from);
                        int i = residual / 8;
                        while (i-- != 0) {
                            l |= ((long)this.s.charAt(pos + i) & 0xFFL) << i * 8;
                        }
                    }
                    l = (l & 0x5555555555555555L) << 1 | l >>> 1 & 0x5555555555555555L;
                    l = (l & 0x3333333333333333L) << 2 | l >>> 2 & 0x3333333333333333L;
                    return (l & 0xF0F0F0F0F0F0F0FL) << 4 | l >>> 4 & 0xF0F0F0F0F0F0F0FL;
                }
                long l = 64L - (to - from);
                long startPos = from - (long)startBit;
                if (l == 64L) {
                    return 0L;
                }
                if ((long)startBit <= l) {
                    return this.getLong(startPos, Math.min(this.length, startPos + 64L)) << (int)(l - (long)startBit) >>> (int)l;
                }
                return this.getLong(startPos, startPos + 64L) >>> startBit | this.getLong(startPos + 64L, Math.min(this.length, startPos + 128L)) << (int)(64L + l - (long)startBit) >>> (int)l;
            }

            @Override
            public long length() {
                return this.length;
            }
        }
    }

    private static class Utf16TransformationStrategy
    implements TransformationStrategy<CharSequence>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final boolean prefixFree;

        protected Utf16TransformationStrategy(boolean prefixFree) {
            this.prefixFree = prefixFree;
        }

        @Override
        public BitVector toBitVector(CharSequence s) {
            return s instanceof MutableString ? new Utf16MutableStringBitVector((MutableString)s, this.prefixFree) : new Utf16CharSequenceBitVector(s, this.prefixFree);
        }

        @Override
        public long numBits() {
            return 0L;
        }

        @Override
        public TransformationStrategy<CharSequence> copy() {
            return this;
        }

        private Object readResolve() {
            return this.prefixFree ? PREFIX_FREE_UTF16 : UTF16;
        }

        private static class Utf16MutableStringBitVector
        extends AbstractBitVector
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private transient char[] a;
            private transient long length;
            private transient long actualEnd;

            public Utf16MutableStringBitVector(MutableString s, boolean prefixFree) {
                this.a = s.array();
                this.actualEnd = s.length() * 16;
                this.length = this.actualEnd + (long)(prefixFree ? 16 : 0);
            }

            @Override
            public boolean getBoolean(long index) {
                if (index > this.length) {
                    throw new IndexOutOfBoundsException();
                }
                if (index >= this.actualEnd) {
                    return false;
                }
                int charIndex = (int)(index / 16L);
                return (this.a[charIndex] & 32768 >>> (int)(index % 16L)) != 0;
            }

            @Override
            public long getLong(long from, long to) {
                int startBit = (int)(from % 64L);
                if (startBit == 0 && to % 16L == 0L) {
                    long l;
                    if (from == to) {
                        return 0L;
                    }
                    int pos = (int)(from / 16L);
                    if (to == from + 64L) {
                        l = (to > this.actualEnd ? 0L : (long)this.a[pos + 3]) << 48 | (long)this.a[pos + 2] << 32 | (long)this.a[pos + 1] << 16 | (long)this.a[pos];
                    } else {
                        l = 0L;
                        int residual = (int)(Math.min(this.actualEnd, to) - from);
                        int i = residual / 16;
                        while (i-- != 0) {
                            l |= (long)this.a[pos + i] << i * 16;
                        }
                    }
                    l = (l & 0x5555555555555555L) << 1 | l >>> 1 & 0x5555555555555555L;
                    l = (l & 0x3333333333333333L) << 2 | l >>> 2 & 0x3333333333333333L;
                    l = (l & 0xF0F0F0F0F0F0F0FL) << 4 | l >>> 4 & 0xF0F0F0F0F0F0F0FL;
                    return (l & 0xFF00FF00FF00FFL) << 8 | l >>> 8 & 0xFF00FF00FF00FFL;
                }
                long l = 64L - (to - from);
                long startPos = from - (long)startBit;
                if (l == 64L) {
                    return 0L;
                }
                if ((long)startBit <= l) {
                    return this.getLong(startPos, Math.min(this.length, startPos + 64L)) << (int)(l - (long)startBit) >>> (int)l;
                }
                return this.getLong(startPos, startPos + 64L) >>> startBit | this.getLong(startPos + 64L, Math.min(this.length, startPos + 128L)) << (int)(64L + l - (long)startBit) >>> (int)l;
            }

            @Override
            public long length() {
                return this.length;
            }
        }

        private static class Utf16CharSequenceBitVector
        extends AbstractBitVector
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private transient CharSequence s;
            private transient long length;
            private transient long actualEnd;

            public Utf16CharSequenceBitVector(CharSequence s, boolean prefixFree) {
                this.s = s;
                this.actualEnd = s.length() * 16;
                this.length = this.actualEnd + (long)(prefixFree ? 16 : 0);
            }

            @Override
            public boolean getBoolean(long index) {
                if (index > this.length) {
                    throw new IndexOutOfBoundsException();
                }
                if (index >= this.actualEnd) {
                    return false;
                }
                int charIndex = (int)(index / 16L);
                return (this.s.charAt(charIndex) & 32768 >>> (int)(index % 16L)) != 0;
            }

            @Override
            public long getLong(long from, long to) {
                int startBit = (int)(from % 64L);
                if (startBit == 0 && to % 16L == 0L) {
                    long l;
                    if (from == to) {
                        return 0L;
                    }
                    int pos = (int)(from / 16L);
                    if (to == from + 64L) {
                        l = (to > this.actualEnd ? 0L : (long)this.s.charAt(pos + 3)) << 48 | (long)this.s.charAt(pos + 2) << 32 | (long)this.s.charAt(pos + 1) << 16 | (long)this.s.charAt(pos);
                    } else {
                        l = 0L;
                        int residual = (int)(Math.min(this.actualEnd, to) - from);
                        int i = residual / 16;
                        while (i-- != 0) {
                            l |= (long)this.s.charAt(pos + i) << i * 16;
                        }
                    }
                    l = (l & 0x5555555555555555L) << 1 | l >>> 1 & 0x5555555555555555L;
                    l = (l & 0x3333333333333333L) << 2 | l >>> 2 & 0x3333333333333333L;
                    l = (l & 0xF0F0F0F0F0F0F0FL) << 4 | l >>> 4 & 0xF0F0F0F0F0F0F0FL;
                    return (l & 0xFF00FF00FF00FFL) << 8 | l >>> 8 & 0xFF00FF00FF00FFL;
                }
                long l = 64L - (to - from);
                long startPos = from - (long)startBit;
                if (l == 64L) {
                    return 0L;
                }
                if ((long)startBit <= l) {
                    return this.getLong(startPos, Math.min(this.length, startPos + 64L)) << (int)(l - (long)startBit) >>> (int)l;
                }
                return this.getLong(startPos, startPos + 64L) >>> startBit | this.getLong(startPos + 64L, Math.min(this.length, startPos + 128L)) << (int)(64L + l - (long)startBit) >>> (int)l;
            }

            @Override
            public long length() {
                return this.length;
            }
        }
    }
}

