/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.compression;

import cern.colt.Sorting;
import cern.colt.function.IntComparator;
import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.compression.CanonicalFast64CodeWordDecoder;
import it.unimi.dsi.compression.CodeWordCoder;
import it.unimi.dsi.compression.Decoder;
import it.unimi.dsi.compression.Fast64CodeWordCoder;
import it.unimi.dsi.compression.PrefixCodec;
import it.unimi.dsi.compression.PrefixCoder;
import java.io.Serializable;
import java.util.Arrays;

public class HuffmanCodec
implements PrefixCodec,
Serializable {
    private static final boolean DEBUG = false;
    private static final boolean ASSERTS = false;
    private static final long serialVersionUID = 2L;
    public final int size;
    private final BitVector[] codeWord;
    private final Fast64CodeWordCoder coder;
    private final CanonicalFast64CodeWordDecoder decoder;

    public HuffmanCodec(int[] frequency) {
        this(frequency, new DecoderInputs());
    }

    public HuffmanCodec(final int[] frequency, DecoderInputs decoderInputs) {
        int next;
        if (decoderInputs == null) {
            throw new IllegalArgumentException();
        }
        this.size = frequency.length;
        if (this.size == 0 || this.size == 1) {
            this.codeWord = new BitVector[this.size];
            if (this.size == 1) {
                this.codeWord[0] = LongArrayBitVector.getInstance();
            }
            this.coder = new Fast64CodeWordCoder(this.codeWord, new long[this.size]);
            decoderInputs.shortestCodeWord = LongArrayBitVector.getInstance().length(0L);
            DecoderInputs.access$102(decoderInputs, new int[this.size]);
            DecoderInputs.access$202(decoderInputs, new int[this.size]);
            this.decoder = new CanonicalFast64CodeWordDecoder(decoderInputs.length, decoderInputs.symbol);
            return;
        }
        long[] a = new long[this.size];
        int i = this.size;
        while (i-- != 0) {
            a[i] = frequency[i];
        }
        Arrays.sort(a);
        a[0] = a[0] + a[1];
        int root = 0;
        int leaf = 2;
        for (next = 1; next < this.size - 1; ++next) {
            if (leaf >= this.size || a[root] < a[leaf]) {
                a[next] = a[root];
                a[root++] = next;
            } else {
                a[next] = a[leaf++];
            }
            if (leaf >= this.size || root < next && a[root] < a[leaf]) {
                int n = next;
                a[n] = a[n] + a[root];
                a[root++] = next;
                continue;
            }
            int n = next;
            a[n] = a[n] + a[leaf++];
        }
        a[this.size - 2] = 0L;
        for (next = this.size - 3; next >= 0; --next) {
            a[next] = a[(int)a[next]] + 1L;
        }
        int available = 1;
        int used = 0;
        int depth = 0;
        root = this.size - 2;
        int next2 = this.size - 1;
        while (available > 0) {
            while (root >= 0 && a[root] == (long)depth) {
                ++used;
                --root;
            }
            while (available > used) {
                a[next2--] = depth;
                --available;
            }
            available = 2 * used;
            ++depth;
            used = 0;
        }
        int[] length = new int[this.size];
        int i2 = this.size;
        while (i2-- != 0) {
            length[i2] = (int)a[this.size - 1 - i2];
        }
        int[] symbol = new int[this.size];
        int i3 = this.size;
        while (i3-- != 0) {
            symbol[i3] = i3;
        }
        Sorting.quickSort(symbol, 0, this.size, new IntComparator(){

            @Override
            public int compare(int x, int y) {
                return frequency[y] - frequency[x];
            }
        });
        int s = symbol[0];
        int l = length[0];
        long value = 0L;
        this.codeWord = new BitVector[this.size];
        long[] longCodeWord = new long[this.size];
        this.codeWord[s] = LongArrayBitVector.getInstance().length(l);
        for (int i4 = 1; i4 < this.size; ++i4) {
            s = symbol[i4];
            if (length[i4] == l) {
                ++value;
            } else {
                ++value;
                value <<= length[i4] - l;
                l = length[i4];
            }
            LongArrayBitVector v = LongArrayBitVector.getInstance().length(l);
            int j = l;
            while (j-- != 0) {
                if ((1L << j & value) == 0L) continue;
                v.set((long)(l - 1 - j));
            }
            this.codeWord[s] = v;
            longCodeWord[s] = value;
        }
        this.coder = new Fast64CodeWordCoder(this.codeWord, longCodeWord);
        decoderInputs.shortestCodeWord = this.codeWord[symbol[0]];
        DecoderInputs.access$102(decoderInputs, length);
        DecoderInputs.access$202(decoderInputs, symbol);
        assert (decoderInputs.shortestCodeWord.size() == length[0]) : "shortestCodeWord=" + DecoderInputs.access$000(decoderInputs) + ", but length[0]=" + length[0];
        this.decoder = new CanonicalFast64CodeWordDecoder(decoderInputs.length, decoderInputs.symbol);
    }

    @Override
    public CodeWordCoder coder() {
        return this.coder;
    }

    @Override
    public Decoder decoder() {
        return this.decoder;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public BitVector[] codeWords() {
        return this.coder.codeWords();
    }

    public static PrefixCoder newCoder(DecoderInputs decoderInputs) {
        return HuffmanCodec.newCoder(decoderInputs.getShortestCodeWord(), decoderInputs.getLengths(), decoderInputs.getSymbols());
    }

    public static PrefixCoder newCoder(BitVector shortestCodeWord, int[] length, int[] symbol) {
        if (shortestCodeWord == null) {
            throw new IllegalArgumentException();
        }
        if (shortestCodeWord.size() == 0) {
            throw new IllegalArgumentException();
        }
        if (length == null) {
            throw new IllegalArgumentException();
        }
        if (length.length == 0) {
            throw new IllegalArgumentException();
        }
        if (symbol == null) {
            throw new IllegalArgumentException();
        }
        if (symbol.length == 0) {
            throw new IllegalArgumentException();
        }
        int size = length.length;
        int s = symbol[0];
        int l = length[0];
        long value = 0L;
        BitVector[] codeWord = new BitVector[size];
        long[] longCodeWord = new long[size];
        codeWord[s] = LongArrayBitVector.getInstance().length(l);
        for (int i = 1; i < size; ++i) {
            s = symbol[i];
            if (length[i] == l) {
                ++value;
            } else {
                ++value;
                value <<= length[i] - l;
                l = length[i];
            }
            LongArrayBitVector v = LongArrayBitVector.getInstance().length(l);
            int j = l;
            while (j-- != 0) {
                if ((1L << j & value) == 0L) continue;
                v.set((long)(l - 1 - j));
            }
            codeWord[s] = v;
            longCodeWord[s] = value;
        }
        return new Fast64CodeWordCoder(codeWord, longCodeWord);
    }

    public static class DecoderInputs {
        private BitVector shortestCodeWord;
        private int[] symbol;
        private int[] length;

        public DecoderInputs() {
        }

        public DecoderInputs(BitVector shortestCodeWord, int[] length, int[] symbol) {
            assert (shortestCodeWord != null);
            assert (length != null);
            assert (symbol != null);
            assert (length.length == symbol.length);
            assert (shortestCodeWord.size() == length[0]);
            this.shortestCodeWord = shortestCodeWord;
            this.length = length;
            this.symbol = symbol;
        }

        public BitVector getShortestCodeWord() {
            return this.shortestCodeWord;
        }

        public int[] getSymbols() {
            return this.symbol;
        }

        public int[] getLengths() {
            return this.length;
        }

        static /* synthetic */ int[] access$102(DecoderInputs x0, int[] x1) {
            x0.length = x1;
            return x1;
        }

        static /* synthetic */ int[] access$202(DecoderInputs x0, int[] x1) {
            x0.symbol = x1;
            return x1;
        }
    }
}

