/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntComparator;

public class IntSemiIndirectHeaps {
    private IntSemiIndirectHeaps() {
    }

    public static int downHeap(int[] refArray, int[] heap, int size, int i, IntComparator c) {
        if (i >= size) {
            throw new IllegalArgumentException("Heap position (" + i + ") is larger than or equal to heap size (" + size + ")");
        }
        int e = heap[i];
        int E2 = refArray[e];
        if (c == null) {
            int child;
            while ((child = 2 * i + 1) < size) {
                if (child + 1 < size && refArray[heap[child + 1]] < refArray[heap[child]]) {
                    ++child;
                }
                if (E2 > refArray[heap[child]]) {
                    heap[i] = heap[child];
                    i = child;
                    continue;
                }
                break;
            }
        } else {
            int child;
            while ((child = 2 * i + 1) < size) {
                if (child + 1 < size && c.compare(refArray[heap[child + 1]], refArray[heap[child]]) < 0) {
                    ++child;
                }
                if (c.compare(E2, refArray[heap[child]]) > 0) {
                    heap[i] = heap[child];
                    i = child;
                    continue;
                }
                break;
            }
        }
        heap[i] = e;
        return i;
    }

    public static int upHeap(int[] refArray, int[] heap, int size, int i, IntComparator c) {
        if (i >= size) {
            throw new IllegalArgumentException("Heap position (" + i + ") is larger than or equal to heap size (" + size + ")");
        }
        int e = heap[i];
        int E2 = refArray[e];
        if (c == null) {
            int parent;
            while (i != 0 && (parent = (i - 1) / 2) >= 0 && refArray[heap[parent]] > E2) {
                heap[i] = heap[parent];
                i = parent;
            }
        } else {
            int parent;
            while (i != 0 && (parent = (i - 1) / 2) >= 0 && c.compare(refArray[heap[parent]], E2) > 0) {
                heap[i] = heap[parent];
                i = parent;
            }
        }
        heap[i] = e;
        return i;
    }

    public static void makeHeap(int[] refArray, int offset, int length, int[] heap, IntComparator c) {
        IntArrays.ensureOffsetLength(refArray, offset, length);
        if (heap.length < length) {
            throw new IllegalArgumentException("The heap length (" + heap.length + ") is smaller than the number of elements (" + length + ")");
        }
        int i = length;
        while (i-- != 0) {
            heap[i] = offset + i;
        }
        i = length / 2;
        while (i-- != 0) {
            IntSemiIndirectHeaps.downHeap(refArray, heap, length, i, c);
        }
    }

    public static int[] makeHeap(int[] refArray, int offset, int length, IntComparator c) {
        int[] heap = length <= 0 ? IntArrays.EMPTY_ARRAY : new int[length];
        IntSemiIndirectHeaps.makeHeap(refArray, offset, length, heap, c);
        return heap;
    }

    public static void makeHeap(int[] refArray, int[] heap, int size, IntComparator c) {
        int i = size / 2;
        while (i-- != 0) {
            IntSemiIndirectHeaps.downHeap(refArray, heap, size, i, c);
        }
    }

    public static int front(int[] refArray, int[] heap, int size, int[] a) {
        int top = refArray[heap[0]];
        int j = 0;
        int l = 0;
        int r = 1;
        int f = 0;
        for (int i = 0; i < r; ++i) {
            if (i == f) {
                if (l >= r) break;
                f = (f << 1) + 1;
                i = l;
                l = -1;
            }
            if (top != refArray[heap[i]]) continue;
            a[j++] = heap[i];
            if (l == -1) {
                l = i * 2 + 1;
            }
            r = Math.min(size, i * 2 + 3);
        }
        return j;
    }

    public static int front(int[] refArray, int[] heap, int size, int[] a, IntComparator c) {
        int top = refArray[heap[0]];
        int j = 0;
        int l = 0;
        int r = 1;
        int f = 0;
        for (int i = 0; i < r; ++i) {
            if (i == f) {
                if (l >= r) break;
                f = (f << 1) + 1;
                i = l;
                l = -1;
            }
            if (c.compare(top, refArray[heap[i]]) != 0) continue;
            a[j++] = heap[i];
            if (l == -1) {
                l = i * 2 + 1;
            }
            r = Math.min(size, i * 2 + 3);
        }
        return j;
    }
}

