/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.io;

import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.fastutil.booleans.AbstractBooleanIterator;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.fastutil.io.RepositionableStream;
import it.unimi.dsi.io.NullInputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.channels.FileChannel;

public class InputBitStream
extends AbstractBooleanIterator
implements Flushable,
Closeable {
    private static final boolean DEBUG = false;
    private static final boolean ASSERTS = false;
    public static final int[] GAMMA = new int[65536];
    public static final int[] DELTA = new int[65536];
    public static final int[] ZETA_3 = new int[65536];
    public static final int[] SHIFTED_GAMMA = new int[65536];
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    protected final InputStream is;
    private final boolean noBuffer;
    protected final FileChannel fileChannel;
    protected final RepositionableStream repositionableStream;
    protected final boolean wrapping;
    private long readBits;
    private int current;
    protected byte[] buffer;
    protected int fill;
    protected int pos;
    private int off = 0;
    protected int avail;
    protected long position;

    static void fillArrayFromResource(String resource, int[] array) throws IOException {
        String resouceFullPath = "/it/unimi/dsi/io/" + resource;
        InputStream ris = InputBitStream.class.getResourceAsStream(resouceFullPath);
        if (ris == null) {
            throw new IOException("Cannot open resource " + resouceFullPath);
        }
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(ris));
        BinIO.loadInts((DataInput)dis, array, 0, array.length);
        dis.close();
    }

    protected InputBitStream() {
        this.is = null;
        this.noBuffer = true;
        this.repositionableStream = null;
        this.fileChannel = null;
        this.wrapping = false;
    }

    public InputBitStream(InputStream is) {
        this(is, true);
    }

    public InputBitStream(InputStream is, boolean testForPosition) {
        this(is, 8192, testForPosition);
    }

    public InputBitStream(InputStream is, int bufSize) {
        this(is, bufSize, true);
    }

    public InputBitStream(InputStream is, int bufSize, boolean testForPosition) {
        this.is = is;
        this.wrapping = false;
        this.noBuffer = bufSize == 0;
        if (!this.noBuffer) {
            this.buffer = new byte[bufSize];
        }
        if (is instanceof RepositionableStream) {
            this.repositionableStream = (RepositionableStream)((Object)is);
            this.fileChannel = null;
        } else if (testForPosition) {
            FileChannel fc = null;
            try {
                fc = (FileChannel)is.getClass().getMethod("getChannel", new Class[0]).invoke((Object)is, new Object[0]);
            }
            catch (IllegalAccessException e) {
            }
            catch (IllegalArgumentException e) {
            }
            catch (NoSuchMethodException e) {
            }
            catch (InvocationTargetException e) {
            }
            catch (ClassCastException e) {
                // empty catch block
            }
            this.fileChannel = fc;
            this.repositionableStream = null;
        } else {
            this.repositionableStream = null;
            this.fileChannel = null;
        }
    }

    public InputBitStream(FileInputStream is) {
        this(is, 8192);
    }

    public InputBitStream(FileInputStream is, int bufSize) {
        this.is = is;
        this.wrapping = false;
        this.noBuffer = bufSize == 0;
        if (!this.noBuffer) {
            this.buffer = new byte[bufSize];
        }
        this.repositionableStream = null;
        this.fileChannel = is.getChannel();
    }

    public InputBitStream(byte[] a) {
        this(a, 0, a.length);
    }

    public InputBitStream(byte[] a, int off, int len) {
        if (a == null) {
            throw new IllegalArgumentException();
        }
        if (off < 0) {
            throw new IllegalArgumentException();
        }
        if (off + len > a.length) {
            throw new IllegalArgumentException();
        }
        this.is = NullInputStream.getInstance();
        this.repositionableStream = null;
        this.fileChannel = null;
        if (a.length > 0) {
            this.buffer = a;
            this.avail = len;
            this.off = this.pos = off;
            this.wrapping = true;
            this.noBuffer = false;
        } else {
            this.buffer = null;
            this.avail = 0;
            this.wrapping = false;
            this.noBuffer = true;
        }
    }

    public InputBitStream(String name, int bufSize) throws FileNotFoundException {
        this(new FileInputStream(name), bufSize);
    }

    public InputBitStream(String name) throws FileNotFoundException {
        this(new FileInputStream(name), 8192);
    }

    public InputBitStream(File file) throws FileNotFoundException {
        this(new FileInputStream(file), 8192);
    }

    public InputBitStream(File file, int bufSize) throws FileNotFoundException {
        this(new FileInputStream(file), bufSize);
    }

    @Override
    public void flush() {
        if (!this.wrapping) {
            this.position += (long)this.pos;
            this.avail = 0;
            this.pos = 0;
        }
        this.fill = 0;
    }

    @Override
    public void close() throws IOException {
        if (this.is != System.in) {
            this.is.close();
        }
        this.buffer = null;
    }

    public long available() throws IOException {
        return (this.is.available() + this.avail) * 8 + this.fill;
    }

    public long readBits() {
        return this.readBits;
    }

    public void readBits(long readBits) {
        this.readBits = readBits;
    }

    private final int read() throws IOException {
        if (this.noBuffer) {
            int t = this.is.read();
            if (t == -1) {
                throw new EOFException();
            }
            ++this.position;
            return t;
        }
        if (this.avail == 0) {
            this.avail = this.is.read(this.buffer);
            if (this.avail == -1) {
                this.avail = 0;
                throw new EOFException();
            }
            this.position += (long)this.pos;
            this.pos = 0;
        }
        --this.avail;
        return this.buffer[this.pos++] & 0xFF;
    }

    private final int refill() throws IOException {
        if (this.avail > 1) {
            this.avail -= 2;
            this.current = this.current << 16 | (this.buffer[this.pos++] & 0xFF) << 8 | this.buffer[this.pos++] & 0xFF;
            return this.fill += 16;
        }
        try {
            this.current = this.current << 8 | this.read();
            this.fill += 8;
            this.current = this.current << 8 | this.read();
            this.fill += 8;
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return this.fill;
    }

    private final int readFromCurrent(int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (this.fill == 0) {
            this.current = this.read();
            this.fill = 8;
        }
        this.readBits += (long)len;
        return this.current >>> (this.fill -= len) & (1 << len) - 1;
    }

    public void align() {
        if ((this.fill & 7) == 0) {
            return;
        }
        this.readBits += (long)(this.fill & 7);
        this.fill &= 0xFFFFFFF8;
    }

    public void read(byte[] bits, int len) throws IOException {
        if (len <= this.fill) {
            if (len <= 8) {
                bits[0] = (byte)(this.readFromCurrent(len) << 8 - len);
                return;
            }
            if (len <= 16) {
                bits[0] = (byte)this.readFromCurrent(8);
                bits[1] = (byte)(this.readFromCurrent(len - 8) << 16 - len);
                return;
            }
            if (len <= 24) {
                bits[0] = (byte)this.readFromCurrent(8);
                bits[1] = (byte)this.readFromCurrent(8);
                bits[2] = (byte)(this.readFromCurrent(len - 16) << 24 - len);
                return;
            }
            bits[0] = (byte)this.readFromCurrent(8);
            bits[1] = (byte)this.readFromCurrent(8);
            bits[2] = (byte)this.readFromCurrent(8);
            bits[3] = (byte)(this.readFromCurrent(len - 24) << 32 - len);
            return;
        }
        int j = 0;
        if (this.fill >= 24) {
            bits[j++] = (byte)this.readFromCurrent(8);
            bits[j++] = (byte)this.readFromCurrent(8);
            bits[j++] = (byte)this.readFromCurrent(8);
            len -= 24;
        } else if (this.fill >= 16) {
            bits[j++] = (byte)this.readFromCurrent(8);
            bits[j++] = (byte)this.readFromCurrent(8);
            len -= 16;
        } else if (this.fill >= 8) {
            bits[j++] = (byte)this.readFromCurrent(8);
            len -= 8;
        }
        int shift = this.fill;
        if (shift != 0) {
            bits[j] = (byte)(this.readFromCurrent(shift) << 8 - shift);
            int i = (len -= shift) >> 3;
            while (i-- != 0) {
                int b = this.read();
                int n = j++;
                bits[n] = (byte)(bits[n] | (b & 0xFF) >>> shift);
                bits[j] = (byte)(b << 8 - shift);
            }
        } else {
            int i = len >> 3;
            while (i-- != 0) {
                bits[j++] = (byte)this.read();
            }
        }
        this.readBits += (long)(len & 0xFFFFFFF8);
        if ((len &= 7) != 0) {
            if (shift == 0) {
                bits[j] = 0;
            }
            if (len <= 8 - shift) {
                int n = j;
                bits[n] = (byte)(bits[n] | (byte)(this.readFromCurrent(len) << 8 - shift - len));
            } else {
                int n = j;
                bits[n] = (byte)(bits[n] | (byte)this.readFromCurrent(8 - shift));
                bits[j + 1] = (byte)(this.readFromCurrent(len + shift - 8) << 16 - shift - len);
            }
        }
    }

    public int readBit() throws IOException {
        return this.readFromCurrent(1);
    }

    public int readInt(int len) throws IOException {
        int x = 0;
        if (len < 0 || len > 32) {
            throw new IllegalArgumentException("You cannot read " + len + " bits into an integer.");
        }
        if (this.fill < 16) {
            this.refill();
        }
        if (len <= this.fill) {
            return this.readFromCurrent(len);
        }
        x = this.readFromCurrent(this.fill);
        int i = (len -= this.fill) >> 3;
        while (i-- != 0) {
            x = x << 8 | this.read();
        }
        this.readBits += (long)(len & 0xFFFFFFF8);
        return x << (len &= 7) | this.readFromCurrent(len);
    }

    public long readLong(int len) throws IOException {
        long x = 0L;
        if (len < 0 || len > 64) {
            throw new IllegalArgumentException("You cannot read " + len + " bits into a long.");
        }
        if (this.fill < 16) {
            this.refill();
        }
        if (len <= this.fill) {
            return this.readFromCurrent(len);
        }
        x = this.readFromCurrent(this.fill);
        int i = (len -= this.fill) >> 3;
        while (i-- != 0) {
            x = x << 8 | (long)this.read();
        }
        this.readBits += (long)(len & 0xFFFFFFF8);
        return x << (len &= 7) | (long)this.readFromCurrent(len);
    }

    public long skip(long n) throws IOException {
        if (n <= (long)this.fill) {
            if (n < 0L) {
                throw new IllegalArgumentException("Negative bit skip value: " + n);
            }
            this.fill = (int)((long)this.fill - n);
            this.readBits += n;
            return n;
        }
        long prevReadBits = this.readBits;
        this.readBits += (long)this.fill;
        this.fill = 0;
        long nb = (n -= (long)this.fill) >> 3;
        if (this.buffer != null && nb > (long)this.avail && nb < (long)(this.avail + this.buffer.length)) {
            this.readBits += (long)(this.avail + 1 << 3);
            n -= (long)(this.avail + 1 << 3);
            nb -= (long)(this.avail + 1);
            this.position += (long)(this.pos + this.avail);
            this.avail = 0;
            this.pos = 0;
            this.read();
        }
        if (nb <= (long)this.avail) {
            this.pos += (int)nb;
            this.avail -= (int)nb;
            this.readBits += n & 0xFFFFFFFFFFFFFFF8L;
        } else {
            n -= (long)(this.avail << 3);
            this.readBits += (long)(this.avail << 3);
            long toSkip = nb - (long)this.avail;
            long skipped = this.is.skip(toSkip);
            if (skipped < toSkip) {
                throw new IOException("skip() has skipped " + skipped + " instead of " + toSkip + " bytes");
            }
            this.position += (long)(this.avail + this.pos) + skipped;
            this.pos = 0;
            this.avail = 0;
            this.readBits += skipped << 3;
            if (skipped != toSkip) {
                return this.readBits - prevReadBits;
            }
        }
        int residual = (int)(n & 7L);
        if (residual != 0) {
            this.current = this.read();
            this.fill = 8 - residual;
            this.readBits += (long)residual;
        }
        return this.readBits - prevReadBits;
    }

    public void position(long position) throws IOException {
        if ((position += (long)(this.off << 3)) < 0L) {
            throw new IllegalArgumentException("Illegal position: " + position);
        }
        long bitDelta = (this.position + (long)this.pos << 3) - position;
        if (bitDelta >= 0L && bitDelta <= (long)this.fill) {
            this.fill = (int)bitDelta;
            return;
        }
        long delta = (position >> 3) - (this.position + (long)this.pos);
        if (delta <= (long)this.avail && delta >= (long)(-this.pos)) {
            this.avail = (int)((long)this.avail - delta);
            this.pos = (int)((long)this.pos + delta);
            this.fill = 0;
        } else if (this.repositionableStream != null) {
            this.flush();
            this.position = position >> 3;
            this.repositionableStream.position(this.position);
        } else if (this.fileChannel != null) {
            this.flush();
            this.position = position >> 3;
            this.fileChannel.position(this.position);
        } else {
            if (this.wrapping) {
                throw new UnsupportedOperationException("Illegal position: " + position);
            }
            throw new UnsupportedOperationException("position() can only be called if the underlying byte stream implements the RepositionableStream interface or if the getChannel() method of the underlying byte stream exists and returns a FileChannel");
        }
        int residual = (int)(position & 7L);
        if (residual != 0) {
            this.current = this.read();
            this.fill = 8 - residual;
        }
    }

    public boolean markSupported() {
        return this.is.markSupported();
    }

    public void mark(int readLimit) throws IOException {
        if (this.fill != 0) {
            throw new IOException("You cannot mark a bit stream outside of byte boundaries.");
        }
        this.is.mark(readLimit);
    }

    public void reset() throws IOException {
        this.flush();
        this.is.reset();
    }

    public int readUnary() throws IOException {
        int currentLeftAligned;
        if (this.fill < 16) {
            this.refill();
        }
        if (this.fill != 0 && (currentLeftAligned = this.current << 32 - this.fill) != 0) {
            int x = (currentLeftAligned & 0xFF000000) != 0 ? 8 - Fast.BYTEMSB[currentLeftAligned >>> 24] : ((currentLeftAligned & 0xFF0000) != 0 ? 16 - Fast.BYTEMSB[currentLeftAligned >>> 16] : ((currentLeftAligned & 0xFF00) != 0 ? 24 - Fast.BYTEMSB[currentLeftAligned >>> 8] : 32 - Fast.BYTEMSB[currentLeftAligned & 0xFF]));
            this.readBits += (long)x;
            this.fill -= x;
            return x - 1;
        }
        int x = this.fill;
        while ((this.current = this.read()) == 0) {
            x += 8;
        }
        this.fill = Fast.BYTEMSB[this.current];
        this.readBits += (long)((x += 7 - this.fill) + 1);
        return x;
    }

    public long readLongUnary() throws IOException {
        if ((this.current & (1 << this.fill) - 1) != 0) {
            return this.readUnary();
        }
        long x = this.fill;
        while ((this.current = this.read()) == 0) {
            x += 8L;
        }
        this.fill = Fast.BYTEMSB[this.current];
        this.readBits += (x += (long)(7 - this.fill)) + 1L;
        return x;
    }

    public int readGamma() throws IOException {
        int preComp;
        if ((this.fill >= 16 || this.refill() >= 16) && (preComp = GAMMA[this.current >> this.fill - 16 & 0xFFFF]) != 0) {
            this.readBits += (long)(preComp >> 16);
            this.fill -= preComp >> 16;
            return preComp & 0xFFFF;
        }
        int msb = this.readUnary();
        return (1 << msb | this.readInt(msb)) - 1;
    }

    public long readLongGamma() throws IOException {
        int preComp;
        if ((this.fill >= 16 || this.refill() >= 16) && (preComp = GAMMA[this.current >> this.fill - 16 & 0xFFFF]) != 0) {
            this.readBits += (long)(preComp >> 16);
            this.fill -= preComp >> 16;
            return preComp & 0xFFFF;
        }
        int msb = this.readUnary();
        return (1L << msb | this.readLong(msb)) - 1L;
    }

    public void skipGammas(int n) throws IOException {
        while (n-- != 0) {
            int preComp;
            if ((this.fill >= 16 || this.refill() >= 16) && (preComp = GAMMA[this.current >> this.fill - 16 & 0xFFFF] >> 16) != 0) {
                this.readBits += (long)preComp;
                this.fill -= preComp;
                continue;
            }
            this.skip((long)this.readUnary());
        }
    }

    public void readGammas(int[] a, int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            int preComp;
            if ((this.fill >= 16 || this.refill() >= 16) && (preComp = GAMMA[this.current >> this.fill - 16 & 0xFFFF]) != 0) {
                this.readBits += (long)(preComp >> 16);
                this.fill -= preComp >> 16;
                a[i] = preComp & 0xFFFF;
                continue;
            }
            int msb = this.readUnary();
            a[i] = (1 << msb | this.readInt(msb)) - 1;
        }
    }

    public int readShiftedGamma() throws IOException {
        int preComp;
        if ((this.fill >= 16 || this.refill() >= 16) && (preComp = SHIFTED_GAMMA[this.current >> this.fill - 16 & 0xFFFF]) != 0) {
            this.readBits += (long)(preComp >> 16);
            this.fill -= preComp >> 16;
            return preComp & 0xFFFF;
        }
        int msb = this.readUnary() - 1;
        return msb == -1 ? 0 : 1 << msb | this.readInt(msb);
    }

    public long readLongShiftedGamma() throws IOException {
        int preComp;
        if ((this.fill >= 16 || this.refill() >= 16) && (preComp = SHIFTED_GAMMA[this.current >> this.fill - 16 & 0xFFFF]) != 0) {
            this.readBits += (long)(preComp >> 16);
            this.fill -= preComp >> 16;
            return preComp & 0xFFFF;
        }
        int msb = this.readUnary() - 1;
        return msb == -1 ? 0L : 1L << msb | this.readLong(msb);
    }

    public void skipShiftedGammas(int n) throws IOException {
        while (n-- != 0) {
            int preComp;
            if ((this.fill >= 16 || this.refill() >= 16) && (preComp = SHIFTED_GAMMA[this.current >> this.fill - 16 & 0xFFFF] >> 16) != 0) {
                this.readBits += (long)preComp;
                this.fill -= preComp;
                continue;
            }
            long msb = this.readUnary() - 1;
            if (msb <= 0L) continue;
            this.skip(msb);
        }
    }

    public void readShiftedGammas(int[] a, int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            int preComp;
            if ((this.fill >= 16 || this.refill() >= 16) && (preComp = SHIFTED_GAMMA[this.current >> this.fill - 16 & 0xFFFF]) != 0) {
                this.readBits += (long)(preComp >> 16);
                this.fill -= preComp >> 16;
                a[i] = preComp & 0xFFFF;
                continue;
            }
            int msb = this.readUnary() - 1;
            a[i] = msb == -1 ? 0 : 1 << msb | this.readInt(msb);
        }
    }

    public int readDelta() throws IOException {
        int preComp;
        if ((this.fill >= 16 || this.refill() >= 16) && (preComp = DELTA[this.current >> this.fill - 16 & 0xFFFF]) != 0) {
            this.readBits += (long)(preComp >> 16);
            this.fill -= preComp >> 16;
            return preComp & 0xFFFF;
        }
        int msb = this.readGamma();
        return (1 << msb | this.readInt(msb)) - 1;
    }

    public long readLongDelta() throws IOException {
        int preComp;
        if ((this.fill >= 16 || this.refill() >= 16) && (preComp = DELTA[this.current >> this.fill - 16 & 0xFFFF]) != 0) {
            this.readBits += (long)(preComp >> 16);
            this.fill -= preComp >> 16;
            return preComp & 0xFFFF;
        }
        int msb = this.readGamma();
        return (1L << msb | this.readLong(msb)) - 1L;
    }

    public void skipDeltas(int n) throws IOException {
        while (n-- != 0) {
            int preComp;
            if ((this.fill >= 16 || this.refill() >= 16) && (preComp = DELTA[this.current >> this.fill - 16 & 0xFFFF] >> 16) != 0) {
                this.readBits += (long)preComp;
                this.fill -= preComp;
                continue;
            }
            this.skip((long)this.readGamma());
        }
    }

    public void readDeltas(int[] a, int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            int preComp;
            if ((this.fill >= 16 || this.refill() >= 16) && (preComp = DELTA[this.current >> this.fill - 16 & 0xFFFF]) != 0) {
                this.readBits += (long)(preComp >> 16);
                this.fill -= preComp >> 16;
                a[i] = preComp & 0xFFFF;
                continue;
            }
            int msb = this.readGamma();
            a[i] = (1 << msb | this.readInt(msb)) - 1;
        }
    }

    public int readMinimalBinary(int b) throws IOException {
        return this.readMinimalBinary(b, Fast.mostSignificantBit(b));
    }

    public int readMinimalBinary(int b, int log2b) throws IOException {
        if (b < 1) {
            throw new IllegalArgumentException("The bound " + b + " is not positive");
        }
        int m = (1 << log2b + 1) - b;
        int x = this.readInt(log2b);
        if (x < m) {
            return x;
        }
        return (x << 1) + this.readBit() - m;
    }

    public long readLongMinimalBinary(long b) throws IOException {
        return this.readLongMinimalBinary(b, Fast.mostSignificantBit(b));
    }

    public long readLongMinimalBinary(long b, int log2b) throws IOException {
        if (b < 1L) {
            throw new IllegalArgumentException("The bound " + b + " is not positive");
        }
        long m = (1L << log2b + 1) - b;
        long x = this.readLong(log2b);
        if (x < m) {
            return x;
        }
        return (x << 1) + (long)this.readBit() - m;
    }

    public int readGolomb(int b) throws IOException {
        return this.readGolomb(b, Fast.mostSignificantBit(b));
    }

    public int readGolomb(int b, int log2b) throws IOException {
        if (b < 0) {
            throw new IllegalArgumentException("The modulus " + b + " is negative");
        }
        if (b == 0) {
            return 0;
        }
        return this.readUnary() * b + this.readMinimalBinary(b, log2b);
    }

    public long readLongGolomb(long b) throws IOException {
        return this.readLongGolomb(b, Fast.mostSignificantBit(b));
    }

    public long readLongGolomb(long b, int log2b) throws IOException {
        if (b < 0L) {
            throw new IllegalArgumentException("The modulus " + b + " is negative");
        }
        if (b == 0L) {
            return 0L;
        }
        return (long)this.readUnary() * b + this.readLongMinimalBinary(b, log2b);
    }

    public int readSkewedGolomb(int b) throws IOException {
        if (b < 0) {
            throw new IllegalArgumentException("The modulus " + b + " is negative");
        }
        if (b == 0) {
            return 0;
        }
        int M2 = ((1 << this.readUnary() + 1) - 1) * b;
        int m = M2 / (2 * b) * b;
        return m + this.readMinimalBinary(M2 - m);
    }

    public long readLongSkewedGolomb(long b) throws IOException {
        if (b < 0L) {
            throw new IllegalArgumentException("The modulus " + b + " is negative");
        }
        if (b == 0L) {
            return 0L;
        }
        long M2 = (long)((1 << this.readUnary() + 1) - 1) * b;
        long m = M2 / (2L * b) * b;
        return m + this.readLongMinimalBinary(M2 - m);
    }

    public int readZeta(int k) throws IOException {
        int preComp;
        if (k < 1) {
            throw new IllegalArgumentException("The shrinking factor " + k + " is not positive");
        }
        if (k == 3 && (this.fill >= 16 || this.refill() >= 16) && (preComp = ZETA_3[this.current >> this.fill - 16 & 0xFFFF]) != 0) {
            this.readBits += (long)(preComp >> 16);
            this.fill -= preComp >> 16;
            return preComp & 0xFFFF;
        }
        int h = this.readUnary();
        int left = 1 << h * k;
        int m = this.readInt(h * k + k - 1);
        if (m < left) {
            return m + left - 1;
        }
        return (m << 1) + this.readBit() - 1;
    }

    public long readLongZeta(int k) throws IOException {
        int preComp;
        if (k < 1) {
            throw new IllegalArgumentException("The shrinking factor " + k + " is not positive");
        }
        if (k == 3 && (this.fill >= 16 || this.refill() >= 16) && (preComp = ZETA_3[this.current >> this.fill - 16 & 0xFFFF]) != 0) {
            this.readBits += (long)(preComp >> 16);
            this.fill -= preComp >> 16;
            return preComp & 0xFFFF;
        }
        int h = this.readUnary();
        long left = 1L << h * k;
        long m = this.readLong(h * k + k - 1);
        if (m < left) {
            return m + left - 1L;
        }
        return (m << 1) + (long)this.readBit() - 1L;
    }

    public void skipZetas(int k, int n) throws IOException {
        while (n-- != 0) {
            int preComp;
            if (k == 3 && (this.fill >= 16 || this.refill() >= 16) && (preComp = ZETA_3[this.current >> this.fill - 16 & 0xFFFF] >> 16) != 0) {
                this.readBits += (long)preComp;
                this.fill -= preComp;
                continue;
            }
            int h = this.readUnary();
            if (this.readInt(h * k + k - 1) < 1 << h * k) continue;
            this.skip(1L);
        }
    }

    public void readZetas(int k, int[] a, int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            int preComp;
            if (k == 3 && (this.fill >= 16 || this.refill() >= 16) && (preComp = ZETA_3[this.current >> this.fill - 16 & 0xFFFF]) != 0) {
                this.readBits += (long)(preComp >> 16);
                this.fill -= preComp >> 16;
                a[i] = preComp & 0xFFFF;
                continue;
            }
            int h = this.readUnary();
            int left = 1 << h * k;
            int m = this.readInt(h * k + k - 1);
            a[i] = m < left ? m + left - 1 : (m << 1) + this.readBit() - 1;
        }
    }

    public int readNibble() throws IOException {
        int b;
        int x = 0;
        do {
            x <<= 3;
            b = this.readBit();
            x |= this.readInt(3);
        } while (b == 0);
        return x;
    }

    public long readLongNibble() throws IOException {
        int b;
        long x = 0L;
        do {
            x <<= 3;
            b = this.readBit();
            x |= (long)this.readInt(3);
        } while (b == 0);
        return x;
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public boolean nextBoolean() {
        try {
            return this.readBit() != 0;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Deprecated
    public int skip(int n) {
        try {
            return (int)this.skip((long)n);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            InputBitStream.fillArrayFromResource("gamma.in.16", GAMMA);
            InputBitStream.fillArrayFromResource("delta.in.16", DELTA);
            InputBitStream.fillArrayFromResource("zeta3.in.16", ZETA_3);
            InputBitStream.fillArrayFromResource("shiftedgamma.in.16", SHIFTED_GAMMA);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

