/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.io;

import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.logging.ProgressLogger;
import java.io.IOException;
import java.util.List;
import java.util.NoSuchElementException;

public class LineIterator
extends AbstractObjectIterator<MutableString> {
    private final FastBufferedReader fastBufferedReader;
    private final MutableString[] s = new MutableString[]{new MutableString(), new MutableString()};
    private final ProgressLogger pl;
    private boolean toAdvance = true;
    private boolean hasNext;
    private int k;

    public LineIterator(FastBufferedReader fastBufferedReader, ProgressLogger pl) {
        this.fastBufferedReader = fastBufferedReader;
        this.pl = pl;
    }

    public LineIterator(FastBufferedReader fastBufferedReader) {
        this(fastBufferedReader, null);
    }

    @Override
    public boolean hasNext() {
        if (this.toAdvance) {
            try {
                this.k = 1 - this.k;
                this.hasNext = this.fastBufferedReader.readLine(this.s[this.k]) != null;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.toAdvance = false;
        }
        return this.hasNext;
    }

    @Override
    public MutableString next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.toAdvance = true;
        if (this.pl != null) {
            this.pl.update();
        }
        return this.s[this.k];
    }

    public List<MutableString> allLines() {
        ObjectArrayList<MutableString> result = new ObjectArrayList<MutableString>();
        while (this.hasNext()) {
            result.add(this.next().copy());
        }
        return result;
    }
}

