/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.io;

import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.io.NullInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MultipleInputStream
extends InputStream {
    private final InputStream[] inputStream;
    private final int from;
    private final int to;
    private int curr;
    private InputStream currStream;

    private MultipleInputStream(InputStream[] inputStream, int offset, int length) {
        ObjectArrays.ensureOffsetLength(inputStream, offset, length);
        this.inputStream = inputStream;
        this.from = offset;
        this.to = offset + length;
        this.curr = offset;
        this.currStream = inputStream[this.curr];
    }

    public static InputStream getStream(InputStream[] inputStream, int offset, int length) {
        if (length == 0) {
            return NullInputStream.getInstance();
        }
        if (length == 1) {
            return inputStream[offset];
        }
        return new MultipleInputStream(inputStream, offset, length);
    }

    public static InputStream getStream(InputStream[] inputStream) {
        return MultipleInputStream.getStream(inputStream, 0, inputStream.length);
    }

    @Override
    public int available() throws IOException {
        return this.currStream.available();
    }

    @Override
    public void close() throws IOException {
        for (int i = this.from; i < this.to; ++i) {
            this.inputStream[i].close();
        }
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        return this.currStream.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.currStream.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.currStream.read(b);
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.curr == this.to - 1) {
            throw new IOException("The streams in this multiple input stream have been exhausted");
        }
        this.currStream = this.inputStream[++this.curr];
    }

    @Override
    public long skip(long n) throws IOException {
        return this.currStream.skip(n);
    }
}

