/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.lang;

import com.martiansoftware.jsap.ParseException;
import com.martiansoftware.jsap.StringParser;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.lang.MutableString;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class ObjectParser
extends StringParser {
    private static final Object NO_CONTEXT = new Object();
    private final String[] packages;
    private final String[] factoryMethod;
    private final Class<?> type;
    private final Object context;

    public ObjectParser(Class<?> type, String[] packages, String[] factoryMethod) {
        this(NO_CONTEXT, type, packages, factoryMethod);
    }

    public ObjectParser(Class<?> type, String[] packages) {
        this(type, packages, null);
    }

    public ObjectParser(Class<?> type) {
        this(type, (String[])null);
    }

    public ObjectParser() {
        this(Object.class);
    }

    public ObjectParser(Object context, Class<?> type, String[] packages, String[] factoryMethod) {
        this.context = context;
        this.type = type;
        this.packages = packages;
        this.factoryMethod = factoryMethod;
    }

    public ObjectParser(Object context, Class<?> type, String[] packages) {
        this(context, type, packages, null);
    }

    public ObjectParser(Object context, Class<?> type) {
        this(context, type, null);
    }

    public ObjectParser(Object context) {
        this(context, Object.class);
    }

    @Override
    public Object parse(String spec) throws ParseException {
        try {
            return ObjectParser.fromSpec(this.context, spec, this.type, this.packages, this.factoryMethod);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    public static Object fromSpec(String spec) throws IllegalArgumentException, ClassNotFoundException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException {
        return ObjectParser.fromSpec(NO_CONTEXT, spec, Object.class, null, null);
    }

    public static <S> S fromSpec(String spec, Class<S> type) throws IllegalArgumentException, ClassNotFoundException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException {
        return ObjectParser.fromSpec(NO_CONTEXT, spec, type, null, null);
    }

    public static <S> S fromSpec(String spec, Class<S> type, String[] packages) throws IllegalArgumentException, ClassNotFoundException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException {
        return ObjectParser.fromSpec(NO_CONTEXT, spec, type, packages, null);
    }

    public static <S> S fromSpec(String spec, Class<S> type, String[] packages, String[] factoryMethod) throws IllegalArgumentException, ClassNotFoundException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException {
        return ObjectParser.fromSpec(NO_CONTEXT, spec, type, packages, factoryMethod);
    }

    public static Object fromSpec(Object context, String spec) throws IllegalArgumentException, ClassNotFoundException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException {
        return ObjectParser.fromSpec(context, spec, Object.class, null, null);
    }

    public static <S> S fromSpec(Object context, String spec, Class<S> type) throws IllegalArgumentException, ClassNotFoundException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException {
        return ObjectParser.fromSpec(context, spec, type, null, null);
    }

    public static <S> S fromSpec(Object context, String spec, Class<S> type, String[] packages) throws IllegalArgumentException, ClassNotFoundException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException {
        return ObjectParser.fromSpec(context, spec, type, packages, null);
    }

    public static <S> S fromSpec(Object context, String spec, Class<S> type, String[] packages, String[] factoryMethod) throws IllegalArgumentException, ClassNotFoundException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException {
        Constructor<?> constr;
        int i;
        String[] stringArgArray;
        Class[] argTypes;
        String className;
        Class<?> klass;
        int length;
        int endOfName;
        boolean contextualised;
        block43: {
            spec = spec.trim();
            contextualised = context != NO_CONTEXT;
            endOfName = spec.indexOf(40);
            length = spec.length();
            if (endOfName < 0) {
                endOfName = length;
            }
            klass = null;
            className = spec.substring(0, endOfName).trim();
            try {
                klass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                if (packages == null) break block43;
                for (String p : packages) {
                    try {
                        klass = Class.forName(p + "." + className);
                    }
                    catch (ClassNotFoundException niceTry) {
                        // empty catch block
                    }
                    if (klass != null) break;
                }
            }
        }
        if (klass == null) {
            throw new ClassNotFoundException(className);
        }
        if (!type.isAssignableFrom(klass)) {
            throw new ClassCastException("Class " + klass.getSimpleName() + " is not assignable to " + type);
        }
        ObjectArrayList<Object> args = new ObjectArrayList<Object>();
        if (contextualised) {
            args.add(context);
        }
        if (endOfName < length) {
            MutableString arg = new MutableString();
            if (spec.charAt(length - 1) != ')') {
                throw new IllegalArgumentException("\")\" missing at the end of argument list");
            }
            int pos = endOfName;
            while (pos < length) {
                ++pos;
                while (pos < length && Character.isWhitespace(spec.charAt(pos))) {
                    ++pos;
                }
                if (pos == length || args.size() == 0 && pos == length - 1 && spec.charAt(pos) == ')') break;
                arg.setLength(0);
                boolean inQuotes = spec.charAt(pos) == '\"';
                if (inQuotes) {
                    ++pos;
                }
                boolean escaped = false;
                while (true) {
                    char c = spec.charAt(pos);
                    if (!inQuotes) {
                        if (c == ',' || pos == length - 1 && c == ')') break;
                        arg.append(c);
                    } else {
                        if (c == '\"' && !escaped) {
                            while (++pos < length && Character.isWhitespace(spec.charAt(pos))) {
                            }
                            if (pos != length && (spec.charAt(pos) == ')' || spec.charAt(pos) == ',')) break;
                            throw new IllegalArgumentException();
                        }
                        if (c == '\\' && !escaped) {
                            escaped = true;
                        } else {
                            arg.append(c);
                            escaped = false;
                        }
                    }
                    ++pos;
                }
                args.add(inQuotes ? arg.toString() : arg.trim().toString());
            }
        }
        Object[] argArray = args.toArray();
        if (contextualised) {
            argTypes = new Class[args.size()];
            stringArgArray = new String[args.size() - 1];
            argTypes[0] = Object.class;
            for (i = 1; i < argTypes.length; ++i) {
                argTypes[i] = String.class;
                stringArgArray[i - 1] = (String)args.get(i);
            }
        } else {
            argTypes = new Class[args.size()];
            stringArgArray = new String[args.size()];
            for (i = 0; i < argTypes.length; ++i) {
                argTypes[i] = String.class;
                stringArgArray[i] = (String)args.get(i);
            }
        }
        Method method = null;
        Object instance = null;
        if (factoryMethod != null) {
            for (String f : factoryMethod) {
                try {
                    method = klass.getMethod(f, argTypes);
                    if (Modifier.isStatic(method.getModifiers())) {
                        instance = method.invoke(null, argArray);
                    }
                }
                catch (NoSuchMethodException niceTry) {
                    // empty catch block
                }
                if (instance != null) {
                    return (S)instance;
                }
                try {
                    if (contextualised) {
                        method = klass.getMethod(f, Object.class, String[].class);
                        if (Modifier.isStatic(method.getModifiers())) {
                            instance = method.invoke(null, context, stringArgArray);
                        }
                    } else {
                        method = klass.getMethod(f, String[].class);
                        if (Modifier.isStatic(method.getModifiers())) {
                            instance = method.invoke(null, new Object[]{stringArgArray});
                        }
                    }
                }
                catch (NoSuchMethodException niceTry) {
                    // empty catch block
                }
                if (instance == null) continue;
                return (S)instance;
            }
        }
        try {
            constr = klass.getConstructor(argTypes);
            instance = constr.newInstance(argArray);
        }
        catch (NoSuchMethodException niceTry) {
            // empty catch block
        }
        if (instance != null) {
            return (S)instance;
        }
        try {
            if (contextualised) {
                constr = klass.getConstructor(Object.class, String[].class);
                return (S)constr.newInstance(context, stringArgArray);
            }
            constr = klass.getConstructor(String[].class);
            return (S)constr.newInstance(new Object[]{stringArgArray});
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodException(contextualised ? "No contextual constructor with " + stringArgArray.length + " strings as argument for class " + klass.getName() : "No constructor with " + stringArgArray.length + " strings as argument for class " + klass.getName());
        }
    }

    public static String toSpec(Object o) {
        Method toSpec = null;
        try {
            toSpec = o.getClass().getMethod("toSpec", new Class[0]);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (toSpec != null) {
            try {
                return (String)toSpec.invoke(o, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return o.getClass().getName();
    }
}

