/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.parser;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.parser.Attribute;
import it.unimi.dsi.parser.Element;
import it.unimi.dsi.parser.Entity;
import it.unimi.dsi.parser.ParsingFactory;

public class HTMLFactory
implements ParsingFactory {
    public static final HTMLFactory INSTANCE = new HTMLFactory();
    static final Object2ObjectOpenHashMap<CharSequence, Entity> NAME2ENTITY = new Object2ObjectOpenHashMap(16, 0.5f);
    static final Object2ObjectOpenHashMap<CharSequence, Attribute> NAME2ATTRIBUTE = new Object2ObjectOpenHashMap(16, 0.5f);
    static final Object2ObjectOpenHashMap<CharSequence, Element> NAME2ELEMENT = new Object2ObjectOpenHashMap(16, 0.5f);

    private HTMLFactory() {
    }

    @Override
    public Element getElement(MutableString name) {
        return NAME2ELEMENT.get(name);
    }

    @Override
    public Attribute getAttribute(MutableString name) {
        return NAME2ATTRIBUTE.get(name);
    }

    @Override
    public Entity getEntity(MutableString name) {
        return NAME2ENTITY.get(name);
    }

    static Element newElement(CharSequence name) {
        Element element = new Element(name);
        NAME2ELEMENT.put(element.name, element);
        return element;
    }

    static Element newElement(CharSequence name, boolean breaksFlow, boolean isSimple) {
        Element element = new Element(name, breaksFlow, isSimple);
        NAME2ELEMENT.put(element.name, element);
        return element;
    }

    static Element newElement(CharSequence name, boolean breaksFlow, boolean isSimple, boolean isImplicit) {
        Element element = new Element(name, breaksFlow, isSimple, isImplicit);
        NAME2ELEMENT.put(element.name, element);
        return element;
    }

    static Attribute newAttribute(CharSequence name) {
        Attribute attribute = new Attribute(name);
        NAME2ATTRIBUTE.put(attribute.name, attribute);
        return attribute;
    }

    static Entity newEntity(CharSequence name, char c) {
        Entity entity = new Entity(name, c);
        NAME2ENTITY.put(entity.name, entity);
        return entity;
    }

    static {
        NAME2ATTRIBUTE.defaultReturnValue(Attribute.UNKNOWN);
        NAME2ELEMENT.defaultReturnValue(Element.UNKNOWN);
        HTMLFactory.newEntity("nbsp", '\u00a0');
        HTMLFactory.newEntity("iexcl", '\u00a1');
        HTMLFactory.newEntity("cent", '\u00a2');
        HTMLFactory.newEntity("pound", '\u00a3');
        HTMLFactory.newEntity("curren", '\u00a4');
        HTMLFactory.newEntity("yen", '\u00a5');
        HTMLFactory.newEntity("brvbar", '\u00a6');
        HTMLFactory.newEntity("sect", '\u00a7');
        HTMLFactory.newEntity("uml", '\u00a8');
        HTMLFactory.newEntity("copy", '\u00a9');
        HTMLFactory.newEntity("ordf", '\u00aa');
        HTMLFactory.newEntity("laquo", '\u00ab');
        HTMLFactory.newEntity("not", '\u00ac');
        HTMLFactory.newEntity("shy", '\u00ad');
        HTMLFactory.newEntity("reg", '\u00ae');
        HTMLFactory.newEntity("macr", '\u00af');
        HTMLFactory.newEntity("deg", '\u00b0');
        HTMLFactory.newEntity("plusmn", '\u00b1');
        HTMLFactory.newEntity("sup2", '\u00b2');
        HTMLFactory.newEntity("sup3", '\u00b3');
        HTMLFactory.newEntity("acute", '\u00b4');
        HTMLFactory.newEntity("micro", '\u00b5');
        HTMLFactory.newEntity("para", '\u00b6');
        HTMLFactory.newEntity("middot", '\u00b7');
        HTMLFactory.newEntity("cedil", '\u00b8');
        HTMLFactory.newEntity("sup1", '\u00b9');
        HTMLFactory.newEntity("ordm", '\u00ba');
        HTMLFactory.newEntity("raquo", '\u00bb');
        HTMLFactory.newEntity("frac14", '\u00bc');
        HTMLFactory.newEntity("frac12", '\u00bd');
        HTMLFactory.newEntity("frac34", '\u00be');
        HTMLFactory.newEntity("iquest", '\u00bf');
        HTMLFactory.newEntity("Agrave", '\u00c0');
        HTMLFactory.newEntity("Aacute", '\u00c1');
        HTMLFactory.newEntity("Acirc", '\u00c2');
        HTMLFactory.newEntity("Atilde", '\u00c3');
        HTMLFactory.newEntity("Auml", '\u00c4');
        HTMLFactory.newEntity("Aring", '\u00c5');
        HTMLFactory.newEntity("AElig", '\u00c6');
        HTMLFactory.newEntity("Ccedil", '\u00c7');
        HTMLFactory.newEntity("Egrave", '\u00c8');
        HTMLFactory.newEntity("Eacute", '\u00c9');
        HTMLFactory.newEntity("Ecirc", '\u00ca');
        HTMLFactory.newEntity("Euml", '\u00cb');
        HTMLFactory.newEntity("Igrave", '\u00cc');
        HTMLFactory.newEntity("Iacute", '\u00cd');
        HTMLFactory.newEntity("Icirc", '\u00ce');
        HTMLFactory.newEntity("Iuml", '\u00cf');
        HTMLFactory.newEntity("ETH", '\u00d0');
        HTMLFactory.newEntity("Ntilde", '\u00d1');
        HTMLFactory.newEntity("Ograve", '\u00d2');
        HTMLFactory.newEntity("Oacute", '\u00d3');
        HTMLFactory.newEntity("Ocirc", '\u00d4');
        HTMLFactory.newEntity("Otilde", '\u00d5');
        HTMLFactory.newEntity("Ouml", '\u00d6');
        HTMLFactory.newEntity("times", '\u00d7');
        HTMLFactory.newEntity("Oslash", '\u00d8');
        HTMLFactory.newEntity("Ugrave", '\u00d9');
        HTMLFactory.newEntity("Uacute", '\u00da');
        HTMLFactory.newEntity("Ucirc", '\u00db');
        HTMLFactory.newEntity("Uuml", '\u00dc');
        HTMLFactory.newEntity("Yacute", '\u00dd');
        HTMLFactory.newEntity("THORN", '\u00de');
        HTMLFactory.newEntity("szlig", '\u00df');
        HTMLFactory.newEntity("agrave", '\u00e0');
        HTMLFactory.newEntity("aacute", '\u00e1');
        HTMLFactory.newEntity("acirc", '\u00e2');
        HTMLFactory.newEntity("atilde", '\u00e3');
        HTMLFactory.newEntity("auml", '\u00e4');
        HTMLFactory.newEntity("aring", '\u00e5');
        HTMLFactory.newEntity("aelig", '\u00e6');
        HTMLFactory.newEntity("ccedil", '\u00e7');
        HTMLFactory.newEntity("egrave", '\u00e8');
        HTMLFactory.newEntity("eacute", '\u00e9');
        HTMLFactory.newEntity("ecirc", '\u00ea');
        HTMLFactory.newEntity("euml", '\u00eb');
        HTMLFactory.newEntity("igrave", '\u00ec');
        HTMLFactory.newEntity("iacute", '\u00ed');
        HTMLFactory.newEntity("icirc", '\u00ee');
        HTMLFactory.newEntity("iuml", '\u00ef');
        HTMLFactory.newEntity("eth", '\u00f0');
        HTMLFactory.newEntity("ntilde", '\u00f1');
        HTMLFactory.newEntity("ograve", '\u00f2');
        HTMLFactory.newEntity("oacute", '\u00f3');
        HTMLFactory.newEntity("ocirc", '\u00f4');
        HTMLFactory.newEntity("otilde", '\u00f5');
        HTMLFactory.newEntity("ouml", '\u00f6');
        HTMLFactory.newEntity("divide", '\u00f7');
        HTMLFactory.newEntity("oslash", '\u00f8');
        HTMLFactory.newEntity("ugrave", '\u00f9');
        HTMLFactory.newEntity("uacute", '\u00fa');
        HTMLFactory.newEntity("ucirc", '\u00fb');
        HTMLFactory.newEntity("uuml", '\u00fc');
        HTMLFactory.newEntity("yacute", '\u00fd');
        HTMLFactory.newEntity("thorn", '\u00fe');
        HTMLFactory.newEntity("yuml", '\u00ff');
        HTMLFactory.newEntity("quot", '\"');
        HTMLFactory.newEntity("apos", '\'');
        HTMLFactory.newEntity("amp", '&');
        HTMLFactory.newEntity("lt", '<');
        HTMLFactory.newEntity("gt", '>');
        HTMLFactory.newEntity("OElig", '\u0152');
        HTMLFactory.newEntity("oelig", '\u0153');
        HTMLFactory.newEntity("Scaron", '\u0160');
        HTMLFactory.newEntity("scaron", '\u0161');
        HTMLFactory.newEntity("Yuml", '\u0178');
        HTMLFactory.newEntity("circ", '\u02c6');
        HTMLFactory.newEntity("tilde", '\u02dc');
        HTMLFactory.newEntity("ensp", '\u2002');
        HTMLFactory.newEntity("emsp", '\u2003');
        HTMLFactory.newEntity("thinsp", '\u2009');
        HTMLFactory.newEntity("zwnj", '\u200c');
        HTMLFactory.newEntity("zwj", '\u200d');
        HTMLFactory.newEntity("lrm", '\u200e');
        HTMLFactory.newEntity("rlm", '\u200f');
        HTMLFactory.newEntity("ndash", '\u2013');
        HTMLFactory.newEntity("mdash", '\u2014');
        HTMLFactory.newEntity("lsquo", '\u2018');
        HTMLFactory.newEntity("rsquo", '\u2019');
        HTMLFactory.newEntity("sbquo", '\u201a');
        HTMLFactory.newEntity("ldquo", '\u201c');
        HTMLFactory.newEntity("rdquo", '\u201d');
        HTMLFactory.newEntity("bdquo", '\u201e');
        HTMLFactory.newEntity("dagger", '\u2020');
        HTMLFactory.newEntity("Dagger", '\u2021');
        HTMLFactory.newEntity("permil", '\u2030');
        HTMLFactory.newEntity("lsaquo", '\u2039');
        HTMLFactory.newEntity("rsaquo", '\u203a');
        HTMLFactory.newEntity("euro", '\u20ac');
        HTMLFactory.newEntity("fnof", '\u0192');
        HTMLFactory.newEntity("Alpha", '\u0391');
        HTMLFactory.newEntity("Beta", '\u0392');
        HTMLFactory.newEntity("Gamma", '\u0393');
        HTMLFactory.newEntity("Delta", '\u0394');
        HTMLFactory.newEntity("Epsilon", '\u0395');
        HTMLFactory.newEntity("Zeta", '\u0396');
        HTMLFactory.newEntity("Eta", '\u0397');
        HTMLFactory.newEntity("Theta", '\u0398');
        HTMLFactory.newEntity("Iota", '\u0399');
        HTMLFactory.newEntity("Kappa", '\u039a');
        HTMLFactory.newEntity("Lambda", '\u039b');
        HTMLFactory.newEntity("Mu", '\u039c');
        HTMLFactory.newEntity("Nu", '\u039d');
        HTMLFactory.newEntity("Xi", '\u039e');
        HTMLFactory.newEntity("Omicron", '\u039f');
        HTMLFactory.newEntity("Pi", '\u03a0');
        HTMLFactory.newEntity("Rho", '\u03a1');
        HTMLFactory.newEntity("Sigma", '\u03a3');
        HTMLFactory.newEntity("Tau", '\u03a4');
        HTMLFactory.newEntity("Upsilon", '\u03a5');
        HTMLFactory.newEntity("Phi", '\u03a6');
        HTMLFactory.newEntity("Chi", '\u03a7');
        HTMLFactory.newEntity("Psi", '\u03a8');
        HTMLFactory.newEntity("Omega", '\u03a9');
        HTMLFactory.newEntity("alpha", '\u03b1');
        HTMLFactory.newEntity("beta", '\u03b2');
        HTMLFactory.newEntity("gamma", '\u03b3');
        HTMLFactory.newEntity("delta", '\u03b4');
        HTMLFactory.newEntity("epsilon", '\u03b5');
        HTMLFactory.newEntity("zeta", '\u03b6');
        HTMLFactory.newEntity("eta", '\u03b7');
        HTMLFactory.newEntity("theta", '\u03b8');
        HTMLFactory.newEntity("iota", '\u03b9');
        HTMLFactory.newEntity("kappa", '\u03ba');
        HTMLFactory.newEntity("lambda", '\u03bb');
        HTMLFactory.newEntity("mu", '\u03bc');
        HTMLFactory.newEntity("nu", '\u03bd');
        HTMLFactory.newEntity("xi", '\u03be');
        HTMLFactory.newEntity("omicron", '\u03bf');
        HTMLFactory.newEntity("pi", '\u03c0');
        HTMLFactory.newEntity("rho", '\u03c1');
        HTMLFactory.newEntity("sigmaf", '\u03c2');
        HTMLFactory.newEntity("sigma", '\u03c3');
        HTMLFactory.newEntity("tau", '\u03c4');
        HTMLFactory.newEntity("upsilon", '\u03c5');
        HTMLFactory.newEntity("phi", '\u03c6');
        HTMLFactory.newEntity("chi", '\u03c7');
        HTMLFactory.newEntity("psi", '\u03c8');
        HTMLFactory.newEntity("omega", '\u03c9');
        HTMLFactory.newEntity("thetasym", '\u03d1');
        HTMLFactory.newEntity("upsih", '\u03d2');
        HTMLFactory.newEntity("piv", '\u03d6');
        HTMLFactory.newEntity("bull", '\u2022');
        HTMLFactory.newEntity("hellip", '\u2026');
        HTMLFactory.newEntity("prime", '\u2032');
        HTMLFactory.newEntity("Prime", '\u2033');
        HTMLFactory.newEntity("oline", '\u203e');
        HTMLFactory.newEntity("frasl", '\u2044');
        HTMLFactory.newEntity("weierp", '\u2118');
        HTMLFactory.newEntity("image", '\u2111');
        HTMLFactory.newEntity("real", '\u211c');
        HTMLFactory.newEntity("trade", '\u2122');
        HTMLFactory.newEntity("alefsym", '\u2135');
        HTMLFactory.newEntity("larr", '\u2190');
        HTMLFactory.newEntity("uarr", '\u2191');
        HTMLFactory.newEntity("rarr", '\u2192');
        HTMLFactory.newEntity("darr", '\u2193');
        HTMLFactory.newEntity("harr", '\u2194');
        HTMLFactory.newEntity("crarr", '\u21b5');
        HTMLFactory.newEntity("lArr", '\u21d0');
        HTMLFactory.newEntity("uArr", '\u21d1');
        HTMLFactory.newEntity("rArr", '\u21d2');
        HTMLFactory.newEntity("dArr", '\u21d3');
        HTMLFactory.newEntity("hArr", '\u21d4');
        HTMLFactory.newEntity("forall", '\u2200');
        HTMLFactory.newEntity("part", '\u2202');
        HTMLFactory.newEntity("exist", '\u2203');
        HTMLFactory.newEntity("empty", '\u2205');
        HTMLFactory.newEntity("nabla", '\u2207');
        HTMLFactory.newEntity("isin", '\u2208');
        HTMLFactory.newEntity("notin", '\u2209');
        HTMLFactory.newEntity("ni", '\u220b');
        HTMLFactory.newEntity("prod", '\u220f');
        HTMLFactory.newEntity("sum", '\u2211');
        HTMLFactory.newEntity("minus", '\u2212');
        HTMLFactory.newEntity("lowast", '\u2217');
        HTMLFactory.newEntity("radic", '\u221a');
        HTMLFactory.newEntity("prop", '\u221d');
        HTMLFactory.newEntity("infin", '\u221e');
        HTMLFactory.newEntity("ang", '\u2220');
        HTMLFactory.newEntity("and", '\u2227');
        HTMLFactory.newEntity("or", '\u2228');
        HTMLFactory.newEntity("cap", '\u2229');
        HTMLFactory.newEntity("cup", '\u222a');
        HTMLFactory.newEntity("int", '\u222b');
        HTMLFactory.newEntity("there4", '\u2234');
        HTMLFactory.newEntity("sim", '\u223c');
        HTMLFactory.newEntity("cong", '\u2245');
        HTMLFactory.newEntity("asymp", '\u2248');
        HTMLFactory.newEntity("ne", '\u2260');
        HTMLFactory.newEntity("equiv", '\u2261');
        HTMLFactory.newEntity("le", '\u2264');
        HTMLFactory.newEntity("ge", '\u2265');
        HTMLFactory.newEntity("sub", '\u2282');
        HTMLFactory.newEntity("sup", '\u2283');
        HTMLFactory.newEntity("nsub", '\u2284');
        HTMLFactory.newEntity("sube", '\u2286');
        HTMLFactory.newEntity("supe", '\u2287');
        HTMLFactory.newEntity("oplus", '\u2295');
        HTMLFactory.newEntity("otimes", '\u2297');
        HTMLFactory.newEntity("perp", '\u22a5');
        HTMLFactory.newEntity("sdot", '\u22c5');
        HTMLFactory.newEntity("lceil", '\u2308');
        HTMLFactory.newEntity("rceil", '\u2309');
        HTMLFactory.newEntity("lfloor", '\u230a');
        HTMLFactory.newEntity("rfloor", '\u230b');
        HTMLFactory.newEntity("lang", '\u2329');
        HTMLFactory.newEntity("rang", '\u232a');
        HTMLFactory.newEntity("loz", '\u25ca');
        HTMLFactory.newEntity("spades", '\u2660');
        HTMLFactory.newEntity("clubs", '\u2663');
        HTMLFactory.newEntity("hearts", '\u2665');
        HTMLFactory.newEntity("diams", '\u2666');
    }
}

