/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.parser.callback;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.parser.Attribute;
import it.unimi.dsi.parser.BulletParser;
import it.unimi.dsi.parser.Element;
import it.unimi.dsi.parser.callback.Callback;
import it.unimi.dsi.parser.callback.DefaultCallback;
import java.util.Map;

public class ComposedCallbackBuilder {
    private final ObjectArrayList<Callback> callbacks = ObjectArrayList.wrap(Callback.EMPTY_CALLBACK_ARRAY);

    public void add(int position, Callback callback) {
        this.callbacks.add(position, callback);
    }

    public void add(Callback callback) {
        this.callbacks.add(callback);
    }

    public boolean isEmpty() {
        return this.callbacks.isEmpty();
    }

    public int size() {
        return this.callbacks.size();
    }

    public Callback compose() {
        if (this.isEmpty()) {
            return DefaultCallback.getInstance();
        }
        if (this.size() == 1) {
            return this.callbacks.get(0);
        }
        return new ComposedCallback(this.callbacks);
    }

    private static final class ComposedCallback
    implements Callback {
        final int size;
        private Callback[] callback;
        private boolean[] cont;
        private final ObjectArrayList<Callback> callbacks;

        private ComposedCallback(ObjectArrayList<Callback> callbacks) {
            this.callbacks = callbacks;
            this.size = callbacks.size();
            this.cont = new boolean[this.size];
            this.callback = new Callback[this.size];
            this.callbacks.toArray(this.callback);
        }

        @Override
        public void configure(BulletParser parser) {
            for (int i = 0; i < this.size; ++i) {
                this.callback[i].configure(parser);
            }
        }

        @Override
        public void startDocument() {
            for (int i = 0; i < this.size; ++i) {
                this.callback[i].startDocument();
                this.cont[i] = true;
            }
        }

        @Override
        public boolean startElement(Element tag, Map<Attribute, MutableString> attrList) {
            boolean retValue = false;
            for (int i = 0; i < this.size; ++i) {
                if (this.cont[i] && !this.callback[i].startElement(tag, attrList)) {
                    this.cont[i] = false;
                }
                retValue |= this.cont[i];
            }
            return retValue;
        }

        @Override
        public boolean endElement(Element tag) {
            boolean retValue = false;
            for (int i = 0; i < this.size; ++i) {
                if (this.cont[i] && !this.callback[i].endElement(tag)) {
                    this.cont[i] = false;
                }
                retValue |= this.cont[i];
            }
            return retValue;
        }

        @Override
        public boolean characters(char[] text, int offset, int length, boolean flowBroken) {
            boolean retValue = false;
            for (int i = 0; i < this.size; ++i) {
                if (this.cont[i] && !this.callback[i].characters(text, offset, length, flowBroken)) {
                    this.cont[i] = false;
                }
                retValue |= this.cont[i];
            }
            return retValue;
        }

        @Override
        public boolean cdata(Element element, char[] text, int offset, int length) {
            boolean retValue = false;
            for (int i = 0; i < this.size; ++i) {
                if (this.cont[i] && !this.callback[i].cdata(element, text, offset, length)) {
                    this.cont[i] = false;
                }
                retValue |= this.cont[i];
            }
            return retValue;
        }

        @Override
        public void endDocument() {
            for (int i = 0; i < this.size; ++i) {
                this.callback[i].endDocument();
            }
        }
    }
}

