/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.parser.callback;

import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.parser.Attribute;
import it.unimi.dsi.parser.BulletParser;
import it.unimi.dsi.parser.Element;
import it.unimi.dsi.parser.callback.DefaultCallback;
import it.unimi.dsi.util.TextPattern;
import java.util.Map;
import java.util.Set;

public class LinkExtractor
extends DefaultCallback {
    private static final TextPattern URLEQUAL_PATTERN = new TextPattern("URL=", 1);
    public final Set<String> urls = new ObjectLinkedOpenHashSet<String>();
    private String metaRefresh = null;
    private String metaLocation = null;
    private String base = null;

    @Override
    public void configure(BulletParser parser) {
        parser.parseTags(true);
        parser.parseAttributes(true);
        parser.parseAttribute(Attribute.SRC);
        parser.parseAttribute(Attribute.HREF);
        parser.parseAttribute(Attribute.HTTP_EQUIV);
        parser.parseAttribute(Attribute.CONTENT);
    }

    @Override
    public void startDocument() {
        this.urls.clear();
        this.metaRefresh = null;
        this.metaLocation = null;
        this.base = null;
    }

    @Override
    public boolean startElement(Element element, Map<Attribute, MutableString> attrMap) {
        MutableString s;
        if ((element == Element.A || element == Element.AREA || element == Element.LINK) && (s = attrMap.get(Attribute.HREF)) != null) {
            this.urls.add(((Object)s).toString());
        }
        if ((element == Element.IFRAME || element == Element.FRAME || element == Element.EMBED) && (s = attrMap.get(Attribute.SRC)) != null) {
            this.urls.add(((Object)s).toString());
        }
        if (element == Element.BASE && this.base == null && (s = attrMap.get(Attribute.HREF)) != null) {
            this.base = ((Object)s).toString();
        }
        if (element == Element.META) {
            MutableString equiv = attrMap.get(Attribute.HTTP_EQUIV);
            MutableString content = attrMap.get(Attribute.CONTENT);
            if (equiv != null && content != null) {
                int pos;
                equiv.toLowerCase();
                if (equiv.equals("refresh") && this.metaRefresh == null && (pos = URLEQUAL_PATTERN.search(content)) != -1) {
                    this.metaRefresh = content.substring(pos + URLEQUAL_PATTERN.length()).toString();
                }
                if (equiv.equals("location") && this.metaLocation == null) {
                    this.metaLocation = attrMap.get(Attribute.CONTENT).toString();
                }
            }
        }
        return true;
    }

    public String metaLocation() {
        return this.metaLocation;
    }

    public String base() {
        return this.base;
    }

    public String metaRefresh() {
        return this.metaRefresh;
    }
}

