/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.util;

import cern.jet.random.engine.MersenneTwister;
import it.unimi.dsi.bits.LongArrayBitVector;
import java.io.Serializable;
import java.util.Random;

public class IntBloomFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final long m;
    public final int d;
    private final LongArrayBitVector bits;
    private final int[] a;
    private final int[] b;
    private static final double NATURAL_LOG_OF_2 = Math.log(2.0);
    private static final boolean DEBUG = false;

    public IntBloomFilter(int n, int d) {
        this.d = d;
        this.bits = LongArrayBitVector.getInstance().length((long)Math.ceil((double)(n * d) / NATURAL_LOG_OF_2));
        this.m = this.bits.length() * 64L;
        MersenneTwister mersenneTwister = new MersenneTwister(new Random().nextInt());
        this.a = new int[d];
        this.b = new int[d];
        for (int i = 0; i < d; ++i) {
            this.a[i] = mersenneTwister.nextInt();
            this.b[i] = mersenneTwister.nextInt();
        }
    }

    private long hash(int x, int k) {
        return ((long)(this.a[k] * x ^ this.b[k]) & Long.MAX_VALUE) % this.m;
    }

    public boolean contains(int x) {
        int i = this.d;
        while (i-- != 0) {
            if (this.bits.getBoolean(this.hash(x, i))) continue;
            return false;
        }
        return true;
    }

    public void add(int x) {
        int i = this.d;
        while (i-- != 0) {
            this.bits.set(this.hash(x, i));
        }
    }
}

