/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.util;

import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.objects.AbstractObjectList;
import it.unimi.dsi.fastutil.objects.AbstractObjectListIterator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.util.FrontCodedStringList;
import java.io.IOException;
import java.io.Serializable;

public class PermutedFrontCodedStringList
extends AbstractObjectList<CharSequence>
implements Serializable {
    public static final long serialVersionUID = -7046029254386353130L;
    protected final FrontCodedStringList frontCodedStringList;
    protected final int[] permutation;

    public PermutedFrontCodedStringList(FrontCodedStringList frontCodedStringList, int[] permutation) {
        this.frontCodedStringList = frontCodedStringList;
        this.permutation = permutation;
    }

    @Override
    public CharSequence get(int index) {
        return this.frontCodedStringList.get(this.permutation[index]);
    }

    public void get(int index, MutableString s) {
        this.frontCodedStringList.get(this.permutation[index], s);
    }

    @Override
    public int size() {
        return this.frontCodedStringList.size();
    }

    @Override
    public ObjectListIterator<CharSequence> listIterator(int k) {
        return new AbstractObjectListIterator<CharSequence>(){
            final IntListIterator i;
            {
                this.i = IntIterators.fromTo(0, PermutedFrontCodedStringList.this.frontCodedStringList.size());
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public boolean hasPrevious() {
                return this.i.hasPrevious();
            }

            @Override
            public CharSequence next() {
                return PermutedFrontCodedStringList.this.frontCodedStringList.get(PermutedFrontCodedStringList.this.permutation[this.i.nextInt()]);
            }

            @Override
            public CharSequence previous() {
                return PermutedFrontCodedStringList.this.frontCodedStringList.get(PermutedFrontCodedStringList.this.permutation[this.i.previousInt()]);
            }

            @Override
            public int nextIndex() {
                return this.i.nextIndex();
            }

            @Override
            public int previousIndex() {
                return this.i.previousIndex();
            }
        };
    }

    public static void main(String[] arg) throws IOException, ClassNotFoundException, JSAPException {
        int[] permutation;
        SimpleJSAP jsap = new SimpleJSAP(PermutedFrontCodedStringList.class.getName(), "Builds a permuted front-coded list of strings using a given front-coded string list and permutation", new Parameter[]{new Switch("invert", 'i', "invert", "Invert permutation before creating the permuted list."), new UnflaggedOption("list", JSAP.STRING_PARSER, true, "A front-coded string list."), new UnflaggedOption("permutation", JSAP.STRING_PARSER, true, "A permutation for the indices of the list."), new UnflaggedOption("permutedList", JSAP.STRING_PARSER, true, "A the filename for the resulting permuted list.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        int[] basePermutation = BinIO.loadInts(jsapResult.getString("permutation"));
        if (jsapResult.getBoolean("invert")) {
            int i = basePermutation.length;
            permutation = new int[i];
            while (i-- != 0) {
                permutation[basePermutation[i]] = i;
            }
        } else {
            permutation = basePermutation;
        }
        basePermutation = null;
        BinIO.storeObject((Object)new PermutedFrontCodedStringList((FrontCodedStringList)BinIO.loadObject(jsapResult.getString("list")), permutation), jsapResult.getString("permutedList"));
    }
}

