/*
 * Decompiled with CFR 0.152.
 */
package net.jini.discovery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.EmptyConfiguration;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.discovery.DiscoveryChangeListener;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryGroupManagement;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.DiscoveryLocatorManagement;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscovery;
import net.jini.discovery.LookupLocatorDiscovery;

public class LookupDiscoveryManager
implements DiscoveryManagement,
DiscoveryGroupManagement,
DiscoveryLocatorManagement {
    public static final int FROM_GROUP = 1;
    public static final int FROM_LOCATOR = 2;
    private static final int DISCOVERED = 0;
    private static final int DISCARDED = 1;
    private static final int CHANGED = 2;
    private final ArrayList discoveredSet = new ArrayList(1);
    private final ArrayList listeners = new ArrayList(1);
    private LookupDiscovery lookupDisc;
    private DiscoveryListener groupListener = new GroupDiscoveryListener();
    private LookupLocatorDiscovery locatorDisc;
    private DiscoveryListener locatorListener = new LocatorDiscoveryListener();

    public LookupDiscoveryManager(String[] groups, LookupLocator[] locators, DiscoveryListener listener) throws IOException {
        try {
            this.beginDiscovery(groups, locators, listener, EmptyConfiguration.INSTANCE);
        }
        catch (ConfigurationException e) {
            // empty catch block
        }
    }

    public LookupDiscoveryManager(String[] groups, LookupLocator[] locators, DiscoveryListener listener, Configuration config) throws IOException, ConfigurationException {
        this.beginDiscovery(groups, locators, listener, config);
    }

    public LookupLocator[] getLocators() {
        return this.locatorDisc.getLocators();
    }

    public void addLocators(LookupLocator[] locators) {
        this.locatorDisc.addLocators(locators);
    }

    public void removeLocators(LookupLocator[] locators) {
        this.locatorDisc.removeLocators(locators);
    }

    public void setLocators(LookupLocator[] locators) {
        this.locatorDisc.setLocators(locators);
    }

    public String[] getGroups() {
        return this.lookupDisc.getGroups();
    }

    public void addGroups(String[] groups) throws IOException {
        this.lookupDisc.addGroups(groups);
    }

    public void removeGroups(String[] groups) {
        if (groups == null) {
            throw new NullPointerException("can't remove null from groups to discover");
        }
        String[] curGroupsToDiscover = this.lookupDisc.getGroups();
        if (curGroupsToDiscover == null) {
            throw new UnsupportedOperationException("can't remove from \"any groups\"");
        }
        if (curGroupsToDiscover.length == 0) {
            return;
        }
        HashSet<String> curGroups = new HashSet<String>(curGroupsToDiscover.length);
        for (int i = 0; i < curGroupsToDiscover.length; ++i) {
            curGroups.add(curGroupsToDiscover[i]);
        }
        boolean removed = false;
        for (int i = 0; i < groups.length; ++i) {
            removed |= curGroups.remove(groups[i]);
        }
        if (!removed) {
            return;
        }
        String[] newGroupsToDiscover = curGroups.toArray(new String[curGroups.size()]);
        this.lookupDisc.removeGroups(groups);
    }

    public void setGroups(String[] groups) throws IOException {
        this.lookupDisc.setGroups(groups);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDiscoveryListener(DiscoveryListener listener) {
        if (listener == null) {
            throw new NullPointerException("can't add null listener");
        }
        HashMap<ServiceRegistrar, String[]> groupsMap = new HashMap<ServiceRegistrar, String[]>(this.discoveredSet.size());
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
            if (this.discoveredSet.isEmpty()) {
                return;
            }
            for (int i = 0; i < this.discoveredSet.size(); ++i) {
                ProxyReg reg = (ProxyReg)this.discoveredSet.get(i);
                groupsMap.put(reg.proxy, reg.getMemberGroups());
            }
        }
        this.notifyListener(listener, groupsMap, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDiscoveryListener(DiscoveryListener listener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceRegistrar[] getRegistrars() {
        ArrayList<ServiceRegistrar> proxySet = new ArrayList<ServiceRegistrar>(1);
        ArrayList arrayList = this.discoveredSet;
        synchronized (arrayList) {
            boolean k = false;
            Iterator iter2 = this.discoveredSet.iterator();
            while (iter2.hasNext()) {
                ProxyReg reg = (ProxyReg)iter2.next();
                if (reg.isDiscarded()) continue;
                proxySet.add(reg.proxy);
            }
        }
        ServiceRegistrar[] ret = new ServiceRegistrar[proxySet.size()];
        proxySet.toArray(ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discard(ServiceRegistrar proxy) {
        if (proxy == null) {
            return;
        }
        ProxyReg reg = this.findReg(proxy);
        if (reg != null) {
            ArrayList arrayList = this.discoveredSet;
            synchronized (arrayList) {
                reg.discard();
                reg.commDiscard = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.clear();
        }
        this.lookupDisc.terminate();
        this.locatorDisc.terminate();
    }

    public int getFrom(ServiceRegistrar proxy) {
        ProxyReg reg = this.findReg(proxy);
        if (reg != null) {
            return reg.getFrom();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProxyReg findReg(ServiceRegistrar proxy) {
        ArrayList arrayList = this.discoveredSet;
        synchronized (arrayList) {
            Iterator iter2 = this.discoveredSet.iterator();
            while (iter2.hasNext()) {
                ProxyReg reg = (ProxyReg)iter2.next();
                if (!reg.proxy.equals(proxy)) continue;
                return reg;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListener(Map groupsMap, int eventType) {
        ArrayList notifies;
        if (groupsMap.isEmpty()) {
            return;
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            notifies = (ArrayList)this.listeners.clone();
        }
        Iterator iter2 = notifies.iterator();
        while (iter2.hasNext()) {
            DiscoveryListener l = (DiscoveryListener)iter2.next();
            this.notifyListener(l, groupsMap, eventType);
        }
    }

    private void notifyListener(DiscoveryListener l, Map groupsMap, int eventType) {
        if (eventType == 2 && !(l instanceof DiscoveryChangeListener)) {
            return;
        }
        DiscoveryEvent evt = new DiscoveryEvent((Object)this, this.deepCopy((HashMap)groupsMap));
        switch (eventType) {
            case 0: {
                l.discovered(evt);
                break;
            }
            case 1: {
                l.discarded(evt);
                break;
            }
            case 2: {
                ((DiscoveryChangeListener)l).changed(evt);
            }
        }
    }

    private static boolean groupSetsEqual(String[] groupSet0, String[] groupSet1) {
        if (groupSet0.length != groupSet1.length) {
            return false;
        }
        block0: for (int i = 0; i < groupSet0.length; ++i) {
            for (int j = 0; j < groupSet1.length; ++j) {
                if (groupSet0[i].equals(groupSet1[j])) continue block0;
            }
            return false;
        }
        return true;
    }

    private boolean stillInterested(String[] regGroups, String[] desiredGroups) {
        if (desiredGroups == DiscoveryGroupManagement.ALL_GROUPS) {
            return true;
        }
        if (desiredGroups.length == 0) {
            return false;
        }
        for (int i = 0; i < regGroups.length; ++i) {
            for (int j = 0; j < desiredGroups.length; ++j) {
                if (!regGroups[i].equals(desiredGroups[j])) continue;
                return true;
            }
        }
        return false;
    }

    private Map deepCopy(HashMap groupsMap) {
        HashMap newMap = (HashMap)groupsMap.clone();
        Set eSet = newMap.entrySet();
        Iterator itr = eSet.iterator();
        while (itr.hasNext()) {
            Map.Entry pair = itr.next();
            pair.setValue(((String[])pair.getValue()).clone());
        }
        return newMap;
    }

    private void beginDiscovery(String[] groups, LookupLocator[] locators, DiscoveryListener listener, Configuration config) throws IOException, ConfigurationException {
        if (listener != null) {
            this.listeners.add(listener);
        }
        this.lookupDisc = new LookupDiscovery(groups, config);
        this.lookupDisc.addDiscoveryListener(this.groupListener);
        this.locatorDisc = new LookupLocatorDiscovery(locators, config);
        this.locatorDisc.addDiscoveryListener(this.locatorListener);
    }

    private final class GroupDiscoveryListener
    extends LocatorDiscoveryListener
    implements DiscoveryChangeListener {
        private GroupDiscoveryListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void discovered(DiscoveryEvent e) {
            ServiceRegistrar[] proxys = e.getRegistrars();
            Map groupsMap = e.getGroups();
            HashMap discoveredGroupsMap = new HashMap(proxys.length);
            HashMap<ServiceRegistrar, String[]> changedGroupsMap = new HashMap<ServiceRegistrar, String[]>(proxys.length);
            for (int i = 0; i < proxys.length; ++i) {
                ArrayList arrayList = LookupDiscoveryManager.this.discoveredSet;
                synchronized (arrayList) {
                    ProxyReg reg = LookupDiscoveryManager.this.findReg(proxys[i]);
                    if (reg == null) {
                        reg = new ProxyReg(proxys[i], (String[])groupsMap.get(proxys[i]), 1);
                        this.addDiscoveredSet(reg);
                        discoveredGroupsMap.put(proxys[i], groupsMap.get(proxys[i]));
                    } else {
                        String[] newGroups;
                        String[] oldGroups = reg.getMemberGroups();
                        if (LookupDiscoveryManager.groupSetsEqual(oldGroups, newGroups = (String[])groupsMap.get(reg.proxy))) {
                            reg.addFrom(1);
                        } else {
                            reg.setMemberGroups(newGroups);
                            changedGroupsMap.put(reg.proxy, newGroups);
                        }
                    }
                    continue;
                }
            }
            LookupDiscoveryManager.this.notifyListener(discoveredGroupsMap, 0);
            LookupDiscoveryManager.this.notifyListener(changedGroupsMap, 2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void discarded(DiscoveryEvent e) {
            ServiceRegistrar[] proxys = e.getRegistrars();
            Map groupsMap = e.getGroups();
            HashMap<ServiceRegistrar, String[]> discardedGroupsMap = new HashMap<ServiceRegistrar, String[]>(proxys.length);
            HashMap<ServiceRegistrar, String[]> changedGroupsMap = new HashMap<ServiceRegistrar, String[]>(proxys.length);
            for (int i = 0; i < proxys.length; ++i) {
                ArrayList arrayList = LookupDiscoveryManager.this.discoveredSet;
                synchronized (arrayList) {
                    ProxyReg reg = LookupDiscoveryManager.this.findReg(proxys[i]);
                    if (reg != null) {
                        String[] newGroups = (String[])groupsMap.get(reg.proxy);
                        if (this.removeDiscoveredSet(reg, 1)) {
                            discardedGroupsMap.put(reg.proxy, newGroups);
                        } else {
                            String[] desiredGroups = LookupDiscoveryManager.this.lookupDisc.getGroups();
                            if (!LookupDiscoveryManager.this.stillInterested(newGroups, desiredGroups)) {
                                String[] oldGroups = reg.getMemberGroups();
                                if (!LookupDiscoveryManager.groupSetsEqual(oldGroups, newGroups)) {
                                    reg.setMemberGroups(newGroups);
                                    changedGroupsMap.put(reg.proxy, newGroups);
                                }
                            } else {
                                reg.discard();
                            }
                        }
                    }
                    continue;
                }
            }
            LookupDiscoveryManager.this.notifyListener(discardedGroupsMap, 1);
            LookupDiscoveryManager.this.notifyListener(changedGroupsMap, 2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void changed(DiscoveryEvent e) {
            ServiceRegistrar[] proxys = e.getRegistrars();
            Map groupsMap = e.getGroups();
            HashMap<ServiceRegistrar, String[]> changedGroupsMap = new HashMap<ServiceRegistrar, String[]>(proxys.length);
            for (int i = 0; i < proxys.length; ++i) {
                ArrayList arrayList = LookupDiscoveryManager.this.discoveredSet;
                synchronized (arrayList) {
                    ProxyReg reg = LookupDiscoveryManager.this.findReg(proxys[i]);
                    if (reg != null) {
                        String[] newGroups = (String[])groupsMap.get(reg.proxy);
                        reg.setMemberGroups(newGroups);
                        changedGroupsMap.put(reg.proxy, newGroups);
                    }
                    continue;
                }
            }
            LookupDiscoveryManager.this.notifyListener(changedGroupsMap, 2);
        }
    }

    class LocatorDiscoveryListener
    implements DiscoveryListener {
        LocatorDiscoveryListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void discovered(DiscoveryEvent e) {
            ServiceRegistrar[] proxys = e.getRegistrars();
            Map groupsMap = e.getGroups();
            HashMap discoveredGroupsMap = new HashMap(proxys.length);
            HashMap changedGroupsMap = new HashMap(proxys.length);
            for (int i = 0; i < proxys.length; ++i) {
                ArrayList arrayList = LookupDiscoveryManager.this.discoveredSet;
                synchronized (arrayList) {
                    ProxyReg reg = LookupDiscoveryManager.this.findReg(proxys[i]);
                    if (reg == null) {
                        reg = new ProxyReg(proxys[i], (String[])groupsMap.get(proxys[i]), 2);
                        this.addDiscoveredSet(reg);
                        discoveredGroupsMap.put(proxys[i], groupsMap.get(proxys[i]));
                    } else {
                        reg.addFrom(2);
                    }
                    continue;
                }
            }
            LookupDiscoveryManager.this.notifyListener(discoveredGroupsMap, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void discarded(DiscoveryEvent e) {
            ServiceRegistrar[] proxys = e.getRegistrars();
            Map groupsMap = e.getGroups();
            HashMap<ServiceRegistrar, String[]> discardedGroupsMap = new HashMap<ServiceRegistrar, String[]>(proxys.length);
            for (int i = 0; i < proxys.length; ++i) {
                ArrayList arrayList = LookupDiscoveryManager.this.discoveredSet;
                synchronized (arrayList) {
                    ProxyReg reg = LookupDiscoveryManager.this.findReg(proxys[i]);
                    if (reg != null) {
                        String[] newGroups = (String[])groupsMap.get(reg.proxy);
                        if (this.removeDiscoveredSet(reg, 2)) {
                            discardedGroupsMap.put(reg.proxy, newGroups);
                        } else if (reg.commDiscard) {
                            reg.discard();
                        }
                    }
                    continue;
                }
            }
            LookupDiscoveryManager.this.notifyListener(discardedGroupsMap, 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addDiscoveredSet(ProxyReg reg) {
            ArrayList arrayList = LookupDiscoveryManager.this.discoveredSet;
            synchronized (arrayList) {
                LookupDiscoveryManager.this.discoveredSet.add(reg);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean removeDiscoveredSet(ProxyReg reg, int from) {
            boolean bret = reg.removeFrom(from);
            if (bret) {
                ArrayList arrayList = LookupDiscoveryManager.this.discoveredSet;
                synchronized (arrayList) {
                    LookupDiscoveryManager.this.discoveredSet.remove(reg);
                }
            }
            return bret;
        }
    }

    private final class ProxyReg {
        public ServiceRegistrar proxy;
        public String[] memberGroups;
        public boolean commDiscard = false;
        private int from;
        private boolean bDiscarded = false;

        public ProxyReg(ServiceRegistrar proxy, String[] memberGroups, int from) {
            if (proxy == null) {
                throw new IllegalArgumentException("proxy cannot be null");
            }
            if (from != 1 && from != 2) {
                throw new IllegalArgumentException("invalid discovery mechanism: must be either FROM_GROUP or FROM_LOCATOR");
            }
            this.proxy = proxy;
            this.memberGroups = memberGroups;
            this.from = from;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ProxyReg) {
                return this.proxy.equals(((ProxyReg)obj).proxy);
            }
            return false;
        }

        public int hashCode() {
            return this.proxy.hashCode();
        }

        public synchronized void addFrom(int from) {
            this.from |= from;
        }

        public synchronized boolean removeFrom(int from) {
            if (from == 0) {
                throw new RuntimeException("call to removeFrom with bad argument");
            }
            this.from &= ~from;
            return this.from == 0;
        }

        public synchronized int getFrom() {
            return this.from;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void discard() {
            ProxyReg proxyReg = this;
            synchronized (proxyReg) {
                this.bDiscarded = true;
            }
            if ((this.from & 1) != 0) {
                LookupDiscoveryManager.this.lookupDisc.discard(this.proxy);
            } else if ((this.from & 2) != 0) {
                LookupDiscoveryManager.this.locatorDisc.discard(this.proxy);
            }
        }

        public synchronized boolean isDiscarded() {
            return this.bDiscarded;
        }

        public synchronized String[] getMemberGroups() {
            return this.memberGroups;
        }

        public synchronized void setMemberGroups(String[] newMemberGroups) {
            this.memberGroups = newMemberGroups;
        }
    }
}

