/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.ssl;

import java.math.BigInteger;
import java.security.Key;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import javax.security.auth.x500.X500PrivateCredential;
import net.jini.jeri.ssl.Utilities;
import net.jini.security.Security;

class SubjectCredentials
extends Utilities {
    private SubjectCredentials() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CertPath getCertificateChain(Subject subject, String name) {
        if (subject == null) {
            return null;
        }
        CertificateMatcher matcher = CertificateMatcher.create(name);
        if (matcher != null) {
            Set<Object> publicCreds;
            Set<Object> set = publicCreds = subject.getPublicCredentials();
            synchronized (set) {
                Iterator<Object> it = publicCreds.iterator();
                while (it.hasNext()) {
                    CertPath chain;
                    Object cred = it.next();
                    if (!SubjectCredentials.isX509CertificateChain(cred) || !matcher.matches(SubjectCredentials.firstX509Cert(chain = (CertPath)cred))) continue;
                    return chain;
                }
            }
        }
        return null;
    }

    static String getCertificateName(X509Certificate cert) {
        return CertificateMatcher.getName(cert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List getCertificateChains(Subject subject) {
        ArrayList<Object> result = null;
        if (subject != null) {
            Set<Object> publicCreds;
            Set<Object> set = publicCreds = subject.getPublicCredentials();
            synchronized (set) {
                Iterator<Object> it = publicCreds.iterator();
                while (it.hasNext()) {
                    Object cred = it.next();
                    if (!SubjectCredentials.isX509CertificateChain(cred)) continue;
                    if (result == null) {
                        result = new ArrayList<Object>(publicCreds.size());
                    }
                    result.add(cred);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CertPath getCertificateChain(Subject subject, X509Certificate cert) {
        if (subject != null) {
            Set<Object> publicCreds;
            Principal subjectDN = null;
            PublicKey key = null;
            Set<Object> set = publicCreds = subject.getPublicCredentials();
            synchronized (set) {
                Iterator<Object> it = publicCreds.iterator();
                while (it.hasNext()) {
                    Object cred = it.next();
                    if (!SubjectCredentials.isX509CertificateChain(cred)) continue;
                    CertPath chain = (CertPath)cred;
                    X509Certificate start = SubjectCredentials.firstX509Cert(chain);
                    if (cert.equals(start)) {
                        return chain;
                    }
                    if (subjectDN == null) {
                        subjectDN = cert.getSubjectDN();
                        key = cert.getPublicKey();
                    }
                    if (!((Object)subjectDN).equals(start.getSubjectDN()) || !key.equals(start.getPublicKey())) continue;
                    return chain;
                }
            }
        }
        return null;
    }

    static Set getPrincipals(Subject subject, int keyAlgorithms, X500PrivateCredential[] privateCredentials) {
        HashSet<X500Principal> result = new HashSet<X500Principal>(subject.getPrincipals().size());
        List certPaths = SubjectCredentials.getCertificateChains(subject);
        if (certPaths != null) {
            int i = certPaths.size();
            while (--i >= 0) {
                boolean pcOK;
                X500Principal principal;
                CertPath chain = (CertPath)certPaths.get(i);
                X509Certificate cert = SubjectCredentials.firstX509Cert(chain);
                String alg = cert.getPublicKey().getAlgorithm();
                if (!SubjectCredentials.permittedKeyAlgorithm(alg, keyAlgorithms) || (principal = SubjectCredentials.getPrincipal(subject, cert)) == null) continue;
                boolean bl = pcOK = privateCredentials == null;
                if (!pcOK) {
                    int j = privateCredentials.length;
                    while (--j >= 0) {
                        X500PrivateCredential xpc = privateCredentials[j];
                        if (!cert.equals(xpc.getCertificate())) continue;
                        pcOK = true;
                        break;
                    }
                }
                if (!pcOK) continue;
                result.add(principal);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static X500PrivateCredential getPrivateCredential(Subject subject, X509Certificate cert) {
        Set<Object> privateCreds;
        X500PrivateCredential result = null;
        Set<Object> set = privateCreds = subject.getPrivateCredentials();
        synchronized (set) {
            Iterator<Object> it = privateCreds.iterator();
            while (it.hasNext()) {
                X500PrivateCredential xpc;
                Object cred = it.next();
                if (!(cred instanceof X500PrivateCredential) || !cert.equals((xpc = (X500PrivateCredential)cred).getCertificate())) continue;
                result = xpc;
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static X500Principal getPrincipal(Subject subject, X509Certificate cert) {
        Set<Principal> principals;
        X500Principal x500 = cert.getSubjectX500Principal();
        String name = x500.getName("CANONICAL");
        Set<Principal> set = principals = subject.getPrincipals();
        synchronized (set) {
            Iterator<Principal> i = principals.iterator();
            while (i.hasNext()) {
                X500Principal principal;
                Principal next = i.next();
                if (!(next instanceof X500Principal) || !(principal = (X500Principal)next).getName("CANONICAL").equals(name)) continue;
                return principal;
            }
        }
        return null;
    }

    static String credentialsString(Subject subject) {
        List certPaths = SubjectCredentials.getCertificateChains(subject);
        if (certPaths == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int i = certPaths.size();
        while (--i >= 0) {
            CertPath chain = (CertPath)certPaths.get(i);
            X509Certificate cert = SubjectCredentials.firstX509Cert(chain);
            X500Principal principal = SubjectCredentials.getPrincipal(subject, cert);
            if (principal == null) continue;
            buf.append("  Principal: ").append(principal).append('\n');
            buf.append("    Public key: ");
            SubjectCredentials.appendKeyString(cert.getPublicKey(), buf);
            buf.append('\n');
            buf.append("    Private key: ");
            try {
                PrivateKey privateKey;
                X500PrivateCredential cred = (X500PrivateCredential)Security.doPrivileged(new GetPrivateCredentialAction(subject, cert));
                PrivateKey privateKey2 = privateKey = cred != null ? cred.getPrivateKey() : null;
                if (privateKey == null) {
                    buf.append("Not found");
                    continue;
                }
                SubjectCredentials.appendKeyString(privateKey, buf);
            }
            catch (SecurityException e) {
                buf.append("No permission");
            }
        }
        return buf.toString();
    }

    private static void appendKeyString(Key key, StringBuffer buf) {
        String className = key.getClass().getName();
        buf.append(className.substring(className.lastIndexOf(46) + 1));
        buf.append('@');
        buf.append(Integer.toHexString(System.identityHashCode(key)));
    }

    private static boolean isX509CertificateChain(Object credential) {
        if (!(credential instanceof CertPath)) {
            return false;
        }
        CertPath certPath = (CertPath)credential;
        if (certPath.getCertificates().isEmpty()) {
            return false;
        }
        return certPath.getType().equals("X.509");
    }

    static class GetAllPrivateCredentialsAction
    implements PrivilegedAction {
        private final Subject subject;

        GetAllPrivateCredentialsAction(Subject subject) {
            this.subject = subject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object run() {
            Set<Object> pcs = this.subject.getPrivateCredentials();
            ArrayList<Object> xpcs = new ArrayList<Object>(pcs.size());
            Set<Object> set = pcs;
            synchronized (set) {
                Iterator<Object> iter2 = pcs.iterator();
                while (iter2.hasNext()) {
                    Object pc = iter2.next();
                    if (!(pc instanceof X500PrivateCredential)) continue;
                    xpcs.add(pc);
                }
            }
            return xpcs.toArray(new X500PrivateCredential[xpcs.size()]);
        }
    }

    static class GetPrivateCredentialAction
    implements PrivilegedAction {
        private final Subject subject;
        private final X509Certificate cert;

        GetPrivateCredentialAction(Subject subject, X509Certificate cert) {
            this.subject = subject;
            this.cert = cert;
        }

        public Object run() {
            return SubjectCredentials.getPrivateCredential(this.subject, this.cert);
        }
    }

    private static class CertificateMatcher {
        private final BigInteger serialNumber;
        private final String issuerName;

        static CertificateMatcher create(String certificateName) {
            BigInteger serialNumber;
            if (certificateName == null) {
                return null;
            }
            int atSignPosition = certificateName.indexOf(64);
            if (atSignPosition < 0) {
                return null;
            }
            try {
                serialNumber = new BigInteger(certificateName.substring(0, atSignPosition), 16);
            }
            catch (NumberFormatException e) {
                return null;
            }
            String issuerName = certificateName.substring(atSignPosition + 1);
            return new CertificateMatcher(serialNumber, issuerName);
        }

        private CertificateMatcher(BigInteger serialNumber, String issuerName) {
            this.serialNumber = serialNumber;
            this.issuerName = issuerName;
        }

        static String getName(X509Certificate certificate) {
            return certificate.getSerialNumber().toString(16) + "@" + CertificateMatcher.getIssuerName(certificate);
        }

        boolean matches(X509Certificate certificate) {
            return certificate.getSerialNumber().equals(this.serialNumber) && CertificateMatcher.getIssuerName(certificate).equals(this.issuerName);
        }

        private static String getIssuerName(X509Certificate certificate) {
            return certificate.getIssuerX500Principal().getName("CANONICAL");
        }
    }
}

