/*
 * Decompiled with CFR 0.152.
 */
package net.jini.lookup;

import com.sun.jini.constants.ThrowableConstants;
import com.sun.jini.lookup.entry.LookupAttributes;
import com.sun.jini.thread.RetryTask;
import com.sun.jini.thread.TaskManager;
import com.sun.jini.thread.WakeupManager;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.EmptyConfiguration;
import net.jini.config.NoSuchEntryException;
import net.jini.core.entry.Entry;
import net.jini.core.lease.Lease;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceRegistration;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.lease.LeaseListener;
import net.jini.lease.LeaseRenewalEvent;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lookup.ServiceIDListener;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;

public class JoinManager {
    private static final String COMPONENT_NAME = "net.jini.lookup.JoinManager";
    private static final Logger logger = Logger.getLogger("net.jini.lookup.JoinManager");
    private static final int MAX_N_TASKS = 15;
    private int taskSeqN = 0;
    private TaskManager taskMgr;
    private int maxNRetries = 6;
    private WakeupManager wakeupMgr;
    private ServiceItem serviceItem;
    private Entry[] lookupAttr = null;
    private ServiceIDListener callback;
    private final ArrayList joinSet = new ArrayList(1);
    private DiscoveryManagement discMgr = null;
    private DiscMgrListener discMgrListener = new DiscMgrListener();
    private boolean bCreateDiscMgr = false;
    private LeaseRenewalManager leaseRenewalMgr = null;
    private long renewalDuration = Long.MAX_VALUE;
    private boolean bTerminated = false;
    private ProxyPreparer registrarPreparer;
    private ProxyPreparer registrationPreparer;
    private ProxyPreparer serviceLeasePreparer;

    public JoinManager(Object serviceProxy, Entry[] attrSets, ServiceIDListener callback, DiscoveryManagement discoveryMgr, LeaseRenewalManager leaseMgr) throws IOException {
        this.discMgr = discoveryMgr;
        try {
            this.createJoinManager(null, serviceProxy, attrSets, callback, leaseMgr, EmptyConfiguration.INSTANCE);
        }
        catch (ConfigurationException e) {
            // empty catch block
        }
    }

    public JoinManager(Object serviceProxy, Entry[] attrSets, ServiceIDListener callback, DiscoveryManagement discoveryMgr, LeaseRenewalManager leaseMgr, Configuration config) throws IOException, ConfigurationException {
        this.discMgr = discoveryMgr;
        this.createJoinManager(null, serviceProxy, attrSets, callback, leaseMgr, config);
    }

    public JoinManager(Object serviceProxy, Entry[] attrSets, ServiceID serviceID, DiscoveryManagement discoveryMgr, LeaseRenewalManager leaseMgr) throws IOException {
        this.discMgr = discoveryMgr;
        try {
            this.createJoinManager(serviceID, serviceProxy, attrSets, null, leaseMgr, EmptyConfiguration.INSTANCE);
        }
        catch (ConfigurationException e) {
            // empty catch block
        }
    }

    public JoinManager(Object serviceProxy, Entry[] attrSets, ServiceID serviceID, DiscoveryManagement discoveryMgr, LeaseRenewalManager leaseMgr, Configuration config) throws IOException, ConfigurationException {
        this.discMgr = discoveryMgr;
        this.createJoinManager(serviceID, serviceProxy, attrSets, null, leaseMgr, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiscoveryManagement getDiscoveryManager() {
        JoinManager joinManager = this;
        synchronized (joinManager) {
            if (this.bTerminated) {
                throw new IllegalStateException("join manager was terminated");
            }
        }
        return this.discMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LeaseRenewalManager getLeaseRenewalManager() {
        JoinManager joinManager = this;
        synchronized (joinManager) {
            if (this.bTerminated) {
                throw new IllegalStateException("join manager was terminated");
            }
        }
        return this.leaseRenewalMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceRegistrar[] getJoinSet() {
        Object object = this;
        synchronized (object) {
            if (this.bTerminated) {
                throw new IllegalStateException("join manager was terminated");
            }
        }
        object = this.joinSet;
        synchronized (object) {
            ArrayList<ServiceRegistrar> retList = new ArrayList<ServiceRegistrar>(this.joinSet.size());
            boolean k = false;
            Iterator iter2 = this.joinSet.iterator();
            while (iter2.hasNext()) {
                ProxyReg proxyReg = (ProxyReg)iter2.next();
                if (proxyReg.srvcRegistration == null) continue;
                retList.add(proxyReg.proxy);
            }
            return retList.toArray(new ServiceRegistrar[retList.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry[] getAttributes() {
        Object object = this;
        synchronized (object) {
            if (this.bTerminated) {
                throw new IllegalStateException("join manager was terminated");
            }
        }
        object = this.joinSet;
        synchronized (object) {
            return (Entry[])this.lookupAttr.clone();
        }
    }

    public void addAttributes(Entry[] attrSets) {
        this.addAttributes(attrSets, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAttributes(Entry[] attrSets, boolean checkSC) {
        Object object = this;
        synchronized (object) {
            if (this.bTerminated) {
                throw new IllegalStateException("join manager was terminated");
            }
        }
        object = this.joinSet;
        synchronized (object) {
            this.lookupAttr = LookupAttributes.add(this.lookupAttr, attrSets, checkSC);
            this.serviceItem.attributeSets = this.lookupAttr;
            for (int i = 0; i < this.joinSet.size(); ++i) {
                ProxyReg proxyReg = (ProxyReg)this.joinSet.get(i);
                proxyReg.addTask(new AddAttributesTask(proxyReg, attrSets));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributes(Entry[] attrSets) {
        Object object = this;
        synchronized (object) {
            if (this.bTerminated) {
                throw new IllegalStateException("join manager was terminated");
            }
        }
        this.testForNullElement(attrSets);
        object = this.joinSet;
        synchronized (object) {
            this.lookupAttr = (Entry[])attrSets.clone();
            this.serviceItem.attributeSets = this.lookupAttr;
            for (int i = 0; i < this.joinSet.size(); ++i) {
                ProxyReg proxyReg = (ProxyReg)this.joinSet.get(i);
                proxyReg.addTask(new SetAttributesTask(proxyReg, attrSets));
            }
        }
    }

    public void modifyAttributes(Entry[] attrSetTemplates, Entry[] attrSets) {
        this.modifyAttributes(attrSetTemplates, attrSets, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyAttributes(Entry[] attrSetTemplates, Entry[] attrSets, boolean checkSC) {
        Object object = this;
        synchronized (object) {
            if (this.bTerminated) {
                throw new IllegalStateException("join manager was terminated");
            }
        }
        object = this.joinSet;
        synchronized (object) {
            this.lookupAttr = LookupAttributes.modify(this.lookupAttr, attrSetTemplates, attrSets, checkSC);
            this.serviceItem.attributeSets = this.lookupAttr;
            for (int i = 0; i < this.joinSet.size(); ++i) {
                ProxyReg proxyReg = (ProxyReg)this.joinSet.get(i);
                proxyReg.addTask(new ModifyAttributesTask(proxyReg, attrSetTemplates, attrSets));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        JoinManager joinManager = this;
        synchronized (joinManager) {
            if (this.bTerminated) {
                return;
            }
            this.bTerminated = true;
            this.discMgr.removeDiscoveryListener(this.discMgrListener);
            if (this.bCreateDiscMgr) {
                this.discMgr.terminate();
            }
        }
        this.terminateTaskMgr();
        ArrayList<Lease> srvcLeases = null;
        ArrayList arrayList = this.joinSet;
        synchronized (arrayList) {
            srvcLeases = new ArrayList<Lease>(this.joinSet.size());
            Iterator iter2 = this.joinSet.iterator();
            while (iter2.hasNext()) {
                srvcLeases.add(((ProxyReg)iter2.next()).serviceLease);
            }
            this.joinSet.clear();
        }
        if (srvcLeases == null) {
            return;
        }
        for (int i = 0; i < srvcLeases.size(); ++i) {
            try {
                this.leaseRenewalMgr.cancel((Lease)srvcLeases.get(i));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void replaceRegistration(Object serviceProxy) {
        this.replaceRegistrationDo(serviceProxy, null, false);
    }

    public void replaceRegistration(Object serviceProxy, Entry[] attrSets) {
        this.replaceRegistrationDo(serviceProxy, attrSets, true);
    }

    private void createJoinManager(ServiceID serviceID, Object serviceProxy, Entry[] attrSets, ServiceIDListener callback, LeaseRenewalManager leaseMgr, Configuration config) throws IOException, ConfigurationException {
        if (!(serviceProxy instanceof Serializable)) {
            throw new IllegalArgumentException("serviceProxy must be Serializable");
        }
        if (config == null) {
            throw new NullPointerException("config is null");
        }
        this.registrarPreparer = (ProxyPreparer)config.getEntry(COMPONENT_NAME, "registrarPreparer", ProxyPreparer.class, new BasicProxyPreparer());
        this.registrationPreparer = (ProxyPreparer)config.getEntry(COMPONENT_NAME, "registrationPreparer", ProxyPreparer.class, new BasicProxyPreparer());
        this.serviceLeasePreparer = (ProxyPreparer)config.getEntry(COMPONENT_NAME, "serviceLeasePreparer", ProxyPreparer.class, new BasicProxyPreparer());
        try {
            this.taskMgr = (TaskManager)config.getEntry(COMPONENT_NAME, "taskManager", TaskManager.class);
        }
        catch (NoSuchEntryException e) {
            this.taskMgr = new TaskManager(15, 15000L, 1.0f);
        }
        try {
            this.wakeupMgr = (WakeupManager)config.getEntry(COMPONENT_NAME, "wakeupManager", WakeupManager.class);
        }
        catch (NoSuchEntryException e) {
            this.wakeupMgr = new WakeupManager(new WakeupManager.ThreadDesc(null, true));
        }
        this.maxNRetries = (Integer)config.getEntry(COMPONENT_NAME, "wakeupRetries", Integer.TYPE, new Integer(this.maxNRetries));
        if (attrSets == null) {
            this.lookupAttr = new Entry[0];
        } else {
            attrSets = (Entry[])attrSets.clone();
            LookupAttributes.check(attrSets, false);
            this.lookupAttr = attrSets;
        }
        this.serviceItem = new ServiceItem(serviceID, serviceProxy, this.lookupAttr);
        this.leaseRenewalMgr = leaseMgr;
        if (this.leaseRenewalMgr == null) {
            try {
                this.leaseRenewalMgr = (LeaseRenewalManager)config.getEntry(COMPONENT_NAME, "leaseManager", LeaseRenewalManager.class);
            }
            catch (NoSuchEntryException e) {
                this.leaseRenewalMgr = new LeaseRenewalManager(config);
            }
        }
        this.renewalDuration = (Long)config.getEntry(COMPONENT_NAME, "maxLeaseDuration", Long.TYPE, new Long(this.renewalDuration));
        if (this.renewalDuration == 0L || this.renewalDuration < -1L) {
            throw new ConfigurationException("invalid configuration entry: renewalDuration (" + this.renewalDuration + ") must be " + "positive or Lease.ANY");
        }
        this.callback = callback;
        if (this.discMgr == null) {
            this.bCreateDiscMgr = true;
            try {
                this.discMgr = (DiscoveryManagement)config.getEntry(COMPONENT_NAME, "discoveryManager", DiscoveryManagement.class);
            }
            catch (NoSuchEntryException e) {
                this.discMgr = new LookupDiscoveryManager(new String[]{""}, null, null, config);
            }
        }
        this.discMgr.addDiscoveryListener(this.discMgrListener);
    }

    private ProxyReg findReg(ServiceRegistrar proxy) {
        Iterator iter2 = this.joinSet.iterator();
        while (iter2.hasNext()) {
            ProxyReg reg = (ProxyReg)iter2.next();
            if (!reg.proxy.equals(proxy)) continue;
            return reg;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTasks(ProxyReg proxyReg) {
        if (proxyReg == null) {
            return;
        }
        if (this.taskMgr == null) {
            return;
        }
        List list = proxyReg.taskList;
        synchronized (list) {
            if (proxyReg.proxyRegTask != null) {
                TaskManager taskManager = this.taskMgr;
                synchronized (taskManager) {
                    this.taskMgr.remove(proxyReg.proxyRegTask);
                }
                proxyReg.proxyRegTask.cancel();
                proxyReg.proxyRegTask = null;
            }
            proxyReg.taskList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminateTaskMgr() {
        WakeupManager wakeupManager = this.wakeupMgr;
        synchronized (wakeupManager) {
            this.wakeupMgr.cancelAll();
            this.wakeupMgr.stop();
            TaskManager taskManager = this.taskMgr;
            synchronized (taskManager) {
                ArrayList pendingTasks = this.taskMgr.getPending();
                for (int i = 0; i < pendingTasks.size(); ++i) {
                    RetryTask pendingTask = (RetryTask)pendingTasks.get(i);
                    pendingTask.cancel();
                    this.taskMgr.remove(pendingTask);
                }
                this.taskMgr.terminate();
                this.taskMgr = null;
            }
            this.wakeupMgr = null;
        }
    }

    private void testForNullElement(Object[] a) {
        if (a == null) {
            return;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != null) continue;
            throw new NullPointerException("input array contains at least one null element");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceRegistrationDo(Object serviceProxy, Entry[] attrSets, boolean doAttrs) {
        Object object = this;
        synchronized (object) {
            if (this.bTerminated) {
                throw new IllegalStateException("join manager was terminated");
            }
        }
        if (!(serviceProxy instanceof Serializable)) {
            throw new IllegalArgumentException("serviceProxy must be Serializable");
        }
        object = this.joinSet;
        synchronized (object) {
            if (doAttrs) {
                if (attrSets == null) {
                    this.lookupAttr = new Entry[0];
                } else {
                    attrSets = (Entry[])attrSets.clone();
                    LookupAttributes.check(attrSets, false);
                    this.lookupAttr = attrSets;
                }
            }
            this.serviceItem.service = serviceProxy;
            this.serviceItem.attributeSets = this.lookupAttr;
            for (int i = 0; i < this.joinSet.size(); ++i) {
                ProxyReg proxyReg = (ProxyReg)this.joinSet.get(i);
                this.removeTasks(proxyReg);
                try {
                    this.leaseRenewalMgr.remove(proxyReg.serviceLease);
                }
                catch (Exception e) {
                    // empty catch block
                }
                proxyReg.addTask(new RegisterTask(proxyReg, (Entry[])this.lookupAttr.clone()));
            }
        }
    }

    private class DiscMgrListener
    implements DiscoveryListener {
        private DiscMgrListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void discovered(DiscoveryEvent e) {
            ArrayList arrayList = JoinManager.this.joinSet;
            synchronized (arrayList) {
                ServiceRegistrar[] proxys = e.getRegistrars();
                for (int i = 0; i < proxys.length; ++i) {
                    try {
                        proxys[i] = (ServiceRegistrar)JoinManager.this.registrarPreparer.prepareProxy(proxys[i]);
                        logger.log(Level.FINEST, "JoinManager - discovered lookup service proxy prepared: {0}", proxys[i]);
                    }
                    catch (Exception e1) {
                        logger.log(Level.INFO, "failure preparing discovered ServiceRegistrar proxy", e1);
                        JoinManager.this.discMgr.discard(proxys[i]);
                        continue;
                    }
                    if (proxys[i].equals(((JoinManager)JoinManager.this).serviceItem.service)) continue;
                    ProxyReg proxyReg = new ProxyReg(proxys[i]);
                    if (JoinManager.this.joinSet.contains(proxyReg)) continue;
                    JoinManager.this.joinSet.add(proxyReg);
                    proxyReg.addTask(new RegisterTask(proxyReg, (Entry[])JoinManager.this.lookupAttr.clone()));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void discarded(DiscoveryEvent e) {
            ArrayList arrayList = JoinManager.this.joinSet;
            synchronized (arrayList) {
                ServiceRegistrar[] proxys = e.getRegistrars();
                for (int i = 0; i < proxys.length; ++i) {
                    ProxyReg proxyReg = JoinManager.this.findReg(proxys[i]);
                    if (proxyReg == null) continue;
                    JoinManager.this.removeTasks(proxyReg);
                    JoinManager.this.joinSet.remove(proxyReg);
                    try {
                        JoinManager.this.leaseRenewalMgr.remove(proxyReg.serviceLease);
                    }
                    catch (UnknownLeaseException ex) {
                        // empty catch block
                    }
                    proxyReg.addTask(new DiscardProxyTask(proxyReg));
                }
            }
        }
    }

    private class ProxyReg {
        public ProxyRegTask proxyRegTask;
        public ServiceRegistrar proxy;
        public ServiceRegistration srvcRegistration = null;
        public Lease serviceLease = null;
        public List taskList = new ArrayList(1);
        private DiscLeaseListener dListener = new DiscLeaseListener();

        public ProxyReg(ServiceRegistrar proxy) {
            if (proxy == null) {
                throw new IllegalArgumentException("proxy can't be null");
            }
            this.proxy = proxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addTask(JoinTask task) {
            Object object = JoinManager.this;
            synchronized (object) {
                if (JoinManager.this.bTerminated) {
                    return;
                }
            }
            object = this.taskList;
            synchronized (object) {
                this.taskList.add(task);
                if (this.proxyRegTask == null) {
                    this.proxyRegTask = new ProxyRegTask(this, JoinManager.this.taskSeqN++);
                    TaskManager taskManager = JoinManager.this.taskMgr;
                    synchronized (taskManager) {
                        JoinManager.this.taskMgr.add(this.proxyRegTask);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void register(Entry[] srvcAttrs) throws Exception {
            if (this.proxy == null) {
                throw new RuntimeException("proxy is null");
            }
            ServiceItem tmpSrvcItem = null;
            ArrayList arrayList = JoinManager.this.joinSet;
            synchronized (arrayList) {
                this.srvcRegistration = null;
                ServiceItem serviceItem = JoinManager.this.serviceItem;
                synchronized (serviceItem) {
                    tmpSrvcItem = new ServiceItem(((JoinManager)JoinManager.this).serviceItem.serviceID, ((JoinManager)JoinManager.this).serviceItem.service, srvcAttrs);
                }
            }
            ServiceRegistration tmpSrvcRegistration = this.proxy.register(tmpSrvcItem, JoinManager.this.renewalDuration);
            try {
                tmpSrvcRegistration = (ServiceRegistration)JoinManager.this.registrationPreparer.prepareProxy(tmpSrvcRegistration);
                logger.finest("JoinManager - ServiceRegistration proxy prepared");
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "failure during preparation of ServiceRegistration proxy", e);
                throw e;
            }
            this.serviceLease = tmpSrvcRegistration.getLease();
            try {
                this.serviceLease = (Lease)JoinManager.this.serviceLeasePreparer.prepareProxy(this.serviceLease);
                logger.finest("JoinManager - service lease proxy prepared");
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "failure during preparation of service lease proxy", e);
                throw e;
            }
            JoinManager.this.leaseRenewalMgr.renewUntil(this.serviceLease, Long.MAX_VALUE, JoinManager.this.renewalDuration, this.dListener);
            ServiceID tmpID = null;
            ArrayList arrayList2 = JoinManager.this.joinSet;
            synchronized (arrayList2) {
                this.srvcRegistration = tmpSrvcRegistration;
                ServiceItem serviceItem = JoinManager.this.serviceItem;
                synchronized (serviceItem) {
                    if (((JoinManager)JoinManager.this).serviceItem.serviceID == null) {
                        tmpID = ((JoinManager)JoinManager.this).serviceItem.serviceID = this.srvcRegistration.getServiceID();
                    }
                }
            }
            if (tmpID != null && JoinManager.this.callback != null) {
                JoinManager.this.callback.serviceIDNotify(tmpID);
            }
        }

        public void addAttributes(Entry[] attSet) throws Exception {
            this.srvcRegistration.addAttributes(attSet);
        }

        public void modifyAttributes(Entry[] templ, Entry[] attSet) throws Exception {
            this.srvcRegistration.modifyAttributes(templ, attSet);
        }

        public void setAttributes(Entry[] attSet) throws Exception {
            this.srvcRegistration.setAttributes(attSet);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fail(Throwable e) {
            ProxyReg proxyReg = this;
            synchronized (proxyReg) {
                if (JoinManager.this.bTerminated) {
                    return;
                }
                logger.log(Level.INFO, "JoinManager - failure", e);
                try {
                    JoinManager.this.discMgr.discard(this.proxy);
                }
                catch (IllegalStateException e1) {
                    logger.log(Level.FINEST, "JoinManager - cannot discard lookup, discovery manager already terminated", e1);
                }
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof ProxyReg) {
                return this.proxy.equals(((ProxyReg)obj).proxy);
            }
            return false;
        }

        public int hashCode() {
            return this.proxy.hashCode();
        }

        private class DiscLeaseListener
        implements LeaseListener {
            private DiscLeaseListener() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void notify(LeaseRenewalEvent e) {
                Throwable ex = e.getException();
                if (ex == null || ex instanceof UnknownLeaseException) {
                    ArrayList arrayList = JoinManager.this.joinSet;
                    synchronized (arrayList) {
                        JoinManager.this.removeTasks(ProxyReg.this);
                        Lease expiredLease = e.getLease();
                        int indx = JoinManager.this.joinSet.indexOf(ProxyReg.this);
                        if (indx >= 0) {
                            ProxyReg curProxyReg = (ProxyReg)JoinManager.this.joinSet.get(indx);
                            if (expiredLease.equals(curProxyReg.serviceLease)) {
                                ProxyReg.this.addTask(new LeaseExpireNotifyTask(ProxyReg.this, (Entry[])JoinManager.this.lookupAttr.clone()));
                            }
                        }
                    }
                } else {
                    ProxyReg.this.fail(ex);
                }
            }
        }
    }

    private final class ModifyAttributesTask
    extends AddAttributesTask {
        private Entry[] attrSetTemplates;

        ModifyAttributesTask(ProxyReg proxyReg, Entry[] attrSetTemplates, Entry[] attrChanges) {
            super(proxyReg, attrChanges);
            this.attrSetTemplates = (Entry[])attrSetTemplates.clone();
        }

        protected void doAttributes(ProxyReg proxyReg) throws Exception {
            logger.finest("JoinManager - ModifyAttributesTask started");
            proxyReg.modifyAttributes(this.attrSetTemplates, this.attrSets);
            logger.finest("JoinManager - ModifyAttributesTask completed");
        }
    }

    private final class SetAttributesTask
    extends AddAttributesTask {
        SetAttributesTask(ProxyReg proxyReg, Entry[] replacementAttrs) {
            super(proxyReg, replacementAttrs);
        }

        protected void doAttributes(ProxyReg proxyReg) throws Exception {
            logger.finest("JoinManager - SetAttributesTask started");
            proxyReg.setAttributes(this.attrSets);
            logger.finest("JoinManager - SetAttributesTask completed");
        }
    }

    private class AddAttributesTask
    extends JoinTask {
        protected Entry[] attrSets;

        AddAttributesTask(ProxyReg proxyReg, Entry[] newAttrs) {
            super(proxyReg);
            this.attrSets = (Entry[])newAttrs.clone();
        }

        protected void doAttributes(ProxyReg proxyReg) throws Exception {
            logger.finest("JoinManager - AddAttributesTask started");
            proxyReg.addAttributes(this.attrSets);
            logger.finest("JoinManager - AddAttributesTask completed");
        }

        public void run() throws Exception {
            this.doAttributes(this.proxyReg);
        }
    }

    private class DiscardProxyTask
    extends JoinTask {
        DiscardProxyTask(ProxyReg proxyReg) {
            super(proxyReg);
        }

        public void run() {
            logger.finest("JoinManager --> DiscardProxyTask started");
            if (this.proxyReg != null && this.proxyReg.serviceLease != null) {
                try {
                    this.proxyReg.serviceLease.cancel();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            logger.finest("JoinManager - DiscardProxyTask completed");
        }
    }

    private class LeaseExpireNotifyTask
    extends JoinTask {
        Entry[] regAttrs;

        LeaseExpireNotifyTask(ProxyReg proxyReg, Entry[] regAttrs) {
            super(proxyReg);
            this.regAttrs = regAttrs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws Exception {
            logger.finest("JoinManager - LeaseExpireNotifyTask started");
            boolean tryIt = false;
            ArrayList arrayList = JoinManager.this.joinSet;
            synchronized (arrayList) {
                tryIt = JoinManager.this.joinSet.contains(this.proxyReg);
            }
            if (tryIt) {
                this.proxyReg.register(this.regAttrs);
            }
            logger.finest("JoinManager - LeaseExpireNotifyTask completed");
        }
    }

    private class RegisterTask
    extends JoinTask {
        Entry[] regAttrs;

        RegisterTask(ProxyReg proxyReg, Entry[] regAttrs) {
            super(proxyReg);
            this.regAttrs = regAttrs;
        }

        public void run() throws Exception {
            logger.finest("JoinManager - RegisterTask started");
            this.proxyReg.register(this.regAttrs);
            logger.finest("JoinManager - RegisterTask completed");
        }
    }

    private abstract class JoinTask {
        protected ProxyReg proxyReg;

        JoinTask(ProxyReg proxyReg) {
            this.proxyReg = proxyReg;
        }

        public abstract void run() throws Exception;
    }

    private class ProxyRegTask
    extends RetryTask {
        private final long[] sleepTime;
        protected int tryIndx;
        protected int nRetries;
        protected ProxyReg proxyReg;
        protected int seqN;

        ProxyRegTask(ProxyReg proxyReg, int seqN) {
            super(JoinManager.this.taskMgr, JoinManager.this.wakeupMgr);
            this.sleepTime = new long[]{5000L, 10000L, 15000L, 20000L, 25000L, 30000L};
            this.tryIndx = 0;
            this.nRetries = 0;
            this.proxyReg = proxyReg;
            this.seqN = seqN;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tryOnce() {
            while (true) {
                JoinTask t = null;
                List list = this.proxyReg.taskList;
                synchronized (list) {
                    if (this.proxyReg.taskList.isEmpty()) {
                        this.proxyReg.proxyRegTask = null;
                        return true;
                    }
                    t = (JoinTask)this.proxyReg.taskList.get(0);
                }
                try {
                    t.run();
                    list = this.proxyReg.taskList;
                    synchronized (list) {
                        if (!this.proxyReg.taskList.isEmpty()) {
                            this.proxyReg.taskList.remove(0);
                        }
                    }
                    this.tryIndx = 0;
                    this.nRetries = 0;
                }
                catch (Exception e) {
                    return this.stopTrying(e);
                }
            }
        }

        public long retryTime() {
            long nextTryTime = System.currentTimeMillis() + this.sleepTime[this.tryIndx];
            if (this.tryIndx < this.sleepTime.length - 1) {
                ++this.tryIndx;
            }
            ++this.nRetries;
            return nextTryTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean runAfter(List tasks, int size) {
            ServiceItem serviceItem = JoinManager.this.serviceItem;
            synchronized (serviceItem) {
                if (((JoinManager)JoinManager.this).serviceItem.serviceID != null) {
                    return false;
                }
                for (int i = 0; i < size; ++i) {
                    TaskManager.Task t = (TaskManager.Task)tasks.get(i);
                    int nextTaskSeqN = ((ProxyRegTask)t).getSeqN();
                    if (this.seqN <= nextTaskSeqN) continue;
                    return true;
                }
                return false;
            }
        }

        public ProxyReg getProxyReg() {
            return this.proxyReg;
        }

        public int getSeqN() {
            return this.seqN;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean stopTrying(Exception e) {
            int exCat = ThrowableConstants.retryable(e);
            if (exCat != 0 || this.nRetries >= JoinManager.this.maxNRetries) {
                ArrayList arrayList = JoinManager.this.joinSet;
                synchronized (arrayList) {
                    JoinManager.this.removeTasks(this.proxyReg);
                }
                this.proxyReg.fail(e);
                return true;
            }
            logger.log(Level.FINER, "JoinManager - failure, will retry later", e);
            return false;
        }
    }
}

