/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.MutableBits;
import org.apache.lucene.util.SparseFixedBitSet;

public abstract class BitSet
implements MutableBits,
Accountable {
    public static BitSet of(DocIdSetIterator it, int maxDoc) throws IOException {
        int threshold;
        long cost = it.cost();
        BitSet set = cost < (long)(threshold = maxDoc >>> 7) ? new SparseFixedBitSet(maxDoc) : new FixedBitSet(maxDoc);
        set.or(it);
        return set;
    }

    public abstract void set(int var1);

    public abstract void clear(int var1, int var2);

    public abstract int cardinality();

    public int approximateCardinality() {
        return this.cardinality();
    }

    public abstract int prevSetBit(int var1);

    public abstract int nextSetBit(int var1);

    protected final void assertUnpositioned(DocIdSetIterator iter2) {
        if (iter2.docID() != -1) {
            throw new IllegalStateException("This operation only works with an unpositioned iterator, got current position = " + iter2.docID());
        }
    }

    public void or(DocIdSetIterator iter2) throws IOException {
        this.assertUnpositioned(iter2);
        int doc = iter2.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            this.set(doc);
            doc = iter2.nextDoc();
        }
    }

    private void leapFrog(DocIdSetIterator iter2, LeapFrogCallBack callback) throws IOException {
        int length = this.length();
        int bitSetDoc = -1;
        int disiDoc = iter2.nextDoc();
        while (true) {
            assert (bitSetDoc <= disiDoc);
            if (disiDoc >= length) {
                callback.finish();
                return;
            }
            if (bitSetDoc < disiDoc) {
                bitSetDoc = this.nextSetBit(disiDoc);
            }
            if (bitSetDoc == disiDoc) {
                callback.onMatch(bitSetDoc);
                disiDoc = iter2.nextDoc();
                continue;
            }
            disiDoc = iter2.advance(bitSetDoc);
        }
    }

    @Deprecated
    public void and(DocIdSetIterator iter2) throws IOException {
        this.assertUnpositioned(iter2);
        this.leapFrog(iter2, new LeapFrogCallBack(){
            int previous = -1;

            @Override
            public void onMatch(int doc) {
                BitSet.this.clear(this.previous + 1, doc);
                this.previous = doc;
            }

            @Override
            public void finish() {
                if (this.previous + 1 < BitSet.this.length()) {
                    BitSet.this.clear(this.previous + 1, BitSet.this.length());
                }
            }
        });
    }

    @Deprecated
    public void andNot(DocIdSetIterator iter2) throws IOException {
        this.assertUnpositioned(iter2);
        this.leapFrog(iter2, new LeapFrogCallBack(){

            @Override
            public void onMatch(int doc) {
                BitSet.this.clear(doc);
            }
        });
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    private static abstract class LeapFrogCallBack {
        private LeapFrogCallBack() {
        }

        abstract void onMatch(int var1);

        void finish() {
        }
    }
}

