/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.MutableBits;
import org.apache.lucene.util.RamUsageEstimator;

public final class FixedBitSet
extends BitSet
implements MutableBits,
Accountable {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(FixedBitSet.class);
    private final long[] bits;
    private final int numBits;
    private final int numWords;

    public static FixedBitSet ensureCapacity(FixedBitSet bits, int numBits) {
        long[] arr;
        if (numBits < bits.numBits) {
            return bits;
        }
        int numWords = FixedBitSet.bits2words(numBits);
        if (numWords >= (arr = bits.getBits()).length) {
            arr = ArrayUtil.grow(arr, numWords + 1);
        }
        return new FixedBitSet(arr, arr.length << 6);
    }

    public static int bits2words(int numBits) {
        return (numBits - 1 >> 6) + 1;
    }

    public static long intersectionCount(FixedBitSet a, FixedBitSet b) {
        return BitUtil.pop_intersect(a.bits, b.bits, 0, Math.min(a.numWords, b.numWords));
    }

    public static long unionCount(FixedBitSet a, FixedBitSet b) {
        long tot = BitUtil.pop_union(a.bits, b.bits, 0, Math.min(a.numWords, b.numWords));
        if (a.numWords < b.numWords) {
            tot += BitUtil.pop_array(b.bits, a.numWords, b.numWords - a.numWords);
        } else if (a.numWords > b.numWords) {
            tot += BitUtil.pop_array(a.bits, b.numWords, a.numWords - b.numWords);
        }
        return tot;
    }

    public static long andNotCount(FixedBitSet a, FixedBitSet b) {
        long tot = BitUtil.pop_andnot(a.bits, b.bits, 0, Math.min(a.numWords, b.numWords));
        if (a.numWords > b.numWords) {
            tot += BitUtil.pop_array(a.bits, b.numWords, a.numWords - b.numWords);
        }
        return tot;
    }

    public FixedBitSet(int numBits) {
        this.numBits = numBits;
        this.bits = new long[FixedBitSet.bits2words(numBits)];
        this.numWords = this.bits.length;
    }

    public FixedBitSet(long[] storedBits, int numBits) {
        this.numWords = FixedBitSet.bits2words(numBits);
        if (this.numWords > storedBits.length) {
            throw new IllegalArgumentException("The given long array is too small  to hold " + numBits + " bits");
        }
        this.numBits = numBits;
        this.bits = storedBits;
        assert (this.verifyGhostBitsClear());
    }

    private boolean verifyGhostBitsClear() {
        for (int i = this.numWords; i < this.bits.length; ++i) {
            if (this.bits[i] == 0L) continue;
            return false;
        }
        if ((this.numBits & 0x3F) == 0) {
            return true;
        }
        long mask = -1L << this.numBits;
        return (this.bits[this.numWords - 1] & mask) == 0L;
    }

    @Override
    public int length() {
        return this.numBits;
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(this.bits);
    }

    public long[] getBits() {
        return this.bits;
    }

    @Override
    public int cardinality() {
        return (int)BitUtil.pop_array(this.bits, 0, this.numWords);
    }

    @Override
    public boolean get(int index) {
        assert (index >= 0 && index < this.numBits) : "index=" + index + ", numBits=" + this.numBits;
        int i = index >> 6;
        long bitmask = 1L << index;
        return (this.bits[i] & bitmask) != 0L;
    }

    @Override
    public void set(int index) {
        assert (index >= 0 && index < this.numBits) : "index=" + index + ", numBits=" + this.numBits;
        int wordNum = index >> 6;
        long bitmask = 1L << index;
        int n = wordNum;
        this.bits[n] = this.bits[n] | bitmask;
    }

    public boolean getAndSet(int index) {
        assert (index >= 0 && index < this.numBits) : "index=" + index + ", numBits=" + this.numBits;
        int wordNum = index >> 6;
        long bitmask = 1L << index;
        boolean val = (this.bits[wordNum] & bitmask) != 0L;
        int n = wordNum;
        this.bits[n] = this.bits[n] | bitmask;
        return val;
    }

    @Override
    public void clear(int index) {
        assert (index >= 0 && index < this.numBits) : "index=" + index + ", numBits=" + this.numBits;
        int wordNum = index >> 6;
        long bitmask = 1L << index;
        int n = wordNum;
        this.bits[n] = this.bits[n] & (bitmask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public boolean getAndClear(int index) {
        assert (index >= 0 && index < this.numBits) : "index=" + index + ", numBits=" + this.numBits;
        int wordNum = index >> 6;
        long bitmask = 1L << index;
        boolean val = (this.bits[wordNum] & bitmask) != 0L;
        int n = wordNum;
        this.bits[n] = this.bits[n] & (bitmask ^ 0xFFFFFFFFFFFFFFFFL);
        return val;
    }

    @Override
    public int nextSetBit(int index) {
        assert (index >= 0 && index < this.numBits) : "index=" + index + ", numBits=" + this.numBits;
        int i = index >> 6;
        long word = this.bits[i] >> index;
        if (word != 0L) {
            return index + Long.numberOfTrailingZeros(word);
        }
        while (++i < this.numWords) {
            word = this.bits[i];
            if (word == 0L) continue;
            return (i << 6) + Long.numberOfTrailingZeros(word);
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int prevSetBit(int index) {
        assert (index >= 0 && index < this.numBits) : "index=" + index + " numBits=" + this.numBits;
        int i = index >> 6;
        int subIndex = index & 0x3F;
        long word = this.bits[i] << 63 - subIndex;
        if (word != 0L) {
            return (i << 6) + subIndex - Long.numberOfLeadingZeros(word);
        }
        while (--i >= 0) {
            word = this.bits[i];
            if (word == 0L) continue;
            return (i << 6) + 63 - Long.numberOfLeadingZeros(word);
        }
        return -1;
    }

    @Override
    public void or(DocIdSetIterator iter2) throws IOException {
        if (BitSetIterator.getFixedBitSetOrNull(iter2) != null) {
            this.assertUnpositioned(iter2);
            FixedBitSet bits = BitSetIterator.getFixedBitSetOrNull(iter2);
            this.or(bits);
        } else {
            super.or(iter2);
        }
    }

    public void or(FixedBitSet other) {
        this.or(other.bits, other.numWords);
    }

    private void or(long[] otherArr, int otherNumWords) {
        assert (otherNumWords <= this.numWords) : "numWords=" + this.numWords + ", otherNumWords=" + otherNumWords;
        long[] thisArr = this.bits;
        int pos = Math.min(this.numWords, otherNumWords);
        while (--pos >= 0) {
            int n = pos;
            thisArr[n] = thisArr[n] | otherArr[pos];
        }
    }

    public void xor(FixedBitSet other) {
        this.xor(other.bits, other.numWords);
    }

    public void xor(DocIdSetIterator iter2) throws IOException {
        this.assertUnpositioned(iter2);
        if (BitSetIterator.getFixedBitSetOrNull(iter2) != null) {
            FixedBitSet bits = BitSetIterator.getFixedBitSetOrNull(iter2);
            this.xor(bits);
        } else {
            int doc;
            while ((doc = iter2.nextDoc()) < this.numBits) {
                this.flip(doc);
            }
        }
    }

    private void xor(long[] otherBits, int otherNumWords) {
        assert (otherNumWords <= this.numWords) : "numWords=" + this.numWords + ", other.numWords=" + otherNumWords;
        long[] thisBits = this.bits;
        int pos = Math.min(this.numWords, otherNumWords);
        while (--pos >= 0) {
            int n = pos;
            thisBits[n] = thisBits[n] ^ otherBits[pos];
        }
    }

    @Override
    public void and(DocIdSetIterator iter2) throws IOException {
        if (BitSetIterator.getFixedBitSetOrNull(iter2) != null) {
            this.assertUnpositioned(iter2);
            FixedBitSet bits = BitSetIterator.getFixedBitSetOrNull(iter2);
            this.and(bits);
        } else {
            super.and(iter2);
        }
    }

    public boolean intersects(FixedBitSet other) {
        int pos = Math.min(this.numWords, other.numWords);
        while (--pos >= 0) {
            if ((this.bits[pos] & other.bits[pos]) == 0L) continue;
            return true;
        }
        return false;
    }

    public void and(FixedBitSet other) {
        this.and(other.bits, other.numWords);
    }

    private void and(long[] otherArr, int otherNumWords) {
        long[] thisArr = this.bits;
        int pos = Math.min(this.numWords, otherNumWords);
        while (--pos >= 0) {
            int n = pos;
            thisArr[n] = thisArr[n] & otherArr[pos];
        }
        if (this.numWords > otherNumWords) {
            Arrays.fill(thisArr, otherNumWords, this.numWords, 0L);
        }
    }

    @Override
    public void andNot(DocIdSetIterator iter2) throws IOException {
        if (BitSetIterator.getFixedBitSetOrNull(iter2) != null) {
            this.assertUnpositioned(iter2);
            FixedBitSet bits = BitSetIterator.getFixedBitSetOrNull(iter2);
            this.andNot(bits);
        } else {
            super.andNot(iter2);
        }
    }

    public void andNot(FixedBitSet other) {
        this.andNot(other.bits, other.numWords);
    }

    private void andNot(long[] otherArr, int otherNumWords) {
        long[] thisArr = this.bits;
        int pos = Math.min(this.numWords, otherNumWords);
        while (--pos >= 0) {
            int n = pos;
            thisArr[n] = thisArr[n] & (otherArr[pos] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public boolean scanIsEmpty() {
        int count = this.numWords;
        for (int i = 0; i < count; ++i) {
            if (this.bits[i] == 0L) continue;
            return false;
        }
        return true;
    }

    public void flip(int startIndex, int endIndex) {
        assert (startIndex >= 0 && startIndex < this.numBits);
        assert (endIndex >= 0 && endIndex <= this.numBits);
        if (endIndex <= startIndex) {
            return;
        }
        int startWord = startIndex >> 6;
        int endWord = endIndex - 1 >> 6;
        long startmask = -1L << startIndex;
        long endmask = -1L >>> -endIndex;
        if (startWord == endWord) {
            int n = startWord;
            this.bits[n] = this.bits[n] ^ startmask & endmask;
            return;
        }
        int n = startWord;
        this.bits[n] = this.bits[n] ^ startmask;
        for (int i = startWord + 1; i < endWord; ++i) {
            this.bits[i] = this.bits[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        int n2 = endWord;
        this.bits[n2] = this.bits[n2] ^ endmask;
    }

    public void flip(int index) {
        assert (index >= 0 && index < this.numBits) : "index=" + index + " numBits=" + this.numBits;
        int wordNum = index >> 6;
        long bitmask = 1L << index;
        int n = wordNum;
        this.bits[n] = this.bits[n] ^ bitmask;
    }

    public void set(int startIndex, int endIndex) {
        assert (startIndex >= 0 && startIndex < this.numBits) : "startIndex=" + startIndex + ", numBits=" + this.numBits;
        assert (endIndex >= 0 && endIndex <= this.numBits) : "endIndex=" + endIndex + ", numBits=" + this.numBits;
        if (endIndex <= startIndex) {
            return;
        }
        int startWord = startIndex >> 6;
        int endWord = endIndex - 1 >> 6;
        long startmask = -1L << startIndex;
        long endmask = -1L >>> -endIndex;
        if (startWord == endWord) {
            int n = startWord;
            this.bits[n] = this.bits[n] | startmask & endmask;
            return;
        }
        int n = startWord;
        this.bits[n] = this.bits[n] | startmask;
        Arrays.fill(this.bits, startWord + 1, endWord, -1L);
        int n2 = endWord;
        this.bits[n2] = this.bits[n2] | endmask;
    }

    @Override
    public void clear(int startIndex, int endIndex) {
        assert (startIndex >= 0 && startIndex < this.numBits) : "startIndex=" + startIndex + ", numBits=" + this.numBits;
        assert (endIndex >= 0 && endIndex <= this.numBits) : "endIndex=" + endIndex + ", numBits=" + this.numBits;
        if (endIndex <= startIndex) {
            return;
        }
        int startWord = startIndex >> 6;
        int endWord = endIndex - 1 >> 6;
        long startmask = -1L << startIndex;
        long endmask = -1L >>> -endIndex;
        startmask ^= 0xFFFFFFFFFFFFFFFFL;
        endmask ^= 0xFFFFFFFFFFFFFFFFL;
        if (startWord == endWord) {
            int n = startWord;
            this.bits[n] = this.bits[n] & (startmask | endmask);
            return;
        }
        int n = startWord;
        this.bits[n] = this.bits[n] & startmask;
        Arrays.fill(this.bits, startWord + 1, endWord, 0L);
        int n2 = endWord;
        this.bits[n2] = this.bits[n2] & endmask;
    }

    public FixedBitSet clone() {
        long[] bits = new long[this.bits.length];
        System.arraycopy(this.bits, 0, bits, 0, this.numWords);
        return new FixedBitSet(bits, this.numBits);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FixedBitSet)) {
            return false;
        }
        FixedBitSet other = (FixedBitSet)o;
        if (this.numBits != other.numBits) {
            return false;
        }
        return Arrays.equals(this.bits, other.bits);
    }

    public int hashCode() {
        long h = 0L;
        int i = this.numWords;
        while (--i >= 0) {
            h ^= this.bits[i];
            h = h << 1 | h >>> 63;
        }
        return (int)(h >> 32 ^ h) + -1737092556;
    }
}

