/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.client.query;

import java.util.Iterator;
import org.openrdf.http.client.HTTPClient;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.impl.AbstractUpdate;

public abstract class AbstractHTTPUpdate
extends AbstractUpdate {
    private final HTTPClient httpClient;
    protected final QueryLanguage queryLanguage;
    protected final String queryString;
    protected final String baseURI;

    public AbstractHTTPUpdate(HTTPClient httpClient, QueryLanguage queryLanguage, String queryString, String baseURI) {
        this.httpClient = httpClient;
        this.queryLanguage = queryLanguage;
        this.queryString = queryString;
        this.baseURI = baseURI;
    }

    protected HTTPClient getHttpClient() {
        return this.httpClient;
    }

    public Binding[] getBindingsArray() {
        BindingSet bindings = this.getBindings();
        Binding[] bindingsArray = new Binding[bindings.size()];
        Iterator<Binding> iter2 = bindings.iterator();
        for (int i = 0; i < bindings.size(); ++i) {
            bindingsArray[i] = iter2.next();
        }
        return bindingsArray;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public QueryLanguage getQueryLanguage() {
        return this.queryLanguage;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String toString() {
        return this.queryString;
    }
}

