/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.model.impl;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import org.openrdf.model.Literal;
import org.openrdf.model.Model;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.UnmodifiableModel;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.util.ModelException;
import org.openrdf.model.util.ModelUtil;

public abstract class AbstractModel
extends AbstractSet<Statement>
implements Model {
    private static final long serialVersionUID = 4254119331281455614L;

    @Override
    public Model unmodifiable() {
        return new UnmodifiableModel(this);
    }

    @Override
    public boolean add(Statement st) {
        return this.add(st.getSubject(), st.getPredicate(), st.getObject(), st.getContext());
    }

    @Override
    public boolean isEmpty() {
        return !this.contains(null, null, null, new Resource[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> e = c.iterator();
        try {
            while (e.hasNext()) {
                if (this.contains(e.next())) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.closeIterator(c, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        if (this.size() > c.size()) {
            Iterator<?> i = c.iterator();
            try {
                while (i.hasNext()) {
                    modified |= this.remove(i.next());
                }
            }
            finally {
                this.closeIterator(c, i);
            }
        }
        Iterator i = this.iterator();
        try {
            while (i.hasNext()) {
                if (!c.contains(i.next())) continue;
                i.remove();
                modified = true;
            }
        }
        finally {
            this.closeIterator(i);
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        Iterator it = this.iterator();
        try {
            ArrayList r = new ArrayList(this.size());
            while (it.hasNext()) {
                r.add(it.next());
            }
            Object[] objectArray = r.toArray();
            return objectArray;
        }
        finally {
            this.closeIterator(it);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        Iterator it = this.iterator();
        try {
            ArrayList r = new ArrayList(this.size());
            while (it.hasNext()) {
                r.add(it.next());
            }
            T[] TArray = r.toArray(a);
            return TArray;
        }
        finally {
            this.closeIterator(it);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends Statement> c) {
        Iterator<? extends Statement> e = c.iterator();
        try {
            boolean modified = false;
            while (e.hasNext()) {
                if (!this.add(e.next())) continue;
                modified = true;
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            this.closeIterator(c, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        Iterator e = this.iterator();
        try {
            boolean modified = false;
            while (e.hasNext()) {
                if (c.contains(e.next())) continue;
                e.remove();
                modified = true;
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            this.closeIterator(e);
        }
    }

    @Override
    public void clear() {
        this.remove(null, null, null, new Resource[0]);
    }

    @Override
    public boolean clear(Resource ... contexts) {
        return this.remove(null, null, null, contexts);
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof Statement) {
            Statement st = (Statement)o;
            return this.remove(st.getSubject(), st.getPredicate(), st.getObject(), st.getContext());
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Statement) {
            Statement st = (Statement)o;
            return this.contains(st.getSubject(), st.getPredicate(), st.getObject(), st.getContext());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value objectValue() throws ModelException {
        Iterator<Value> iter2 = this.objects().iterator();
        try {
            if (iter2.hasNext()) {
                Value obj = iter2.next();
                if (iter2.hasNext()) {
                    throw new ModelException(obj, iter2.next());
                }
                Value value = obj;
                return value;
            }
            Value value = null;
            return value;
        }
        finally {
            this.closeIterator(iter2);
        }
    }

    @Override
    public Literal objectLiteral() throws ModelException {
        Value obj = this.objectValue();
        if (obj == null) {
            return null;
        }
        if (obj instanceof Literal) {
            return (Literal)obj;
        }
        throw new ModelException(obj);
    }

    @Override
    public Resource objectResource() throws ModelException {
        Value obj = this.objectValue();
        if (obj == null) {
            return null;
        }
        if (obj instanceof Resource) {
            return (Resource)obj;
        }
        throw new ModelException(obj);
    }

    @Override
    public URI objectURI() throws ModelException {
        Value obj = this.objectValue();
        if (obj == null) {
            return null;
        }
        if (obj instanceof URI) {
            return (URI)obj;
        }
        throw new ModelException(obj);
    }

    @Override
    public String objectString() throws ModelException {
        Value obj = this.objectValue();
        if (obj == null) {
            return null;
        }
        return obj.stringValue();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Model) {
            Model model = (Model)o;
            return ModelUtil.equals(this, model);
        }
        return false;
    }

    @Override
    public Set<Resource> subjects() {
        return new ValueSet<Resource>(){

            @Override
            public boolean contains(Object o) {
                if (o instanceof Resource) {
                    return AbstractModel.this.contains((Resource)o, null, null, new Resource[0]);
                }
                return false;
            }

            @Override
            public boolean remove(Object o) {
                if (o instanceof Resource) {
                    return AbstractModel.this.remove((Resource)o, null, null, new Resource[0]);
                }
                return false;
            }

            @Override
            public boolean add(Resource subj) {
                return AbstractModel.this.add(subj, null, null, new Resource[0]);
            }

            @Override
            protected Resource term(Statement st) {
                return st.getSubject();
            }

            @Override
            protected void removeIteration(Iterator<Statement> iter2, Resource subj) {
                AbstractModel.this.removeTermIteration(iter2, subj, null, null, new Resource[0]);
            }
        };
    }

    @Override
    public Set<URI> predicates() {
        return new ValueSet<URI>(){

            @Override
            public boolean contains(Object o) {
                if (o instanceof URI) {
                    return AbstractModel.this.contains(null, (URI)o, null, new Resource[0]);
                }
                return false;
            }

            @Override
            public boolean remove(Object o) {
                if (o instanceof URI) {
                    return AbstractModel.this.remove(null, (URI)o, null, new Resource[0]);
                }
                return false;
            }

            @Override
            public boolean add(URI pred) {
                return AbstractModel.this.add(null, pred, null, new Resource[0]);
            }

            @Override
            protected URI term(Statement st) {
                return st.getPredicate();
            }

            @Override
            protected void removeIteration(Iterator<Statement> iter2, URI pred) {
                AbstractModel.this.removeTermIteration(iter2, null, pred, null, new Resource[0]);
            }
        };
    }

    @Override
    public Set<Value> objects() {
        return new ValueSet<Value>(){

            @Override
            public boolean contains(Object o) {
                if (o instanceof Value) {
                    return AbstractModel.this.contains(null, null, (Value)o, new Resource[0]);
                }
                return false;
            }

            @Override
            public boolean remove(Object o) {
                if (o instanceof Value) {
                    return AbstractModel.this.remove(null, null, (Value)o, new Resource[0]);
                }
                return false;
            }

            @Override
            public boolean add(Value obj) {
                return AbstractModel.this.add(null, null, obj, new Resource[0]);
            }

            @Override
            protected Value term(Statement st) {
                return st.getObject();
            }

            @Override
            protected void removeIteration(Iterator<Statement> iter2, Value obj) {
                AbstractModel.this.removeTermIteration(iter2, null, null, obj, new Resource[0]);
            }
        };
    }

    @Override
    public Set<Resource> contexts() {
        return new ValueSet<Resource>(){

            @Override
            public boolean contains(Object o) {
                if (o instanceof Resource || o == null) {
                    return AbstractModel.this.contains(null, null, null, (Resource)o);
                }
                return false;
            }

            @Override
            public boolean remove(Object o) {
                if (o instanceof Resource || o == null) {
                    return AbstractModel.this.remove(null, null, null, (Resource)o);
                }
                return false;
            }

            @Override
            public boolean add(Resource context) {
                return AbstractModel.this.add(null, null, null, context);
            }

            @Override
            protected Resource term(Statement st) {
                return st.getContext();
            }

            @Override
            protected void removeIteration(Iterator<Statement> iter2, Resource term) {
                AbstractModel.this.removeTermIteration(iter2, null, null, null, term);
            }
        };
    }

    public abstract void removeTermIteration(Iterator<Statement> var1, Resource var2, URI var3, Value var4, Resource ... var5);

    protected void closeIterator(Iterator<?> iter2) {
        if (iter2 instanceof ValueSet.ValueSetIterator) {
            this.closeIterator(((ValueSet.ValueSetIterator)iter2).iter);
        }
    }

    private void closeIterator(Collection<?> c, Iterator<?> e) {
        if (c instanceof AbstractModel) {
            ((AbstractModel)c).closeIterator(e);
        } else if (c instanceof ValueSet) {
            ((ValueSet)c).closeIterator(e);
        }
    }

    @Override
    @Deprecated
    public Iterator<Statement> match(Resource subj, URI pred, Value obj, Resource ... contexts) {
        return this.filter(subj, pred, obj, contexts).iterator();
    }

    @Override
    @Deprecated
    public ValueFactory getValueFactory() {
        return ValueFactoryImpl.getInstance();
    }

    private abstract class ValueSet<V extends Value>
    extends AbstractSet<V> {
        private ValueSet() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueSetIterator(AbstractModel.this.iterator());
        }

        @Override
        public void clear() {
            AbstractModel.this.clear();
        }

        @Override
        public boolean isEmpty() {
            return AbstractModel.this.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Iterator iter2 = AbstractModel.this.iterator();
            try {
                LinkedHashSet<V> set = new LinkedHashSet<V>();
                while (iter2.hasNext()) {
                    set.add(this.term((Statement)iter2.next()));
                }
                int n = set.size();
                return n;
            }
            finally {
                AbstractModel.this.closeIterator(iter2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> c) {
            boolean modified = false;
            Iterator<?> i = c.iterator();
            try {
                while (i.hasNext()) {
                    modified |= this.remove(i.next());
                }
            }
            finally {
                this.closeIterator(c, i);
            }
            return modified;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Iterator iter2 = AbstractModel.this.iterator();
            try {
                LinkedHashSet<V> set = new LinkedHashSet<V>();
                while (iter2.hasNext()) {
                    set.add(this.term((Statement)iter2.next()));
                }
                Object[] objectArray = set.toArray();
                return objectArray;
            }
            finally {
                AbstractModel.this.closeIterator(iter2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            Iterator iter2 = AbstractModel.this.iterator();
            try {
                LinkedHashSet<V> set = new LinkedHashSet<V>();
                while (iter2.hasNext()) {
                    set.add(this.term((Statement)iter2.next()));
                }
                T[] TArray = set.toArray(a);
                return TArray;
            }
            finally {
                AbstractModel.this.closeIterator(iter2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsAll(Collection<?> c) {
            Iterator<?> e = c.iterator();
            try {
                while (e.hasNext()) {
                    if (this.contains(e.next())) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.closeIterator(c, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends V> c) {
            Iterator<V> e = c.iterator();
            try {
                boolean modified = false;
                while (e.hasNext()) {
                    if (!this.add((V)((Value)e.next()))) continue;
                    modified = true;
                }
                boolean bl = modified;
                return bl;
            }
            finally {
                this.closeIterator(c, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> c) {
            Iterator<V> e = this.iterator();
            try {
                boolean modified = false;
                while (e.hasNext()) {
                    if (c.contains(e.next())) continue;
                    e.remove();
                    modified = true;
                }
                boolean bl = modified;
                return bl;
            }
            finally {
                this.closeIterator(e);
            }
        }

        @Override
        public abstract boolean add(V var1);

        protected abstract V term(Statement var1);

        protected abstract void removeIteration(Iterator<Statement> var1, V var2);

        protected void closeIterator(Iterator<?> iter2) {
            AbstractModel.this.closeIterator(((ValueSetIterator)iter2).iter);
        }

        private void closeIterator(Collection<?> c, Iterator<?> e) {
            if (c instanceof AbstractModel) {
                ((AbstractModel)c).closeIterator(e);
            } else if (c instanceof ValueSet) {
                ((ValueSet)c).closeIterator(e);
            }
        }

        private final class ValueSetIterator
        implements Iterator<V> {
            private final Iterator<Statement> iter;
            private final Set<V> set = new LinkedHashSet();
            private Statement current;
            private Statement next;

            private ValueSetIterator(Iterator<Statement> iter2) {
                this.iter = iter2;
            }

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    this.next = this.findNext();
                }
                return this.next != null;
            }

            @Override
            public V next() {
                if (this.next == null) {
                    this.next = this.findNext();
                    if (this.next == null) {
                        throw new NoSuchElementException();
                    }
                }
                this.current = this.next;
                this.next = null;
                Object value = ValueSet.this.term(this.current);
                this.set.add(value);
                return value;
            }

            @Override
            public void remove() {
                if (this.current == null) {
                    throw new IllegalStateException();
                }
                ValueSet.this.removeIteration(this.iter, ValueSet.this.term(this.current));
                this.current = null;
            }

            private Statement findNext() {
                while (this.iter.hasNext()) {
                    Statement st = this.iter.next();
                    if (!this.accept(st)) continue;
                    return st;
                }
                return null;
            }

            private boolean accept(Statement st) {
                return !this.set.contains(ValueSet.this.term(st));
            }
        }
    }
}

