/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.impl;

import java.util.List;
import org.openrdf.model.Value;
import org.openrdf.model.impl.BooleanLiteralImpl;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.And;
import org.openrdf.query.algebra.BinaryValueOperator;
import org.openrdf.query.algebra.Bound;
import org.openrdf.query.algebra.FunctionCall;
import org.openrdf.query.algebra.If;
import org.openrdf.query.algebra.Or;
import org.openrdf.query.algebra.Regex;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.UnaryValueOperator;
import org.openrdf.query.algebra.ValueConstant;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.evaluation.EvaluationStrategy;
import org.openrdf.query.algebra.evaluation.QueryOptimizer;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;
import org.openrdf.query.algebra.evaluation.function.Function;
import org.openrdf.query.algebra.evaluation.function.FunctionRegistry;
import org.openrdf.query.algebra.evaluation.function.numeric.Rand;
import org.openrdf.query.algebra.evaluation.function.rdfterm.STRUUID;
import org.openrdf.query.algebra.evaluation.function.rdfterm.UUID;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;
import org.openrdf.query.impl.EmptyBindingSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstantOptimizer
implements QueryOptimizer {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final EvaluationStrategy strategy;

    public ConstantOptimizer(EvaluationStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        tupleExpr.visit(new ConstantVisitor());
    }

    protected class ConstantVisitor
    extends QueryModelVisitorBase<RuntimeException> {
        protected ConstantVisitor() {
        }

        @Override
        public void meet(Or or) {
            or.visitChildren(this);
            try {
                if (this.isConstant(or.getLeftArg()) && this.isConstant(or.getRightArg())) {
                    boolean value = ConstantOptimizer.this.strategy.isTrue(or, EmptyBindingSet.getInstance());
                    or.replaceWith(new ValueConstant(BooleanLiteralImpl.valueOf(value)));
                } else if (this.isConstant(or.getLeftArg())) {
                    boolean leftIsTrue = ConstantOptimizer.this.strategy.isTrue(or.getLeftArg(), EmptyBindingSet.getInstance());
                    if (leftIsTrue) {
                        or.replaceWith(new ValueConstant(BooleanLiteralImpl.TRUE));
                    } else {
                        or.replaceWith(or.getRightArg());
                    }
                } else if (this.isConstant(or.getRightArg())) {
                    boolean rightIsTrue = ConstantOptimizer.this.strategy.isTrue(or.getRightArg(), EmptyBindingSet.getInstance());
                    if (rightIsTrue) {
                        or.replaceWith(new ValueConstant(BooleanLiteralImpl.TRUE));
                    } else {
                        or.replaceWith(or.getLeftArg());
                    }
                }
            }
            catch (ValueExprEvaluationException e) {
                ConstantOptimizer.this.logger.debug("Failed to evaluate BinaryValueOperator with two constant arguments", e);
            }
            catch (QueryEvaluationException e) {
                ConstantOptimizer.this.logger.error("Query evaluation exception caught", e);
            }
        }

        @Override
        public void meet(And and) {
            and.visitChildren(this);
            try {
                if (this.isConstant(and.getLeftArg()) && this.isConstant(and.getRightArg())) {
                    boolean value = ConstantOptimizer.this.strategy.isTrue(and, EmptyBindingSet.getInstance());
                    and.replaceWith(new ValueConstant(BooleanLiteralImpl.valueOf(value)));
                } else if (this.isConstant(and.getLeftArg())) {
                    boolean leftIsTrue = ConstantOptimizer.this.strategy.isTrue(and.getLeftArg(), EmptyBindingSet.getInstance());
                    if (leftIsTrue) {
                        and.replaceWith(and.getRightArg());
                    } else {
                        and.replaceWith(new ValueConstant(BooleanLiteralImpl.FALSE));
                    }
                } else if (this.isConstant(and.getRightArg())) {
                    boolean rightIsTrue = ConstantOptimizer.this.strategy.isTrue(and.getRightArg(), EmptyBindingSet.getInstance());
                    if (rightIsTrue) {
                        and.replaceWith(and.getLeftArg());
                    } else {
                        and.replaceWith(new ValueConstant(BooleanLiteralImpl.FALSE));
                    }
                }
            }
            catch (ValueExprEvaluationException e) {
                ConstantOptimizer.this.logger.debug("Failed to evaluate BinaryValueOperator with two constant arguments", e);
            }
            catch (QueryEvaluationException e) {
                ConstantOptimizer.this.logger.error("Query evaluation exception caught", e);
            }
        }

        @Override
        protected void meetBinaryValueOperator(BinaryValueOperator binaryValueOp) {
            super.meetBinaryValueOperator(binaryValueOp);
            if (this.isConstant(binaryValueOp.getLeftArg()) && this.isConstant(binaryValueOp.getRightArg())) {
                try {
                    Value value = ConstantOptimizer.this.strategy.evaluate(binaryValueOp, EmptyBindingSet.getInstance());
                    binaryValueOp.replaceWith(new ValueConstant(value));
                }
                catch (ValueExprEvaluationException e) {
                    ConstantOptimizer.this.logger.debug("Failed to evaluate BinaryValueOperator with two constant arguments", e);
                }
                catch (QueryEvaluationException e) {
                    ConstantOptimizer.this.logger.error("Query evaluation exception caught", e);
                }
            }
        }

        @Override
        protected void meetUnaryValueOperator(UnaryValueOperator unaryValueOp) {
            super.meetUnaryValueOperator(unaryValueOp);
            if (this.isConstant(unaryValueOp.getArg())) {
                try {
                    Value value = ConstantOptimizer.this.strategy.evaluate(unaryValueOp, EmptyBindingSet.getInstance());
                    unaryValueOp.replaceWith(new ValueConstant(value));
                }
                catch (ValueExprEvaluationException e) {
                    ConstantOptimizer.this.logger.debug("Failed to evaluate UnaryValueOperator with a constant argument", e);
                }
                catch (QueryEvaluationException e) {
                    ConstantOptimizer.this.logger.error("Query evaluation exception caught", e);
                }
            }
        }

        @Override
        public void meet(FunctionCall functionCall) {
            super.meet(functionCall);
            List<ValueExpr> args = functionCall.getArgs();
            if (args.size() == 0) {
                if (!this.isConstantZeroArgFunction(functionCall)) {
                    return;
                }
            } else {
                for (ValueExpr arg : args) {
                    if (this.isConstant(arg)) continue;
                    return;
                }
            }
            try {
                Value value = ConstantOptimizer.this.strategy.evaluate(functionCall, EmptyBindingSet.getInstance());
                functionCall.replaceWith(new ValueConstant(value));
            }
            catch (ValueExprEvaluationException e) {
                ConstantOptimizer.this.logger.debug("Failed to evaluate BinaryValueOperator with two constant arguments", e);
            }
            catch (QueryEvaluationException e) {
                ConstantOptimizer.this.logger.error("Query evaluation exception caught", e);
            }
        }

        private boolean isConstantZeroArgFunction(FunctionCall functionCall) {
            Function function = (Function)FunctionRegistry.getInstance().get(functionCall.getURI());
            return !(function instanceof Rand) && !(function instanceof UUID) && !(function instanceof STRUUID);
        }

        @Override
        public void meet(Bound bound) {
            super.meet(bound);
            if (bound.getArg().hasValue()) {
                bound.replaceWith(new ValueConstant(BooleanLiteralImpl.TRUE));
            }
        }

        @Override
        public void meet(If node) {
            super.meet(node);
            if (this.isConstant(node.getCondition())) {
                try {
                    if (ConstantOptimizer.this.strategy.isTrue(node.getCondition(), EmptyBindingSet.getInstance())) {
                        node.replaceWith(node.getResult());
                    } else {
                        node.replaceWith(node.getAlternative());
                    }
                }
                catch (ValueExprEvaluationException e) {
                    ConstantOptimizer.this.logger.debug("Failed to evaluate UnaryValueOperator with a constant argument", e);
                }
                catch (QueryEvaluationException e) {
                    ConstantOptimizer.this.logger.error("Query evaluation exception caught", e);
                }
            }
        }

        @Override
        public void meet(Regex node) {
            super.meetNode(node);
            if (this.isConstant(node.getArg()) && this.isConstant(node.getPatternArg()) && this.isConstant(node.getFlagsArg())) {
                try {
                    Value value = ConstantOptimizer.this.strategy.evaluate(node, EmptyBindingSet.getInstance());
                    node.replaceWith(new ValueConstant(value));
                }
                catch (ValueExprEvaluationException e) {
                    ConstantOptimizer.this.logger.debug("Failed to evaluate BinaryValueOperator with two constant arguments", e);
                }
                catch (QueryEvaluationException e) {
                    ConstantOptimizer.this.logger.error("Query evaluation exception caught", e);
                }
            }
        }

        private boolean isConstant(ValueExpr expr) {
            return expr instanceof ValueConstant || expr instanceof Var && ((Var)expr).hasValue();
        }
    }
}

