/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.limited;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.DelayedIteration;
import info.aduna.iteration.Iteration;
import java.util.concurrent.atomic.AtomicLong;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.ArbitraryLengthPath;
import org.openrdf.query.algebra.Difference;
import org.openrdf.query.algebra.Distinct;
import org.openrdf.query.algebra.Intersection;
import org.openrdf.query.algebra.Join;
import org.openrdf.query.algebra.Order;
import org.openrdf.query.algebra.Service;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.evaluation.TripleSource;
import org.openrdf.query.algebra.evaluation.federation.ServiceJoinIterator;
import org.openrdf.query.algebra.evaluation.impl.EvaluationStrategyImpl;
import org.openrdf.query.algebra.evaluation.iterator.JoinIterator;
import org.openrdf.query.algebra.evaluation.iterator.ZeroLengthPathIteration;
import org.openrdf.query.algebra.evaluation.limited.iterator.LimitedSizeBottomUpJoinIterator;
import org.openrdf.query.algebra.evaluation.limited.iterator.LimitedSizeDistinctIteration;
import org.openrdf.query.algebra.evaluation.limited.iterator.LimitedSizeIntersectIteration;
import org.openrdf.query.algebra.evaluation.limited.iterator.LimitedSizeOrderIteration;
import org.openrdf.query.algebra.evaluation.limited.iterator.LimitedSizePathIterator;
import org.openrdf.query.algebra.evaluation.limited.iterator.LimitedSizeSPARQLMinusIteration;
import org.openrdf.query.algebra.evaluation.limited.iterator.LimitedSizeZeroLengthPathIteration;
import org.openrdf.query.algebra.evaluation.util.OrderComparator;
import org.openrdf.query.algebra.evaluation.util.ValueComparator;

public class LimitedSizeEvaluationStrategy
extends EvaluationStrategyImpl {
    private final AtomicLong used = new AtomicLong();
    private long maxSize;

    public LimitedSizeEvaluationStrategy(TripleSource tripleSource, long maxSize) {
        super(tripleSource);
        this.maxSize = maxSize;
    }

    public LimitedSizeEvaluationStrategy(TripleSource tripleSource, Dataset dataset, int maxCollectionsSize) {
        super(tripleSource, dataset);
        this.maxSize = maxCollectionsSize;
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Distinct distinct, BindingSet bindings) throws QueryEvaluationException {
        return new LimitedSizeDistinctIteration(this.evaluate(distinct.getArg(), bindings), this.used, this.maxSize);
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(final Difference difference, final BindingSet bindings) throws QueryEvaluationException {
        DelayedIteration<BindingSet, QueryEvaluationException> leftArg = new DelayedIteration<BindingSet, QueryEvaluationException>(){

            @Override
            protected Iteration<BindingSet, QueryEvaluationException> createIteration() throws QueryEvaluationException {
                return LimitedSizeEvaluationStrategy.this.evaluate(difference.getLeftArg(), bindings);
            }
        };
        DelayedIteration<BindingSet, QueryEvaluationException> rightArg = new DelayedIteration<BindingSet, QueryEvaluationException>(){

            @Override
            protected Iteration<BindingSet, QueryEvaluationException> createIteration() throws QueryEvaluationException {
                return LimitedSizeEvaluationStrategy.this.evaluate(difference.getRightArg(), bindings);
            }
        };
        return new LimitedSizeSPARQLMinusIteration((Iteration<BindingSet, QueryEvaluationException>)leftArg, (Iteration<BindingSet, QueryEvaluationException>)rightArg, this.used, this.maxSize);
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(final Intersection intersection, final BindingSet bindings) throws QueryEvaluationException {
        DelayedIteration<BindingSet, QueryEvaluationException> leftArg = new DelayedIteration<BindingSet, QueryEvaluationException>(){

            @Override
            protected Iteration<BindingSet, QueryEvaluationException> createIteration() throws QueryEvaluationException {
                return LimitedSizeEvaluationStrategy.this.evaluate(intersection.getLeftArg(), bindings);
            }
        };
        DelayedIteration<BindingSet, QueryEvaluationException> rightArg = new DelayedIteration<BindingSet, QueryEvaluationException>(){

            @Override
            protected Iteration<BindingSet, QueryEvaluationException> createIteration() throws QueryEvaluationException {
                return LimitedSizeEvaluationStrategy.this.evaluate(intersection.getRightArg(), bindings);
            }
        };
        return new LimitedSizeIntersectIteration((Iteration<? extends BindingSet, ? extends QueryEvaluationException>)leftArg, (Iteration<? extends BindingSet, ? extends QueryEvaluationException>)rightArg, this.used, this.maxSize);
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Join join, BindingSet bindings) throws QueryEvaluationException {
        if (join.getRightArg() instanceof Service) {
            CloseableIteration<BindingSet, QueryEvaluationException> leftIter = this.evaluate(join.getLeftArg(), bindings);
            return new ServiceJoinIterator(leftIter, (Service)join.getRightArg(), bindings, this);
        }
        if (join.hasSubSelectInRightArg()) {
            return new LimitedSizeBottomUpJoinIterator(this, join, bindings, this.used, this.maxSize);
        }
        return new JoinIterator(this, join, bindings);
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(ArbitraryLengthPath alp, BindingSet bindings) throws QueryEvaluationException {
        StatementPattern.Scope scope = alp.getScope();
        Var subjectVar = alp.getSubjectVar();
        TupleExpr pathExpression = alp.getPathExpression();
        Var objVar = alp.getObjectVar();
        Var contextVar = alp.getContextVar();
        long minLength = alp.getMinLength();
        return new LimitedSizePathIterator(this, scope, subjectVar, pathExpression, objVar, contextVar, minLength, bindings, this.used, this.maxSize);
    }

    @Override
    protected ZeroLengthPathIteration getZeroLengthPathIterator(BindingSet bindings, Var subjectVar, Var objVar, Var contextVar, Value subj, Value obj) {
        return new LimitedSizeZeroLengthPathIteration(this, subjectVar, objVar, subj, obj, contextVar, bindings, this.used, this.maxSize);
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Order node, BindingSet bindings) throws QueryEvaluationException {
        ValueComparator vcmp = new ValueComparator();
        OrderComparator cmp = new OrderComparator(this, node, vcmp);
        boolean reduced = this.isReducedOrDistinct(node);
        long limit = this.getLimit(node);
        return new LimitedSizeOrderIteration(this.evaluate(node.getArg(), bindings), cmp, limit, reduced, this.used, this.maxSize);
    }
}

