/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.limited.iterator;

import info.aduna.iteration.Iteration;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;

public class LimitedSizeIteratorUtil {
    public static Set<BindingSet> addAll(Iteration<? extends BindingSet, ? extends QueryEvaluationException> arg2, Set<BindingSet> includeSet, AtomicLong used, long maxSize) throws QueryEvaluationException {
        while (arg2.hasNext()) {
            if (!includeSet.add(arg2.next()) || used.incrementAndGet() <= maxSize) continue;
            throw new QueryEvaluationException("Size limited reached inside intersect operator");
        }
        return includeSet;
    }

    public static <V> boolean add(V object, Collection<V> excludeSet, AtomicLong used, long maxSize) throws QueryEvaluationException {
        boolean add = excludeSet.add(object);
        if (add && used.incrementAndGet() > maxSize) {
            throw new QueryEvaluationException("Size limited reached inside query operator.");
        }
        return add;
    }
}

