/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.limited.iterator;

import info.aduna.iteration.CloseableIteration;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.atomic.AtomicLong;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.evaluation.iterator.OrderIterator;
import org.openrdf.query.algebra.evaluation.limited.iterator.LimitedSizeIteratorUtil;

public class LimitedSizeOrderIteration
extends OrderIterator {
    private final AtomicLong used;
    private final long maxSize;

    public LimitedSizeOrderIteration(CloseableIteration<BindingSet, QueryEvaluationException> iter2, Comparator<BindingSet> comparator, AtomicLong used, long maxSize) {
        this(iter2, comparator, Integer.MAX_VALUE, false, used, maxSize);
    }

    public LimitedSizeOrderIteration(CloseableIteration<BindingSet, QueryEvaluationException> iter2, Comparator<BindingSet> comparator, long limit, boolean distinct, AtomicLong used, long maxSize) {
        super(iter2, comparator, limit, distinct);
        this.used = used;
        this.maxSize = maxSize;
    }

    @Override
    protected void removeLast(Collection<BindingSet> lastResults) {
        super.removeLast(lastResults);
        this.used.decrementAndGet();
    }

    @Override
    protected Collection<BindingSet> remove(NavigableMap<BindingSet, Collection<BindingSet>> map, BindingSet lastKey) {
        Collection col = (Collection)map.get(lastKey);
        col.remove(lastKey);
        this.used.addAndGet(-(col.size() + 1));
        return col;
    }

    @Override
    protected boolean add(BindingSet next, Collection<BindingSet> list) throws QueryEvaluationException {
        return LimitedSizeIteratorUtil.add(next, list, this.used, this.maxSize);
    }

    @Override
    protected Collection<BindingSet> put(Map<BindingSet, Collection<BindingSet>> map, BindingSet next, Collection<BindingSet> list) throws QueryEvaluationException {
        Collection<BindingSet> put = super.put(map, next, list);
        if (put != null && this.used.incrementAndGet() > this.maxSize) {
            throw new QueryEvaluationException("Size limited reached inside order operator query, max size is:" + this.maxSize);
        }
        return put;
    }
}

