/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.impl;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.openrdf.model.Value;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.impl.BindingImpl;

public class ListBindingSet
implements BindingSet {
    private static final long serialVersionUID = -2907809218835403743L;
    private final List<String> bindingNames;
    private final List<? extends Value> values;

    public ListBindingSet(List<String> names, Value ... values) {
        this(names, Arrays.asList(values));
    }

    public ListBindingSet(List<String> bindingNames, List<? extends Value> values) {
        assert (bindingNames.size() == values.size()) : "number of binding names and values not equal";
        this.bindingNames = bindingNames;
        this.values = values;
    }

    @Override
    public Set<String> getBindingNames() {
        return new LinkedHashSet<String>(this.bindingNames);
    }

    @Override
    public Value getValue(String bindingName) {
        int idx = this.bindingNames.indexOf(bindingName);
        if (idx != -1) {
            return this.values.get(idx);
        }
        return null;
    }

    @Override
    public Binding getBinding(String bindingName) {
        Value value = this.getValue(bindingName);
        if (value != null) {
            return new BindingImpl(bindingName, value);
        }
        return null;
    }

    @Override
    public boolean hasBinding(String bindingName) {
        return this.getValue(bindingName) != null;
    }

    @Override
    public Iterator<Binding> iterator() {
        return new ListBindingSetIterator();
    }

    @Override
    public int size() {
        int size = 0;
        for (Value value : this.values) {
            if (value == null) continue;
            ++size;
        }
        return size;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof BindingSet) {
            int otherSize = 0;
            for (Binding binding : (BindingSet)other) {
                Value value = this.getValue(binding.getName());
                if (!binding.getValue().equals(value)) {
                    return false;
                }
                ++otherSize;
            }
            int thisSize = 0;
            for (Value value : this.values) {
                if (value == null) continue;
                ++thisSize;
            }
            return thisSize == otherSize;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        for (Binding binding : this) {
            hashCode ^= binding.hashCode();
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32 * this.size());
        sb.append('[');
        Iterator<Binding> iter2 = this.iterator();
        while (iter2.hasNext()) {
            sb.append(iter2.next().toString());
            if (!iter2.hasNext()) continue;
            sb.append(';');
        }
        sb.append(']');
        return sb.toString();
    }

    private class ListBindingSetIterator
    implements Iterator<Binding> {
        private int index = -1;

        public ListBindingSetIterator() {
            this.findNextElement();
        }

        private void findNextElement() {
            ++this.index;
            while (this.index < ListBindingSet.this.values.size() && ListBindingSet.this.values.get(this.index) == null) {
                ++this.index;
            }
        }

        @Override
        public boolean hasNext() {
            return this.index < ListBindingSet.this.values.size();
        }

        @Override
        public Binding next() {
            BindingImpl result = new BindingImpl((String)ListBindingSet.this.bindingNames.get(this.index), (Value)ListBindingSet.this.values.get(this.index));
            this.findNextElement();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

