/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.impl;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.Value;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.impl.BindingImpl;

public class MapBindingSet
implements BindingSet {
    private static final long serialVersionUID = -8857324525220429607L;
    private final Map<String, Binding> bindings;

    public MapBindingSet() {
        this(8);
    }

    public MapBindingSet(int capacity) {
        this.bindings = new LinkedHashMap<String, Binding>(capacity * 2);
    }

    public void addBinding(String name, Value value) {
        this.addBinding(new BindingImpl(name, value));
    }

    public void addBinding(Binding binding) {
        this.bindings.put(binding.getName(), binding);
    }

    public void removeBinding(String name) {
        this.bindings.remove(name);
    }

    public void clear() {
        this.bindings.clear();
    }

    @Override
    public Iterator<Binding> iterator() {
        return this.bindings.values().iterator();
    }

    @Override
    public Set<String> getBindingNames() {
        return this.bindings.keySet();
    }

    @Override
    public Binding getBinding(String bindingName) {
        return this.bindings.get(bindingName);
    }

    @Override
    public boolean hasBinding(String bindingName) {
        return this.bindings.containsKey(bindingName);
    }

    @Override
    public Value getValue(String bindingName) {
        Binding binding = this.getBinding(bindingName);
        if (binding != null) {
            return binding.getValue();
        }
        return null;
    }

    @Override
    public int size() {
        return this.bindings.size();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof BindingSet) {
            int otherSize = 0;
            for (Binding binding : (BindingSet)other) {
                Value ownValue = this.getValue(binding.getName());
                if (!binding.getValue().equals(ownValue)) {
                    return false;
                }
                ++otherSize;
            }
            return otherSize == this.bindings.size();
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        for (Binding binding : this) {
            hashCode ^= binding.hashCode();
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32 * this.size());
        sb.append('[');
        Iterator<Binding> iter2 = this.iterator();
        while (iter2.hasNext()) {
            sb.append(iter2.next().toString());
            if (!iter2.hasNext()) continue;
            sb.append(';');
        }
        sb.append(']');
        return sb.toString();
    }
}

