/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.parser.sparql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.BooleanLiteralImpl;
import org.openrdf.model.vocabulary.FN;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.query.BindingSet;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.algebra.AggregateOperator;
import org.openrdf.query.algebra.And;
import org.openrdf.query.algebra.ArbitraryLengthPath;
import org.openrdf.query.algebra.Avg;
import org.openrdf.query.algebra.BNodeGenerator;
import org.openrdf.query.algebra.BinaryValueOperator;
import org.openrdf.query.algebra.BindingSetAssignment;
import org.openrdf.query.algebra.Bound;
import org.openrdf.query.algebra.Coalesce;
import org.openrdf.query.algebra.Compare;
import org.openrdf.query.algebra.Count;
import org.openrdf.query.algebra.Datatype;
import org.openrdf.query.algebra.DescribeOperator;
import org.openrdf.query.algebra.Difference;
import org.openrdf.query.algebra.Distinct;
import org.openrdf.query.algebra.EmptySet;
import org.openrdf.query.algebra.Exists;
import org.openrdf.query.algebra.Extension;
import org.openrdf.query.algebra.ExtensionElem;
import org.openrdf.query.algebra.Filter;
import org.openrdf.query.algebra.FunctionCall;
import org.openrdf.query.algebra.Group;
import org.openrdf.query.algebra.GroupConcat;
import org.openrdf.query.algebra.GroupElem;
import org.openrdf.query.algebra.IRIFunction;
import org.openrdf.query.algebra.If;
import org.openrdf.query.algebra.IsBNode;
import org.openrdf.query.algebra.IsLiteral;
import org.openrdf.query.algebra.IsNumeric;
import org.openrdf.query.algebra.IsURI;
import org.openrdf.query.algebra.Join;
import org.openrdf.query.algebra.Lang;
import org.openrdf.query.algebra.LangMatches;
import org.openrdf.query.algebra.ListMemberOperator;
import org.openrdf.query.algebra.MathExpr;
import org.openrdf.query.algebra.Max;
import org.openrdf.query.algebra.Min;
import org.openrdf.query.algebra.MultiProjection;
import org.openrdf.query.algebra.Not;
import org.openrdf.query.algebra.Or;
import org.openrdf.query.algebra.Order;
import org.openrdf.query.algebra.OrderElem;
import org.openrdf.query.algebra.Projection;
import org.openrdf.query.algebra.ProjectionElem;
import org.openrdf.query.algebra.ProjectionElemList;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.QueryModelNodeBase;
import org.openrdf.query.algebra.Reduced;
import org.openrdf.query.algebra.Regex;
import org.openrdf.query.algebra.SameTerm;
import org.openrdf.query.algebra.Sample;
import org.openrdf.query.algebra.Service;
import org.openrdf.query.algebra.SingletonSet;
import org.openrdf.query.algebra.Slice;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.Str;
import org.openrdf.query.algebra.Sum;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.Union;
import org.openrdf.query.algebra.ValueConstant;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.ZeroLengthPath;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;
import org.openrdf.query.algebra.helpers.StatementPatternCollector;
import org.openrdf.query.impl.ListBindingSet;
import org.openrdf.query.parser.sparql.ASTVisitorBase;
import org.openrdf.query.parser.sparql.ConstructorBuilder;
import org.openrdf.query.parser.sparql.GraphPattern;
import org.openrdf.query.parser.sparql.NegatedPropertySet;
import org.openrdf.query.parser.sparql.PropertySetElem;
import org.openrdf.query.parser.sparql.ast.ASTAbs;
import org.openrdf.query.parser.sparql.ast.ASTAnd;
import org.openrdf.query.parser.sparql.ast.ASTAskQuery;
import org.openrdf.query.parser.sparql.ast.ASTAvg;
import org.openrdf.query.parser.sparql.ast.ASTBNodeFunc;
import org.openrdf.query.parser.sparql.ast.ASTBind;
import org.openrdf.query.parser.sparql.ast.ASTBindingSet;
import org.openrdf.query.parser.sparql.ast.ASTBindingValue;
import org.openrdf.query.parser.sparql.ast.ASTBindingsClause;
import org.openrdf.query.parser.sparql.ast.ASTBlankNode;
import org.openrdf.query.parser.sparql.ast.ASTBlankNodePropertyList;
import org.openrdf.query.parser.sparql.ast.ASTBound;
import org.openrdf.query.parser.sparql.ast.ASTCeil;
import org.openrdf.query.parser.sparql.ast.ASTCoalesce;
import org.openrdf.query.parser.sparql.ast.ASTCollection;
import org.openrdf.query.parser.sparql.ast.ASTCompare;
import org.openrdf.query.parser.sparql.ast.ASTConcat;
import org.openrdf.query.parser.sparql.ast.ASTConstraint;
import org.openrdf.query.parser.sparql.ast.ASTConstruct;
import org.openrdf.query.parser.sparql.ast.ASTConstructQuery;
import org.openrdf.query.parser.sparql.ast.ASTContains;
import org.openrdf.query.parser.sparql.ast.ASTCount;
import org.openrdf.query.parser.sparql.ast.ASTDatatype;
import org.openrdf.query.parser.sparql.ast.ASTDay;
import org.openrdf.query.parser.sparql.ast.ASTDescribe;
import org.openrdf.query.parser.sparql.ast.ASTDescribeQuery;
import org.openrdf.query.parser.sparql.ast.ASTEncodeForURI;
import org.openrdf.query.parser.sparql.ast.ASTExistsFunc;
import org.openrdf.query.parser.sparql.ast.ASTFalse;
import org.openrdf.query.parser.sparql.ast.ASTFloor;
import org.openrdf.query.parser.sparql.ast.ASTFunctionCall;
import org.openrdf.query.parser.sparql.ast.ASTGraphGraphPattern;
import org.openrdf.query.parser.sparql.ast.ASTGraphPatternGroup;
import org.openrdf.query.parser.sparql.ast.ASTGroupClause;
import org.openrdf.query.parser.sparql.ast.ASTGroupConcat;
import org.openrdf.query.parser.sparql.ast.ASTGroupCondition;
import org.openrdf.query.parser.sparql.ast.ASTHavingClause;
import org.openrdf.query.parser.sparql.ast.ASTHours;
import org.openrdf.query.parser.sparql.ast.ASTIRI;
import org.openrdf.query.parser.sparql.ast.ASTIRIFunc;
import org.openrdf.query.parser.sparql.ast.ASTIf;
import org.openrdf.query.parser.sparql.ast.ASTIn;
import org.openrdf.query.parser.sparql.ast.ASTInfix;
import org.openrdf.query.parser.sparql.ast.ASTInlineData;
import org.openrdf.query.parser.sparql.ast.ASTIsBlank;
import org.openrdf.query.parser.sparql.ast.ASTIsIRI;
import org.openrdf.query.parser.sparql.ast.ASTIsLiteral;
import org.openrdf.query.parser.sparql.ast.ASTIsNumeric;
import org.openrdf.query.parser.sparql.ast.ASTLang;
import org.openrdf.query.parser.sparql.ast.ASTLangMatches;
import org.openrdf.query.parser.sparql.ast.ASTLimit;
import org.openrdf.query.parser.sparql.ast.ASTLowerCase;
import org.openrdf.query.parser.sparql.ast.ASTMD5;
import org.openrdf.query.parser.sparql.ast.ASTMath;
import org.openrdf.query.parser.sparql.ast.ASTMax;
import org.openrdf.query.parser.sparql.ast.ASTMin;
import org.openrdf.query.parser.sparql.ast.ASTMinusGraphPattern;
import org.openrdf.query.parser.sparql.ast.ASTMinutes;
import org.openrdf.query.parser.sparql.ast.ASTMonth;
import org.openrdf.query.parser.sparql.ast.ASTNot;
import org.openrdf.query.parser.sparql.ast.ASTNotExistsFunc;
import org.openrdf.query.parser.sparql.ast.ASTNotIn;
import org.openrdf.query.parser.sparql.ast.ASTNow;
import org.openrdf.query.parser.sparql.ast.ASTNumericLiteral;
import org.openrdf.query.parser.sparql.ast.ASTObjectList;
import org.openrdf.query.parser.sparql.ast.ASTOffset;
import org.openrdf.query.parser.sparql.ast.ASTOptionalGraphPattern;
import org.openrdf.query.parser.sparql.ast.ASTOr;
import org.openrdf.query.parser.sparql.ast.ASTOrderClause;
import org.openrdf.query.parser.sparql.ast.ASTOrderCondition;
import org.openrdf.query.parser.sparql.ast.ASTPathAlternative;
import org.openrdf.query.parser.sparql.ast.ASTPathElt;
import org.openrdf.query.parser.sparql.ast.ASTPathMod;
import org.openrdf.query.parser.sparql.ast.ASTPathOneInPropertySet;
import org.openrdf.query.parser.sparql.ast.ASTPathSequence;
import org.openrdf.query.parser.sparql.ast.ASTProjectionElem;
import org.openrdf.query.parser.sparql.ast.ASTPropertyList;
import org.openrdf.query.parser.sparql.ast.ASTPropertyListPath;
import org.openrdf.query.parser.sparql.ast.ASTQName;
import org.openrdf.query.parser.sparql.ast.ASTQueryContainer;
import org.openrdf.query.parser.sparql.ast.ASTRDFLiteral;
import org.openrdf.query.parser.sparql.ast.ASTRand;
import org.openrdf.query.parser.sparql.ast.ASTRegexExpression;
import org.openrdf.query.parser.sparql.ast.ASTReplace;
import org.openrdf.query.parser.sparql.ast.ASTRound;
import org.openrdf.query.parser.sparql.ast.ASTSHA1;
import org.openrdf.query.parser.sparql.ast.ASTSHA224;
import org.openrdf.query.parser.sparql.ast.ASTSHA256;
import org.openrdf.query.parser.sparql.ast.ASTSHA384;
import org.openrdf.query.parser.sparql.ast.ASTSHA512;
import org.openrdf.query.parser.sparql.ast.ASTSTRUUID;
import org.openrdf.query.parser.sparql.ast.ASTSameTerm;
import org.openrdf.query.parser.sparql.ast.ASTSample;
import org.openrdf.query.parser.sparql.ast.ASTSeconds;
import org.openrdf.query.parser.sparql.ast.ASTSelect;
import org.openrdf.query.parser.sparql.ast.ASTSelectQuery;
import org.openrdf.query.parser.sparql.ast.ASTServiceGraphPattern;
import org.openrdf.query.parser.sparql.ast.ASTStr;
import org.openrdf.query.parser.sparql.ast.ASTStrAfter;
import org.openrdf.query.parser.sparql.ast.ASTStrBefore;
import org.openrdf.query.parser.sparql.ast.ASTStrDt;
import org.openrdf.query.parser.sparql.ast.ASTStrEnds;
import org.openrdf.query.parser.sparql.ast.ASTStrLang;
import org.openrdf.query.parser.sparql.ast.ASTStrLen;
import org.openrdf.query.parser.sparql.ast.ASTStrStarts;
import org.openrdf.query.parser.sparql.ast.ASTString;
import org.openrdf.query.parser.sparql.ast.ASTSubstr;
import org.openrdf.query.parser.sparql.ast.ASTSum;
import org.openrdf.query.parser.sparql.ast.ASTTimezone;
import org.openrdf.query.parser.sparql.ast.ASTTrue;
import org.openrdf.query.parser.sparql.ast.ASTTz;
import org.openrdf.query.parser.sparql.ast.ASTUUID;
import org.openrdf.query.parser.sparql.ast.ASTUnionGraphPattern;
import org.openrdf.query.parser.sparql.ast.ASTUpperCase;
import org.openrdf.query.parser.sparql.ast.ASTVar;
import org.openrdf.query.parser.sparql.ast.ASTYear;
import org.openrdf.query.parser.sparql.ast.Node;
import org.openrdf.query.parser.sparql.ast.SimpleNode;
import org.openrdf.query.parser.sparql.ast.VisitorException;

public class TupleExprBuilder
extends ASTVisitorBase {
    private ValueFactory valueFactory;
    GraphPattern graphPattern = new GraphPattern();
    private int anonVarID = 1;

    public TupleExprBuilder(ValueFactory valueFactory) {
        this.valueFactory = valueFactory;
    }

    protected Var mapValueExprToVar(ValueExpr valueExpr) {
        if (valueExpr instanceof Var) {
            return (Var)valueExpr;
        }
        if (valueExpr instanceof ValueConstant) {
            Var v = this.createConstVar(((ValueConstant)valueExpr).getValue());
            return v;
        }
        if (valueExpr == null) {
            throw new IllegalArgumentException("valueExpr is null");
        }
        throw new IllegalArgumentException("valueExpr is a: " + valueExpr.getClass());
    }

    protected Value getValueForExpr(ValueExpr valueExpr) {
        if (valueExpr instanceof Var) {
            return ((Var)valueExpr).getValue();
        }
        if (valueExpr instanceof ValueConstant) {
            ValueConstant vc = (ValueConstant)valueExpr;
            return vc.getValue();
        }
        if (valueExpr == null) {
            throw new IllegalArgumentException("valueExpr is null");
        }
        throw new IllegalArgumentException("valueExpr is a: " + valueExpr.getClass());
    }

    private Var createConstVar(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("value can not be null");
        }
        String uniqueStringForValue = value.stringValue();
        if (value instanceof Literal) {
            uniqueStringForValue = uniqueStringForValue + "-lit";
            Literal lit = (Literal)value;
            if (lit.getDatatype() != null) {
                uniqueStringForValue = uniqueStringForValue + "-" + lit.getDatatype().stringValue();
            }
            if (lit.getLanguage() != null) {
                uniqueStringForValue = uniqueStringForValue + "-" + lit.getLanguage();
            }
        } else {
            uniqueStringForValue = value instanceof BNode ? uniqueStringForValue + "-node" : uniqueStringForValue + "-uri";
        }
        Var var = this.createAnonVar("-const-" + uniqueStringForValue);
        var.setConstant(true);
        var.setValue(value);
        return var;
    }

    private Var createAnonVar(String varName) {
        Var var = new Var(varName);
        var.setAnonymous(true);
        return var;
    }

    private FunctionCall createFunctionCall(String uri, SimpleNode node, int minArgs, int maxArgs) throws VisitorException {
        FunctionCall functionCall = new FunctionCall(uri, new ValueExpr[0]);
        int noOfArguments = node.jjtGetNumChildren();
        if (noOfArguments > maxArgs || noOfArguments < minArgs) {
            throw new VisitorException("unexpected number of arguments (" + noOfArguments + ") for function " + uri);
        }
        for (int i = 0; i < noOfArguments; ++i) {
            Node argNode = node.jjtGetChild(i);
            functionCall.addArg((ValueExpr)argNode.jjtAccept(this, null));
        }
        return functionCall;
    }

    @Override
    public TupleExpr visit(ASTQueryContainer node, Object data) throws VisitorException {
        return (TupleExpr)node.getQuery().jjtAccept(this, null);
    }

    @Override
    public TupleExpr visit(ASTSelectQuery node, Object data) throws VisitorException {
        GraphPattern parentGP = this.graphPattern;
        this.graphPattern = new GraphPattern(parentGP);
        node.getWhereClause().jjtAccept(this, null);
        TupleExpr tupleExpr = this.graphPattern.buildTupleExpr();
        ASTGroupClause groupNode = node.getGroupClause();
        if (groupNode != null) {
            tupleExpr = (TupleExpr)groupNode.jjtAccept(this, tupleExpr);
        }
        Group group = null;
        group = tupleExpr instanceof Group ? (Group)tupleExpr : new Group(tupleExpr);
        tupleExpr = this.processHavingClause(node.getHavingClause(), tupleExpr, group);
        ASTBindingsClause bindingsClause = node.getBindingsClause();
        if (bindingsClause != null) {
            tupleExpr = new Join((BindingSetAssignment)bindingsClause.jjtAccept(this, null), tupleExpr);
        }
        tupleExpr = this.processOrderClause(node.getOrderClause(), tupleExpr, group);
        tupleExpr = (TupleExpr)node.getSelect().jjtAccept(this, tupleExpr);
        ASTLimit limitNode = node.getLimit();
        long limit = -1L;
        if (limitNode != null) {
            limit = (Long)limitNode.jjtAccept(this, null);
        }
        ASTOffset offsetNode = node.getOffset();
        long offset = -1L;
        if (offsetNode != null) {
            offset = (Long)offsetNode.jjtAccept(this, null);
        }
        if (offset >= 1L || limit >= 0L) {
            tupleExpr = new Slice(tupleExpr, offset, limit);
        }
        if (parentGP != null) {
            parentGP.addRequiredTE(tupleExpr);
            this.graphPattern = parentGP;
        }
        return tupleExpr;
    }

    private TupleExpr processHavingClause(ASTHavingClause havingNode, TupleExpr tupleExpr, Group group) throws VisitorException {
        if (havingNode != null) {
            ValueExpr expr = (ValueExpr)havingNode.jjtGetChild(0).jjtAccept(this, tupleExpr);
            AggregateCollector collector = new AggregateCollector();
            collector.meetOther(expr);
            Extension extension = new Extension();
            for (AggregateOperator operator : collector.getOperators()) {
                Var var = this.createAnonVar("-anon-" + this.anonVarID++);
                AggregateOperatorReplacer replacer = new AggregateOperatorReplacer(operator, var);
                replacer.meetOther(expr);
                String alias = var.getName();
                ExtensionElem pe = new ExtensionElem(operator, alias);
                extension.addElement(pe);
                GroupElem ge = new GroupElem(alias, operator);
                group.addGroupElement(ge);
            }
            extension.setArg(group);
            tupleExpr = new Filter(extension, expr);
        }
        return tupleExpr;
    }

    private TupleExpr processOrderClause(ASTOrderClause orderNode, TupleExpr tupleExpr, Group group) throws VisitorException {
        if (orderNode != null) {
            List orderElements = (List)orderNode.jjtAccept(this, null);
            for (OrderElem orderElem : orderElements) {
                AggregateCollector collector = new AggregateCollector();
                collector.meet(orderElem);
                Extension extension = new Extension();
                for (AggregateOperator operator : collector.getOperators()) {
                    Var var = this.createAnonVar("-anon-" + this.anonVarID++);
                    AggregateOperatorReplacer replacer = new AggregateOperatorReplacer(operator, var);
                    replacer.meet(orderElem);
                    String alias = var.getName();
                    ExtensionElem pe = new ExtensionElem(operator, alias);
                    extension.addElement(pe);
                    GroupElem ge = new GroupElem(alias, operator);
                    group.addGroupElement(ge);
                    extension.setArg(tupleExpr);
                    tupleExpr = extension;
                }
            }
            tupleExpr = new Order(tupleExpr, orderElements);
        }
        return tupleExpr;
    }

    @Override
    public TupleExpr visit(ASTSelect node, Object data) throws VisitorException {
        TupleExpr result = (TupleExpr)data;
        Order orderClause = result instanceof Order ? (Order)result : null;
        Extension extension = new Extension();
        ProjectionElemList projElemList = new ProjectionElemList();
        GroupFinder groupFinder = new GroupFinder();
        result.visit(groupFinder);
        Group group = groupFinder.getGroup();
        boolean existingGroup = group != null;
        ArrayList<String> aliasesInProjection = new ArrayList<String>();
        for (ASTProjectionElem projElemNode : node.getProjectionElemList()) {
            Node child = projElemNode.jjtGetChild(0);
            String alias = projElemNode.getAlias();
            if (alias != null) {
                if (aliasesInProjection.contains(alias)) {
                    throw new VisitorException("duplicate use of alias '" + alias + "' in projection.");
                }
                if (result.getBindingNames().contains(alias)) {
                    throw new VisitorException("projection alias '" + alias + "' was previously used");
                }
                aliasesInProjection.add(alias);
                ValueExpr valueExpr = (ValueExpr)child.jjtAccept(this, null);
                String targetName = alias;
                String sourceName = alias;
                if (child instanceof ASTVar) {
                    sourceName = ((ASTVar)child).getName();
                }
                ProjectionElem elem = new ProjectionElem(sourceName, targetName);
                projElemList.addElement(elem);
                AggregateCollector collector = new AggregateCollector();
                valueExpr.visit(collector);
                if (collector.getOperators().size() > 0) {
                    elem.setAggregateOperatorInExpression(true);
                    for (AggregateOperator operator : collector.getOperators()) {
                        if (group == null) {
                            group = new Group(result);
                        }
                        if (operator.equals(valueExpr)) {
                            group.addGroupElement(new GroupElem(alias, operator));
                            extension.setArg(group);
                        } else {
                            ValueExpr expr = (ValueExpr)operator.getParentNode();
                            Extension anonymousExtension = new Extension();
                            Var anonVar = this.createAnonVar("_anon_" + this.anonVarID++);
                            expr.replaceChildNode(operator, anonVar);
                            anonymousExtension.addElement(new ExtensionElem(operator, anonVar.getName()));
                            anonymousExtension.setArg(result);
                            result = anonymousExtension;
                            group.addGroupElement(new GroupElem(anonVar.getName(), operator));
                        }
                        if (existingGroup) continue;
                        result = group;
                    }
                }
                ExtensionElem extElem = new ExtensionElem(valueExpr, alias);
                extension.addElement(extElem);
                elem.setSourceExpression(extElem);
                continue;
            }
            if (child instanceof ASTVar) {
                Var projVar = (Var)child.jjtAccept(this, null);
                ProjectionElem elem = new ProjectionElem(projVar.getName());
                projElemList.addElement(elem);
                VarCollector whereClauseVarCollector = new VarCollector();
                result.visit(whereClauseVarCollector);
                if (whereClauseVarCollector.collectedVars.contains(projVar)) continue;
                ExtensionElem extElem = new ExtensionElem(projVar, projVar.getName());
                extension.addElement(extElem);
                elem.setSourceExpression(extElem);
                continue;
            }
            throw new IllegalStateException("required alias for non-Var projection elements not found");
        }
        if (!extension.getElements().isEmpty()) {
            if (orderClause != null) {
                TupleExpr arg = orderClause.getArg();
                extension.setArg(arg);
                orderClause.setArg(extension);
                result = orderClause;
            } else {
                extension.setArg(result);
                result = extension;
            }
        }
        result = new Projection(result, projElemList);
        if (group != null) {
            for (ProjectionElem elem : projElemList.getElements()) {
                if (elem.hasAggregateOperatorInExpression()) continue;
                Set<String> groupNames = group.getBindingNames();
                ExtensionElem extElem = elem.getSourceExpression();
                if (extElem != null) {
                    ValueExpr expr = extElem.getExpr();
                    VarCollector collector = new VarCollector();
                    expr.visit(collector);
                    for (Var var : collector.getCollectedVars()) {
                        if (groupNames.contains(var.getName())) continue;
                        throw new VisitorException("variable '" + var.getName() + "' in projection not present in GROUP BY.");
                    }
                    continue;
                }
                if (!groupNames.contains(elem.getTargetName())) {
                    throw new VisitorException("variable '" + elem.getTargetName() + "' in projection not present in GROUP BY.");
                }
                if (groupNames.contains(elem.getSourceName())) continue;
                throw new VisitorException("variable '" + elem.getSourceName() + "' in projection not present in GROUP BY.");
            }
        }
        if (node.isSubSelect()) {
            ((Projection)result).setProjectionContext(this.graphPattern.getContextVar());
        }
        if (node.isDistinct()) {
            result = new Distinct(result);
        } else if (node.isReduced()) {
            result = new Reduced(result);
        }
        return result;
    }

    @Override
    public TupleExpr visit(ASTConstructQuery node, Object data) throws VisitorException {
        this.graphPattern = new GraphPattern();
        node.getWhereClause().jjtAccept(this, null);
        TupleExpr tupleExpr = this.graphPattern.buildTupleExpr();
        ASTGroupClause groupNode = node.getGroupClause();
        if (groupNode != null) {
            tupleExpr = (TupleExpr)groupNode.jjtAccept(this, tupleExpr);
        }
        Group group = null;
        group = tupleExpr instanceof Group ? (Group)tupleExpr : new Group(tupleExpr);
        tupleExpr = this.processHavingClause(node.getHavingClause(), tupleExpr, group);
        ASTBindingsClause bindingsClause = node.getBindingsClause();
        if (bindingsClause != null) {
            tupleExpr = new Join((BindingSetAssignment)bindingsClause.jjtAccept(this, null), tupleExpr);
        }
        tupleExpr = this.processOrderClause(node.getOrderClause(), tupleExpr, null);
        ASTConstruct constructNode = node.getConstruct();
        if (!constructNode.isWildcard()) {
            tupleExpr = (TupleExpr)constructNode.jjtAccept(this, tupleExpr);
        } else {
            ConstructorBuilder cb = new ConstructorBuilder();
            try {
                tupleExpr = cb.buildConstructor(tupleExpr, false, false);
            }
            catch (MalformedQueryException e) {
                throw new VisitorException(e.getMessage());
            }
        }
        ASTLimit limitNode = node.getLimit();
        long limit = -1L;
        if (limitNode != null) {
            limit = (Long)limitNode.jjtAccept(this, null);
        }
        ASTOffset offsetNode = node.getOffset();
        long offset = -1L;
        if (offsetNode != null) {
            offset = (Long)offsetNode.jjtAccept(this, null);
        }
        if (offset >= 1L || limit >= 0L) {
            tupleExpr = new Slice(tupleExpr, offset, limit);
        }
        return tupleExpr;
    }

    @Override
    public TupleExpr visit(ASTConstruct node, Object data) throws VisitorException {
        QueryModelNode result = (TupleExpr)data;
        this.graphPattern = new GraphPattern();
        super.visit(node, null);
        TupleExpr constructExpr = this.graphPattern.buildTupleExpr();
        List<StatementPattern> statementPatterns = StatementPatternCollector.process(constructExpr);
        Set<Var> constructVars = this.getConstructVars(statementPatterns);
        VarCollector whereClauseVarCollector = new VarCollector();
        result.visit(whereClauseVarCollector);
        HashMap<Var, ExtensionElem> extElemMap = new HashMap<Var, ExtensionElem>();
        for (Var var : constructVars) {
            if (var.isAnonymous() && !extElemMap.containsKey(var)) {
                QueryModelNodeBase valueExpr = var.hasValue() ? new ValueConstant(var.getValue()) : new BNodeGenerator();
                extElemMap.put(var, new ExtensionElem((ValueExpr)((Object)valueExpr), var.getName()));
                continue;
            }
            if (whereClauseVarCollector.collectedVars.contains(var) || extElemMap.containsKey(var)) continue;
            extElemMap.put(var, new ExtensionElem(var, var.getName()));
        }
        if (!extElemMap.isEmpty()) {
            result = new Extension((TupleExpr)result, (Iterable<ExtensionElem>)extElemMap.values());
        }
        ArrayList<ProjectionElemList> projList = new ArrayList<ProjectionElemList>();
        for (StatementPattern sp : statementPatterns) {
            ProjectionElemList projElemList = new ProjectionElemList();
            projElemList.addElement(new ProjectionElem(sp.getSubjectVar().getName(), "subject"));
            projElemList.addElement(new ProjectionElem(sp.getPredicateVar().getName(), "predicate"));
            projElemList.addElement(new ProjectionElem(sp.getObjectVar().getName(), "object"));
            if (sp.getContextVar() != null) {
                projElemList.addElement(new ProjectionElem(sp.getContextVar().getName(), "context"));
            }
            projList.add(projElemList);
        }
        result = projList.size() == 1 ? new Projection((TupleExpr)result, (ProjectionElemList)projList.get(0)) : (projList.size() > 1 ? new MultiProjection((TupleExpr)result, (Iterable<ProjectionElemList>)projList) : new EmptySet());
        return new Reduced((TupleExpr)result);
    }

    private Set<Var> getConstructVars(Collection<StatementPattern> statementPatterns) {
        LinkedHashSet<Var> vars = new LinkedHashSet<Var>(statementPatterns.size() * 2);
        for (StatementPattern sp : statementPatterns) {
            vars.add(sp.getSubjectVar());
            vars.add(sp.getPredicateVar());
            vars.add(sp.getObjectVar());
        }
        return vars;
    }

    @Override
    public TupleExpr visit(ASTDescribeQuery node, Object data) throws VisitorException {
        TupleExpr tupleExpr = null;
        if (node.getWhereClause() != null) {
            this.graphPattern = new GraphPattern();
            node.getWhereClause().jjtAccept(this, null);
            tupleExpr = this.graphPattern.buildTupleExpr();
            ASTGroupClause groupNode = node.getGroupClause();
            if (groupNode != null) {
                tupleExpr = (TupleExpr)groupNode.jjtAccept(this, tupleExpr);
            }
            Group group = null;
            group = tupleExpr instanceof Group ? (Group)tupleExpr : new Group(tupleExpr);
            tupleExpr = this.processHavingClause(node.getHavingClause(), tupleExpr, group);
            tupleExpr = this.processOrderClause(node.getOrderClause(), tupleExpr, null);
            ASTLimit limitNode = node.getLimit();
            long limit = -1L;
            if (limitNode != null) {
                limit = (Long)limitNode.jjtAccept(this, null);
            }
            ASTOffset offsetNode = node.getOffset();
            long offset = -1L;
            if (offsetNode != null) {
                offset = (Long)offsetNode.jjtAccept(this, null);
            }
            if (offset >= 1L || limit >= 0L) {
                tupleExpr = new Slice(tupleExpr, offset, limit);
            }
        }
        return (TupleExpr)node.getDescribe().jjtAccept(this, tupleExpr);
    }

    @Override
    public TupleExpr visit(ASTDescribe node, Object data) throws VisitorException {
        TupleExpr tupleExpr = (TupleExpr)data;
        if (tupleExpr == null) {
            tupleExpr = new SingletonSet();
        }
        Extension e = new Extension();
        ProjectionElemList projectionElements = new ProjectionElemList();
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            ValueExpr resource = (ValueExpr)node.jjtGetChild(i).jjtAccept(this, null);
            if (resource instanceof Var) {
                projectionElements.addElement(new ProjectionElem(((Var)resource).getName()));
                continue;
            }
            String alias = "-describe-" + UUID.randomUUID();
            ExtensionElem elem = new ExtensionElem(resource, alias);
            e.addElement(elem);
            projectionElements.addElement(new ProjectionElem(alias));
        }
        if (!e.getElements().isEmpty()) {
            e.setArg(tupleExpr);
            tupleExpr = e;
        }
        Projection p = new Projection(tupleExpr, projectionElements);
        return new DescribeOperator(p);
    }

    @Override
    public TupleExpr visit(ASTAskQuery node, Object data) throws VisitorException {
        this.graphPattern = new GraphPattern();
        super.visit(node, null);
        TupleExpr tupleExpr = this.graphPattern.buildTupleExpr();
        tupleExpr = new Slice(tupleExpr, 0L, 1L);
        ASTBindingsClause bindingsClause = node.getBindingsClause();
        if (bindingsClause != null) {
            tupleExpr = new Join((BindingSetAssignment)bindingsClause.jjtAccept(this, null), tupleExpr);
        }
        return tupleExpr;
    }

    @Override
    public Group visit(ASTGroupClause node, Object data) throws VisitorException {
        TupleExpr tupleExpr = (TupleExpr)data;
        Group g = new Group(tupleExpr);
        int childCount = node.jjtGetNumChildren();
        ArrayList<String> groupBindingNames = new ArrayList<String>();
        for (int i = 0; i < childCount; ++i) {
            String name = (String)node.jjtGetChild(i).jjtAccept(this, g);
            groupBindingNames.add(name);
        }
        g.setGroupBindingNames(groupBindingNames);
        return g;
    }

    @Override
    public String visit(ASTGroupCondition node, Object data) throws VisitorException {
        Var v;
        Group group = (Group)data;
        TupleExpr arg = group.getArg();
        Extension extension = null;
        extension = arg instanceof Extension ? (Extension)arg : new Extension();
        String name = null;
        ValueExpr ve = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, data);
        boolean aliased = false;
        if (node.jjtGetNumChildren() > 1) {
            aliased = true;
            v = (Var)node.jjtGetChild(1).jjtAccept(this, data);
            name = v.getName();
        } else if (ve instanceof Var) {
            name = ((Var)ve).getName();
        } else {
            aliased = true;
            v = this.createAnonVar("_anon_" + node.getName());
            name = v.getName();
        }
        if (aliased) {
            ExtensionElem elem = new ExtensionElem(ve, name);
            extension.addElement(elem);
        }
        if (extension.getElements().size() > 0 && !(arg instanceof Extension)) {
            extension.setArg(arg);
            group.setArg(extension);
        }
        return name;
    }

    @Override
    public List<OrderElem> visit(ASTOrderClause node, Object data) throws VisitorException {
        int childCount = node.jjtGetNumChildren();
        ArrayList<OrderElem> elements = new ArrayList<OrderElem>(childCount);
        for (int i = 0; i < childCount; ++i) {
            elements.add((OrderElem)node.jjtGetChild(i).jjtAccept(this, null));
        }
        return elements;
    }

    @Override
    public OrderElem visit(ASTOrderCondition node, Object data) throws VisitorException {
        ValueExpr valueExpr = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        return new OrderElem(valueExpr, node.isAscending());
    }

    @Override
    public Long visit(ASTLimit node, Object data) throws VisitorException {
        return node.getValue();
    }

    @Override
    public Long visit(ASTOffset node, Object data) throws VisitorException {
        return node.getValue();
    }

    @Override
    public Object visit(ASTGraphPatternGroup node, Object data) throws VisitorException {
        GraphPattern parentGP = this.graphPattern;
        this.graphPattern = new GraphPattern(parentGP);
        boolean optionalPatternInGroup = false;
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            if (optionalPatternInGroup) {
                TupleExpr te = this.graphPattern.buildTupleExpr();
                this.graphPattern = new GraphPattern(parentGP);
                this.graphPattern.addRequiredTE(te);
                optionalPatternInGroup = false;
            }
            Node childNode = node.jjtGetChild(i);
            data = childNode.jjtAccept(this, data);
            if (!(childNode instanceof ASTOptionalGraphPattern)) continue;
            optionalPatternInGroup = true;
        }
        TupleExpr te = this.graphPattern.buildTupleExpr();
        parentGP.addRequiredTE(te);
        this.graphPattern = parentGP;
        return te;
    }

    @Override
    public Object visit(ASTServiceGraphPattern node, Object data) throws VisitorException {
        GraphPattern parentGP = this.graphPattern;
        ValueExpr serviceRef = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        this.graphPattern = new GraphPattern(parentGP);
        node.jjtGetChild(1).jjtAccept(this, null);
        TupleExpr serviceExpr = this.graphPattern.buildTupleExpr();
        if (serviceExpr instanceof SingletonSet) {
            return null;
        }
        String serviceExpressionString = node.getPatternString();
        parentGP.addRequiredTE(new Service(this.mapValueExprToVar(serviceRef), serviceExpr, serviceExpressionString, node.getPrefixDeclarations(), node.getBaseURI(), node.isSilent()));
        this.graphPattern = parentGP;
        return null;
    }

    @Override
    public Object visit(ASTOptionalGraphPattern node, Object data) throws VisitorException {
        GraphPattern parentGP = this.graphPattern;
        this.graphPattern = new GraphPattern(parentGP);
        super.visit(node, null);
        List<ValueExpr> optionalConstraints = this.graphPattern.removeAllConstraints();
        TupleExpr optional = this.graphPattern.buildTupleExpr();
        this.graphPattern = parentGP;
        this.graphPattern.addOptionalTE(optional, optionalConstraints);
        return null;
    }

    @Override
    public Object visit(ASTGraphGraphPattern node, Object data) throws VisitorException {
        Var oldContext = this.graphPattern.getContextVar();
        StatementPattern.Scope oldScope = this.graphPattern.getStatementPatternScope();
        ValueExpr newContext = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        this.graphPattern.setContextVar(this.mapValueExprToVar(newContext));
        this.graphPattern.setStatementPatternScope(StatementPattern.Scope.NAMED_CONTEXTS);
        node.jjtGetChild(1).jjtAccept(this, null);
        this.graphPattern.setContextVar(oldContext);
        this.graphPattern.setStatementPatternScope(oldScope);
        return null;
    }

    @Override
    public Object visit(ASTUnionGraphPattern node, Object data) throws VisitorException {
        GraphPattern parentGP = this.graphPattern;
        this.graphPattern = new GraphPattern(parentGP);
        node.jjtGetChild(0).jjtAccept(this, null);
        TupleExpr leftArg = this.graphPattern.buildTupleExpr();
        this.graphPattern = new GraphPattern(parentGP);
        node.jjtGetChild(1).jjtAccept(this, null);
        TupleExpr rightArg = this.graphPattern.buildTupleExpr();
        parentGP.addRequiredTE(new Union(leftArg, rightArg));
        this.graphPattern = parentGP;
        return null;
    }

    @Override
    public Object visit(ASTMinusGraphPattern node, Object data) throws VisitorException {
        GraphPattern parentGP = this.graphPattern;
        TupleExpr leftArg = this.graphPattern.buildTupleExpr();
        this.graphPattern = new GraphPattern(parentGP);
        node.jjtGetChild(0).jjtAccept(this, null);
        TupleExpr rightArg = this.graphPattern.buildTupleExpr();
        parentGP = new GraphPattern();
        parentGP.addRequiredTE(new Difference(leftArg, rightArg));
        this.graphPattern = parentGP;
        return null;
    }

    @Override
    public Object visit(ASTPropertyList propListNode, Object data) throws VisitorException {
        ValueExpr subject = (ValueExpr)data;
        ValueExpr predicate = (ValueExpr)propListNode.getVerb().jjtAccept(this, null);
        List objectList = (List)propListNode.getObjectList().jjtAccept(this, null);
        Var subjVar = this.mapValueExprToVar(subject);
        Var predVar = this.mapValueExprToVar(predicate);
        for (ValueExpr object : objectList) {
            Var objVar = this.mapValueExprToVar(object);
            this.graphPattern.addRequiredSP(subjVar, predVar, objVar);
        }
        ASTPropertyList nextPropList = propListNode.getNextPropertyList();
        if (nextPropList != null) {
            nextPropList.jjtAccept(this, subject);
        }
        return this.graphPattern.buildTupleExpr();
    }

    @Override
    public Object visit(ASTPathAlternative pathAltNode, Object data) throws VisitorException {
        int altCount = pathAltNode.jjtGetNumChildren();
        if (altCount > 1) {
            Union union;
            GraphPattern parentGP = this.graphPattern;
            Union currentUnion = union = new Union();
            for (int i = 0; i < altCount - 1; ++i) {
                this.graphPattern = new GraphPattern(parentGP);
                pathAltNode.jjtGetChild(i).jjtAccept(this, data);
                TupleExpr arg = this.graphPattern.buildTupleExpr();
                currentUnion.setLeftArg(arg);
                if (i == altCount - 2) {
                    this.graphPattern = new GraphPattern(parentGP);
                    pathAltNode.jjtGetChild(i + 1).jjtAccept(this, data);
                    arg = this.graphPattern.buildTupleExpr();
                    currentUnion.setRightArg(arg);
                    continue;
                }
                Union newUnion = new Union();
                currentUnion.setRightArg(newUnion);
                currentUnion = newUnion;
            }
            parentGP.addRequiredTE(union);
            this.graphPattern = parentGP;
        } else {
            pathAltNode.jjtGetChild(0).jjtAccept(this, data);
        }
        return null;
    }

    @Override
    public PropertySetElem visit(ASTPathOneInPropertySet node, Object data) throws VisitorException {
        PropertySetElem result = new PropertySetElem();
        result.setInverse(node.isInverse());
        ValueConstant predicate = (ValueConstant)node.jjtGetChild(0).jjtAccept(this, data);
        result.setPredicate(predicate);
        return result;
    }

    private ASTObjectList getObjectList(Node node) {
        if (node == null) {
            return null;
        }
        if (node instanceof ASTPropertyListPath) {
            return ((ASTPropertyListPath)node).getObjectList();
        }
        return this.getObjectList(node.jjtGetParent());
    }

    private boolean checkInverse(Node node) {
        if (node instanceof ASTPathElt) {
            return ((ASTPathElt)node).isInverse();
        }
        Node parent = node.jjtGetParent();
        if (parent != null) {
            return this.checkInverse(parent);
        }
        return false;
    }

    @Override
    public Object visit(ASTPathSequence pathSeqNode, Object data) throws VisitorException {
        ValueExpr subject = (ValueExpr)data;
        Var subjVar = this.mapValueExprToVar(subject);
        boolean invertSequence = this.checkInverse(pathSeqNode);
        List objectList = (List)this.getObjectList(pathSeqNode).jjtAccept(this, null);
        List<ASTPathElt> pathElements = pathSeqNode.getPathElements();
        int pathLength = pathElements.size();
        GraphPattern pathSequencePattern = new GraphPattern(this.graphPattern);
        StatementPattern.Scope scope = pathSequencePattern.getStatementPatternScope();
        Var contextVar = pathSequencePattern.getContextVar();
        Var startVar = subjVar;
        for (int i = 0; i < pathLength; ++i) {
            TupleExpr te;
            ASTPathElt pathElement = pathElements.get(i);
            ASTPathMod pathMod = pathElement.getPathMod();
            long lowerBound = Long.MIN_VALUE;
            long upperBound = Long.MIN_VALUE;
            if (pathMod != null) {
                lowerBound = pathMod.getLowerBound();
                upperBound = pathMod.getUpperBound();
                if (upperBound == Long.MIN_VALUE) {
                    upperBound = lowerBound;
                } else if (lowerBound == Long.MIN_VALUE) {
                    lowerBound = upperBound;
                }
            }
            if (pathElement.isNegatedPropertySet()) {
                NegatedPropertySet nps = new NegatedPropertySet();
                nps.setScope(scope);
                nps.setSubjectVar(startVar);
                nps.setContextVar(contextVar);
                for (Node child : pathElement.jjtGetChildren()) {
                    nps.addPropertySetElem((PropertySetElem)child.jjtAccept(this, data));
                }
                Var[] objVarReplacement = null;
                if (i == pathLength - 1) {
                    if (objectList.contains(subjVar)) {
                        Var objVar = this.mapValueExprToVar((ValueExpr)objectList.get(objectList.indexOf(subjVar)));
                        objVarReplacement = new Var[]{objVar, this.createAnonVar(objVar.getName() + "-" + UUID.randomUUID().toString())};
                        objectList.remove(objVar);
                        objectList.add(objVarReplacement[1]);
                    } else {
                        nps.setObjectList(objectList);
                    }
                } else {
                    Var nextVar = this.createAnonVar(subjVar.getName() + startVar.getName() + "-property-set-" + i);
                    ArrayList<ValueExpr> nextVarList = new ArrayList<ValueExpr>();
                    nextVarList.add(nextVar);
                    nps.setObjectList(nextVarList);
                    startVar = nextVar;
                }
                te = this.createTupleExprForNegatedPropertySet(nps, i);
                if (objVarReplacement != null) {
                    SameTerm condition = new SameTerm((ValueExpr)objVarReplacement[0], (ValueExpr)objVarReplacement[1]);
                    pathSequencePattern.addConstraint(condition);
                }
                pathSequencePattern.addRequiredTE(te);
                continue;
            }
            if (pathElement.isNestedPath()) {
                GraphPattern parentGP = this.graphPattern;
                this.graphPattern = new GraphPattern(parentGP);
                if (i == pathLength - 1) {
                    pathElement.jjtGetChild(0).jjtAccept(this, startVar);
                    TupleExpr te2 = this.graphPattern.buildTupleExpr();
                    for (ValueExpr object : objectList) {
                        Var objVar = this.mapValueExprToVar(object);
                        if (objVar.equals(subjVar)) {
                            Var objVarReplacement = this.createAnonVar(objVar.getName() + "-" + UUID.randomUUID().toString());
                            te2 = this.handlePathModifiers(scope, startVar, te2, objVarReplacement, contextVar, lowerBound, upperBound);
                            SameTerm condition = new SameTerm(objVar, objVarReplacement);
                            pathSequencePattern.addConstraint(condition);
                        } else {
                            te2 = this.handlePathModifiers(scope, startVar, te2, objVar, contextVar, lowerBound, upperBound);
                        }
                        pathSequencePattern.addRequiredTE(te2);
                    }
                } else {
                    Var nextVar = this.createAnonVar(subjVar.getName() + "-nested-" + i);
                    pathElement.jjtGetChild(0).jjtAccept(this, startVar);
                    te = this.graphPattern.buildTupleExpr();
                    te = this.replaceVarOccurrence(te, objectList, nextVar);
                    te = this.handlePathModifiers(scope, startVar, te, nextVar, contextVar, lowerBound, upperBound);
                    pathSequencePattern.addRequiredTE(te);
                    startVar = nextVar;
                }
                this.graphPattern = parentGP;
                continue;
            }
            ValueExpr pred = (ValueExpr)pathElement.jjtAccept(this, data);
            Var predVar = this.mapValueExprToVar(pred);
            if (i == pathLength - 1) {
                for (ValueExpr object : objectList) {
                    Var objVar = this.mapValueExprToVar(object);
                    boolean replaced = false;
                    if (objVar.equals(subjVar)) {
                        objVar = this.createAnonVar(objVar.getName() + "-" + UUID.randomUUID().toString());
                        replaced = true;
                    }
                    Var endVar = objVar;
                    if (invertSequence) {
                        endVar = subjVar;
                        if (startVar.equals(subjVar)) {
                            startVar = objVar;
                        }
                    }
                    if (pathElement.isInverse()) {
                        te = new StatementPattern(scope, endVar, predVar, startVar, contextVar);
                        te = this.handlePathModifiers(scope, endVar, te, startVar, contextVar, lowerBound, upperBound);
                    } else {
                        te = new StatementPattern(scope, startVar, predVar, endVar, contextVar);
                        te = this.handlePathModifiers(scope, startVar, te, endVar, contextVar, lowerBound, upperBound);
                    }
                    if (replaced) {
                        SameTerm condition = new SameTerm(objVar, this.mapValueExprToVar(object));
                        pathSequencePattern.addConstraint(condition);
                    }
                    pathSequencePattern.addRequiredTE(te);
                }
                continue;
            }
            Var nextVar = this.createAnonVar(subjVar.getName() + predVar.getName() + "-" + i);
            if (invertSequence && startVar.equals(subjVar)) {
                for (ValueExpr object : objectList) {
                    Var objVar;
                    startVar = objVar = this.mapValueExprToVar(object);
                    if (pathElement.isInverse()) {
                        Var temp = startVar;
                        startVar = nextVar;
                        nextVar = temp;
                    }
                    te = new StatementPattern(scope, startVar, predVar, nextVar, contextVar);
                    te = this.handlePathModifiers(scope, startVar, te, nextVar, contextVar, lowerBound, upperBound);
                    pathSequencePattern.addRequiredTE(te);
                }
            } else {
                if (pathElement.isInverse()) {
                    Var oldStartVar = startVar;
                    startVar = nextVar;
                    nextVar = oldStartVar;
                }
                te = new StatementPattern(scope, startVar, predVar, nextVar, contextVar);
                te = this.handlePathModifiers(scope, startVar, te, nextVar, contextVar, lowerBound, upperBound);
                pathSequencePattern.addRequiredTE(te);
            }
            startVar = pathElement.isInverse() ? startVar : nextVar;
        }
        for (TupleExpr te : pathSequencePattern.getRequiredTEs()) {
            this.graphPattern.addRequiredTE(te);
        }
        if (pathSequencePattern.getConstraints() != null) {
            for (ValueExpr constraint : pathSequencePattern.getConstraints()) {
                this.graphPattern.addConstraint(constraint);
            }
        }
        return null;
    }

    private TupleExpr createTupleExprForNegatedPropertySet(NegatedPropertySet nps, int index) {
        Var subjVar = nps.getSubjectVar();
        Var predVar = this.createAnonVar("nps-" + subjVar.getName() + "-" + index);
        BinaryValueOperator filterCondition = null;
        BinaryValueOperator filterConditionInverse = null;
        for (PropertySetElem elem : nps.getPropertySetElems()) {
            Compare compare;
            ValueConstant predicate = elem.getPredicate();
            if (elem.isInverse()) {
                compare = new Compare(predVar, predicate, Compare.CompareOp.NE);
                if (filterConditionInverse == null) {
                    filterConditionInverse = compare;
                    continue;
                }
                filterConditionInverse = new And(compare, filterConditionInverse);
                continue;
            }
            compare = new Compare(predVar, predicate, Compare.CompareOp.NE);
            if (filterCondition == null) {
                filterCondition = compare;
                continue;
            }
            filterCondition = new And(compare, filterCondition);
        }
        QueryModelNodeBase patternMatch = null;
        if (filterCondition != null) {
            for (ValueExpr objVar : nps.getObjectList()) {
                if (patternMatch == null) {
                    patternMatch = new StatementPattern(nps.getScope(), subjVar, predVar, (Var)objVar, nps.getContextVar());
                    continue;
                }
                patternMatch = new Join(new StatementPattern(nps.getScope(), subjVar, predVar, (Var)objVar, nps.getContextVar()), (TupleExpr)((Object)patternMatch));
            }
        }
        QueryModelNodeBase patternMatchInverse = null;
        if (filterConditionInverse != null) {
            for (ValueExpr objVar : nps.getObjectList()) {
                if (patternMatchInverse == null) {
                    patternMatchInverse = new StatementPattern(nps.getScope(), (Var)objVar, predVar, subjVar, nps.getContextVar());
                    continue;
                }
                patternMatchInverse = new Join(new StatementPattern(nps.getScope(), (Var)objVar, predVar, subjVar, nps.getContextVar()), (TupleExpr)((Object)patternMatchInverse));
            }
        }
        QueryModelNodeBase completeMatch = null;
        if (patternMatch != null) {
            completeMatch = new Filter((TupleExpr)((Object)patternMatch), filterCondition);
        }
        if (patternMatchInverse != null) {
            completeMatch = completeMatch == null ? new Filter((TupleExpr)((Object)patternMatchInverse), filterConditionInverse) : new Union(new Filter((TupleExpr)((Object)patternMatchInverse), filterConditionInverse), (TupleExpr)((Object)completeMatch));
        }
        return completeMatch;
    }

    private TupleExpr replaceVarOccurrence(TupleExpr te, List<ValueExpr> objectList, Var replacementVar) throws VisitorException {
        for (ValueExpr objExpr : objectList) {
            Var objVar = this.mapValueExprToVar(objExpr);
            VarReplacer replacer = new VarReplacer(objVar, replacementVar);
            te.visit(replacer);
        }
        return te;
    }

    private TupleExpr handlePathModifiers(StatementPattern.Scope scope, Var subjVar, TupleExpr te, Var endVar, Var contextVar, long lowerBound, long upperBound) throws VisitorException {
        TupleExpr result = te;
        if (lowerBound >= 0L) {
            if (lowerBound < upperBound) {
                if (upperBound < Long.MAX_VALUE) {
                    Union union;
                    Union currentUnion = union = new Union();
                    for (long length = lowerBound; length < upperBound; ++length) {
                        TupleExpr path = this.createPath(scope, subjVar, te, endVar, contextVar, length);
                        currentUnion.setLeftArg(path);
                        if (length == upperBound - 1L) {
                            path = this.createPath(scope, subjVar, te, endVar, contextVar, length + 1L);
                            currentUnion.setRightArg(path);
                            continue;
                        }
                        Union nextUnion = new Union();
                        currentUnion.setRightArg(nextUnion);
                        currentUnion = nextUnion;
                    }
                    ProjectionElemList pelist = new ProjectionElemList();
                    for (String name : union.getAssuredBindingNames()) {
                        ProjectionElem pe = new ProjectionElem(name);
                        pelist.addElement(pe);
                    }
                    result = new Distinct(new Projection(union, pelist));
                } else {
                    result = new ArbitraryLengthPath(scope, subjVar, te, endVar, contextVar, lowerBound);
                }
            } else {
                TupleExpr path;
                result = path = this.createPath(scope, subjVar, te, endVar, contextVar, lowerBound);
            }
        }
        return result;
    }

    private TupleExpr createPath(StatementPattern.Scope scope, Var subjVar, TupleExpr pathExpression, Var endVar, Var contextVar, long length) throws VisitorException {
        if (pathExpression instanceof StatementPattern) {
            Var predVar = ((StatementPattern)pathExpression).getPredicateVar();
            if (length == 0L) {
                return new ZeroLengthPath(scope, subjVar, endVar, contextVar);
            }
            GraphPattern gp = new GraphPattern();
            gp.setContextVar(contextVar);
            gp.setStatementPatternScope(scope);
            Var nextVar = null;
            for (long i = 0L; i < length; ++i) {
                nextVar = i < length - 1L ? this.createAnonVar(subjVar.getName() + predVar.getName() + "-path-" + length + "-" + i) : endVar;
                gp.addRequiredSP(subjVar, predVar, nextVar);
                subjVar = nextVar;
            }
            return gp.buildTupleExpr();
        }
        if (length == 0L) {
            return new ZeroLengthPath(scope, subjVar, endVar, contextVar);
        }
        GraphPattern gp = new GraphPattern();
        gp.setContextVar(contextVar);
        gp.setStatementPatternScope(scope);
        Var nextVar = null;
        for (long i = 0L; i < length; ++i) {
            nextVar = i < length - 1L ? this.createAnonVar(subjVar.getName() + "-expression-path-" + length + "-" + i) : endVar;
            TupleExpr clone = pathExpression.clone();
            VarReplacer replacer = new VarReplacer(endVar, nextVar);
            clone.visit(replacer);
            gp.addRequiredTE(clone);
            subjVar = nextVar;
        }
        return gp.buildTupleExpr();
    }

    @Override
    public Object visit(ASTPropertyListPath propListNode, Object data) throws VisitorException {
        ASTPropertyListPath nextPropList;
        ValueExpr subject = (ValueExpr)data;
        ValueExpr verbPath = (ValueExpr)propListNode.getVerb().jjtAccept(this, data);
        if (verbPath instanceof Var) {
            List objectList = (List)propListNode.getObjectList().jjtAccept(this, null);
            Var subjVar = this.mapValueExprToVar(subject);
            Var predVar = this.mapValueExprToVar(verbPath);
            for (ValueExpr object : objectList) {
                Var objVar = this.mapValueExprToVar(object);
                this.graphPattern.addRequiredSP(subjVar, predVar, objVar);
            }
        }
        if ((nextPropList = propListNode.getNextPropertyList()) != null) {
            nextPropList.jjtAccept(this, subject);
        }
        return null;
    }

    @Override
    public List<ValueExpr> visit(ASTObjectList node, Object data) throws VisitorException {
        int childCount = node.jjtGetNumChildren();
        ArrayList<ValueExpr> result = new ArrayList<ValueExpr>(childCount);
        for (int i = 0; i < childCount; ++i) {
            result.add((ValueExpr)node.jjtGetChild(i).jjtAccept(this, null));
        }
        return result;
    }

    @Override
    public Var visit(ASTBlankNodePropertyList node, Object data) throws VisitorException {
        Var bnodeVar = this.createAnonVar(node.getVarName());
        super.visit(node, (Object)bnodeVar);
        return bnodeVar;
    }

    @Override
    public Var visit(ASTCollection node, Object data) throws VisitorException {
        Var rootListVar;
        String listVarName = node.getVarName();
        Var listVar = rootListVar = this.createAnonVar(listVarName);
        int childCount = node.jjtGetNumChildren();
        for (int i = 0; i < childCount; ++i) {
            ValueExpr childValue = (ValueExpr)node.jjtGetChild(i).jjtAccept(this, null);
            Var childVar = this.mapValueExprToVar(childValue);
            this.graphPattern.addRequiredSP(listVar, this.createConstVar(RDF.FIRST), childVar);
            Var nextListVar = i == childCount - 1 ? this.createConstVar(RDF.NIL) : this.createAnonVar(listVarName + "-" + (i + 1));
            this.graphPattern.addRequiredSP(listVar, this.createConstVar(RDF.REST), nextListVar);
            listVar = nextListVar;
        }
        return rootListVar;
    }

    @Override
    public Object visit(ASTConstraint node, Object data) throws VisitorException {
        ValueExpr valueExpr = (ValueExpr)super.visit(node, null);
        this.graphPattern.addConstraint(valueExpr);
        return valueExpr;
    }

    @Override
    public Or visit(ASTOr node, Object data) throws VisitorException {
        ValueExpr leftArg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        ValueExpr rightArg = (ValueExpr)node.jjtGetChild(1).jjtAccept(this, null);
        return new Or(leftArg, rightArg);
    }

    @Override
    public Object visit(ASTAnd node, Object data) throws VisitorException {
        ValueExpr leftArg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        ValueExpr rightArg = (ValueExpr)node.jjtGetChild(1).jjtAccept(this, null);
        return new And(leftArg, rightArg);
    }

    @Override
    public Not visit(ASTNot node, Object data) throws VisitorException {
        ValueExpr arg = (ValueExpr)super.visit(node, null);
        return new Not(arg);
    }

    @Override
    public Coalesce visit(ASTCoalesce node, Object data) throws VisitorException {
        Coalesce coalesce = new Coalesce();
        int noOfArgs = node.jjtGetNumChildren();
        for (int i = 0; i < noOfArgs; ++i) {
            ValueExpr arg = (ValueExpr)node.jjtGetChild(i).jjtAccept(this, data);
            coalesce.addArgument(arg);
        }
        return coalesce;
    }

    @Override
    public Compare visit(ASTCompare node, Object data) throws VisitorException {
        ValueExpr leftArg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        ValueExpr rightArg = (ValueExpr)node.jjtGetChild(1).jjtAccept(this, null);
        return new Compare(leftArg, rightArg, node.getOperator());
    }

    @Override
    public FunctionCall visit(ASTSubstr node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.SUBSTRING.toString(), node, 2, 3);
    }

    @Override
    public FunctionCall visit(ASTConcat node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.CONCAT.toString(), node, 1, Integer.MAX_VALUE);
    }

    @Override
    public FunctionCall visit(ASTAbs node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.NUMERIC_ABS.toString(), node, 1, 1);
    }

    @Override
    public FunctionCall visit(ASTCeil node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.NUMERIC_CEIL.toString(), node, 1, 1);
    }

    @Override
    public FunctionCall visit(ASTContains node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.CONTAINS.toString(), node, 2, 2);
    }

    @Override
    public FunctionCall visit(ASTFloor node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.NUMERIC_FLOOR.toString(), node, 1, 1);
    }

    @Override
    public FunctionCall visit(ASTRound node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.NUMERIC_ROUND.toString(), node, 1, 1);
    }

    @Override
    public FunctionCall visit(ASTRand node, Object data) throws VisitorException {
        return this.createFunctionCall("RAND", node, 0, 0);
    }

    @Override
    public SameTerm visit(ASTSameTerm node, Object data) throws VisitorException {
        ValueExpr leftArg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        ValueExpr rightArg = (ValueExpr)node.jjtGetChild(1).jjtAccept(this, null);
        return new SameTerm(leftArg, rightArg);
    }

    @Override
    public Sample visit(ASTSample node, Object data) throws VisitorException {
        ValueExpr ve = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, data);
        return new Sample(ve, node.isDistinct());
    }

    @Override
    public MathExpr visit(ASTMath node, Object data) throws VisitorException {
        ValueExpr leftArg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        ValueExpr rightArg = (ValueExpr)node.jjtGetChild(1).jjtAccept(this, null);
        return new MathExpr(leftArg, rightArg, node.getOperator());
    }

    @Override
    public Object visit(ASTFunctionCall node, Object data) throws VisitorException {
        ValueConstant uriNode = (ValueConstant)node.jjtGetChild(0).jjtAccept(this, null);
        URI functionURI = (URI)uriNode.getValue();
        FunctionCall functionCall = new FunctionCall(functionURI.toString(), new ValueExpr[0]);
        for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
            Node argNode = node.jjtGetChild(i);
            functionCall.addArg((ValueExpr)argNode.jjtAccept(this, null));
        }
        return functionCall;
    }

    @Override
    public FunctionCall visit(ASTEncodeForURI node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.ENCODE_FOR_URI.toString(), node, 1, 1);
    }

    @Override
    public Object visit(ASTStr node, Object data) throws VisitorException {
        ValueExpr arg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        return new Str(arg);
    }

    @Override
    public FunctionCall visit(ASTStrDt node, Object data) throws VisitorException {
        return this.createFunctionCall("STRDT", node, 2, 2);
    }

    @Override
    public FunctionCall visit(ASTStrStarts node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.STARTS_WITH.toString(), node, 2, 2);
    }

    @Override
    public FunctionCall visit(ASTStrEnds node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.ENDS_WITH.toString(), node, 2, 2);
    }

    @Override
    public FunctionCall visit(ASTStrLen node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.STRING_LENGTH.toString(), node, 1, 1);
    }

    @Override
    public FunctionCall visit(ASTStrAfter node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.SUBSTRING_AFTER.toString(), node, 2, 2);
    }

    @Override
    public FunctionCall visit(ASTStrBefore node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.SUBSTRING_BEFORE.toString(), node, 2, 2);
    }

    @Override
    public FunctionCall visit(ASTUpperCase node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.UPPER_CASE.toString(), node, 1, 1);
    }

    @Override
    public FunctionCall visit(ASTLowerCase node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.LOWER_CASE.toString(), node, 1, 1);
    }

    @Override
    public FunctionCall visit(ASTStrLang node, Object data) throws VisitorException {
        return this.createFunctionCall("STRLANG", node, 2, 2);
    }

    @Override
    public FunctionCall visit(ASTNow node, Object data) throws VisitorException {
        return this.createFunctionCall("NOW", node, 0, 0);
    }

    @Override
    public FunctionCall visit(ASTYear node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.YEAR_FROM_DATETIME.toString(), node, 1, 1);
    }

    @Override
    public FunctionCall visit(ASTMonth node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.MONTH_FROM_DATETIME.toString(), node, 1, 1);
    }

    @Override
    public FunctionCall visit(ASTDay node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.DAY_FROM_DATETIME.toString(), node, 1, 1);
    }

    @Override
    public FunctionCall visit(ASTHours node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.HOURS_FROM_DATETIME.toString(), node, 1, 1);
    }

    @Override
    public FunctionCall visit(ASTMinutes node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.MINUTES_FROM_DATETIME.toString(), node, 1, 1);
    }

    @Override
    public FunctionCall visit(ASTSeconds node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.SECONDS_FROM_DATETIME.toString(), node, 1, 1);
    }

    @Override
    public FunctionCall visit(ASTTimezone node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.TIMEZONE_FROM_DATETIME.toString(), node, 1, 1);
    }

    @Override
    public FunctionCall visit(ASTTz node, Object data) throws VisitorException {
        return this.createFunctionCall("TZ", node, 1, 1);
    }

    @Override
    public FunctionCall visit(ASTMD5 node, Object data) throws VisitorException {
        return this.createFunctionCall("MD5", node, 1, 1);
    }

    @Override
    public FunctionCall visit(ASTSHA1 node, Object data) throws VisitorException {
        return this.createFunctionCall("SHA1", node, 1, 1);
    }

    @Override
    public FunctionCall visit(ASTSHA224 node, Object data) throws VisitorException {
        throw new VisitorException("hash function SHA-224 is currently not supported");
    }

    @Override
    public FunctionCall visit(ASTSHA256 node, Object data) throws VisitorException {
        return this.createFunctionCall("SHA256", node, 1, 1);
    }

    @Override
    public FunctionCall visit(ASTSHA384 node, Object data) throws VisitorException {
        return this.createFunctionCall("SHA384", node, 1, 1);
    }

    @Override
    public FunctionCall visit(ASTSHA512 node, Object data) throws VisitorException {
        return this.createFunctionCall("SHA512", node, 1, 1);
    }

    @Override
    public FunctionCall visit(ASTUUID node, Object data) throws VisitorException {
        return this.createFunctionCall("UUID", node, 0, 0);
    }

    @Override
    public FunctionCall visit(ASTSTRUUID node, Object data) throws VisitorException {
        return this.createFunctionCall("STRUUID", node, 0, 0);
    }

    @Override
    public IRIFunction visit(ASTIRIFunc node, Object data) throws VisitorException {
        ValueExpr expr = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        IRIFunction fn = new IRIFunction(expr);
        fn.setBaseURI(node.getBaseURI());
        return fn;
    }

    @Override
    public Lang visit(ASTLang node, Object data) throws VisitorException {
        ValueExpr arg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        return new Lang(arg);
    }

    @Override
    public Datatype visit(ASTDatatype node, Object data) throws VisitorException {
        ValueExpr arg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        return new Datatype(arg);
    }

    @Override
    public Object visit(ASTLangMatches node, Object data) throws VisitorException {
        ValueExpr leftArg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        ValueExpr rightArg = (ValueExpr)node.jjtGetChild(1).jjtAccept(this, null);
        return new LangMatches(leftArg, rightArg);
    }

    @Override
    public BindingSetAssignment visit(ASTInlineData node, Object data) throws VisitorException {
        BindingSetAssignment bsa = new BindingSetAssignment();
        List<ASTVar> varNodes = node.jjtGetChildren(ASTVar.class);
        ArrayList<Var> vars = new ArrayList<Var>(varNodes.size());
        for (ASTVar varNode : varNodes) {
            Var var = (Var)varNode.jjtAccept(this, data);
            vars.add(var);
        }
        ArrayList<BindingSet> bindingSets = new ArrayList<BindingSet>();
        List<ASTBindingSet> bindingNodes = node.jjtGetChildren(ASTBindingSet.class);
        for (ASTBindingSet bindingNode : bindingNodes) {
            BindingSet bindingSet = (BindingSet)bindingNode.jjtAccept(this, vars);
            bindingSets.add(bindingSet);
        }
        bsa.setBindingSets(bindingSets);
        this.graphPattern.addRequiredTE(bsa);
        return bsa;
    }

    @Override
    public BindingSetAssignment visit(ASTBindingsClause node, Object data) throws VisitorException {
        BindingSetAssignment bsa = new BindingSetAssignment();
        List<ASTVar> varNodes = node.jjtGetChildren(ASTVar.class);
        ArrayList<Var> vars = new ArrayList<Var>(varNodes.size());
        for (ASTVar varNode : varNodes) {
            Var var = (Var)varNode.jjtAccept(this, data);
            vars.add(var);
        }
        List<ASTBindingSet> bindingNodes = node.jjtGetChildren(ASTBindingSet.class);
        ArrayList<BindingSet> bindingSets = new ArrayList<BindingSet>();
        for (ASTBindingSet bindingNode : bindingNodes) {
            BindingSet bindingSet = (BindingSet)bindingNode.jjtAccept(this, vars);
            bindingSets.add(bindingSet);
        }
        bsa.setBindingSets(bindingSets);
        return bsa;
    }

    @Override
    public BindingSet visit(ASTBindingSet node, Object data) throws VisitorException {
        List vars = (List)data;
        ArrayList<String> names = new ArrayList<String>(vars.size());
        for (Var var : vars) {
            names.add(var.getName());
        }
        int numberOfBindingValues = node.jjtGetNumChildren();
        if (numberOfBindingValues != vars.size()) {
            throw new VisitorException("number of values in bindingset does not match variables in BINDINGS clause");
        }
        Value[] values = new Value[numberOfBindingValues];
        for (int i = 0; i < numberOfBindingValues; ++i) {
            Value v;
            ValueExpr ve = (ValueExpr)node.jjtGetChild(i).jjtAccept(this, null);
            if (ve == null) continue;
            values[i] = v = this.getValueForExpr(ve);
        }
        ListBindingSet result = new ListBindingSet(names, values);
        return result;
    }

    @Override
    public ValueExpr visit(ASTBindingValue node, Object data) throws VisitorException {
        if (node.jjtGetNumChildren() > 0) {
            return (ValueExpr)node.jjtGetChild(0).jjtAccept(this, data);
        }
        return null;
    }

    @Override
    public ValueExpr visit(ASTBound node, Object data) throws VisitorException {
        Var var = (Var)node.getArg().jjtAccept(this, null);
        return new Bound(var);
    }

    @Override
    public IsURI visit(ASTIsIRI node, Object data) throws VisitorException {
        ValueExpr arg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        return new IsURI(arg);
    }

    @Override
    public IsBNode visit(ASTIsBlank node, Object data) throws VisitorException {
        ValueExpr arg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        return new IsBNode(arg);
    }

    @Override
    public IsLiteral visit(ASTIsLiteral node, Object data) throws VisitorException {
        ValueExpr arg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        return new IsLiteral(arg);
    }

    @Override
    public IsNumeric visit(ASTIsNumeric node, Object data) throws VisitorException {
        ValueExpr arg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        return new IsNumeric(arg);
    }

    @Override
    public Object visit(ASTBNodeFunc node, Object data) throws VisitorException {
        BNodeGenerator generator = new BNodeGenerator();
        if (node.jjtGetNumChildren() > 0) {
            ValueExpr nodeIdExpr = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
            generator.setNodeIdExpr(nodeIdExpr);
        }
        return generator;
    }

    @Override
    public Object visit(ASTRegexExpression node, Object data) throws VisitorException {
        ValueExpr arg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        ValueExpr pattern = (ValueExpr)node.jjtGetChild(1).jjtAccept(this, null);
        ValueExpr flags = null;
        if (node.jjtGetNumChildren() > 2) {
            flags = (ValueExpr)node.jjtGetChild(2).jjtAccept(this, null);
        }
        return new Regex(arg, pattern, flags);
    }

    @Override
    public FunctionCall visit(ASTReplace node, Object data) throws VisitorException {
        return this.createFunctionCall(FN.REPLACE.toString(), node, 3, 4);
    }

    @Override
    public Exists visit(ASTExistsFunc node, Object data) throws VisitorException {
        GraphPattern parentGP = this.graphPattern;
        this.graphPattern = new GraphPattern(parentGP);
        Exists e = new Exists();
        node.jjtGetChild(0).jjtAccept(this, e);
        TupleExpr te = this.graphPattern.buildTupleExpr();
        e.setSubQuery(te);
        this.graphPattern = parentGP;
        return e;
    }

    @Override
    public Not visit(ASTNotExistsFunc node, Object data) throws VisitorException {
        GraphPattern parentGP = this.graphPattern;
        this.graphPattern = new GraphPattern(parentGP);
        Exists e = new Exists();
        node.jjtGetChild(0).jjtAccept(this, e);
        TupleExpr te = this.graphPattern.buildTupleExpr();
        e.setSubQuery(te);
        this.graphPattern = parentGP;
        return new Not(e);
    }

    @Override
    public If visit(ASTIf node, Object data) throws VisitorException {
        If result = null;
        if (node.jjtGetNumChildren() < 3) {
            throw new VisitorException("IF construction missing required number of arguments");
        }
        ValueExpr condition = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
        ValueExpr resultExpr = (ValueExpr)node.jjtGetChild(1).jjtAccept(this, null);
        ValueExpr alternative = (ValueExpr)node.jjtGetChild(2).jjtAccept(this, null);
        result = new If(condition, resultExpr, alternative);
        return result;
    }

    @Override
    public ValueExpr visit(ASTInfix node, Object data) throws VisitorException {
        ValueExpr leftArg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, data);
        ValueExpr rightArg = (ValueExpr)node.jjtGetChild(1).jjtAccept(this, leftArg);
        return rightArg;
    }

    @Override
    public ValueExpr visit(ASTIn node, Object data) throws VisitorException {
        QueryModelNodeBase result = null;
        ValueExpr leftArg = (ValueExpr)data;
        int listItemCount = node.jjtGetNumChildren();
        if (listItemCount == 0) {
            result = new ValueConstant(BooleanLiteralImpl.FALSE);
        } else if (listItemCount == 1) {
            ValueExpr arg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
            result = new Compare(leftArg, arg, Compare.CompareOp.EQ);
        } else {
            ListMemberOperator listMemberOperator = new ListMemberOperator();
            listMemberOperator.addArgument(leftArg);
            for (int i = 0; i < listItemCount; ++i) {
                ValueExpr arg = (ValueExpr)node.jjtGetChild(i).jjtAccept(this, null);
                listMemberOperator.addArgument(arg);
            }
            result = listMemberOperator;
        }
        return result;
    }

    @Override
    public ValueExpr visit(ASTNotIn node, Object data) throws VisitorException {
        QueryModelNodeBase result = null;
        ValueExpr leftArg = (ValueExpr)data;
        int listItemCount = node.jjtGetNumChildren();
        if (listItemCount == 0) {
            result = new ValueConstant(BooleanLiteralImpl.TRUE);
        } else if (listItemCount == 1) {
            ValueExpr arg = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, null);
            result = new Compare(leftArg, arg, Compare.CompareOp.NE);
        } else {
            And and;
            And currentAnd = and = new And();
            for (int i = 0; i < listItemCount - 1; ++i) {
                ValueExpr arg = (ValueExpr)node.jjtGetChild(i).jjtAccept(this, null);
                currentAnd.setLeftArg(new Compare(leftArg, arg, Compare.CompareOp.NE));
                if (i == listItemCount - 2) {
                    arg = (ValueExpr)node.jjtGetChild(i + 1).jjtAccept(this, null);
                    currentAnd.setRightArg(new Compare(leftArg, arg, Compare.CompareOp.NE));
                    continue;
                }
                And newAnd = new And();
                currentAnd.setRightArg(newAnd);
                currentAnd = newAnd;
            }
            result = and;
        }
        return result;
    }

    @Override
    public Var visit(ASTVar node, Object data) throws VisitorException {
        Var var = new Var(node.getName());
        var.setAnonymous(node.isAnonymous());
        return var;
    }

    @Override
    public ValueConstant visit(ASTIRI node, Object data) throws VisitorException {
        URI uri;
        try {
            uri = this.valueFactory.createURI(node.getValue());
        }
        catch (IllegalArgumentException e) {
            throw new VisitorException(e.getMessage());
        }
        return new ValueConstant(uri);
    }

    @Override
    public Object visit(ASTQName node, Object data) throws VisitorException {
        throw new VisitorException("QNames must be resolved before building the query model");
    }

    @Override
    public Object visit(ASTBind node, Object data) throws VisitorException {
        ValueExpr ve = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, data);
        Node aliasNode = node.jjtGetChild(1);
        String alias = ((ASTVar)aliasNode).getName();
        Extension extension = new Extension();
        extension.addElement(new ExtensionElem(ve, alias));
        TupleExpr result = null;
        TupleExpr arg = this.graphPattern.buildTupleExpr();
        if (arg.getBindingNames().contains(alias)) {
            throw new VisitorException(String.format("BIND clause alias '{}' was previously used", alias));
        }
        if (arg instanceof Filter) {
            result = arg;
            while (((Filter)arg).getArg() instanceof Filter) {
                arg = ((Filter)arg).getArg();
            }
            extension.setArg(((Filter)arg).getArg());
            ((Filter)arg).setArg(extension);
        } else {
            extension.setArg(arg);
            result = extension;
        }
        GraphPattern replacementGP = new GraphPattern(this.graphPattern);
        replacementGP.addRequiredTE(result);
        this.graphPattern = replacementGP;
        return result;
    }

    @Override
    public Object visit(ASTBlankNode node, Object data) throws VisitorException {
        throw new VisitorException("Blank nodes must be replaced with variables before building the query model");
    }

    @Override
    public ValueConstant visit(ASTRDFLiteral node, Object data) throws VisitorException {
        Literal literal;
        String label = (String)node.getLabel().jjtAccept(this, null);
        String lang = node.getLang();
        ASTIRI datatypeNode = node.getDatatype();
        if (datatypeNode != null) {
            URI datatype;
            try {
                datatype = this.valueFactory.createURI(datatypeNode.getValue());
            }
            catch (IllegalArgumentException e) {
                throw new VisitorException(e.getMessage());
            }
            literal = this.valueFactory.createLiteral(label, datatype);
        } else {
            literal = lang != null ? this.valueFactory.createLiteral(label, lang) : this.valueFactory.createLiteral(label);
        }
        return new ValueConstant(literal);
    }

    @Override
    public ValueConstant visit(ASTNumericLiteral node, Object data) throws VisitorException {
        Literal literal = this.valueFactory.createLiteral(node.getValue(), node.getDatatype());
        return new ValueConstant(literal);
    }

    @Override
    public ValueConstant visit(ASTTrue node, Object data) throws VisitorException {
        return new ValueConstant(this.valueFactory.createLiteral(true));
    }

    @Override
    public ValueConstant visit(ASTFalse node, Object data) throws VisitorException {
        return new ValueConstant(this.valueFactory.createLiteral(false));
    }

    @Override
    public String visit(ASTString node, Object data) throws VisitorException {
        return node.getValue();
    }

    @Override
    public Object visit(ASTCount node, Object data) throws VisitorException {
        ValueExpr ve = null;
        if (node.jjtGetNumChildren() > 0) {
            ve = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, data);
        }
        return new Count(ve, node.isDistinct());
    }

    @Override
    public Object visit(ASTGroupConcat node, Object data) throws VisitorException {
        ValueExpr ve = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, data);
        GroupConcat gc = new GroupConcat(ve, node.isDistinct());
        if (node.jjtGetNumChildren() > 1) {
            ValueExpr separator = (ValueExpr)node.jjtGetChild(1).jjtAccept(this, data);
            gc.setSeparator(separator);
        }
        return gc;
    }

    @Override
    public Object visit(ASTMax node, Object data) throws VisitorException {
        ValueExpr ve = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, data);
        return new Max(ve, node.isDistinct());
    }

    @Override
    public Object visit(ASTMin node, Object data) throws VisitorException {
        ValueExpr ve = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, data);
        return new Min(ve, node.isDistinct());
    }

    @Override
    public Object visit(ASTSum node, Object data) throws VisitorException {
        ValueExpr ve = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, data);
        return new Sum(ve, node.isDistinct());
    }

    @Override
    public Object visit(ASTAvg node, Object data) throws VisitorException {
        ValueExpr ve = (ValueExpr)node.jjtGetChild(0).jjtAccept(this, data);
        return new Avg(ve, node.isDistinct());
    }

    static class AggregateOperatorReplacer
    extends QueryModelVisitorBase<VisitorException> {
        private Var replacement;
        private AggregateOperator operator;

        public AggregateOperatorReplacer(AggregateOperator operator, Var replacement) {
            this.operator = operator;
            this.replacement = replacement;
        }

        @Override
        public void meet(Avg node) throws VisitorException {
            super.meet(node);
            this.meetAggregate(node);
        }

        @Override
        public void meet(Count node) throws VisitorException {
            super.meet(node);
            this.meetAggregate(node);
        }

        @Override
        public void meet(GroupConcat node) throws VisitorException {
            super.meet(node);
            this.meetAggregate(node);
        }

        @Override
        public void meet(Max node) throws VisitorException {
            super.meet(node);
            this.meetAggregate(node);
        }

        @Override
        public void meet(Min node) throws VisitorException {
            super.meet(node);
            this.meetAggregate(node);
        }

        @Override
        public void meet(Sample node) throws VisitorException {
            super.meet(node);
            this.meetAggregate(node);
        }

        @Override
        public void meet(Sum node) throws VisitorException {
            super.meet(node);
            this.meetAggregate(node);
        }

        private void meetAggregate(AggregateOperator node) {
            if (node.equals(this.operator)) {
                node.getParentNode().replaceChildNode(node, this.replacement);
            }
        }
    }

    static class AggregateCollector
    extends QueryModelVisitorBase<VisitorException> {
        private Collection<AggregateOperator> operators = new ArrayList<AggregateOperator>();

        AggregateCollector() {
        }

        public Collection<AggregateOperator> getOperators() {
            return this.operators;
        }

        @Override
        public void meet(Avg node) throws VisitorException {
            super.meet(node);
            this.meetAggregate(node);
        }

        @Override
        public void meet(Count node) throws VisitorException {
            super.meet(node);
            this.meetAggregate(node);
        }

        @Override
        public void meet(GroupConcat node) throws VisitorException {
            super.meet(node);
            this.meetAggregate(node);
        }

        @Override
        public void meet(Max node) throws VisitorException {
            super.meet(node);
            this.meetAggregate(node);
        }

        @Override
        public void meet(Min node) throws VisitorException {
            super.meet(node);
            this.meetAggregate(node);
        }

        @Override
        public void meet(Sample node) throws VisitorException {
            super.meet(node);
            this.meetAggregate(node);
        }

        @Override
        public void meet(Sum node) throws VisitorException {
            super.meet(node);
            this.meetAggregate(node);
        }

        private void meetAggregate(AggregateOperator node) {
            this.operators.add(node);
        }
    }

    private class VarReplacer
    extends QueryModelVisitorBase<VisitorException> {
        private Var toBeReplaced;
        private Var replacement;

        public VarReplacer(Var toBeReplaced, Var replacement) {
            this.toBeReplaced = toBeReplaced;
            this.replacement = replacement;
        }

        @Override
        public void meet(Var var) {
            if (this.toBeReplaced.equals(var)) {
                QueryModelNode parent = var.getParentNode();
                parent.replaceChildNode(var, this.replacement);
                this.replacement.setParentNode(parent);
            }
        }
    }

    protected class VarCollector
    extends QueryModelVisitorBase<VisitorException> {
        private final Set<Var> collectedVars = new HashSet<Var>();

        protected VarCollector() {
        }

        @Override
        public void meet(Var var) {
            this.collectedVars.add(var);
        }

        public Set<Var> getCollectedVars() {
            return this.collectedVars;
        }
    }

    private class GroupFinder
    extends QueryModelVisitorBase<VisitorException> {
        private Group group;

        private GroupFinder() {
        }

        @Override
        public void meet(Projection projection) {
        }

        @Override
        public void meet(Group group) {
            this.group = group;
        }

        public Group getGroup() {
            return this.group;
        }
    }
}

