/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.rdfxml;

import info.aduna.net.ParsedURI;
import info.aduna.xml.XMLReaderFactory;
import info.aduna.xml.XMLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import javax.xml.transform.sax.SAXResult;
import org.apache.commons.io.input.BOMInputStream;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RioSetting;
import org.openrdf.rio.helpers.RDFParserBase;
import org.openrdf.rio.helpers.XMLParserSettings;
import org.openrdf.rio.rdfxml.Att;
import org.openrdf.rio.rdfxml.Atts;
import org.openrdf.rio.rdfxml.SAXFilter;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class RDFXMLParser
extends RDFParserBase
implements ErrorHandler {
    private SAXFilter saxFilter;
    private String documentURI;
    private String xmlLang;
    private Stack<Object> elementStack = new Stack();
    private Set<URI> usedIDs = new HashSet<URI>();

    public RDFXMLParser() {
        this.saxFilter = new SAXFilter(this);
    }

    public RDFXMLParser(ValueFactory valueFactory) {
        super(valueFactory);
        this.saxFilter = new SAXFilter(this);
    }

    @Override
    public final RDFFormat getRDFFormat() {
        return RDFFormat.RDFXML;
    }

    public void setParseStandAloneDocuments(boolean standAloneDocs) {
        this.getParserConfig().set(XMLParserSettings.PARSE_STANDALONE_DOCUMENTS, standAloneDocs);
    }

    public boolean getParseStandAloneDocuments() {
        return this.getParserConfig().get(XMLParserSettings.PARSE_STANDALONE_DOCUMENTS);
    }

    @Override
    public synchronized void parse(InputStream in, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        if (in == null) {
            throw new IllegalArgumentException("Input stream cannot be 'null'");
        }
        if (baseURI == null) {
            throw new IllegalArgumentException("Base URI cannot be 'null'");
        }
        InputSource inputSource = new InputSource(new BOMInputStream(in, false));
        inputSource.setSystemId(baseURI);
        this.parse(inputSource);
    }

    @Override
    public synchronized void parse(Reader reader, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        if (reader == null) {
            throw new IllegalArgumentException("Reader cannot be 'null'");
        }
        if (baseURI == null) {
            throw new IllegalArgumentException("Base URI cannot be 'null'");
        }
        InputSource inputSource = new InputSource(reader);
        inputSource.setSystemId(baseURI);
        this.parse(inputSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(InputSource inputSource) throws IOException, RDFParseException, RDFHandlerException {
        try {
            this.documentURI = inputSource.getSystemId();
            this.saxFilter.setParseStandAloneDocuments(this.getParserConfig().get(XMLParserSettings.PARSE_STANDALONE_DOCUMENTS));
            this.saxFilter.setDocumentURI(this.documentURI);
            XMLReader xmlReader = this.getParserConfig().isSet(XMLParserSettings.CUSTOM_XML_READER) ? this.getParserConfig().get(XMLParserSettings.CUSTOM_XML_READER) : XMLReaderFactory.createXMLReader();
            xmlReader.setContentHandler(this.saxFilter);
            xmlReader.setErrorHandler(this);
            for (RioSetting<Boolean> rioSetting : this.getCompulsoryXmlFeatureSettings()) {
                try {
                    xmlReader.setFeature(rioSetting.getKey(), this.getParserConfig().get(rioSetting));
                }
                catch (SAXNotRecognizedException e) {
                    this.reportWarning(String.format("%s is not a recognized SAX feature.", rioSetting.getKey()));
                }
                catch (SAXNotSupportedException e) {
                    this.reportWarning(String.format("%s is not a supported SAX feature.", rioSetting.getKey()));
                }
            }
            for (RioSetting<Boolean> rioSetting : this.getCompulsoryXmlPropertySettings()) {
                try {
                    xmlReader.setProperty(rioSetting.getKey(), this.getParserConfig().get(rioSetting));
                }
                catch (SAXNotRecognizedException e) {
                    this.reportWarning(String.format("%s is not a recognized SAX property.", rioSetting.getKey()));
                }
                catch (SAXNotSupportedException e) {
                    this.reportWarning(String.format("%s is not a supported SAX property.", rioSetting.getKey()));
                }
            }
            for (RioSetting<Boolean> rioSetting : this.getOptionalXmlFeatureSettings()) {
                try {
                    if (!this.getParserConfig().isSet(rioSetting)) continue;
                    xmlReader.setFeature(rioSetting.getKey(), this.getParserConfig().get(rioSetting));
                }
                catch (SAXNotRecognizedException e) {
                    this.reportWarning(String.format("%s is not a recognized SAX feature.", rioSetting.getKey()));
                }
                catch (SAXNotSupportedException e) {
                    this.reportWarning(String.format("%s is not a supported SAX feature.", rioSetting.getKey()));
                }
            }
            for (RioSetting<Boolean> rioSetting : this.getOptionalXmlPropertySettings()) {
                try {
                    if (!this.getParserConfig().isSet(rioSetting)) continue;
                    xmlReader.setProperty(rioSetting.getKey(), this.getParserConfig().get(rioSetting));
                }
                catch (SAXNotRecognizedException e) {
                    this.reportWarning(String.format("%s is not a recognized SAX property.", rioSetting.getKey()));
                }
                catch (SAXNotSupportedException e) {
                    this.reportWarning(String.format("%s is not a supported SAX property.", rioSetting.getKey()));
                }
            }
            xmlReader.parse(inputSource);
        }
        catch (SAXParseException e) {
            Exception wrappedExc = e.getException();
            if (wrappedExc == null) {
                this.reportFatalError(e, e.getLineNumber(), e.getColumnNumber());
            } else {
                this.reportFatalError(wrappedExc, e.getLineNumber(), e.getColumnNumber());
            }
        }
        catch (SAXException e) {
            Exception wrappedExc = e.getException();
            if (wrappedExc == null) {
                this.reportFatalError(e);
            } else {
                if (wrappedExc instanceof RDFParseException) {
                    throw (RDFParseException)wrappedExc;
                }
                if (wrappedExc instanceof RDFHandlerException) {
                    throw (RDFHandlerException)wrappedExc;
                }
                this.reportFatalError(wrappedExc);
            }
        }
        finally {
            this.saxFilter.clear();
            this.xmlLang = null;
            this.elementStack.clear();
            this.usedIDs.clear();
            this.clear();
        }
    }

    public Collection<RioSetting<?>> getCompulsoryXmlPropertySettings() {
        return Collections.emptyList();
    }

    public Collection<RioSetting<Boolean>> getCompulsoryXmlFeatureSettings() {
        HashSet<RioSetting<Boolean>> results = new HashSet<RioSetting<Boolean>>();
        results.add(XMLParserSettings.SECURE_PROCESSING);
        return results;
    }

    public Collection<RioSetting<?>> getOptionalXmlPropertySettings() {
        return Collections.emptyList();
    }

    public Collection<RioSetting<Boolean>> getOptionalXmlFeatureSettings() {
        HashSet<RioSetting<Boolean>> results = new HashSet<RioSetting<Boolean>>();
        results.add(XMLParserSettings.LOAD_EXTERNAL_DTD);
        return results;
    }

    @Override
    public Collection<RioSetting<?>> getSupportedSettings() {
        HashSet results = new HashSet(super.getSupportedSettings());
        results.addAll(this.getCompulsoryXmlPropertySettings());
        results.addAll(this.getCompulsoryXmlFeatureSettings());
        results.addAll(this.getOptionalXmlPropertySettings());
        results.addAll(this.getOptionalXmlFeatureSettings());
        results.add(XMLParserSettings.CUSTOM_XML_READER);
        results.add(XMLParserSettings.FAIL_ON_DUPLICATE_RDF_ID);
        results.add(XMLParserSettings.FAIL_ON_INVALID_NCNAME);
        results.add(XMLParserSettings.FAIL_ON_INVALID_QNAME);
        results.add(XMLParserSettings.FAIL_ON_MISMATCHED_TAGS);
        results.add(XMLParserSettings.FAIL_ON_NON_STANDARD_ATTRIBUTES);
        results.add(XMLParserSettings.FAIL_ON_SAX_NON_FATAL_ERRORS);
        results.add(XMLParserSettings.PARSE_STANDALONE_DOCUMENTS);
        return results;
    }

    public SAXResult getSAXResult(String baseURI) {
        if (baseURI == null) {
            throw new IllegalArgumentException("Base URI cannot be 'null'");
        }
        this.documentURI = baseURI;
        this.saxFilter.setDocumentURI(baseURI);
        return new SAXResult(this.saxFilter);
    }

    void startDocument() throws RDFParseException, RDFHandlerException {
        if (this.rdfHandler != null) {
            this.rdfHandler.startRDF();
        }
    }

    void endDocument() throws RDFParseException, RDFHandlerException {
        if (this.rdfHandler != null) {
            this.rdfHandler.endRDF();
        }
    }

    @Override
    protected void setBaseURI(ParsedURI baseURI) {
        super.setBaseURI(baseURI);
    }

    void setXMLLang(String xmlLang) {
        this.xmlLang = "".equals(xmlLang) ? null : xmlLang;
    }

    void startElement(String namespaceURI, String localName, String qName, Atts atts) throws RDFParseException, RDFHandlerException {
        if (this.topIsProperty()) {
            this.processNodeElt(namespaceURI, localName, qName, atts, false);
        } else {
            this.processPropertyElt(namespaceURI, localName, qName, atts, false);
        }
    }

    void endElement(String namespaceURI, String localName, String qName) throws RDFParseException, RDFHandlerException {
        Object topElement = this.peekStack(0);
        if (topElement instanceof NodeElement) {
            if (((NodeElement)topElement).isVolatile()) {
                this.elementStack.pop();
            }
        } else {
            PropertyElement predicate = (PropertyElement)topElement;
            if (predicate.parseCollection()) {
                Resource lastListResource = predicate.getLastListResource();
                if (lastListResource == null) {
                    NodeElement subject = (NodeElement)this.peekStack(1);
                    this.reportStatement(subject.getResource(), predicate.getURI(), RDF.NIL);
                    this.handleReification(RDF.NIL);
                } else {
                    this.reportStatement(lastListResource, RDF.REST, RDF.NIL);
                }
            }
        }
        this.elementStack.pop();
    }

    void emptyElement(String namespaceURI, String localName, String qName, Atts atts) throws RDFParseException, RDFHandlerException {
        if (this.topIsProperty()) {
            this.processNodeElt(namespaceURI, localName, qName, atts, true);
        } else {
            this.processPropertyElt(namespaceURI, localName, qName, atts, true);
        }
    }

    void text(String text) throws RDFParseException, RDFHandlerException {
        if (!this.topIsProperty()) {
            this.reportError("unexpected literal", XMLParserSettings.FAIL_ON_NON_STANDARD_ATTRIBUTES);
            return;
        }
        PropertyElement propEl = (PropertyElement)this.peekStack(0);
        URI datatype = propEl.getDatatype();
        Literal lit = this.createLiteral(text, this.xmlLang, datatype);
        NodeElement subject = (NodeElement)this.peekStack(1);
        PropertyElement predicate = (PropertyElement)this.peekStack(0);
        this.reportStatement(subject.getResource(), predicate.getURI(), lit);
        this.handleReification(lit);
    }

    private void processNodeElt(String namespaceURI, String localName, String qName, Atts atts, boolean isEmptyElt) throws RDFParseException, RDFHandlerException {
        Att type;
        if (this.getParserConfig().get(XMLParserSettings.FAIL_ON_NON_STANDARD_ATTRIBUTES).booleanValue()) {
            this.checkNodeEltName(namespaceURI, localName, qName);
        }
        Resource nodeResource = this.getNodeResource(atts);
        NodeElement nodeElement = new NodeElement(nodeResource);
        if (!this.elementStack.isEmpty()) {
            NodeElement subject = (NodeElement)this.peekStack(1);
            PropertyElement predicate = (PropertyElement)this.peekStack(0);
            if (predicate.parseCollection()) {
                Resource lastListRes = predicate.getLastListResource();
                BNode newListRes = this.createBNode();
                if (lastListRes == null) {
                    this.reportStatement(subject.getResource(), predicate.getURI(), newListRes);
                    this.handleReification(newListRes);
                } else {
                    this.reportStatement(lastListRes, RDF.REST, newListRes);
                }
                this.reportStatement(newListRes, RDF.FIRST, nodeResource);
                predicate.setLastListResource(newListRes);
            } else {
                this.reportStatement(subject.getResource(), predicate.getURI(), nodeResource);
                this.handleReification(nodeResource);
            }
        }
        if (!localName.equals("Description") || !namespaceURI.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#")) {
            URI className = null;
            className = "".equals(namespaceURI) ? this.buildResourceFromLocalName(localName) : this.createURI(namespaceURI + localName);
            this.reportStatement(nodeResource, RDF.TYPE, className);
        }
        if ((type = atts.removeAtt("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "type")) != null) {
            URI className = this.resolveURI(type.getValue());
            this.reportStatement(nodeResource, RDF.TYPE, className);
        }
        if (this.getParserConfig().get(XMLParserSettings.FAIL_ON_NON_STANDARD_ATTRIBUTES).booleanValue()) {
            this.checkRDFAtts(atts);
        }
        this.processSubjectAtts(nodeElement, atts);
        if (!isEmptyElt) {
            this.elementStack.push(nodeElement);
        }
    }

    private Resource getNodeResource(Atts atts) throws RDFParseException {
        Att id = atts.removeAtt("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "ID");
        Att about = atts.removeAtt("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about");
        Att nodeID = atts.removeAtt("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "nodeID");
        if (this.getParserConfig().get(XMLParserSettings.FAIL_ON_NON_STANDARD_ATTRIBUTES).booleanValue()) {
            int definedAttsCount = 0;
            if (id != null) {
                ++definedAttsCount;
            }
            if (about != null) {
                ++definedAttsCount;
            }
            if (nodeID != null) {
                ++definedAttsCount;
            }
            if (definedAttsCount > 1) {
                this.reportError("Only one of the attributes rdf:ID, rdf:about or rdf:nodeID can be used here", XMLParserSettings.FAIL_ON_NON_STANDARD_ATTRIBUTES);
            }
        }
        Resource result = null;
        result = id != null ? this.buildURIFromID(id.getValue()) : (about != null ? this.resolveURI(about.getValue()) : (nodeID != null ? this.createBNode(nodeID.getValue()) : this.createBNode()));
        return result;
    }

    private void processSubjectAtts(NodeElement nodeElt, Atts atts) throws RDFParseException, RDFHandlerException {
        Resource subject = nodeElt.getResource();
        Iterator<Att> iter2 = atts.iterator();
        while (iter2.hasNext()) {
            Att att = iter2.next();
            URI predicate = this.createURI(att.getURI());
            Literal lit = this.createLiteral(att.getValue(), this.xmlLang, null);
            this.reportStatement(subject, predicate, lit);
        }
    }

    private void processPropertyElt(String namespaceURI, String localName, String qName, Atts atts, boolean isEmptyElt) throws RDFParseException, RDFHandlerException {
        Att parseType;
        if (this.getParserConfig().get(XMLParserSettings.FAIL_ON_NON_STANDARD_ATTRIBUTES).booleanValue()) {
            this.checkPropertyEltName(namespaceURI, localName, qName, XMLParserSettings.FAIL_ON_NON_STANDARD_ATTRIBUTES);
        }
        URI propURI = null;
        if (namespaceURI.equals("")) {
            this.reportError("unqualified property element <" + qName + "> not allowed", XMLParserSettings.FAIL_ON_INVALID_QNAME);
            propURI = this.buildResourceFromLocalName(localName);
        } else {
            propURI = this.createURI(namespaceURI + localName);
        }
        if (propURI.equals(RDF.LI)) {
            NodeElement subject = (NodeElement)this.peekStack(0);
            propURI = this.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#_" + subject.getNextLiCounter());
        }
        PropertyElement predicate = new PropertyElement(propURI);
        this.elementStack.push(predicate);
        Att id = atts.removeAtt("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "ID");
        if (id != null) {
            URI reifURI = this.buildURIFromID(id.getValue());
            predicate.setReificationURI(reifURI);
        }
        if ((parseType = atts.removeAtt("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "parseType")) != null) {
            String parseTypeValue;
            if (this.getParserConfig().get(XMLParserSettings.FAIL_ON_NON_STANDARD_ATTRIBUTES).booleanValue()) {
                this.checkNoMoreAtts(atts);
            }
            if ((parseTypeValue = parseType.getValue()).equals("Resource")) {
                BNode objectResource = this.createBNode();
                NodeElement subject = (NodeElement)this.peekStack(1);
                this.reportStatement(subject.getResource(), propURI, objectResource);
                if (isEmptyElt) {
                    this.handleReification(objectResource);
                } else {
                    NodeElement object = new NodeElement(objectResource);
                    object.setIsVolatile(true);
                    this.elementStack.push(object);
                }
            } else if (parseTypeValue.equals("Collection")) {
                if (isEmptyElt) {
                    NodeElement subject = (NodeElement)this.peekStack(1);
                    this.reportStatement(subject.getResource(), propURI, RDF.NIL);
                    this.handleReification(RDF.NIL);
                } else {
                    predicate.setParseCollection(true);
                }
            } else {
                if (!parseTypeValue.equals("Literal")) {
                    this.reportWarning("unknown parseType: " + parseType.getValue());
                }
                if (isEmptyElt) {
                    NodeElement subject = (NodeElement)this.peekStack(1);
                    Literal lit = this.createLiteral("", null, RDF.XMLLITERAL);
                    this.reportStatement(subject.getResource(), propURI, lit);
                    this.handleReification(lit);
                } else {
                    predicate.setDatatype(RDF.XMLLITERAL);
                    this.saxFilter.setParseLiteralMode();
                }
            }
        } else if (isEmptyElt) {
            Att datatype = atts.getAtt("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "datatype");
            if (atts.size() == 0 || atts.size() == 1 && datatype != null) {
                NodeElement subject = (NodeElement)this.peekStack(1);
                URI dtURI = null;
                if (datatype != null) {
                    dtURI = this.createURI(datatype.getValue());
                }
                Literal lit = this.createLiteral("", this.xmlLang, dtURI);
                this.reportStatement(subject.getResource(), propURI, lit);
                this.handleReification(lit);
            } else {
                Resource resourceRes = this.getPropertyResource(atts);
                if (this.getParserConfig().get(XMLParserSettings.FAIL_ON_NON_STANDARD_ATTRIBUTES).booleanValue()) {
                    this.checkRDFAtts(atts);
                }
                NodeElement resourceElt = new NodeElement(resourceRes);
                NodeElement subject = (NodeElement)this.peekStack(1);
                this.reportStatement(subject.getResource(), propURI, resourceRes);
                this.handleReification(resourceRes);
                Att type = atts.removeAtt("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "type");
                if (type != null) {
                    URI className = this.resolveURI(type.getValue());
                    this.reportStatement(resourceRes, RDF.TYPE, className);
                }
                this.processSubjectAtts(resourceElt, atts);
            }
        } else {
            Att datatype = atts.removeAtt("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "datatype");
            if (datatype != null) {
                URI dtURI = this.resolveURI(datatype.getValue());
                predicate.setDatatype(dtURI);
            }
            if (this.getParserConfig().get(XMLParserSettings.FAIL_ON_NON_STANDARD_ATTRIBUTES).booleanValue()) {
                this.checkNoMoreAtts(atts);
            }
        }
        if (isEmptyElt) {
            this.elementStack.pop();
        }
    }

    private Resource getPropertyResource(Atts atts) throws RDFParseException {
        Att resource = atts.removeAtt("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource");
        Att nodeID = atts.removeAtt("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "nodeID");
        if (this.getParserConfig().get(XMLParserSettings.FAIL_ON_NON_STANDARD_ATTRIBUTES).booleanValue()) {
            int definedAttsCount = 0;
            if (resource != null) {
                ++definedAttsCount;
            }
            if (nodeID != null) {
                ++definedAttsCount;
            }
            if (definedAttsCount > 1) {
                this.reportError("Only one of the attributes rdf:resource or rdf:nodeID can be used here", XMLParserSettings.FAIL_ON_NON_STANDARD_ATTRIBUTES);
            }
        }
        Resource result = null;
        result = resource != null ? this.resolveURI(resource.getValue()) : (nodeID != null ? this.createBNode(nodeID.getValue()) : this.createBNode());
        return result;
    }

    private void handleReification(Value value) throws RDFParseException, RDFHandlerException {
        PropertyElement predicate = (PropertyElement)this.peekStack(0);
        if (predicate.isReified()) {
            NodeElement subject = (NodeElement)this.peekStack(1);
            URI reifRes = predicate.getReificationURI();
            this.reifyStatement(reifRes, subject.getResource(), predicate.getURI(), value);
        }
    }

    private void reifyStatement(Resource reifNode, Resource subj, URI pred, Value obj) throws RDFParseException, RDFHandlerException {
        this.reportStatement(reifNode, RDF.TYPE, RDF.STATEMENT);
        this.reportStatement(reifNode, RDF.SUBJECT, subj);
        this.reportStatement(reifNode, RDF.PREDICATE, pred);
        this.reportStatement(reifNode, RDF.OBJECT, obj);
    }

    private URI buildResourceFromLocalName(String localName) throws RDFParseException {
        return this.resolveURI("#" + localName);
    }

    private URI buildURIFromID(String id) throws RDFParseException {
        if (this.getParserConfig().get(XMLParserSettings.FAIL_ON_INVALID_NCNAME).booleanValue() && !XMLUtil.isNCName(id)) {
            this.reportError("Not an XML Name: " + id, XMLParserSettings.FAIL_ON_INVALID_NCNAME);
        }
        URI uri = this.resolveURI("#" + id);
        if (this.getParserConfig().get(XMLParserSettings.FAIL_ON_DUPLICATE_RDF_ID).booleanValue() && !this.usedIDs.add(uri)) {
            this.reportError("ID '" + id + "' has already been defined", XMLParserSettings.FAIL_ON_DUPLICATE_RDF_ID);
        }
        return uri;
    }

    @Override
    protected BNode createBNode(String nodeID) throws RDFParseException {
        if (this.getParserConfig().get(XMLParserSettings.FAIL_ON_INVALID_NCNAME).booleanValue() && !XMLUtil.isNCName(nodeID)) {
            this.reportError("Not an XML Name: " + nodeID, XMLParserSettings.FAIL_ON_INVALID_NCNAME);
        }
        return super.createBNode(nodeID);
    }

    private Object peekStack(int distFromTop) {
        return this.elementStack.get(this.elementStack.size() - 1 - distFromTop);
    }

    private boolean topIsProperty() {
        return this.elementStack.isEmpty() || this.peekStack(0) instanceof PropertyElement;
    }

    private void checkNodeEltName(String namespaceURI, String localName, String qName) throws RDFParseException {
        if (!(!"http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(namespaceURI) || localName.equals("Description") || localName.equals("Seq") || localName.equals("Bag") || localName.equals("Alt") || localName.equals("Statement") || localName.equals("Property") || localName.equals("List") || localName.equals("subject") || localName.equals("predicate") || localName.equals("object") || localName.equals("type") || localName.equals("value") || localName.equals("first") || localName.equals("rest") || localName.equals("nil") || localName.startsWith("_"))) {
            if (localName.equals("li") || localName.equals("RDF") || localName.equals("ID") || localName.equals("about") || localName.equals("parseType") || localName.equals("resource") || localName.equals("nodeID") || localName.equals("datatype")) {
                this.reportError("<" + qName + "> not allowed as node element", XMLParserSettings.FAIL_ON_NON_STANDARD_ATTRIBUTES);
            } else if (localName.equals("bagID") || localName.equals("aboutEach") || localName.equals("aboutEachPrefix")) {
                this.reportError(qName + " is no longer a valid RDF name", XMLParserSettings.FAIL_ON_NON_STANDARD_ATTRIBUTES);
            } else {
                this.reportWarning("unknown rdf element <" + qName + ">");
            }
        }
    }

    private void checkPropertyEltName(String namespaceURI, String localName, String qName, RioSetting<Boolean> setting) throws RDFParseException {
        if (!(!"http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(namespaceURI) || localName.equals("li") || localName.equals("Seq") || localName.equals("Bag") || localName.equals("Alt") || localName.equals("Statement") || localName.equals("Property") || localName.equals("List") || localName.equals("subject") || localName.equals("predicate") || localName.equals("object") || localName.equals("type") || localName.equals("value") || localName.equals("first") || localName.equals("rest") || localName.equals("nil") || localName.startsWith("_"))) {
            if (localName.equals("Description") || localName.equals("RDF") || localName.equals("ID") || localName.equals("about") || localName.equals("parseType") || localName.equals("resource") || localName.equals("nodeID") || localName.equals("datatype")) {
                this.reportError("<" + qName + "> not allowed as property element", setting);
            } else if (localName.equals("bagID") || localName.equals("aboutEach") || localName.equals("aboutEachPrefix")) {
                this.reportError(qName + " is no longer a valid RDF name", setting);
            } else {
                this.reportWarning("unknown rdf element <" + qName + ">");
            }
        }
    }

    private void checkRDFAtts(Atts atts) throws RDFParseException {
        Iterator<Att> iter2 = atts.iterator();
        while (iter2.hasNext()) {
            String localName;
            Att att = iter2.next();
            if (!"http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(att.getNamespace()) || (localName = att.getLocalName()).equals("Seq") || localName.equals("Bag") || localName.equals("Alt") || localName.equals("Statement") || localName.equals("Property") || localName.equals("List") || localName.equals("subject") || localName.equals("predicate") || localName.equals("object") || localName.equals("type") || localName.equals("value") || localName.equals("first") || localName.equals("rest") || localName.equals("nil") || localName.startsWith("_")) continue;
            if (localName.equals("Description") || localName.equals("li") || localName.equals("RDF") || localName.equals("ID") || localName.equals("about") || localName.equals("parseType") || localName.equals("resource") || localName.equals("nodeID") || localName.equals("datatype")) {
                this.reportError("'" + att.getQName() + "' not allowed as attribute name", XMLParserSettings.FAIL_ON_NON_STANDARD_ATTRIBUTES);
                iter2.remove();
                continue;
            }
            if (localName.equals("bagID") || localName.equals("aboutEach") || localName.equals("aboutEachPrefix")) {
                this.reportError(att.getQName() + " is no longer a valid RDF name", XMLParserSettings.FAIL_ON_NON_STANDARD_ATTRIBUTES);
                continue;
            }
            this.reportWarning("unknown rdf attribute '" + att.getQName() + "'");
        }
    }

    private void checkNoMoreAtts(Atts atts) throws RDFParseException {
        if (atts.size() > 0) {
            Iterator<Att> iter2 = atts.iterator();
            while (iter2.hasNext()) {
                Att att = iter2.next();
                this.reportError("unexpected attribute '" + att.getQName() + "'", XMLParserSettings.FAIL_ON_NON_STANDARD_ATTRIBUTES);
                iter2.remove();
            }
        }
    }

    private void reportStatement(Resource subject, URI predicate, Value object) throws RDFParseException, RDFHandlerException {
        Statement st = this.createStatement(subject, predicate, object);
        if (this.rdfHandler != null) {
            this.rdfHandler.handleStatement(st);
        }
    }

    @Override
    protected Literal createLiteral(String label, String lang, URI datatype) throws RDFParseException {
        Locator locator = this.saxFilter.getLocator();
        if (locator != null) {
            return this.createLiteral(label, lang, datatype, locator.getLineNumber(), locator.getColumnNumber());
        }
        return this.createLiteral(label, lang, datatype, -1, -1);
    }

    @Override
    protected void reportWarning(String msg) {
        Locator locator = this.saxFilter.getLocator();
        if (locator != null) {
            this.reportWarning(msg, locator.getLineNumber(), locator.getColumnNumber());
        } else {
            this.reportWarning(msg, -1, -1);
        }
    }

    @Override
    protected void reportError(String msg, RioSetting<Boolean> setting) throws RDFParseException {
        Locator locator = this.saxFilter.getLocator();
        if (locator != null) {
            this.reportError(msg, locator.getLineNumber(), locator.getColumnNumber(), setting);
        } else {
            this.reportError(msg, -1, -1, setting);
        }
    }

    @Override
    protected void reportFatalError(String msg) throws RDFParseException {
        Locator locator = this.saxFilter.getLocator();
        if (locator != null) {
            this.reportFatalError(msg, locator.getLineNumber(), locator.getColumnNumber());
        } else {
            this.reportFatalError(msg, -1, -1);
        }
    }

    @Override
    protected void reportFatalError(Exception e) throws RDFParseException {
        Locator locator = this.saxFilter.getLocator();
        if (locator != null) {
            this.reportFatalError(e, locator.getLineNumber(), locator.getColumnNumber());
        } else {
            this.reportFatalError(e, -1, -1);
        }
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        this.reportWarning(exception.getMessage());
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        try {
            this.reportError(exception.getMessage(), XMLParserSettings.FAIL_ON_SAX_NON_FATAL_ERRORS);
        }
        catch (RDFParseException rdfpe) {
            throw new SAXException(rdfpe);
        }
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        try {
            this.reportFatalError(exception.getMessage());
        }
        catch (RDFParseException rdfpe) {
            throw new SAXException(rdfpe);
        }
    }

    static class PropertyElement {
        private URI uri;
        private URI reificationURI;
        private URI datatype;
        private boolean parseCollection = false;
        private Resource lastListResource;

        public PropertyElement(URI uri) {
            this.uri = uri;
        }

        public URI getURI() {
            return this.uri;
        }

        public boolean isReified() {
            return this.reificationURI != null;
        }

        public void setReificationURI(URI reifURI) {
            this.reificationURI = reifURI;
        }

        public URI getReificationURI() {
            return this.reificationURI;
        }

        public void setDatatype(URI datatype) {
            this.datatype = datatype;
        }

        public URI getDatatype() {
            return this.datatype;
        }

        public boolean parseCollection() {
            return this.parseCollection;
        }

        public void setParseCollection(boolean parseCollection) {
            this.parseCollection = parseCollection;
        }

        public Resource getLastListResource() {
            return this.lastListResource;
        }

        public void setLastListResource(Resource resource) {
            this.lastListResource = resource;
        }
    }

    static class NodeElement {
        private Resource resource;
        private boolean isVolatile = false;
        private int liCounter = 1;

        public NodeElement(Resource resource) {
            this.resource = resource;
        }

        public Resource getResource() {
            return this.resource;
        }

        public void setIsVolatile(boolean isVolatile) {
            this.isVolatile = isVolatile;
        }

        public boolean isVolatile() {
            return this.isVolatile;
        }

        public int getNextLiCounter() {
            return this.liCounter++;
        }
    }
}

