/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.inferencer.fc.config;

import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrdf.OpenRDFException;
import org.openrdf.model.BNode;
import org.openrdf.model.Graph;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.util.GraphUtil;
import org.openrdf.model.util.GraphUtilException;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.SP;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.parser.QueryParserUtil;
import org.openrdf.sail.config.DelegatingSailImplConfigBase;
import org.openrdf.sail.config.SailConfigException;
import org.openrdf.sail.config.SailImplConfig;
import org.openrdf.sail.inferencer.fc.config.CustomGraphQueryInferencerSchema;

public final class CustomGraphQueryInferencerConfig
extends DelegatingSailImplConfigBase {
    public static final Pattern SPARQL_PATTERN;
    public static final Pattern SERQL_PATTERN;
    private QueryLanguage language;
    private String ruleQuery;
    private String matcherQuery;

    public CustomGraphQueryInferencerConfig() {
        super("openrdf:CustomGraphQueryInferencer");
    }

    public CustomGraphQueryInferencerConfig(SailImplConfig delegate) {
        super("openrdf:CustomGraphQueryInferencer", delegate);
    }

    public void setQueryLanguage(QueryLanguage language) {
        this.language = language;
    }

    public QueryLanguage getQueryLanguage() {
        return this.language;
    }

    public void setRuleQuery(String ruleQuery) {
        this.ruleQuery = ruleQuery;
    }

    public String getRuleQuery() {
        return this.ruleQuery;
    }

    public void setMatcherQuery(String matcherQuery) {
        this.matcherQuery = null == matcherQuery ? "" : matcherQuery;
    }

    public String getMatcherQuery() {
        return this.matcherQuery;
    }

    @Override
    public void parse(Graph graph, Resource implNode) throws SailConfigException {
        super.parse(graph, implNode);
        try {
            Literal language = GraphUtil.getOptionalObjectLiteral(graph, implNode, CustomGraphQueryInferencerSchema.QUERY_LANGUAGE);
            if (null == language) {
                this.setQueryLanguage(QueryLanguage.SPARQL);
            } else {
                this.setQueryLanguage(QueryLanguage.valueOf(language.stringValue()));
                if (null == this.getQueryLanguage()) {
                    throw new SailConfigException("Valid value required for " + CustomGraphQueryInferencerSchema.QUERY_LANGUAGE + " property, found " + language);
                }
            }
            Iterator<Value> iter2 = GraphUtil.getObjectIterator(graph, implNode, CustomGraphQueryInferencerSchema.RULE_QUERY, new Resource[0]);
            if (iter2.hasNext()) {
                this.setRuleQuery(GraphUtil.getUniqueObjectLiteral(graph, (Resource)iter2.next(), SP.TEXT_PROPERTY).stringValue());
            }
            if ((iter2 = GraphUtil.getObjectIterator(graph, implNode, CustomGraphQueryInferencerSchema.MATCHER_QUERY, new Resource[0])).hasNext()) {
                this.setMatcherQuery(GraphUtil.getUniqueObjectLiteral(graph, (Resource)iter2.next(), SP.TEXT_PROPERTY).stringValue());
            }
        }
        catch (GraphUtilException e) {
            throw new SailConfigException(e.getMessage(), e);
        }
    }

    @Override
    public void validate() throws SailConfigException {
        super.validate();
        if (null == this.language) {
            throw new SailConfigException("No query language specified for " + this.getType() + " Sail.");
        }
        if (null == this.ruleQuery) {
            throw new SailConfigException("No rule query specified for " + this.getType() + " Sail.");
        }
        try {
            QueryParserUtil.parseGraphQuery(this.language, this.ruleQuery, null);
        }
        catch (OpenRDFException e) {
            throw new SailConfigException("Problem occured parsing supplied rule query.", e);
        }
        try {
            if (this.matcherQuery.trim().isEmpty()) {
                this.matcherQuery = CustomGraphQueryInferencerConfig.buildMatcherQueryFromRuleQuery(this.language, this.ruleQuery);
            }
            QueryParserUtil.parseGraphQuery(this.language, this.matcherQuery, null);
        }
        catch (OpenRDFException e) {
            throw new SailConfigException("Problem occured parsing matcher query: " + this.matcherQuery, e);
        }
    }

    @Override
    public Resource export(Graph graph) {
        Resource implNode = super.export(graph);
        if (null != this.language) {
            graph.add(implNode, CustomGraphQueryInferencerSchema.QUERY_LANGUAGE, ValueFactoryImpl.getInstance().createLiteral(this.language.getName()), new Resource[0]);
        }
        this.addQueryNode(graph, implNode, CustomGraphQueryInferencerSchema.RULE_QUERY, this.ruleQuery);
        this.addQueryNode(graph, implNode, CustomGraphQueryInferencerSchema.MATCHER_QUERY, this.matcherQuery);
        return implNode;
    }

    public static String buildMatcherQueryFromRuleQuery(QueryLanguage language, String ruleQuery) throws MalformedQueryException {
        String result = "";
        if (QueryLanguage.SPARQL == language) {
            Matcher matcher = SPARQL_PATTERN.matcher(ruleQuery);
            if (matcher.matches()) {
                result = matcher.group(1) + "WHERE" + matcher.group(2);
            }
        } else if (QueryLanguage.SERQL == language) {
            Matcher matcher = SERQL_PATTERN.matcher(ruleQuery);
            if (matcher.matches()) {
                result = "CONSTRUCT * FROM" + matcher.group(1) + matcher.group(2);
            }
        } else {
            throw new IllegalStateException("language");
        }
        return result;
    }

    private void addQueryNode(Graph graph, Resource implNode, URI predicate, String queryText) {
        if (null != queryText) {
            ValueFactoryImpl factory = ValueFactoryImpl.getInstance();
            BNode queryNode = factory.createBNode();
            graph.add(implNode, predicate, queryNode, new Resource[0]);
            graph.add(queryNode, RDF.TYPE, SP.CONSTRUCT_CLASS, new Resource[0]);
            graph.add(queryNode, SP.TEXT_PROPERTY, factory.createLiteral(queryText), new Resource[0]);
        }
    }

    static {
        int flags = 34;
        SPARQL_PATTERN = Pattern.compile("^(.*construct\\s+)(\\{.*\\}\\s*)where.*$", flags);
        SERQL_PATTERN = Pattern.compile("^\\s*construct(\\s+.*)from\\s+.*(\\s+using\\s+namespace.*)$", flags);
    }
}

