/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.inferencer.fc.config;

import org.openrdf.OpenRDFException;
import org.openrdf.sail.Sail;
import org.openrdf.sail.config.SailConfigException;
import org.openrdf.sail.config.SailFactory;
import org.openrdf.sail.config.SailImplConfig;
import org.openrdf.sail.inferencer.fc.CustomGraphQueryInferencer;
import org.openrdf.sail.inferencer.fc.config.CustomGraphQueryInferencerConfig;

public class CustomGraphQueryInferencerFactory
implements SailFactory {
    public static final String SAIL_TYPE = "openrdf:CustomGraphQueryInferencer";

    @Override
    public String getSailType() {
        return SAIL_TYPE;
    }

    @Override
    public SailImplConfig getConfig() {
        return new CustomGraphQueryInferencerConfig();
    }

    @Override
    public Sail getSail(SailImplConfig config) throws SailConfigException {
        if (!SAIL_TYPE.equals(config.getType())) {
            throw new SailConfigException("Invalid Sail type: " + config.getType());
        }
        CustomGraphQueryInferencer sail = new CustomGraphQueryInferencer();
        if (config instanceof CustomGraphQueryInferencerConfig) {
            CustomGraphQueryInferencerConfig customConfig = (CustomGraphQueryInferencerConfig)config;
            try {
                sail.setFields(customConfig.getQueryLanguage(), customConfig.getRuleQuery(), customConfig.getMatcherQuery());
            }
            catch (OpenRDFException e) {
                throw new SailConfigException("Problem occured parsing rule or matcher query text.", e);
            }
        }
        return sail;
    }
}

