/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.postgresql;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.dbcp.BasicDataSource;
import org.openrdf.sail.SailException;
import org.openrdf.sail.rdbms.RdbmsStore;
import org.openrdf.sail.rdbms.exceptions.RdbmsException;
import org.openrdf.sail.rdbms.postgresql.PgSqlConnectionFactory;

@Deprecated
public class PgSqlStore
extends RdbmsStore {
    private String serverName;
    private String databaseName;
    private int portNumber;
    private Map<String, String> properties = Collections.emptyMap();
    private String user;
    private String password;

    public PgSqlStore() {
    }

    public PgSqlStore(String databaseName) {
        this.setDatabaseName(databaseName);
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = new HashMap<String, String>(properties);
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public void initialize() throws SailException {
        try {
            Class.forName("org.postgresql.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new RdbmsException(e.toString(), e);
        }
        StringBuilder url = new StringBuilder();
        url.append("jdbc:postgresql:");
        if (this.serverName != null) {
            url.append("//").append(this.serverName);
            if (this.portNumber > 0) {
                url.append(":").append(this.portNumber);
            }
            url.append("/");
        }
        url.append(this.databaseName);
        Iterator<Map.Entry<String, String>> iter2 = this.getProperties().entrySet().iterator();
        if (iter2.hasNext()) {
            url.append("?");
        }
        while (iter2.hasNext()) {
            Map.Entry<String, String> e = iter2.next();
            url.append(this.enc(e.getKey()));
            url.append("=");
            url.append(this.enc(e.getValue()));
            if (!iter2.hasNext()) continue;
            url.append("&");
        }
        BasicDataSource ds = new BasicDataSource();
        ds.setUrl(url.toString());
        if (this.user != null) {
            ds.setUsername(this.user);
        } else {
            ds.setUsername(System.getProperty("user.name"));
        }
        if (this.password != null) {
            ds.setPassword(this.password);
        }
        PgSqlConnectionFactory factory = new PgSqlConnectionFactory();
        factory.setSail(this);
        factory.setDataSource(ds);
        this.setBasicDataSource(ds);
        this.setConnectionFactory(factory);
        super.initialize();
    }

    private String enc(String text) {
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }
}

