/*
 * Decompiled with CFR 0.152.
 */
package org.semarglproject.rdf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.semarglproject.rdf.ParseException;
import org.semarglproject.rdf.ProcessorGraphHandler;
import org.semarglproject.ri.MalformedIriException;
import org.semarglproject.ri.RIUtils;
import org.semarglproject.sink.Pipe;
import org.semarglproject.sink.TripleSink;
import org.semarglproject.sink.XmlSink;
import org.semarglproject.xml.XmlUtils;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public final class RdfXmlParser
extends Pipe<TripleSink>
implements XmlSink {
    public static final String ERROR = "http://semarglproject.org/ntriples/Error";
    private static final String IS_NOT_ALLOWED_HERE = " is not allowed here";
    private static final short INSIDE_OF_PROPERTY = 1;
    private static final short INSIDE_OF_RESOURCE = 2;
    private static final short PARSE_TYPE_LITERAL = 3;
    private static final short PARSE_TYPE_COLLECTION = 4;
    private static final short PARSE_TYPE_RESOURCE = 5;
    private static final short ERROR_RECOVERY = 6;
    private static final String ID_ATTR = "ID";
    private static final String NODE_ID_ATTR = "nodeID";
    private static final String ABOUT_ATTR = "about";
    private static final String PARSE_LITERAL_VALUE = "Literal";
    private static final String PARSE_RESOURCE_VALUE = "Resource";
    private static final String PARSE_COLLECTION_VALUE = "Collection";
    private short mode = 0;
    private String baseUri = "";
    private final Stack<Short> modeStack = new Stack();
    private final Stack<String> langStack = new Stack();
    private final Stack<String> baseStack = new Stack();
    private final Stack<String> subjStack = new Stack();
    private final Stack<Integer> subjLiIndexStack = new Stack();
    private final Map<String, String> nsMappings = new HashMap<String, String>();
    private final Set<String> processedIDs = new HashSet<String>();
    private int bnodeId = 0;
    private String subjRes = null;
    private String seqTailRes = null;
    private String predIri = null;
    private String datatypeIri = null;
    private String reifyIri = null;
    private boolean captureLiteral = false;
    private int parseDepth = 0;
    private StringBuilder parse = new StringBuilder();
    private ProcessorGraphHandler processorGraphHandler = null;
    private boolean ignoreErrors = false;
    private List<String> pendingTriples = new ArrayList<String>();

    private RdfXmlParser(TripleSink sink) {
        super(sink);
    }

    public static XmlSink connect(TripleSink sink) {
        return new RdfXmlParser(sink);
    }

    private void error(String msg) throws SAXException {
        if (this.processorGraphHandler != null) {
            this.processorGraphHandler.error(ERROR, msg);
        }
        if (!this.ignoreErrors) {
            throw new SAXException(new ParseException(msg));
        }
        this.modeStack.push(this.mode);
        this.mode = (short)6;
    }

    private boolean violatesSchema(String nodeIri) {
        return nodeIri == null || nodeIri.isEmpty() || nodeIri.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#parseType") || nodeIri.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#aboutEach") || nodeIri.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#datatype") || nodeIri.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#bagID") || nodeIri.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#about") || nodeIri.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#resource") || nodeIri.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#nodeID") || nodeIri.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#ID") || nodeIri.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#aboutEachPrefix");
    }

    @Override
    public void startElement(String nsUri, String lname, String qname, Attributes attrs) throws SAXException {
        this.processPendingTriples(true);
        this.modeStack.push(this.mode);
        if (this.parseDepth > 0) {
            ++this.parseDepth;
            if (this.mode == 3) {
                this.parse.append(XmlUtils.serializeOpenTag(nsUri, qname, this.nsMappings, attrs, true));
                this.nsMappings.clear();
                return;
            }
        }
        if (this.mode == 6) {
            return;
        }
        this.processLangAndBase(attrs);
        String iri = nsUri + lname;
        if (this.subjRes == null && (nsUri == null || nsUri.isEmpty()) || iri.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#RDF")) {
            return;
        }
        if (this.violatesSchema(iri)) {
            this.error(qname + IS_NOT_ALLOWED_HERE);
        }
        switch (this.mode) {
            case 1: 
            case 4: {
                this.subjRes = this.getSubject(attrs);
                if (this.subjRes == null) {
                    return;
                }
                if (this.mode != 4 && !this.subjStack.isEmpty()) {
                    this.processNonLiteralTriple(this.subjStack.peek(), this.predIri, this.subjRes);
                }
                if (!iri.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#Description")) {
                    if (iri.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#li")) {
                        this.error(qname + IS_NOT_ALLOWED_HERE);
                    } else {
                        ((TripleSink)this.sink).addNonLiteral(this.subjRes, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", iri);
                    }
                }
                this.processResourceAttrs(qname, attrs);
                this.subjStack.push(this.subjRes);
                this.subjLiIndexStack.push(1);
                if (this.mode != 1) break;
                this.mode = (short)2;
                break;
            }
            case 2: 
            case 5: {
                int liIndex = this.subjLiIndexStack.pop();
                boolean correctProperty = this.checkPropertyForErrors(qname, iri, attrs);
                if (!correctProperty) {
                    return;
                }
                this.predIri = iri;
                if (this.predIri.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#li")) {
                    this.predIri = "http://www.w3.org/1999/02/22-rdf-syntax-ns#_" + liIndex++;
                }
                this.subjLiIndexStack.push(liIndex);
                String nodeId = attrs.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", ID_ATTR);
                if (nodeId != null) {
                    this.reifyIri = this.resolveIRINoResolve(this.baseStack.peek(), nodeId);
                }
                this.captureLiteral = true;
                this.mode = 1;
                this.processPropertyAttrs(nsUri, attrs);
                if (!this.captureLiteral) break;
                this.parse = new StringBuilder();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown mode = " + this.mode);
            }
        }
    }

    private void processPendingTriples(boolean forceNewBNode) {
        Iterator<String> iterator = this.pendingTriples.iterator();
        while (iterator.hasNext()) {
            String propRes = iterator.next();
            String attr = iterator.next();
            String value = iterator.next();
            if (forceNewBNode || propRes == null) {
                String bnode = this.newBnode();
                this.processNonLiteralTriple(this.subjRes, this.predIri, bnode);
                ((TripleSink)this.sink).addPlainLiteral(bnode, attr, value, this.langStack.peek());
                continue;
            }
            ((TripleSink)this.sink).addPlainLiteral(propRes, attr, value, this.langStack.peek());
        }
        this.pendingTriples.clear();
    }

    private boolean checkPropertyForErrors(String qname, String iri, Attributes attrs) throws SAXException {
        if (iri.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil") || iri.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#Description")) {
            this.error(qname + IS_NOT_ALLOWED_HERE);
            return false;
        }
        if (!RIUtils.isIri(iri)) {
            this.error("Invalid property IRI");
            return false;
        }
        if (attrs.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource") != null && attrs.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", NODE_ID_ATTR) != null) {
            this.error("Both rdf:resource and rdf:nodeID are present");
            return false;
        }
        if (attrs.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "parseType") != null && !this.isAttrsValidForParseType(attrs)) {
            this.error("rdf:parseType conflicts with other attributes");
            return false;
        }
        return true;
    }

    private void processResourceAttrs(String qname, Attributes attrs) throws SAXException {
        for (int i = 0; i < attrs.getLength(); ++i) {
            String tag = attrs.getURI(i) + attrs.getLocalName(i);
            if (tag.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#nodeID") || tag.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#about") || tag.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#ID") || attrs.getQName(i).startsWith("xml")) continue;
            String value = attrs.getValue(i);
            if (tag.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type")) {
                ((TripleSink)this.sink).addNonLiteral(this.subjRes, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", value);
                continue;
            }
            if (this.violatesSchema(tag) || tag.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#li")) {
                this.error(qname + IS_NOT_ALLOWED_HERE);
                continue;
            }
            ((TripleSink)this.sink).addPlainLiteral(this.subjRes, tag, value, this.langStack.peek());
        }
    }

    private void processPropertyAttrs(String nsUri, Attributes attrs) throws SAXException {
        int resIdx = attrs.getIndex("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource");
        String propertyRes = null;
        if (resIdx >= 0) {
            propertyRes = this.processPropertyRes(attrs.getValue(resIdx));
        }
        for (int i = 0; i < attrs.getLength(); ++i) {
            if (i == resIdx) continue;
            String attr = attrs.getURI(i) + attrs.getLocalName(i);
            if (attrs.getQName(i).startsWith("xml") || attr.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#ID")) continue;
            this.processPropertyTagAttr(nsUri, attr, attrs.getValue(i), propertyRes);
        }
    }

    private void processLangAndBase(Attributes attrs) throws SAXException {
        String lang = this.langStack.peek();
        if (attrs.getValue("xml:lang") != null) {
            lang = attrs.getValue("xml:lang");
        }
        this.langStack.push(lang);
        String base = this.baseStack.peek();
        if (attrs.getValue("xml:base") != null) {
            base = attrs.getValue("xml:base");
            if (base.contains("#")) {
                base = base.substring(0, base.lastIndexOf(35));
            }
            if (!RIUtils.isAbsoluteIri(base = base + '#')) {
                this.error("Invalid base IRI");
                base = this.baseStack.peek();
            }
        }
        this.baseStack.push(base);
    }

    private String processPropertyRes(String value) throws SAXException {
        String propertyRes = this.resolveIRI(this.baseStack.peek(), value);
        if (propertyRes != null) {
            this.processNonLiteralTriple(this.subjRes, this.predIri, propertyRes);
            this.captureLiteral = false;
        }
        return propertyRes;
    }

    private void processPropertyTagAttr(String nsUri, String attr, String value, String propertyRes) throws SAXException {
        if (attr.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#datatype")) {
            this.datatypeIri = this.resolveIRINoResolve(nsUri, value);
        } else if (attr.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#parseType")) {
            this.parseDepth = 1;
            if (value.equalsIgnoreCase(PARSE_LITERAL_VALUE)) {
                this.parse = new StringBuilder();
                this.mode = (short)3;
            } else if (value.equalsIgnoreCase(PARSE_RESOURCE_VALUE)) {
                String bnode = this.newBnode();
                this.processNonLiteralTriple(this.subjRes, this.predIri, bnode);
                this.subjRes = bnode;
                this.subjStack.push(this.subjRes);
                this.subjLiIndexStack.push(1);
                this.mode = (short)5;
            } else if (value.equalsIgnoreCase(PARSE_COLLECTION_VALUE)) {
                String bnode = this.newBnode();
                ((TripleSink)this.sink).addNonLiteral(this.subjRes, this.predIri, bnode);
                this.subjRes = bnode;
                this.seqTailRes = null;
                this.subjStack.push(bnode);
                this.subjLiIndexStack.push(1);
                this.mode = (short)4;
            }
            this.captureLiteral = false;
        } else if (attr.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#nodeID")) {
            if (!XmlUtils.isValidNCName(value)) {
                this.error("Invalid nodeID");
            } else {
                String id = "_:n" + value.hashCode();
                this.processNonLiteralTriple(this.subjRes, this.predIri, id);
                this.captureLiteral = false;
            }
        } else if (this.violatesSchema(attr) || attr.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil")) {
            this.error(attr + IS_NOT_ALLOWED_HERE);
        } else {
            this.pendingTriples.add(propertyRes);
            this.pendingTriples.add(attr);
            this.pendingTriples.add(value);
            this.captureLiteral = false;
        }
    }

    @Override
    public void endElement(String namespaceUri, String lname, String qname) throws SAXException {
        this.processPendingTriples(false);
        if (this.parseDepth > 0) {
            --this.parseDepth;
            if (this.mode == 3 && this.parseDepth > 0) {
                this.parse.append("</").append(qname).append(">");
                return;
            }
        }
        if (this.subjStack.isEmpty()) {
            return;
        }
        switch (this.mode) {
            case 2: 
            case 5: {
                this.subjStack.pop();
                if (!this.subjStack.isEmpty()) {
                    this.subjRes = this.subjStack.peek();
                }
                this.subjLiIndexStack.pop();
                if (this.mode == 2) {
                    this.mode = 1;
                    break;
                }
                this.mode = (short)2;
                break;
            }
            case 4: {
                this.subjStack.pop();
                this.subjLiIndexStack.pop();
                if (this.parseDepth > 0) {
                    if (this.seqTailRes == null) {
                        this.seqTailRes = this.subjStack.peek();
                        ((TripleSink)this.sink).addNonLiteral(this.seqTailRes, "http://www.w3.org/1999/02/22-rdf-syntax-ns#first", this.subjRes);
                        break;
                    }
                    String bnode = this.newBnode();
                    ((TripleSink)this.sink).addNonLiteral(this.seqTailRes, "http://www.w3.org/1999/02/22-rdf-syntax-ns#rest", bnode);
                    ((TripleSink)this.sink).addNonLiteral(bnode, "http://www.w3.org/1999/02/22-rdf-syntax-ns#first", this.subjRes);
                    this.seqTailRes = bnode;
                    break;
                }
                ((TripleSink)this.sink).addNonLiteral(this.seqTailRes, "http://www.w3.org/1999/02/22-rdf-syntax-ns#rest", "http://www.w3.org/1999/02/22-rdf-syntax-ns#nil");
                if (!this.subjStack.isEmpty()) {
                    this.subjRes = this.subjStack.peek();
                }
                this.mode = (short)2;
                break;
            }
            case 1: {
                if (this.captureLiteral) {
                    String value = this.parse.toString();
                    if (this.datatypeIri != null) {
                        this.processLiteralTriple(this.subjRes, this.predIri, value, this.datatypeIri, true);
                    } else {
                        this.processLiteralTriple(this.subjRes, this.predIri, value, this.langStack.peek(), false);
                    }
                    this.captureLiteral = false;
                }
                this.mode = (short)2;
                break;
            }
            case 3: {
                this.processLiteralTriple(this.subjRes, this.predIri, this.parse.toString(), "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral", true);
                this.mode = (short)2;
                break;
            }
            case 6: {
                this.mode = this.modeStack.pop();
                return;
            }
            default: {
                throw new IllegalStateException("Unknown mode = " + this.mode);
            }
        }
        this.langStack.pop();
        this.baseStack.pop();
        short savedMode = this.modeStack.pop();
        if (savedMode == 5) {
            this.mode = savedMode;
        }
    }

    private boolean isAttrsValidForParseType(Attributes attrs) {
        for (int i = 0; i < attrs.getLength(); ++i) {
            String uri;
            if (attrs.getQName(i).startsWith("xml") || (uri = attrs.getURI(i) + attrs.getLocalName(i)).equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#parseType") || uri.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#ID")) continue;
            return false;
        }
        return true;
    }

    private void processNonLiteralTriple(String subj, String pred, String obj) {
        ((TripleSink)this.sink).addNonLiteral(subj, pred, obj);
        if (this.reifyIri != null) {
            ((TripleSink)this.sink).addNonLiteral(this.reifyIri, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://www.w3.org/1999/02/22-rdf-syntax-ns#Statement");
            ((TripleSink)this.sink).addNonLiteral(this.reifyIri, "http://www.w3.org/1999/02/22-rdf-syntax-ns#subject", subj);
            ((TripleSink)this.sink).addNonLiteral(this.reifyIri, "http://www.w3.org/1999/02/22-rdf-syntax-ns#predicate", pred);
            ((TripleSink)this.sink).addNonLiteral(this.reifyIri, "http://www.w3.org/1999/02/22-rdf-syntax-ns#object", obj);
            this.reifyIri = null;
        }
    }

    private void processLiteralTriple(String subj, String pred, String value, String langOrDt, boolean typed) {
        if (typed) {
            ((TripleSink)this.sink).addTypedLiteral(subj, pred, value, langOrDt);
        } else {
            ((TripleSink)this.sink).addPlainLiteral(subj, pred, value, langOrDt);
        }
        if (this.reifyIri != null) {
            ((TripleSink)this.sink).addNonLiteral(this.reifyIri, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://www.w3.org/1999/02/22-rdf-syntax-ns#Statement");
            ((TripleSink)this.sink).addNonLiteral(this.reifyIri, "http://www.w3.org/1999/02/22-rdf-syntax-ns#subject", subj);
            ((TripleSink)this.sink).addNonLiteral(this.reifyIri, "http://www.w3.org/1999/02/22-rdf-syntax-ns#predicate", pred);
            if (typed) {
                ((TripleSink)this.sink).addTypedLiteral(this.reifyIri, "http://www.w3.org/1999/02/22-rdf-syntax-ns#object", value, langOrDt);
            } else {
                ((TripleSink)this.sink).addPlainLiteral(this.reifyIri, "http://www.w3.org/1999/02/22-rdf-syntax-ns#object", value, langOrDt);
            }
            this.reifyIri = null;
        }
    }

    private String getSubject(Attributes attrs) throws SAXException {
        int count = 0;
        String result = null;
        String attrValue = attrs.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", ABOUT_ATTR);
        if (attrValue != null && (result = this.resolveIRI(this.baseStack.peek(), attrValue)) != null) {
            ++count;
        }
        if ((attrValue = attrs.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", ID_ATTR)) != null && (result = this.resolveIRINoResolve(this.baseStack.peek(), attrValue)) != null) {
            if (this.processedIDs.contains(result)) {
                this.error("Duplicate definition for resource ID = " + result);
                return null;
            }
            this.processedIDs.add(result);
            ++count;
        }
        if ((attrValue = attrs.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", NODE_ID_ATTR)) != null) {
            result = "_:n" + attrValue.hashCode();
            ++count;
        }
        if (count == 0) {
            return this.newBnode();
        }
        if (count > 1) {
            this.error("Ambiguous identifier definition");
            return null;
        }
        return result;
    }

    private String newBnode() {
        ++this.bnodeId;
        return "_:n" + this.bnodeId;
    }

    private String resolveIRINoResolve(String baseIri, String iri) throws SAXException {
        if (RIUtils.isAbsoluteIri(iri)) {
            return iri;
        }
        if (!XmlUtils.isValidNCName(iri)) {
            this.error("Vocab term must be a valid NCName");
            return null;
        }
        String result = baseIri + iri;
        if (RIUtils.isAbsoluteIri(result)) {
            return result;
        }
        this.error("Malformed IRI: " + iri);
        return null;
    }

    private String resolveIRI(String baseIri, String iri) throws SAXException {
        try {
            return RIUtils.resolveIri(baseIri, iri);
        }
        catch (MalformedIriException e) {
            this.error(e.getMessage());
            return null;
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.mode = 1;
        ((TripleSink)this.sink).setBaseUri(this.baseUri);
        this.baseStack.push(this.baseUri);
        this.langStack.push(null);
        this.captureLiteral = false;
        this.subjRes = null;
        this.seqTailRes = null;
        this.predIri = null;
        this.datatypeIri = null;
        this.reifyIri = null;
        this.parseDepth = 0;
    }

    @Override
    public void endDocument() throws SAXException {
        this.langStack.clear();
        this.baseStack.clear();
        this.subjStack.clear();
        this.modeStack.clear();
        this.subjLiIndexStack.clear();
        this.nsMappings.clear();
        this.processedIDs.clear();
        this.parse = new StringBuilder();
        this.pendingTriples.clear();
    }

    @Override
    public void characters(char[] buffer, int offset, int length) throws SAXException {
        this.processPendingTriples(true);
        if (this.mode == 3 || this.captureLiteral) {
            this.parse.append(String.copyValueOf(buffer, offset, length));
        }
    }

    @Override
    public void ignorableWhitespace(char[] buffer, int offset, int length) throws SAXException {
        this.characters(buffer, offset, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.processPendingTriples(true);
        if (this.parseDepth > 0 && this.mode == 3) {
            this.parse.append("<?").append(target).append(" ").append(data).append("?>");
        }
    }

    @Override
    public void comment(char[] buffer, int offset, int length) throws SAXException {
        this.processPendingTriples(true);
        if (this.parseDepth > 0 && this.mode == 3) {
            this.parse.append("<!--");
            this.parse.append(String.copyValueOf(buffer, offset, length));
            this.parse.append("-->");
        }
    }

    @Override
    public void startPrefixMapping(String abbr, String uri) throws SAXException {
        if (this.mode == 3) {
            this.nsMappings.put(abbr, uri);
        }
    }

    @Override
    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri != null && !baseUri.isEmpty() && Character.isLetter(baseUri.charAt(baseUri.length() - 1)) ? baseUri + "#" : (baseUri == null ? "" : baseUri);
    }

    @Override
    public void setDocumentLocator(Locator arg0) {
    }

    @Override
    public void skippedEntity(String arg0) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String arg0) throws SAXException {
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void endEntity(String arg0) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void startDTD(String arg0, String arg1, String arg2) throws SAXException {
    }

    @Override
    public void startEntity(String arg0) throws SAXException {
    }

    @Override
    public ParseException processException(SAXException e) {
        Throwable cause = e.getCause();
        if (cause instanceof ParseException) {
            return (ParseException)cause;
        }
        return new ParseException(e);
    }

    @Override
    protected boolean setPropertyInternal(String key, Object value) {
        if ("http://semarglproject.org/core/properties/processor-graph-handler".equals(key) && value instanceof ProcessorGraphHandler) {
            this.processorGraphHandler = (ProcessorGraphHandler)value;
        } else if ("http://semarglproject.org/core/properties/enable-error-recovery".equals(key) && value instanceof Boolean) {
            this.ignoreErrors = (Boolean)value;
        }
        return false;
    }
}

