/*
 * Decompiled with CFR 0.152.
 */
package org.semarglproject.sesame.core.sink;

import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.semarglproject.rdf.ParseException;
import org.semarglproject.sink.QuadSink;

public class SesameSink
implements QuadSink {
    public static final String RDF_HANDLER_PROPERTY = "http://semarglproject.org/sesame/properties/rdf-handler";
    public static final String VALUE_FACTORY_PROPERTY = "http://semarglproject.org/sesame/properties/value-factory";
    protected RDFHandler handler;
    protected ValueFactory valueFactory = ValueFactoryImpl.getInstance();

    protected SesameSink(RDFHandler handler) {
        this.handler = handler;
    }

    public static QuadSink connect(RDFHandler handler) {
        return new SesameSink(handler);
    }

    private Resource convertNonLiteral(String arg) {
        if (arg.startsWith("_:")) {
            return this.valueFactory.createBNode(arg.substring(2));
        }
        return this.valueFactory.createURI(arg);
    }

    @Override
    public final void addNonLiteral(String subj, String pred, String obj) {
        this.addTriple(this.convertNonLiteral(subj), this.valueFactory.createURI(pred), this.convertNonLiteral(obj));
    }

    @Override
    public final void addPlainLiteral(String subj, String pred, String content, String lang) {
        if (lang == null) {
            this.addTriple(this.convertNonLiteral(subj), this.valueFactory.createURI(pred), this.valueFactory.createLiteral(content));
        } else {
            this.addTriple(this.convertNonLiteral(subj), this.valueFactory.createURI(pred), this.valueFactory.createLiteral(content, lang));
        }
    }

    @Override
    public final void addTypedLiteral(String subj, String pred, String content, String type) {
        Literal literal = this.valueFactory.createLiteral(content, this.valueFactory.createURI(type));
        this.addTriple(this.convertNonLiteral(subj), this.valueFactory.createURI(pred), literal);
    }

    protected void addTriple(Resource subject, URI predicate, Value object) {
        try {
            this.handler.handleStatement(this.valueFactory.createStatement(subject, predicate, object));
        }
        catch (RDFHandlerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final void addNonLiteral(String subj, String pred, String obj, String graph) {
        if (graph == null) {
            this.addNonLiteral(subj, pred, obj);
        } else {
            this.addQuad(this.convertNonLiteral(subj), this.valueFactory.createURI(pred), this.convertNonLiteral(obj), this.convertNonLiteral(graph));
        }
    }

    @Override
    public final void addPlainLiteral(String subj, String pred, String content, String lang, String graph) {
        if (graph == null) {
            this.addPlainLiteral(subj, pred, content, lang);
        } else if (lang == null) {
            this.addQuad(this.convertNonLiteral(subj), this.valueFactory.createURI(pred), this.valueFactory.createLiteral(content), this.convertNonLiteral(graph));
        } else {
            this.addQuad(this.convertNonLiteral(subj), this.valueFactory.createURI(pred), this.valueFactory.createLiteral(content, lang), this.convertNonLiteral(graph));
        }
    }

    @Override
    public final void addTypedLiteral(String subj, String pred, String content, String type, String graph) {
        if (graph == null) {
            this.addTypedLiteral(subj, pred, content, type);
        } else {
            Literal literal = this.valueFactory.createLiteral(content, this.valueFactory.createURI(type));
            this.addQuad(this.convertNonLiteral(subj), this.valueFactory.createURI(pred), literal, this.convertNonLiteral(graph));
        }
    }

    protected void addQuad(Resource subject, URI predicate, Value object, Resource graph) {
        try {
            this.handler.handleStatement(this.valueFactory.createStatement(subject, predicate, object, graph));
        }
        catch (RDFHandlerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void startStream() throws ParseException {
        try {
            this.handler.startRDF();
        }
        catch (RDFHandlerException e) {
            throw new ParseException(e);
        }
    }

    @Override
    public void endStream() throws ParseException {
        try {
            this.handler.endRDF();
        }
        catch (RDFHandlerException e) {
            throw new ParseException(e);
        }
    }

    @Override
    public boolean setProperty(String key, Object value) {
        if (RDF_HANDLER_PROPERTY.equals(key) && value instanceof RDFHandler) {
            this.handler = (RDFHandler)value;
        } else if (VALUE_FACTORY_PROPERTY.equals(key) && value instanceof ValueFactory) {
            this.valueFactory = (ValueFactory)value;
        } else {
            return false;
        }
        return true;
    }

    @Override
    public void setBaseUri(String baseUri) {
    }
}

