/*
 * Decompiled with CFR 0.152.
 */
package org.semarglproject.sesame.rdf.rdfa;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import org.openrdf.model.ValueFactory;
import org.openrdf.rio.ParseErrorListener;
import org.openrdf.rio.ParseLocationListener;
import org.openrdf.rio.ParserConfig;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.RioSetting;
import org.openrdf.rio.helpers.BasicParserSettings;
import org.openrdf.rio.helpers.RDFaParserSettings;
import org.openrdf.rio.helpers.RDFaVersion;
import org.semarglproject.rdf.ParseException;
import org.semarglproject.rdf.ProcessorGraphHandler;
import org.semarglproject.rdf.rdfa.RdfaParser;
import org.semarglproject.sesame.core.sink.SesameSink;
import org.semarglproject.sesame.rdf.rdfa.SemarglParserSettings;
import org.semarglproject.source.StreamProcessor;
import org.xml.sax.XMLReader;

public final class SesameRDFaParser
implements RDFParser,
ProcessorGraphHandler {
    private ParserConfig parserConfig;
    private final StreamProcessor streamProcessor = new StreamProcessor(RdfaParser.connect(SesameSink.connect(null)));
    private ParseErrorListener parseErrorListener;

    public SesameRDFaParser() {
        this.streamProcessor.setProperty("http://semarglproject.org/core/properties/processor-graph-handler", this);
        this.setParserConfig(new ParserConfig());
        this.setPreserveBNodeIDs(true);
        this.parseErrorListener = null;
    }

    public SesameRDFaParser(XMLReader xmlReader) {
        this();
        this.setXmlReader(xmlReader);
    }

    @Override
    public RDFFormat getRDFFormat() {
        return RDFFormat.RDFA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputStream in, String baseURI) throws RDFParseException, RDFHandlerException {
        InputStreamReader reader = new InputStreamReader(in, Charset.forName("UTF-8"));
        try {
            this.parse(reader, baseURI);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {}
        }
    }

    @Override
    public void parse(Reader reader, String baseURI) throws RDFParseException, RDFHandlerException {
        this.refreshSettings();
        try {
            this.streamProcessor.process(reader, baseURI);
        }
        catch (ParseException e) {
            throw new RDFParseException(e);
        }
    }

    @Override
    public void setValueFactory(ValueFactory valueFactory) {
        this.streamProcessor.setProperty("http://semarglproject.org/sesame/properties/value-factory", valueFactory);
    }

    @Override
    public void setRDFHandler(RDFHandler handler) {
        this.streamProcessor.setProperty("http://semarglproject.org/sesame/properties/rdf-handler", handler);
    }

    @Override
    public void setParseErrorListener(ParseErrorListener el) {
        this.parseErrorListener = el;
    }

    @Override
    public void setParseLocationListener(ParseLocationListener ll) {
    }

    @Override
    public void setParserConfig(ParserConfig config) {
        this.parserConfig = config;
        this.refreshSettings();
    }

    @Override
    public ParserConfig getParserConfig() {
        return this.parserConfig;
    }

    @Override
    public Collection<RioSetting<?>> getSupportedSettings() {
        ArrayList result = new ArrayList(5);
        result.add(BasicParserSettings.PRESERVE_BNODE_IDS);
        result.add(SemarglParserSettings.PROCESSOR_GRAPH_ENABLED);
        result.add(RDFaParserSettings.VOCAB_EXPANSION_ENABLED);
        result.add(RDFaParserSettings.RDFA_COMPATIBILITY);
        result.add(SemarglParserSettings.CUSTOM_XML_READER);
        return result;
    }

    @Override
    public void setVerifyData(boolean verifyData) {
    }

    @Override
    public void setPreserveBNodeIDs(boolean preserveBNodeIDs) {
        this.parserConfig.set(BasicParserSettings.PRESERVE_BNODE_IDS, preserveBNodeIDs);
        this.refreshSettings();
    }

    @Override
    public void setStopAtFirstError(boolean stopAtFirstError) {
    }

    @Override
    public void setDatatypeHandling(RDFParser.DatatypeHandling datatypeHandling) {
    }

    public void setProcessorGraphEnabled(boolean processorGraphEnabled) {
        this.parserConfig.set(SemarglParserSettings.PROCESSOR_GRAPH_ENABLED, processorGraphEnabled);
        this.refreshSettings();
    }

    public void setVocabExpansionEnabled(boolean vocabExpansionEnabled) {
        this.parserConfig.set(RDFaParserSettings.VOCAB_EXPANSION_ENABLED, vocabExpansionEnabled);
        this.refreshSettings();
    }

    public void setRdfaCompatibility(short rdfaCompatibility) {
        RDFaVersion version = RDFaVersion.RDFA_1_1;
        if (rdfaCompatibility == 1) {
            version = RDFaVersion.RDFA_1_0;
        } else if (rdfaCompatibility == 2) {
            version = RDFaVersion.RDFA_1_1;
        }
        this.setRdfaCompatibility(version);
    }

    public void setRdfaCompatibility(RDFaVersion version) {
        this.parserConfig.set(RDFaParserSettings.RDFA_COMPATIBILITY, version);
        this.refreshSettings();
    }

    public void setXmlReader(XMLReader reader) {
        this.parserConfig.set(SemarglParserSettings.CUSTOM_XML_READER, reader);
        this.refreshSettings();
    }

    private void refreshSettings() {
        short rdfaCompatibility = 2;
        RDFaVersion version = this.parserConfig.get(RDFaParserSettings.RDFA_COMPATIBILITY);
        if (version == RDFaVersion.RDFA_1_0) {
            rdfaCompatibility = 1;
        } else if (version == RDFaVersion.RDFA_1_1) {
            rdfaCompatibility = 2;
        }
        this.streamProcessor.setProperty("http://semarglproject.org/rdfa/properties/version", rdfaCompatibility);
        this.streamProcessor.setProperty("http://semarglproject.org/rdfa/properties/enable-vocab-expansion", this.parserConfig.get(RDFaParserSettings.VOCAB_EXPANSION_ENABLED));
        this.streamProcessor.setProperty("http://semarglproject.org/rdfa/properties/enable-processor-graph", this.parserConfig.get(SemarglParserSettings.PROCESSOR_GRAPH_ENABLED));
        this.streamProcessor.setProperty("http://semarglproject.org/core/properties/xml-parser", this.parserConfig.get(SemarglParserSettings.CUSTOM_XML_READER));
    }

    @Override
    public void info(String infoClass, String message) {
    }

    @Override
    public void warning(String warningClass, String message) {
        if (this.parseErrorListener != null) {
            this.parseErrorListener.warning(message, -1, -1);
        }
    }

    @Override
    public void error(String errorClass, String message) {
        if (this.parseErrorListener != null) {
            this.parseErrorListener.error(message, -1, -1);
        }
    }
}

