/*
 * Decompiled with CFR 0.152.
 */
package arq;

import arq.cmdline.CmdUpdate;
import java.io.OutputStream;
import java.util.List;
import jena.cmd.ArgDecl;
import jena.cmd.CmdException;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.core.TransactionalNull;
import org.apache.jena.update.UpdateExecutionFactory;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;

public class update
extends CmdUpdate {
    static final ArgDecl updateArg = new ArgDecl(true, "update", "file");
    static final ArgDecl dumpArg = new ArgDecl(false, "dump");
    List<String> requestFiles = null;
    boolean dump = false;

    public static void main(String ... argv) {
        new update(argv).mainRun();
    }

    protected update(String[] argv) {
        super(argv);
        super.add(updateArg, "--update=FILE", "Update commands to execute");
        super.add(dumpArg, "--dump", "Dump the resulting graph store");
    }

    @Override
    protected void processModulesAndArgs() {
        this.requestFiles = this.getValues(updateArg);
        this.dump = this.contains(dumpArg);
        super.processModulesAndArgs();
    }

    @Override
    protected String getCommandName() {
        return Lib.className(this);
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + " --desc=assembler [--dump] --update=<request file>";
    }

    @Override
    protected void execUpdate(DatasetGraph graphStore) {
        if (this.requestFiles.size() == 0 && this.getPositional().size() == 0) {
            throw new CmdException("Nothing to do");
        }
        Transactional transactional = graphStore instanceof Transactional ? (Transactional)((Object)graphStore) : new TransactionalNull();
        for (String filename : this.requestFiles) {
            try {
                transactional.begin(ReadWrite.WRITE);
                this.execOneFile(filename, graphStore);
                transactional.commit();
            }
            catch (Throwable ex) {
                try {
                    transactional.abort();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw ex;
            }
            finally {
                transactional.end();
            }
        }
        for (String requestString : super.getPositional()) {
            requestString = this.indirect(requestString);
            try {
                transactional.begin(ReadWrite.WRITE);
                this.execOne(requestString, graphStore);
                transactional.commit();
            }
            catch (Throwable ex) {
                try {
                    transactional.abort();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw ex;
            }
            finally {
                transactional.end();
            }
        }
        SystemARQ.sync(graphStore);
        if (this.dump) {
            RDFDataMgr.write((OutputStream)System.out, graphStore, Lang.NQUADS);
        }
    }

    private void execOneFile(String filename, DatasetGraph store) {
        UpdateRequest req = UpdateFactory.read(filename, this.updateSyntax);
        UpdateExecutionFactory.create(req, store).execute();
    }

    private void execOne(String requestString, DatasetGraph store) {
        UpdateRequest req = UpdateFactory.create(requestString, this.updateSyntax);
        UpdateExecutionFactory.create(req, store).execute();
    }

    @Override
    protected DatasetGraph dealWithNoDataset() {
        return DatasetGraphFactory.create();
    }
}

