/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query;

import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.iri.IRI;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryException;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;

public class ParameterizedSparqlString
implements PrefixMapping {
    private Model model = ModelFactory.createDefaultModel();
    private StringBuilder cmd = new StringBuilder();
    private String baseUri;
    private Map<String, Node> params = new HashMap<String, Node>();
    private Map<Integer, Node> positionalParams = new HashMap<Integer, Node>();
    private PrefixMapping prefixes;

    public ParameterizedSparqlString(String command, QuerySolutionMap map, String base, PrefixMapping prefixes) {
        if (command != null) {
            this.cmd.append(command);
        }
        this.setParams(map);
        this.baseUri = base != null && !base.equals("") ? base : null;
        this.prefixes = new PrefixMappingImpl();
        if (prefixes != null) {
            this.prefixes.setNsPrefixes(prefixes);
        }
    }

    public ParameterizedSparqlString(String command, QuerySolutionMap map, String base) {
        this(command, map, base, null);
    }

    public ParameterizedSparqlString(String command, QuerySolutionMap map, PrefixMapping prefixes) {
        this(command, map, null, prefixes);
    }

    public ParameterizedSparqlString(String command, QuerySolutionMap map) {
        this(command, map, null, null);
    }

    public ParameterizedSparqlString(String command, String base, PrefixMapping prefixes) {
        this(command, null, base, prefixes);
    }

    public ParameterizedSparqlString(String command, PrefixMapping prefixes) {
        this(command, null, null, prefixes);
    }

    public ParameterizedSparqlString(String command, String base) {
        this(command, null, base, null);
    }

    public ParameterizedSparqlString(String command) {
        this(command, null, null, null);
    }

    public ParameterizedSparqlString(QuerySolutionMap map, PrefixMapping prefixes) {
        this(null, map, null, prefixes);
    }

    public ParameterizedSparqlString(QuerySolutionMap map) {
        this(null, map, null, null);
    }

    public ParameterizedSparqlString(PrefixMapping prefixes) {
        this(null, null, null, prefixes);
    }

    public ParameterizedSparqlString() {
        this("", null, null, null);
    }

    public void setCommandText(String command) {
        this.cmd = new StringBuilder();
        this.cmd.append(command);
    }

    public void append(String text) {
        this.cmd.append(text);
    }

    public void append(char c) {
        this.cmd.append(c);
    }

    public void append(boolean b) {
        this.cmd.append(b);
    }

    public void append(double d) {
        this.cmd.append(d);
    }

    public void append(float f) {
        this.cmd.append(f);
    }

    public void append(int i) {
        this.cmd.append(i);
    }

    public void append(long l) {
        this.cmd.append(l);
    }

    public void append(Object obj) {
        this.cmd.append(obj);
    }

    public void appendNode(Node n) {
        SerializationContext context = new SerializationContext(this.prefixes);
        context.setBaseIRI(this.baseUri);
        this.cmd.append(this.stringForNode(n, context));
    }

    public void appendNode(RDFNode n) {
        this.appendNode(n.asNode());
    }

    public void appendIri(String uri) {
        this.appendNode(NodeFactory.createURI(uri));
    }

    public void appendIri(IRI iri2) {
        this.appendNode(NodeFactory.createURI(iri2.toString()));
    }

    public void appendLiteral(String value) {
        this.appendNode(NodeFactoryExtra.createLiteralNode(value, null, null));
    }

    public void appendLiteral(String value, String lang) {
        this.appendNode(NodeFactoryExtra.createLiteralNode(value, lang, null));
    }

    public void appendLiteral(String value, RDFDatatype datatype) {
        this.appendNode(NodeFactoryExtra.createLiteralNode(value, null, datatype.getURI()));
    }

    public void appendLiteral(boolean b) {
        this.appendNode(this.model.createTypedLiteral(b));
    }

    public void appendLiteral(int i) {
        this.appendNode(NodeFactoryExtra.intToNode(i));
    }

    public void appendLiteral(long l) {
        this.appendNode(NodeFactoryExtra.intToNode(l));
    }

    public void appendLiteral(float f) {
        this.appendNode(this.model.createTypedLiteral(f));
    }

    public void appendLiteral(double d) {
        this.appendNode(this.model.createTypedLiteral(d));
    }

    public void appendLiteral(Calendar dt) {
        this.appendNode(this.model.createTypedLiteral(dt));
    }

    public String getCommandText() {
        return this.cmd.toString();
    }

    public void setBaseUri(String base) {
        this.baseUri = base;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    protected void validateParameterValue(Node n) {
        if (n.isURI() && n.getURI().contains(">")) {
            throw new ARQException("Value for the parameter contains a SPARQL injection risk");
        }
    }

    public void setParams(QuerySolutionMap map) {
        if (map != null) {
            Iterator<String> iter = map.varNames();
            while (iter.hasNext()) {
                String var = iter.next();
                this.setParam(var, map.get(var).asNode());
            }
        }
    }

    public void setParam(int index, Node n) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n != null) {
            this.validateParameterValue(n);
            this.positionalParams.put(index, n);
        } else {
            this.positionalParams.remove(index);
        }
    }

    public void setParam(String var, Node n) {
        if (var == null) {
            throw new IllegalArgumentException("var cannot be null");
        }
        if (var.startsWith("?") || var.startsWith("$")) {
            var = var.substring(1);
        }
        if (n != null) {
            this.validateParameterValue(n);
            this.params.put(var, n);
        } else {
            this.params.remove(var);
        }
    }

    public void setParam(int index, RDFNode n) {
        this.setParam(index, n.asNode());
    }

    public void setParam(String var, RDFNode n) {
        this.setParam(var, n.asNode());
    }

    public void setIri(int index, String iri2) {
        this.setParam(index, NodeFactory.createURI(iri2));
    }

    public void setIri(String var, String iri2) {
        this.setParam(var, NodeFactory.createURI(iri2));
    }

    public void setIri(int index, IRI iri2) {
        this.setIri(index, iri2.toString());
    }

    public void setIri(String var, IRI iri2) {
        this.setIri(var, iri2.toString());
    }

    public void setIri(int index, URL url) {
        this.setIri(index, url.toString());
    }

    public void setIri(String var, URL url) {
        this.setIri(var, url.toString());
    }

    public void setLiteral(int index, Literal lit) {
        this.setParam(index, lit.asNode());
    }

    public void setLiteral(String var, Literal lit) {
        this.setParam(var, lit.asNode());
    }

    public void setLiteral(int index, String value) {
        this.setParam(index, NodeFactoryExtra.createLiteralNode(value, null, null));
    }

    public void setLiteral(String var, String value) {
        this.setParam(var, NodeFactoryExtra.createLiteralNode(value, null, null));
    }

    public void setLiteral(int index, String value, String lang) {
        this.setParam(index, NodeFactoryExtra.createLiteralNode(value, lang, null));
    }

    public void setLiteral(String var, String value, String lang) {
        this.setParam(var, NodeFactoryExtra.createLiteralNode(value, lang, null));
    }

    public void setLiteral(int index, String value, RDFDatatype datatype) {
        this.setParam(index, (RDFNode)this.model.createTypedLiteral(value, datatype));
    }

    public void setLiteral(String var, String value, RDFDatatype datatype) {
        this.setParam(var, (RDFNode)this.model.createTypedLiteral(value, datatype));
    }

    public void setLiteral(int index, boolean value) {
        this.setParam(index, (RDFNode)this.model.createTypedLiteral(value));
    }

    public void setLiteral(String var, boolean value) {
        this.setParam(var, (RDFNode)this.model.createTypedLiteral(value));
    }

    public void setLiteral(int index, int i) {
        this.setParam(index, NodeFactoryExtra.intToNode(i));
    }

    public void setLiteral(String var, int i) {
        this.setParam(var, NodeFactoryExtra.intToNode(i));
    }

    public void setLiteral(int index, long l) {
        this.setParam(index, NodeFactoryExtra.intToNode(l));
    }

    public void setLiteral(String var, long l) {
        this.setParam(var, NodeFactoryExtra.intToNode(l));
    }

    public void setLiteral(int index, float f) {
        this.setParam(index, NodeFactoryExtra.floatToNode(f));
    }

    public void setLiteral(String var, float f) {
        this.setParam(var, NodeFactoryExtra.floatToNode(f));
    }

    public void setLiteral(int index, double d) {
        this.setParam(index, (RDFNode)this.model.createTypedLiteral(d));
    }

    public void setLiteral(String var, double d) {
        this.setParam(var, (RDFNode)this.model.createTypedLiteral(d));
    }

    public void setLiteral(int index, Calendar dt) {
        this.setParam(index, (RDFNode)this.model.createTypedLiteral(dt));
    }

    public void setLiteral(String var, Calendar dt) {
        this.setParam(var, (RDFNode)this.model.createTypedLiteral(dt));
    }

    public Node getParam(String var) {
        return this.params.get(var);
    }

    public Node getParam(int index) {
        return this.positionalParams.get(index);
    }

    @Deprecated
    public Iterator<String> getVars() {
        return this.params.keySet().iterator();
    }

    public Map<String, Node> getVariableParameters() {
        return Collections.unmodifiableMap(this.params);
    }

    public Map<Integer, Node> getPositionalParameters() {
        return Collections.unmodifiableMap(this.positionalParams);
    }

    public Iterator<Integer> getEligiblePositionalParameters() {
        Pattern p = Pattern.compile("(\\?)[\\s;,.]");
        ArrayList<Integer> positions = new ArrayList<Integer>();
        int index = 0;
        Matcher matcher = p.matcher(this.cmd.toString());
        while (matcher.find()) {
            positions.add(index);
            ++index;
        }
        return positions.iterator();
    }

    public void clearParam(String var) {
        this.params.remove(var);
    }

    public void clearParam(int index) {
        this.positionalParams.remove(index);
    }

    public void clearParams() {
        this.params.clear();
        this.positionalParams.clear();
    }

    protected void validateSafeToInject(String command, String var, Node n) throws ARQException {
        Pattern p = Pattern.compile("\"[?$]" + var + "\"|'[?$]" + var + "'");
        if (p.matcher(command).find() && n.isLiteral()) {
            throw new ARQException("Command string is vunerable to injection attack, variable ?" + var + " appears surrounded directly by quotes and is bound to a literal which provides a SPARQL injection attack vector");
        }
        DelimiterInfo delims = this.findDelimiters(command);
        p = Pattern.compile("([?$]" + var + ")([^\\w]|$)");
        Matcher matcher = p.matcher(command);
        while (matcher.find()) {
            MatchResult posMatch = matcher.toMatchResult();
            if (!n.isLiteral() || !delims.isInsideLiteral(posMatch.start(1), posMatch.end(1))) continue;
            throw new ARQException("Command string is vunerable to injection attack, variable ?" + var + " appears inside of a literal and is bound to a literal which provides a SPARQL injection attack vector");
        }
    }

    protected void validateSafeToInject(String command, int index, int position, Node n) throws ARQException {
        DelimiterInfo delims = this.findDelimiters(command);
        if (n.isLiteral() && delims.isInsideLiteral(position, position)) {
            throw new ARQException("Command string is vunerable to injection attack, a positional paramter (index " + index + ") appears inside of a literal and is bound to a literal which provides a SPARQL injection attack vector");
        }
    }

    protected final DelimiterInfo findDelimiters(String command) {
        DelimiterInfo delims = new DelimiterInfo();
        delims.parseFrom(command);
        return delims;
    }

    protected final String stringForNode(Node n, SerializationContext context) {
        String str2 = FmtUtils.stringForNode(n, context);
        if (n.isLiteral() && str2.contains("'")) {
            str2 = str2.replace("'", "\\'");
        }
        return str2;
    }

    public String toString() {
        Pattern p;
        String command = this.cmd.toString();
        SerializationContext context = new SerializationContext(this.prefixes);
        context.setBaseIRI(this.baseUri);
        for (String var : this.params.keySet()) {
            Node n = this.params.get(var);
            if (n == null) continue;
            this.validateSafeToInject(command, var, n);
            p = Pattern.compile("([?$]" + var + ")([^\\w]|$)");
            command = p.matcher(command).replaceAll(Matcher.quoteReplacement(this.stringForNode(n, context)) + "$2");
        }
        p = Pattern.compile("(\\?)[\\s;,.]");
        int index = -1;
        int adj = 0;
        Matcher matcher = p.matcher(command);
        while (matcher.find()) {
            Node n;
            MatchResult posMatch = matcher.toMatchResult();
            if ((n = this.positionalParams.get(++index)) == null) continue;
            this.validateSafeToInject(command, index, posMatch.start(1) + adj, n);
            String nodeStr = this.stringForNode(n, context);
            command = command.substring(0, posMatch.start() + adj) + nodeStr + command.substring(posMatch.start() + adj + 1);
            adj += nodeStr.length() - 1;
        }
        StringBuilder finalCmd = new StringBuilder();
        if (this.baseUri != null) {
            finalCmd.append("BASE ");
            finalCmd.append(FmtUtils.stringForURI(this.baseUri, null, null));
            finalCmd.append('\n');
        }
        for (String prefix : this.prefixes.getNsPrefixMap().keySet()) {
            finalCmd.append("PREFIX ");
            finalCmd.append(prefix);
            finalCmd.append(": ");
            finalCmd.append(FmtUtils.stringForURI(this.prefixes.getNsPrefixURI(prefix), null, null));
            finalCmd.append('\n');
        }
        finalCmd.append(command);
        return finalCmd.toString();
    }

    public Query asQuery() throws QueryException {
        return QueryFactory.create(this.toString());
    }

    public UpdateRequest asUpdate() {
        return UpdateFactory.create(this.toString());
    }

    public ParameterizedSparqlString copy() {
        return this.copy(true, true, true);
    }

    public ParameterizedSparqlString copy(boolean copyParams) {
        return this.copy(copyParams, true, true);
    }

    public ParameterizedSparqlString copy(boolean copyParams, boolean copyBase, boolean copyPrefixes) {
        ParameterizedSparqlString copy = new ParameterizedSparqlString(this.cmd.toString(), null, copyBase ? this.baseUri : null, copyPrefixes ? this.prefixes : null);
        if (copyParams) {
            Iterator<String> vars = this.getVars();
            while (vars.hasNext()) {
                String var = vars.next();
                copy.setParam(var, this.getParam(var));
            }
            for (Map.Entry<Integer, Node> entry : this.positionalParams.entrySet()) {
                copy.setParam((int)entry.getKey(), entry.getValue());
            }
        }
        return copy;
    }

    @Override
    public PrefixMapping setNsPrefix(String prefix, String uri) {
        return this.prefixes.setNsPrefix(prefix, uri);
    }

    @Override
    public PrefixMapping removeNsPrefix(String prefix) {
        return this.prefixes.removeNsPrefix(prefix);
    }

    @Override
    public PrefixMapping setNsPrefixes(PrefixMapping other) {
        return this.prefixes.setNsPrefixes(other);
    }

    @Override
    public PrefixMapping setNsPrefixes(Map<String, String> map) {
        return this.prefixes.setNsPrefixes(map);
    }

    @Override
    public PrefixMapping withDefaultMappings(PrefixMapping map) {
        return this.prefixes.withDefaultMappings(map);
    }

    @Override
    public String getNsPrefixURI(String prefix) {
        return this.prefixes.getNsPrefixURI(prefix);
    }

    @Override
    public String getNsURIPrefix(String uri) {
        return this.prefixes.getNsURIPrefix(uri);
    }

    @Override
    public Map<String, String> getNsPrefixMap() {
        return this.prefixes.getNsPrefixMap();
    }

    @Override
    public String expandPrefix(String prefixed) {
        return this.prefixes.expandPrefix(prefixed);
    }

    @Override
    public String shortForm(String uri) {
        return this.prefixes.shortForm(uri);
    }

    @Override
    public String qnameFor(String uri) {
        return this.prefixes.qnameFor(uri);
    }

    @Override
    public PrefixMapping lock() {
        return this.prefixes.lock();
    }

    @Override
    public boolean samePrefixMappingAs(PrefixMapping other) {
        return this.prefixes.samePrefixMappingAs(other);
    }

    private class DelimiterInfo {
        private List<Pair<Integer, String>> starts = new ArrayList<Pair<Integer, String>>();
        private Map<Integer, Integer> stops = new HashMap<Integer, Integer>();

        private DelimiterInfo() {
        }

        public void parseFrom(String command) {
            this.starts.clear();
            this.stops.clear();
            char[] cs = command.toCharArray();
            block7: for (int i = 0; i < cs.length; ++i) {
                switch (cs[i]) {
                    case '\"': {
                        int j;
                        if (i < cs.length - 2 && cs[i + 1] == '\"' && cs[i + 2] == '\"') {
                            this.addStart(i, "\"\"\"");
                            for (j = i + 3; j < cs.length - 2; ++j) {
                                if (cs[j] != '\"' || cs[j + 1] != '\"' || cs[j + 2] != '\"') continue;
                                this.addStop(i, j + 2);
                                i = j + 2;
                            }
                            continue block7;
                        }
                        this.addStart(i, "\"");
                        for (j = i + 1; j < cs.length; ++j) {
                            if (cs[j] != '\"' || cs[j - 1] == '\\') continue;
                            this.addStop(i, j);
                            i = j;
                        }
                        continue block7;
                    }
                    case '<': {
                        int j;
                        this.addStart(i, "<");
                        for (j = i + 1; j < cs.length; ++j) {
                            if (cs[j] != '>' || cs[j - 1] == '\\') continue;
                            this.addStop(i, j);
                            i = j;
                        }
                        continue block7;
                    }
                    case '\'': {
                        int j;
                        if (i < cs.length - 2 && cs[i + 1] == '\'' && cs[i + 2] == '\'') {
                            this.addStart(i, "'''");
                            for (j = i + 3; j < cs.length - 2; ++j) {
                                if (cs[j] != '\'' || cs[j + 1] != '\'' || cs[j + 2] != '\'') continue;
                                this.addStop(i, j + 2);
                                i = j + 2;
                            }
                            continue block7;
                        }
                        this.addStart(i, "'");
                        for (j = i + 1; j < cs.length; ++j) {
                            if (cs[j] != '\'' || cs[j - 1] == '\\') continue;
                            this.addStop(i, j);
                            i = j;
                        }
                        continue block7;
                    }
                    case '#': {
                        int j;
                        this.addStart(i, "#");
                        for (j = i + 1; j < cs.length; ++j) {
                            if (cs[j] != '\n' && cs[j] != '\r') continue;
                            this.addStop(i, j);
                            i = j;
                        }
                        this.addStop(i, cs.length - 1);
                        continue block7;
                    }
                    case '\n': 
                    case '\r': 
                    case '(': 
                    case ')': 
                    case ',': 
                    case '.': 
                    case ';': 
                    case '[': 
                    case ']': 
                    case '{': 
                    case '}': {
                        this.addStart(i, new String(new char[]{cs[i]}));
                        this.addStop(i, i);
                    }
                }
            }
        }

        public void addStart(int index, String delim) {
            this.starts.add(new Pair<Integer, String>(index, delim));
        }

        public void addStop(int start, int stop) {
            this.stops.put(start, stop);
        }

        public Pair<Integer, String> findBefore(int index) {
            Pair<Integer, String> found = null;
            for (Pair<Integer, String> pair : this.starts) {
                if (pair.getLeft() < index) {
                    found = pair;
                }
                if (pair.getLeft() < index) continue;
                break;
            }
            return found;
        }

        public Pair<Integer, String> findAfter(int index) {
            for (Pair<Integer, String> pair : this.starts) {
                if (pair.getLeft() <= index) continue;
                return pair;
            }
            return null;
        }

        public boolean isInsideLiteral(int start, int stop) {
            Pair<Integer, String> pair = this.findBefore(start);
            if (pair == null) {
                return false;
            }
            if (pair.getRight().equals("\"")) {
                Integer nearestStop = this.stops.get(pair.getLeft());
                if (nearestStop == null) {
                    return true;
                }
                return nearestStop > stop;
            }
            return false;
        }

        public boolean isInsideAltLiteral(int start, int stop) {
            Pair<Integer, String> pair = this.findBefore(start);
            if (pair == null) {
                return false;
            }
            if (pair.getRight().equals("'")) {
                Integer nearestStop = this.stops.get(pair.getLeft());
                if (nearestStop == null) {
                    return true;
                }
                return nearestStop > stop;
            }
            return false;
        }

        public boolean isBetweenLiterals(int start, int stop) {
            Pair<Integer, String> pairBefore = this.findBefore(start);
            if (pairBefore == null) {
                return false;
            }
            if (pairBefore.getRight().equals("\"")) {
                Integer stopBefore = this.stops.get(pairBefore.getLeft());
                if (stopBefore == null) {
                    return false;
                }
                Pair<Integer, String> pairAfter = this.findAfter(stop);
                return pairAfter != null && pairAfter.getRight().equals("\"");
            }
            return false;
        }
    }
}

