/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.SortCondition;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.OpVisitorByType;
import org.apache.jena.sparql.algebra.OpWalker;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.TransformWrapper;
import org.apache.jena.sparql.algebra.op.Op0;
import org.apache.jena.sparql.algebra.op.Op1;
import org.apache.jena.sparql.algebra.op.Op2;
import org.apache.jena.sparql.algebra.op.OpAssign;
import org.apache.jena.sparql.algebra.op.OpExt;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpGroup;
import org.apache.jena.sparql.algebra.op.OpLeftJoin;
import org.apache.jena.sparql.algebra.op.OpN;
import org.apache.jena.sparql.algebra.op.OpOrder;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.algebra.optimize.ExprTransformApplyTransform;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprTransformer;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.aggregate.Aggregator;

public class Transformer {
    private static Transformer singleton = new Transformer();

    public static Transformer get() {
        return singleton;
    }

    public static void set(Transformer value) {
        singleton = value;
    }

    public static Op transform(Transform transform, Op op) {
        return Transformer.get().transformation(transform, op, null, null);
    }

    public static Op transform(Transform transform, ExprTransform exprTransform, Op op) {
        return Transformer.get().transformation(transform, exprTransform, op, null, null);
    }

    public static Op transform(Transform transform, Op op, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        return Transformer.get().transformation(transform, op, beforeVisitor, afterVisitor);
    }

    public static Op transform(Transform transform, ExprTransform exprTransform, Op op, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        return Transformer.get().transformation(transform, exprTransform, op, beforeVisitor, afterVisitor);
    }

    public static Op transformSkipService(Transform transform, Op op) {
        return Transformer.transformSkipService(transform, op, null, null);
    }

    public static Op transformSkipService(Transform transform, ExprTransform exprTransform, Op op) {
        return Transformer.transformSkipService(transform, exprTransform, op, null, null);
    }

    public static Op transformSkipService(Transform transform, Op op, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        TransformSkipService walker = new TransformSkipService(transform);
        return Transformer.transform(walker, op, beforeVisitor, afterVisitor);
    }

    public static Op transformSkipService(Transform transform, ExprTransform exprTransform, Op op, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        TransformSkipService walker = new TransformSkipService(transform);
        return Transformer.transform(walker, exprTransform, op, beforeVisitor, afterVisitor);
    }

    protected Op transformation(Transform transform, Op op, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        ExprTransformApplyTransform exprTransform = new ExprTransformApplyTransform(transform, beforeVisitor, afterVisitor);
        return this.transformation(transform, exprTransform, op, beforeVisitor, afterVisitor);
    }

    protected Op transformation(Transform transform, ExprTransform exprTransform, Op op, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        ApplyTransformVisitor v = new ApplyTransformVisitor(transform, exprTransform);
        return this.transformation(v, op, beforeVisitor, afterVisitor);
    }

    protected Op transformation(ApplyTransformVisitor transformApply, Op op, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        if (op == null) {
            Log.warn(this, "Attempt to transform a null Op - ignored");
            return op;
        }
        return this.applyTransformation(transformApply, op, beforeVisitor, afterVisitor);
    }

    protected Op applyTransformation(ApplyTransformVisitor transformApply, Op op, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        OpWalker.walk(op, transformApply, beforeVisitor, afterVisitor);
        Op r = transformApply.result();
        return r;
    }

    protected Transformer() {
    }

    static class TransformSkipService
    extends TransformWrapper {
        public TransformSkipService(Transform transform) {
            super(transform);
        }

        @Override
        public Op transform(OpService opService, Op subOp) {
            return opService;
        }
    }

    static class WalkerVisitorSkipService
    extends OpWalker.WalkerVisitor {
        public WalkerVisitorSkipService(OpVisitor visitor, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
            super(visitor, beforeVisitor, afterVisitor);
        }

        public WalkerVisitorSkipService(OpVisitor visitor) {
            super(visitor);
        }

        @Override
        public void visit(OpService op) {
            this.before(op);
            if (this.visitor != null) {
                op.visit(this.visitor);
            }
            this.after(op);
        }
    }

    static class ApplyTransformVisitorServiceAsLeaf
    extends ApplyTransformVisitor {
        public ApplyTransformVisitorServiceAsLeaf(Transform transform, ExprTransform exprTransform) {
            super(transform, exprTransform);
        }

        @Override
        public void visit(OpService op) {
            this.push(op);
        }
    }

    public static class ApplyTransformVisitor
    extends OpVisitorByType {
        protected final Transform transform;
        private final ExprTransform exprTransform;
        private final Deque<Op> stack = new ArrayDeque<Op>();

        protected final Op pop() {
            return this.stack.pop();
        }

        protected final void push(Op op) {
            this.stack.push(op);
        }

        public ApplyTransformVisitor(Transform transform, ExprTransform exprTransform) {
            this.transform = transform;
            this.exprTransform = exprTransform;
        }

        final Op result() {
            if (this.stack.size() != 1) {
                Log.warn(this, "Stack is not aligned");
            }
            return this.pop();
        }

        private static ExprList transform(ExprList exprList, ExprTransform exprTransform) {
            if (exprList == null || exprTransform == null) {
                return exprList;
            }
            return ExprTransformer.transform(exprTransform, exprList);
        }

        private static Expr transform(Expr expr, ExprTransform exprTransform) {
            if (expr == null || exprTransform == null) {
                return expr;
            }
            return ExprTransformer.transform(exprTransform, expr);
        }

        @Override
        public void visit(OpOrder opOrder) {
            List<SortCondition> conditions = opOrder.getConditions();
            ArrayList<SortCondition> conditions2 = new ArrayList<SortCondition>();
            boolean changed = false;
            for (SortCondition sc : conditions) {
                Expr e2 = sc.getExpression();
                Expr e22 = ApplyTransformVisitor.transform(e2, this.exprTransform);
                conditions2.add(new SortCondition(e22, sc.getDirection()));
                if (e2 == e22) continue;
                changed = true;
            }
            OpOrder x = opOrder;
            if (changed) {
                x = new OpOrder(opOrder.getSubOp(), conditions2);
            }
            this.visit1(x);
        }

        @Override
        public void visit(OpAssign opAssign) {
            VarExprList varExpr = opAssign.getVarExprList();
            VarExprList varExpr2 = ApplyTransformVisitor.process(varExpr, this.exprTransform);
            OpAssign opAssign2 = opAssign;
            if (varExpr != varExpr2) {
                opAssign2 = OpAssign.create(opAssign.getSubOp(), varExpr2);
            }
            this.visit1(opAssign2);
        }

        @Override
        public void visit(OpExtend opExtend) {
            VarExprList varExpr = opExtend.getVarExprList();
            VarExprList varExpr2 = ApplyTransformVisitor.process(varExpr, this.exprTransform);
            OpExtend opExtend2 = opExtend;
            if (varExpr != varExpr2) {
                opExtend2 = OpExtend.create(opExtend.getSubOp(), varExpr2);
            }
            this.visit1(opExtend2);
        }

        private static VarExprList process(VarExprList varExpr, ExprTransform exprTransform) {
            List<Var> vars = varExpr.getVars();
            VarExprList varExpr2 = new VarExprList();
            boolean changed = false;
            for (Var v : vars) {
                Expr e2;
                Expr e22 = e2 = varExpr.getExpr(v);
                if (e2 != null) {
                    e22 = ApplyTransformVisitor.transform(e2, exprTransform);
                }
                if (e22 == null) {
                    varExpr2.add(v);
                } else {
                    varExpr2.add(v, e22);
                }
                if (e2 == e22) continue;
                changed = true;
            }
            if (!changed) {
                return varExpr;
            }
            return varExpr2;
        }

        private static ExprList process(ExprList exprList, ExprTransform exprTransform) {
            if (exprList == null) {
                return null;
            }
            ExprList exprList2 = new ExprList();
            boolean changed = false;
            for (Expr e2 : exprList) {
                Expr e22 = ApplyTransformVisitor.process(e2, exprTransform);
                exprList2.add(e22);
                if (e2 == e22) continue;
                changed = true;
            }
            if (!changed) {
                return exprList;
            }
            return exprList2;
        }

        private static Expr process(Expr expr, ExprTransform exprTransform) {
            Expr e2;
            Expr e22 = e2 = expr;
            if (e2 != null) {
                e22 = ApplyTransformVisitor.transform(e2, exprTransform);
            }
            if (e2 == e22) {
                return expr;
            }
            return e22;
        }

        @Override
        public void visit(OpGroup opGroup) {
            List<ExprAggregator> aggs;
            VarExprList varExpr2;
            boolean changed = false;
            VarExprList varExpr = opGroup.getGroupVars();
            if (varExpr != (varExpr2 = ApplyTransformVisitor.process(varExpr, this.exprTransform))) {
                changed = true;
            }
            List<ExprAggregator> aggs2 = aggs = opGroup.getAggregators();
            aggs2 = new ArrayList<ExprAggregator>();
            for (ExprAggregator agg : aggs) {
                ExprList e2;
                Expr eVar2;
                Aggregator aggregator = agg.getAggregator();
                Var v = agg.getVar();
                ExprVar eVar = agg.getAggVar();
                if (eVar != (eVar2 = ApplyTransformVisitor.transform(eVar, this.exprTransform))) {
                    changed = true;
                }
                ExprList e22 = e2 = aggregator.getExprList();
                if (e2 != null) {
                    e22 = ApplyTransformVisitor.transform(e2, this.exprTransform);
                }
                if (e2 != e22) {
                    changed = true;
                }
                Aggregator a2 = aggregator.copy(e22);
                aggs2.add(new ExprAggregator(eVar2.asVar(), a2));
            }
            OpGroup opGroup2 = opGroup;
            if (changed) {
                opGroup2 = new OpGroup(opGroup.getSubOp(), varExpr2, aggs2);
            }
            this.visit1(opGroup2);
        }

        @Override
        protected void visit0(Op0 op) {
            this.push(op.apply(this.transform));
        }

        @Override
        protected void visit1(Op1 op) {
            Op subOp = null;
            if (op.getSubOp() != null) {
                subOp = this.pop();
            }
            this.push(op.apply(this.transform, subOp));
        }

        @Override
        protected void visit2(Op2 op) {
            Op left = null;
            Op right = null;
            if (op.getRight() != null) {
                right = this.pop();
            }
            if (op.getLeft() != null) {
                left = this.pop();
            }
            Op opX = op.apply(this.transform, left, right);
            this.push(opX);
        }

        @Override
        protected void visitN(OpN op) {
            ArrayList<Op> x = new ArrayList<Op>(op.size());
            Iterator<Op> iter = op.iterator();
            while (iter.hasNext()) {
                Op sub = iter.next();
                Op r = this.pop();
                if (r == null) continue;
                x.add(0, r);
            }
            Op opX = op.apply(this.transform, x);
            this.push(opX);
        }

        @Override
        protected void visitFilter(OpFilter opFilter) {
            Op subOp = null;
            if (opFilter.getSubOp() != null) {
                subOp = this.pop();
            }
            boolean changed = opFilter.getSubOp() != subOp;
            ExprList ex = opFilter.getExprs();
            ExprList ex2 = ApplyTransformVisitor.process(ex, this.exprTransform);
            OpFilter f = opFilter;
            if (ex != ex2) {
                f = (OpFilter)OpFilter.filter(ex2, subOp);
            }
            this.push(f.apply(this.transform, subOp));
        }

        @Override
        protected void visitLeftJoin(OpLeftJoin op) {
            Op left = null;
            Op right = null;
            if (op.getRight() != null) {
                right = this.pop();
            }
            if (op.getLeft() != null) {
                left = this.pop();
            }
            ExprList exprs = op.getExprs();
            ExprList exprs2 = ApplyTransformVisitor.process(exprs, this.exprTransform);
            OpLeftJoin x = op;
            if (exprs != exprs2) {
                x = OpLeftJoin.createLeftJoin(left, right, exprs2);
            }
            Op opX = x.apply(this.transform, left, right);
            this.push(opX);
        }

        @Override
        protected void visitExt(OpExt op) {
            this.push(this.transform.transform(op));
        }
    }
}

