/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.Iterator;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.shared.Lock;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.DatasetGraphMap;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.NodeUtils;

public class DatasetImpl
implements Dataset {
    protected DatasetGraph dsg = null;
    private Transactional transactional = null;
    private Graph seenDftGraph = null;
    private Model dftModel = null;

    public static Dataset wrap(DatasetGraph datasetGraph) {
        DatasetImpl ds = new DatasetImpl(datasetGraph);
        return ds;
    }

    public static Dataset cloneStructure(DatasetGraph datasetGraph) {
        return new DatasetImpl(new DatasetGraphMap(datasetGraph));
    }

    protected DatasetImpl(DatasetGraph dsg) {
        this.dsg = dsg;
        if (dsg instanceof Transactional) {
            this.transactional = (Transactional)((Object)dsg);
        }
    }

    public DatasetImpl(Model model) {
        this.seenDftGraph = model.getGraph();
        this.dftModel = model;
        this.dsg = DatasetGraphFactory.create(model.getGraph());
        if (this.dsg instanceof Transactional) {
            this.transactional = (Transactional)((Object)this.dsg);
        }
    }

    public DatasetImpl(Dataset ds) {
        this(DatasetGraphFactory.create(ds.asDatasetGraph()));
    }

    @Override
    public Model getDefaultModel() {
        this.setDefaultModelSlots();
        return this.dftModel;
    }

    private synchronized void setDefaultModelSlots() {
        Graph g = this.dsg.getDefaultGraph();
        if (g != this.seenDftGraph) {
            this.seenDftGraph = g;
            this.dftModel = ModelFactory.createModelForGraph(g);
        }
    }

    private synchronized void clearDefaultModelSlots() {
        this.seenDftGraph = null;
        this.dftModel = null;
    }

    @Override
    public Lock getLock() {
        return this.dsg.getLock();
    }

    @Override
    public Context getContext() {
        return this.dsg.getContext();
    }

    @Override
    public boolean supportsTransactions() {
        return this.transactional != null;
    }

    @Override
    public void begin(ReadWrite mode) {
        this.checkTransactional();
        this.transactional.begin(mode);
    }

    @Override
    public boolean isInTransaction() {
        this.checkTransactional();
        return this.transactional.isInTransaction();
    }

    @Override
    public void commit() {
        this.checkTransactional();
        this.transactional.commit();
    }

    @Override
    public void abort() {
        this.checkTransactional();
        this.transactional.abort();
    }

    @Override
    public void end() {
        this.checkTransactional();
        this.transactional.end();
        this.seenDftGraph = null;
        this.dftModel = null;
    }

    private void checkTransactional() {
        if (!this.supportsTransactions()) {
            throw new UnsupportedOperationException("Transactions not supported");
        }
    }

    @Override
    public DatasetGraph asDatasetGraph() {
        return this.dsg;
    }

    @Override
    public Model getNamedModel(String uri) {
        DatasetImpl.checkGraphName(uri);
        Node n = NodeFactory.createURI(uri);
        return this.graph2model(this.dsg.getGraph(n));
    }

    @Override
    public void addNamedModel(String uri, Model model) {
        DatasetImpl.checkGraphName(uri);
        Node n = NodeFactory.createURI(uri);
        this.dsg.addGraph(n, model.getGraph());
    }

    @Override
    public void removeNamedModel(String uri) {
        DatasetImpl.checkGraphName(uri);
        Node n = NodeFactory.createURI(uri);
        this.dsg.removeGraph(n);
    }

    @Override
    public void replaceNamedModel(String uri, Model model) {
        DatasetImpl.checkGraphName(uri);
        Node n = NodeFactory.createURI(uri);
        this.dsg.removeGraph(n);
        this.dsg.addGraph(n, model.getGraph());
    }

    @Override
    public void setDefaultModel(Model model) {
        if (model == null) {
            model = ModelFactory.createDefaultModel();
        }
        this.dsg.setDefaultGraph(model.getGraph());
        this.clearDefaultModelSlots();
    }

    @Override
    public boolean containsNamedModel(String uri) {
        DatasetImpl.checkGraphName(uri);
        Node n = NodeFactory.createURI(uri);
        return this.dsg.containsGraph(n);
    }

    @Override
    public Iterator<String> listNames() {
        return NodeUtils.nodesToURIs(this.dsg.listGraphNodes());
    }

    @Override
    public void close() {
        this.dsg.close();
        this.seenDftGraph = null;
        this.dftModel = null;
    }

    protected Model graph2model(Graph graph) {
        return ModelFactory.createModelForGraph(graph);
    }

    protected static void checkGraphName(String uri) {
        if (uri == null) {
            throw new ARQException("null for graph name");
        }
    }
}

