/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core.mem;

import java.util.stream.Stream;
import org.apache.jena.atlas.lib.persistent.PersistentSet;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.mem.FourTupleMap;
import org.apache.jena.sparql.core.mem.PMapTupleTable;
import org.apache.jena.sparql.core.mem.QuadTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PMapQuadTable
extends PMapTupleTable<FourTupleMap, Quad>
implements QuadTable {
    private static final Logger log = LoggerFactory.getLogger(PMapQuadTable.class);

    public PMapQuadTable(String tableName) {
        super(tableName);
    }

    @Override
    protected Logger log() {
        return log;
    }

    @Override
    protected FourTupleMap initial() {
        return new FourTupleMap();
    }

    protected abstract Quad quad(Node var1, Node var2, Node var3, Node var4);

    protected Stream<Quad> _find(Node first, Node second, Node third, Node fourth) {
        this.debug("Querying on four-tuple pattern: {} {} {} {} .", first, second, third, fourth);
        FourTupleMap fourTuples = (FourTupleMap)this.local().get();
        if (this.isConcrete(first)) {
            this.debug("Using a specific first slot value.", new Object[0]);
            return fourTuples.get(first).map(threeTuples -> {
                if (this.isConcrete(second)) {
                    this.debug("Using a specific second slot value.", new Object[0]);
                    return threeTuples.get(second).map(twoTuples -> {
                        if (this.isConcrete(third)) {
                            this.debug("Using a specific third slot value.", new Object[0]);
                            return twoTuples.get(third).map(oneTuples -> {
                                if (this.isConcrete(fourth)) {
                                    this.debug("Using a specific fourth slot value.", new Object[0]);
                                    return oneTuples.contains(fourth) ? Stream.of(this.quad(first, second, third, fourth)) : Stream.empty();
                                }
                                this.debug("Using a wildcard fourth slot value.", new Object[0]);
                                return oneTuples.stream().map(slot4 -> this.quad(first, second, third, (Node)slot4));
                            }).orElse(Stream.empty());
                        }
                        this.debug("Using wildcard third and fourth slot values.", new Object[0]);
                        return twoTuples.flatten((slot3, oneTuples) -> oneTuples.stream().map(slot4 -> this.quad(first, second, (Node)slot3, (Node)slot4)));
                    }).orElse(Stream.empty());
                }
                this.debug("Using wildcard second, third and fourth slot values.", new Object[0]);
                return threeTuples.flatten((slot2, twoTuples) -> twoTuples.flatten((slot3, oneTuples) -> oneTuples.stream().map(slot4 -> this.quad(first, (Node)slot2, (Node)slot3, (Node)slot4))));
            }).orElse(Stream.empty());
        }
        this.debug("Using a wildcard for all slot values.", new Object[0]);
        return fourTuples.flatten((slot1, threeTuples) -> threeTuples.flatten((slot2, twoTuples) -> twoTuples.flatten((slot3, oneTuples) -> oneTuples.stream().map(slot4 -> this.quad((Node)slot1, (Node)slot2, (Node)slot3, (Node)slot4)))));
    }

    protected void _add(Node first, Node second, Node third, Node fourth) {
        this.debug("Adding four-tuple: {} {} {} {} .", first, second, third, fourth);
        FourTupleMap fourTuples = (FourTupleMap)this.local().get();
        FourTupleMap.ThreeTupleMap threeTuples = fourTuples.get(first).orElse(new FourTupleMap.ThreeTupleMap());
        FourTupleMap.TwoTupleMap twoTuples = threeTuples.get(second).orElse(new FourTupleMap.TwoTupleMap());
        PersistentSet<Object> oneTuples = twoTuples.get(third).orElse(PersistentSet.empty());
        if (!oneTuples.contains(fourth)) {
            oneTuples = oneTuples.plus(fourth);
        }
        twoTuples = (FourTupleMap.TwoTupleMap)((FourTupleMap.TwoTupleMap)twoTuples.minus(third)).plus(third, oneTuples);
        threeTuples = (FourTupleMap.ThreeTupleMap)((FourTupleMap.ThreeTupleMap)threeTuples.minus(second)).plus(second, twoTuples);
        this.debug("Setting transactional index to new value.", new Object[0]);
        this.local().set(((FourTupleMap)fourTuples.minus(first)).plus(first, threeTuples));
    }

    protected void _delete(Node first, Node second, Node third, Node fourth) {
        this.debug("Removing four-tuple: {} {} {} {} .", first, second, third, fourth);
        FourTupleMap fourTuples = (FourTupleMap)this.local().get();
        fourTuples.get(first).ifPresent(threeTuples -> threeTuples.get(second).ifPresent(twoTuples -> twoTuples.get(third).ifPresent(oneTuples -> {
            if (oneTuples.contains(fourth)) {
                oneTuples = oneTuples.minus(fourth);
                FourTupleMap.TwoTupleMap newTwoTuples = (FourTupleMap.TwoTupleMap)((FourTupleMap.TwoTupleMap)twoTuples.minus(third)).plus(third, oneTuples);
                FourTupleMap.ThreeTupleMap newThreeTuples = (FourTupleMap.ThreeTupleMap)((FourTupleMap.ThreeTupleMap)threeTuples.minus(second)).plus(second, newTwoTuples);
                this.debug("Setting transactional index to new value.", new Object[0]);
                this.local().set(((FourTupleMap)fourTuples.minus(first)).plus(first, newThreeTuples));
            }
        })));
    }
}

