/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.main;

import java.util.HashSet;
import java.util.Set;
import org.apache.jena.atlas.lib.SetUtils;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVars;
import org.apache.jena.sparql.algebra.op.OpExt;
import org.apache.jena.sparql.algebra.op.OpLeftJoin;
import org.apache.jena.sparql.algebra.op.OpModifier;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.main.VarFinder;

public class LeftJoinClassifier {
    public static boolean print = false;

    public static boolean isLinear(OpLeftJoin op) {
        return LeftJoinClassifier.isLinear(op.getLeft(), op.getRight());
    }

    public static boolean isLinear(Op left, Op right) {
        boolean b3;
        left = LeftJoinClassifier.effectiveOp(left);
        if ((right = LeftJoinClassifier.effectiveOp(right)) instanceof OpModifier) {
            return false;
        }
        Set<Var> leftVars = OpVars.visibleVars(left);
        VarFinder vf = new VarFinder(right);
        Set<Var> optRight = vf.getOpt();
        Set<Var> fixedRight = vf.getFixed();
        Set<Var> filterVarsRight = vf.getFilter();
        Set<Var> assignVarsRight = vf.getAssign();
        if (print) {
            System.err.println("Left/visible: " + leftVars);
            System.err.println("Right/fixed:  " + fixedRight);
            System.err.println("Right/opt:    " + optRight);
            System.err.println("Right/filter: " + filterVarsRight);
            System.err.println("Right/assign: " + assignVarsRight);
        }
        boolean b1 = SetUtils.intersectionP(leftVars, optRight);
        if (print) {
            System.err.println("Case 1 - " + b1);
        }
        boolean b2 = SetUtils.intersectionP(leftVars, filterVarsRight);
        if (print) {
            System.err.println("Case 2 - " + b2);
        }
        HashSet<Var> unsafeAssign = new HashSet<Var>(assignVarsRight);
        unsafeAssign.removeAll(fixedRight);
        boolean bl = b3 = unsafeAssign.size() > 0;
        if (print) {
            System.err.println("Case 3 - " + b3);
        }
        return !b1 && !b2 && !b3;
    }

    public static Set<Var> nonLinearVars(OpLeftJoin op) {
        Op left = LeftJoinClassifier.effectiveOp(op.getLeft());
        Op right = LeftJoinClassifier.effectiveOp(op.getRight());
        Set<Var> leftVars = OpVars.visibleVars(left);
        Set<Var> optRight = VarFinder.optDefined(right);
        return SetUtils.intersection(leftVars, optRight);
    }

    private static Op effectiveOp(Op op) {
        if (op instanceof OpExt) {
            op = ((OpExt)op).effectiveOp();
        }
        return op;
    }
}

